/* stco.h */

#ifndef STCO_H
#define STCO_H

#include "qtime_io.h"
#include "qtime_sample_info.h"
#include "atom.h"

#define QTIME_TYPE_STCO    QTIME_TYPE('s','t','c','o')
#define QTIME_TYPE_CO64    QTIME_TYPE('c','o','6','4')

typedef struct {
  uint8_t  version;
  uint8_t  flags[3];
  uint32_t number_of_entries;
} STCO_PROP;

#define STCO_PROP_SIZE (8)

typedef struct {
  atom_t   atom;
  uint8_t  version;
  uint8_t  flags[3];
  int32_t  number_of_entries;
  int32_t  table_max;
  int32_t  num_ent32;
  uint32_t *table32;
  int32_t  num_ent64;
  int64_t  *table64;
  int32_t  use_co64;
} stco_t;


int64_t stco_calc_size(stco_t *stco);
void    stco_init(stco_t *stco);
void    stco_clean(stco_t *stco);
stco_t* stco_new(void);
void    stco_delete(stco_t *stco);


stco_t* stco_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, stco_t *stco);
stco_t* stco_create(stco_t* stco);
int     stco_write_atom(qtime_io_t *qtio, stco_t *stco);
void    stco_dump(const char *parent_types, stco_t *stco);
int     stco_valid(stco_t *stco);


int32_t stco_add_offset(stco_t *stco, int64_t offset);
//uint32_t stco_set_offset(stco_t *stco, uint32_t count, int64_t offset);
int64_t stco_get_offset(stco_t *stco, uint32_t count);
int32_t stco_shift_offset(stco_t *stco, int64_t shift);

int     stco_get_sample_info(stco_t *stco, qtime_sample_info_t *spinfo);
int     stco_add_sample_info(stco_t *stco, qtime_sample_info_t *spinfo);


#endif /* STCO_H */

