/* moov.h */

#ifndef MOOV_H
#define MOOV_H

#include "qtime_io.h"
#include "atom.h"
#include "mvhd.h"
#include "clip.h"
#include "trak.h"
#include "udta.h"
#include "ctab.h"

#define QTIME_TYPE_MOOV    QTIME_TYPE('m','o','o','v')

#define QTIME_TRAK_MAX     1024

typedef struct {
  atom_t   atom;
  mvhd_t   mvhd;
} moov_t;


void    moov_init(moov_t *moov);
void    moov_clean(moov_t *moov);
moov_t *moov_new(void);
void    moov_delete(moov_t *moov);

moov_t* moov_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, moov_t *moov);
int     moov_write_atom_pre(moov_t *moov);
int     moov_write_atom(qtime_io_t *qtio, moov_t *moov);
void    moov_dump(moov_t *moov);
moov_t* moov_create(moov_t* moov);

trak_t* moov_create_trak(moov_t* moov, trak_t *trak);

int     moov_add_trak(moov_t *moov);



#endif /* MOOV_H */

