/* dinf.h */

#ifndef DINF_H
#define DINF_H

#include "qtime_io.h"
#include "atom.h"
#include "dref.h"

#define QTIME_TYPE_DINF    QTIME_TYPE('d','i','n','f')

typedef struct {
  atom_t  atom;
  dref_t  dref;
} dinf_t;


void    dinf_init(dinf_t *dinf);
void    dinf_clean(dinf_t *dinf);
dinf_t* dinf_new(void);
void    dinf_delete(dinf_t *dinf);

dinf_t* dinf_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, dinf_t *dinf);
dinf_t* dinf_create(dinf_t *dinf);
int     dinf_write_atom(qtime_io_t *qtio, dinf_t *dinf);
int64_t dinf_calc_size(dinf_t *dinf);
void    dinf_dump(const char *parent_types, dinf_t *dinf);


#endif /* DINF_H */

