/* crgn.h */

#ifndef CRGN_H
#define CRGN_H

#include "qtime_io.h"
#include "atom.h"

#define QTIME_TYPE_CRGN    QTIME_TYPE('c','r','g','n')


typedef struct {
  atom_t  atom;
  // region_size;
  // region_boundary_box;
  // clipping_region_data;
} crgn_t;


void    crgn_init(crgn_t *crgn);
void    crgn_clean(crgn_t *crgn);
crgn_t* crgn_creqte(void);
void    crgn_delete(crgn_t *crgn);

int64_t crgn_calc_size(crgn_t *crgn);
int     crgn_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, crgn_t *crgn);
crgn_t* crgn_create_read_atom(qtime_io_t *qtio, atom_head_t *atom_head);
int     crgn_write_atom(qtime_io_t *qtio, crgn_t *crgn);
void    crgn_dump(const char *parent_types, crgn_t *crgn);


#endif /* CRGN_H */

