/* clip.h */

#ifndef CLIP_H
#define CLIP_H

#include "atom.h"
#include "crgn.h"

#define QTIME_TYPE_CLIP    QTIME_TYPE('c','l','i','p')

typedef struct {
  atom_t atom;
  crgn_t *crgn;
} clip_t;


void    clip_init(clip_t *clip);
void    clip_clean(clip_t *clip);
clip_t* clip_create(void);
void    clip_delete(clip_t *clip);

int64_t clip_calc_size(clip_t *clip);
int     clip_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, clip_t *clip);
clip_t* clip_create_read_atom(qtime_io_t *qtio, atom_head_t *atom_head);
int     clip_write_atom(qtime_io_t *qtio, clip_t *clip);
void    clip_dump(const char *parent_types, clip_t *clip);


#endif /* CLIP_H */

