/* aframe_mgr.h */

#ifndef _AFRAME_MGR_H
#define _AFRAME_MGR_H

#include <pthread.h>
#include <inttypes.h>
#include "util.h"

typedef struct AFRAME_tag {
  struct AFRAME_tag *prev;
  struct AFRAME_tag *next;
#define NORMAL_AFRAME (1<<0)
#define EXT_AFRAME    (1<<1)
#define START_AFRAME  (1<<2)
#define END_AFRAME    (1<<3)
#define QUIT_AFRAME   (1<<4)
#define DROP_AFRAME   (1<<5)
#define CHANGE_AFRAME (1<<6)
  uint32_t flag;
//  int bitspspl;
//  int channels;
  int sample_length;
  int sample_buf_size;
  uint8_t *sample[2];
  int stream_length;
  int stream_buf_size;
  uint8_t *stream;
  uint8_t *bufp;
} AFRAME;

typedef struct {
  pthread_mutex_t mutex;
  int state;
#define SRC_WAIT   (1<<0)
#define ENC_WAIT   (1<<1)
#define DST_WAIT   (1<<2)
#define FREE_WAIT  (1<<3)
#define ENC_SRC_WAIT (1<<4)
#define ENC_DST_WAIT (1<<5)
  int aframe_flag;

  int rate;
  int channels;
  int bitspspl;
  int bytespspl;

  int aframe_buf_sample_size;
  int aframe_buf_byte_size;

  unsigned int last_frame_alloc_count;
  unsigned int max_last_frame_alloc_count;
  int max_frame_num;
  int max_ext_frame_num;

  int alloc_frame_num;
  int alloc_ext_frame_num;
  int used_frame_num;
  int free_frame_num;
  int src_frame_num;
  int dst_frame_num;

  void (*src_wait_cb) (void);
  void (*enc_wait_cb) (void);
  void (*dst_wait_cb) (void);

  AFRAME *free_chain;
  AFRAME *src_chain;
  AFRAME *dst_chain;

  AFRAME *src_frame;
  AFRAME *dst_frame;
  AFRAME *enc_src_frame;
  AFRAME *enc_dst_frame;
} AFRAME_MGR;

#define AFRAME_MGR_OK     0
#define AFRAME_MGR_FAIL  -1
#define AFRAME_MGR_BUSY  -2
#define AFRAME_MGR_NOT_READY -3

AFRAME*  aframe_ext_frame_get(void);
AFRAME*  aframe_src_frame_get(void);
void  aframe_src_frame_update(AFRAME* afrm);
AFRAME*  aframe_enc_src_frame_get(void);
void  aframe_enc_src_frame_update(AFRAME* afrm);
AFRAME*  aframe_enc_dst_frame_get(void);
void  aframe_enc_dst_frame_update(AFRAME* afrm);
AFRAME*  aframe_dst_frame_get(void);
void  aframe_dst_frame_update(AFRAME* afrm);

void aframe_set_src_wait_cb(void (*wait_cb)(void));
void aframe_set_enc_wait_cb(void (*wait_cb)(void));
void aframe_set_dst_wait_cb(void (*wait_cb)(void));

int aframe_get_src_frame_num(void);
int aframe_get_dst_frame_num(void);
int aframe_get_used_frame_num(void);

int aframe_mgr_init(int rate, int channels, int bitspspl, int frame_size);
int aframe_mgr_quit(void);
int aframe_mgr_error_quit(void);

#endif /* _AFRAME_MGR_H */

