/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#include	<sys/types.h> 
#include	<sys/socket.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<arpa/inet.h>
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<openssl/sha.h>
#include	<wchar.h>
#include	<assert.h>

#include	"env.h"
#include	"utils/nt_std_t.h"
#include	"utils/text.h"
#include	"utils/db.h"
#include	"net/nt_socket.h"
#include	"net/nt_http.h"

int url_decode(const char *src, char *out_buf, size_t out_buf_len)
{
	int len , i, c, n1, n2;
	char *outp;
	assert(src && out_buf);
	len = strlen(src);
	outp = out_buf;
	int cnt = 0;
	
	for(i = 0; i < len; i++){
		c = src[i];
		if(c == '%' && i+2 < len && cnt+1 < out_buf_len){
			c = src[i+1];
			if(c == '%'){
				*outp = '%';
				outp++;
				cnt++;
				i++;
			}else{
				if(c >= '0' && c <= '9'){
					n1 = c - '0';
				}else if(c >= 'A' && c <= 'Z'){
					n1 = c - 'A' + 10;
				}else if(c >= 'a' && c <= 'z'){
					n1 = c - 'a' + 10;
				}else{
					return -1;
				}
				n1 = (n1 << 4) & 0xf0;
				c = src[i+2];
				if(c >= '0' && c <= '9'){
					n2 = c - '0';
				}else if(c >= 'A' && c <= 'Z'){
					n2 = c - 'A' + 10;
				}else if(c >= 'a' && c <= 'z'){
					n2 = c - 'a' + 10;
				}else{
					return -1;
				}
				*outp = (char)(n1 + (n2 & 0x0f));
				outp++;
				cnt++;
				i += 2;
			}
		}else{
			*outp = c;
			outp++;
			cnt++;
		}
	}
	*outp = '\0';
	return cnt;
}

BOOL url_encode(const char *src, char *out_buf, size_t out_buf_len)
{
	int len , i; 
	unsigned int c;
	assert(src && out_buf);
	len = strlen(src);
	if((len * 3) > out_buf_len - 1)
		return FALSE;
	
	for(i = 0; i < len; i++){
		c = 0xff & src[i];
		if((c >= '0' && c <= '9') ||
			(c >= 'a' && c <= 'z') ||
			(c >= 'A' && c <= 'Z') ||
			c == '-' || c == '_' || 
			c == '.' || c == '~'){
			*out_buf = c;
			out_buf++;
		}else{
			sprintf(out_buf, "%%%02X", c);
			out_buf += 3;
		}
	}
	*out_buf = '\0';
	return TRUE;
}

wchar_t* nt_rid_sufix(const wchar_t *file_name)
{
	int len;
	wchar_t *cptr, *cptr1;

	assert(file_name);
	len = wcslen(file_name);
	if(len == 0){
		cptr = malloc(sizeof(wchar_t));
		if(!cptr)
			return NULL;
		*cptr = L'\0';
		return cptr;
	}
	cptr = malloc(sizeof(wchar_t)*(len+1));
	if(!cptr)
		return NULL;
	wcscpy(cptr, file_name);
	cptr1 = wcsstr(cptr,	L".dat");
	if(cptr1){
		*cptr1 = L'\0';
	}else{
		cptr1 = wcsstr(cptr, L".cgi");
		if(cptr1){
			*cptr1 = L'\0';
		}
	}
	return cptr;
}

BOOL nt_parse_server_name_and_board_name(const wchar_t *url,
    wchar_t *buf, size_t buf_size, wchar_t **server_name,
	wchar_t **board_name)
{
	wchar_t *cptr1, *cptr2, *cptr3;
	int i, len;

	assert(url);

	len = wcslen(url);
	if(len >= buf_size-1)
		return FALSE;
	wcscpy(buf, url);
	
	cptr1 = wcsstr(buf, L"http://");
	if(NULL == cptr1)
		return FALSE;
	cptr1 += 7;
	
	cptr2 = wcschr(cptr1, L'/');
	if(NULL == cptr2)
		return FALSE;
	*cptr2 = L'\0';
	cptr2++;	
	cptr3 = wcschr(cptr2, L'/');
	if(cptr3 != NULL)
		*cptr3 = L'\0';

	len = wcslen(cptr2);
	for(i = len - 1; i >= 0; i--){
		if(cptr2[i] != L' ')
			break;
		cptr2[i] = L'\0';
	}
	*server_name = cptr1;
	*board_name = cptr2;
	return TRUE;
}
