/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _NT_COOKIE_H_ 
#define _NT_COOKIE_H_
#include "utils/nt_std_t.h"

typedef struct tag_nt_cookie_t  *nt_cookie_tp;
typedef struct tag_nt_cookie_t {
	char *db_file_name;
	nt_link_tp cookies; /* the data content is a nt_key_value_tp */
}nt_cookie_t;

extern nt_cookie_tp nt_load_cookies(const char *db_path);
extern void nt_unload_cookie(nt_cookie_tp cookie);
extern BOOL nt_add_cookie(nt_cookie_tp cookiep,
			const char *domain, const char *value);
extern nt_link_tp  nt_get_cookies(nt_cookie_tp cookiep, 
		const char *host_name);

#endif /* _NT_COOKIE_H_ */
