<?php
/*
 nce (ntch cloud environment.)
 name: nc_write_file.php
 author: Akira Ohta (akohta001.gmail.com)
 date: 2013-apr-14th
 description:
 License: GPLv3
 */
include_once "account.php";
include_once "preference.php";
include_once "database.php";
include_once "log.php";
include_once "http_util.php";
include_once "error_code.php";

$user_id = $_POST['user'];
$token = $_POST['token'];
$file_name = $_POST['file_name'];
$data = $_POST['data'];

$user = chk_passwd( $user_id, $token);
if(FALSE === $user){
	echo $ERROR_MSG;
	exit;
}

if(!chk_param($file_name) || !$data){
	echo ERROR303;
	exit;
}

$home_dir = OUTPUT_DIR."/{$user->home_dir}";

if(!is_dir($home_dir)){
	$rc = mkdir($home_dir, 0755, true);
	if(!$rc){
		nc_logging("Failed to create folders: $home_dir");
		echo ERROR400;
		exit;
	}
}

$data = replace_urlencodeTo64symbol($data);

$file_path = $home_dir.'/'.$file_name;

@$fp=fopen($file_path, 'w');
if(!$fp){
	nc_logging("Failed to create file: $file_path");
	echo ERROR400;
	exit;
}
flock($fp, LOCK_EX);
if(FALSE === fwrite($fp, $data."\n")){
	flock($fp, LOCK_UN);
	nc_logging("Failed to write file: $file_path");
	echo ERROR400;
	exit;
}
flock($fp, LOCK_UN);
fclose($fp);


echo SUCCESS100;
echo "\n".$file_path;
?>
