/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _NT_PTHREAD_h_
#define _NT_PTHREAD_h_
#include <pthread.h>

typedef struct tag_nt_pthread_t *nt_pthread_tp;
typedef struct tag_nt_pthread_t{
	//nt_pthread_fn;
	void *param;
}nt_pthread_t;

typedef struct tag_nt_pthread_ctx *nt_pthread_ctxp;
typedef struct tag_nt_pthread_ctx{
	pthread_t *pthreads;
	nt_queue_tp queue;
	int num_threads;
	int max_queue_size;
}nt_pthread_ctx;

extern nt_pthread_ctxp nt_pthread_init(
		int num_threads, int queue_size. const wchar_t *error_msg);
extern void nt_pthread_free(nt_pthread_ctxp ctxp);

#endif /* _NT_PTHREAD_h_ */
