/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _FAVORITE_T_H_
#define _FAVORITE_T_H_

#include "utils/nt_std_t.h"
#include "utils/nt_mutex.h"

#define NT_FAVORITE_GRP_FLAG_FOLDER_OPEN (1)


typedef struct tag_nt_favorite_handle{
	int chk_sum;
} nt_favorite_handle_t, *nt_favorite_handle;

typedef struct tag_nt_favorite_board_handle{
	int chk_sum;
} nt_favorite_board_handle_t, *nt_favorite_board_handle;

typedef struct tag_nt_favorite_grp_handle{
	int chk_sum;
} nt_favorite_grp_handle_t, *nt_favorite_grp_handle;

typedef struct tag_nt_favorite_thread_handle{
	int chk_sum;
} nt_favorite_thread_handle_t, *nt_favorite_thread_handle;

extern void favorite_dump(nt_favorite_handle handle);

extern BOOL nt_favorite_load_boards(
			nt_favorite_handle handle, nt_link_tp board_list);
extern nt_link_tp nt_favorite_retrieve_boards(nt_favorite_handle handle);
extern BOOL nt_favorite_load_threads(nt_favorite_handle handle, 
		nt_favorite_grp_handle h_grp, 
		nt_link_tp thread_list);
extern BOOL nt_favorite_retrieve_threads(nt_favorite_handle handle,
		nt_link_tp *grp_list, nt_link_tp *thread_list);

extern nt_favorite_handle nt_favorite_alloc(const wchar_t *unique_key);
extern nt_favorite_board_handle nt_favorite_board_alloc(
	nt_favorite_handle favorite_handle, const wchar_t *board_name);
extern nt_favorite_grp_handle nt_favorite_grp_alloc(
	nt_favorite_handle favorite_handle, const wchar_t *grp_name, int flags);
extern nt_favorite_thread_handle nt_favorite_thread_alloc(
	nt_favorite_grp_handle grp_handle, 
	const wchar_t *dat_name, const wchar_t *board_name,
	const wchar_t *title);
extern BOOL nt_favorite_board_remove(nt_favorite_board_handle handle);
extern BOOL nt_favorite_thread_remove(nt_favorite_thread_handle handle);


extern int nt_favorite_add_ref(nt_favorite_handle handle);
extern int nt_favorite_release_ref(nt_favorite_handle handle);
extern int nt_favorite_board_add_ref(nt_favorite_board_handle handle);
extern int nt_favorite_board_release_ref(nt_favorite_board_handle handle);
extern int nt_favorite_grp_add_ref(nt_favorite_grp_handle handle);
extern int nt_favorite_grp_release_ref(nt_favorite_grp_handle handle);
extern int nt_favorite_thread_add_ref(nt_favorite_thread_handle handle);
extern int nt_favorite_thread_release_ref(nt_favorite_thread_handle handle);

extern nt_enum_handle nt_favorite_acquire_board_enum(nt_favorite_handle handle);
extern nt_enum_handle nt_favorite_acquire_grp_enum(nt_favorite_handle handle);
extern nt_enum_handle nt_favorite_acquire_thread_enum(nt_favorite_grp_handle handle);

extern nt_mutex_handle nt_favorite_get_mutex(nt_favorite_handle handle);
extern nt_mutex_handle nt_favorite_board_get_mutex(nt_favorite_board_handle handle);
extern nt_mutex_handle nt_favorite_grp_get_mutex(nt_favorite_grp_handle handle);
extern nt_mutex_handle nt_favorite_thread_get_mutex(nt_favorite_thread_handle handle);

extern const wchar_t* nt_favorite_board_get_name(
		nt_favorite_board_handle handle);
extern const wchar_t* nt_favorite_grp_get_name(
		nt_favorite_grp_handle handle);
extern BOOL nt_favorite_grp_get_flag(
		nt_favorite_grp_handle handle, int flag);
extern void nt_favorite_grp_set_flag(
		nt_favorite_grp_handle handle, int flag);
extern void nt_favorite_grp_unset_flag(
		nt_favorite_grp_handle handle, int flag);
extern const wchar_t* nt_favorite_thread_get_dat_name(
		nt_favorite_thread_handle handle);
extern const wchar_t* nt_favorite_thread_get_board_name(
		nt_favorite_thread_handle handle);
extern const wchar_t* nt_favorite_thread_get_title(
		nt_favorite_thread_handle handle);


#endif /* _FAVORITE_T_H_ */

