#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iconv.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>

#include "utils/nt_std_t.h"
#include "net/nt_socket.h"

void nt_socket_free(nt_socket_tp socketp)
{
	free(socketp);
}

nt_socket_tp nt_socket_init(int port, char *addr)
{
	struct hostent *hostinfo;

	nt_socket_tp ptr = malloc(sizeof(nt_socket_t));
	if(ptr == NULL)
		return NULL;
	
	ptr->_sockaddr_in.sin_family = AF_INET;
	ptr->_sockaddr_in.sin_port = htons(port);
	ptr->_sockaddr_in.sin_addr.s_addr = inet_addr(addr);
	if(ptr->_sockaddr_in.sin_addr.s_addr == 0xffffffff){
		hostinfo = gethostbyname(addr);
		if(NULL == hostinfo)
			return NULL;
		if(hostinfo->h_addrtype != AF_INET)
			return NULL;
		if(hostinfo->h_addr_list[0] == NULL)
			return NULL;
		memcpy(&ptr->_sockaddr_in.sin_addr.s_addr, 
				hostinfo->h_addr_list[0], 4);
	}
	return ptr;
}

int nt_socket_connect(nt_socket_tp socketp, char* data, int data_len)
{
	int sockfd;
	int len;
	int result;

	sockfd = socket(AF_INET, SOCK_STREAM, 0);
	if(sockfd == -1)
		return -1;
	len = sizeof(socketp->_sockaddr_in);
	result = connect(sockfd, 
			(struct sockaddr *)&(socketp->_sockaddr_in), len);
	if(result == -1){
		close(sockfd);
		return -1;
	}

	result = write(sockfd, data, data_len);
	if(result == -1){
		close(sockfd);
		return -1;
	}
	return sockfd;
}
