/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.form;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import twitter.cache.TwitterImageCache;
import twitter.gui.component.TweetHashtagHyperlinkHandler;
import twitter.gui.component.TweetHyperlinkHandler;
import twitter.gui.component.UserTableModel;
import twitter.manage.TweetManager;
import twitter4j.User;

public class FollowingFollowerDialog
extends JDialog {
    private UserTableModel listTableModel = new UserTableModel();
    private TweetManager tweetManager = null;
    private int numOfPage = 0;
    private static final int iconSize = 50;
    private TweetHashtagHyperlinkHandler hashTagHyperlinkListener = new TweetHashtagHyperlinkHandler();
    private int prevGetFollowingFollower = 0;
    private String prevUsername = "";
    private Thread updateThread = null;
    private boolean currentThreadRunState = false;
    private JEditorPane clientNameLabel;
    private JLabel followerLabel;
    private JLabel followingLabel;
    private JLabel informationLabel;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JTable jTable1;
    private JTextField jTextField1;
    private JLabel locationLabel;
    private JEditorPane tweetMessageBox;
    private JLabel updateLabel;
    private JLabel updateTimeLabel;
    private JLabel userImageLabel;
    private JEditorPane userIntroBox;
    private JLabel userNameLabel;
    private JEditorPane userWebBox;

    public FollowingFollowerDialog(Frame parent, boolean modal, TweetManager manager) {
        super(parent, modal);
        this.initComponents();
        this.tweetManager = manager;
        this.numOfPage = 0;
    }

    public Thread createFollowingFollowerGetThread() {
        return new Thread(){

            @Override
            public void run() {
                String userName = FollowingFollowerDialog.this.jTextField1.getText();
                int ffIndex = FollowingFollowerDialog.this.jComboBox1.getSelectedIndex();
                if (userName == null || userName.length() <= 0 || !FollowingFollowerDialog.this.prevUsername.equals(userName) || FollowingFollowerDialog.this.prevGetFollowingFollower != ffIndex) {
                    FollowingFollowerDialog.this.numOfPage = 0;
                    FollowingFollowerDialog.this.jLabel2.setText("0");
                    FollowingFollowerDialog.this.listTableModel.clearStatus();
                }
                InsertProgressListener progressListener = new InsertProgressListener(FollowingFollowerDialog.this.jProgressBar1);
                try {
                    if (userName != null && userName.length() > 0) {
                        boolean update = false;
                        switch (ffIndex) {
                            case 0: {
                                update = FollowingFollowerDialog.this.addFollowingToTable(userName, FollowingFollowerDialog.this.numOfPage, progressListener);
                                break;
                            }
                            default: {
                                update = FollowingFollowerDialog.this.addFollowerToTable(userName, FollowingFollowerDialog.this.numOfPage, progressListener);
                            }
                        }
                        if (update) {
                            FollowingFollowerDialog followingFollowerDialog = FollowingFollowerDialog.this;
                            followingFollowerDialog.numOfPage = followingFollowerDialog.numOfPage + 1;
                            FollowingFollowerDialog.this.jLabel2.setText(String.valueOf(FollowingFollowerDialog.this.numOfPage * 100));
                        }
                        FollowingFollowerDialog.this.prevUsername = userName;
                        FollowingFollowerDialog.this.prevGetFollowingFollower = ffIndex;
                    }
                    FollowingFollowerDialog.this.setInformation("\u30c7\u30fc\u30bf\u53d6\u5f97\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
                }
                catch (Exception e) {
                    FollowingFollowerDialog.this.setInformation("\u30c7\u30fc\u30bf\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u6307\u5b9a\u3057\u305f\u30e6\u30fc\u30b6\u306f\u5b58\u5728\u3057\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
                }
            }
        };
    }

    public boolean addFollowingToTable(String username, int page, InsertProgressListener listener) {
        this.setTableEnvironment();
        boolean update = false;
        List<User> list = this.tweetManager.getFollowingUser(username, page);
        if (list != null) {
            if (listener != null) {
                listener.setMaxNum(list.size() - 1);
            }
            int currentInsertNum = 0;
            for (User u : list) {
                if (listener != null) {
                    listener.setCurrentNum(currentInsertNum);
                }
                ++currentInsertNum;
                this.listTableModel.insertUserList(u);
                update = true;
            }
        }
        return update;
    }

    public boolean addFollowerToTable(String username, int page, InsertProgressListener listener) {
        this.setTableEnvironment();
        boolean update = false;
        List<User> list = this.tweetManager.getFollowerUser(username, page);
        if (list != null) {
            if (listener != null) {
                listener.setMaxNum(list.size() - 1);
            }
            int currentInsertNum = 0;
            for (User u : list) {
                if (listener != null) {
                    listener.setCurrentNum(currentInsertNum);
                }
                ++currentInsertNum;
                this.listTableModel.insertUserList(u);
                update = true;
            }
        }
        return update;
    }

    public void setTableEnvironment() {
        TableColumnModel columnModel = this.jTable1.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setMinWidth(50);
        column.setMaxWidth(50);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FollowingFollowerDialog.this.jTable1.clearSelection();
                Point p = e.getPoint();
                int col = FollowingFollowerDialog.this.jTable1.columnAtPoint(p);
                int row = FollowingFollowerDialog.this.jTable1.rowAtPoint(p);
                FollowingFollowerDialog.this.jTable1.changeSelection(row, col, false, false);
                FollowingFollowerDialog.this.setDetailInformation(FollowingFollowerDialog.this.jTable1);
            }
        });
        this.jTable1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                FollowingFollowerDialog.this.setDetailInformation(FollowingFollowerDialog.this.jTable1);
            }
        });
    }

    public void setDetailInformation(JTable table) {
        ImageIcon icon;
        User user = this.getTweetTableInformation(table, this.listTableModel);
        if (user == null) {
            return;
        }
        String username = user.getName();
        String screenName = user.getScreenName();
        String updateTime = "";
        if (user.getStatus() != null) {
            updateTime = user.getStatus().getCreatedAt().toString();
        }
        String location = "";
        if (user.getLocation() != null) {
            location = user.getLocation().toString();
        }
        String following = String.valueOf(user.getFriendsCount());
        String follower = String.valueOf(user.getFollowersCount());
        String update = String.valueOf(user.getStatusesCount());
        String url = "";
        if (user.getURL() != null) {
            url = user.getURL().toString();
        }
        String client = "";
        String text = "";
        if (user.getStatus() != null) {
            client = user.getStatus().getSource();
            text = user.getStatus().getText();
        }
        String profile = user.getDescription();
        if (username != null || screenName != null) {
            this.userNameLabel.setText(String.valueOf(username) + "/" + screenName);
        }
        if (updateTime != null) {
            this.updateTimeLabel.setText(updateTime);
        }
        if (location != null) {
            this.locationLabel.setText(location);
        }
        if (following != null) {
            this.followingLabel.setText(following);
        }
        if (follower != null) {
            this.followerLabel.setText(follower);
        }
        if (update != null) {
            this.updateLabel.setText(update);
        }
        if (url != null) {
            this.userWebBox.setText(url);
        }
        if (client != null) {
            this.clientNameLabel.setText(client);
        }
        if (text != null) {
            this.tweetMessageBox.setText(text);
        }
        if (profile != null) {
            this.userIntroBox.setText(profile);
        }
        if ((icon = TwitterImageCache.getInstance().getProfileImage(user.getProfileImageURL().toString())) != null) {
            this.userImageLabel.setIcon(icon);
        }
    }

    public User getTweetTableInformation(JTable table, TableModel model) {
        int index = table.convertRowIndexToModel(table.getSelectedRow());
        User info = null;
        if (model instanceof UserTableModel && index >= 0) {
            info = ((UserTableModel)model).getUserList(index);
        }
        return info;
    }

    private void initComponents() {
        Style body;
        int i;
        StyleSheet[] style;
        HTMLDocument doc;
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.userIntroBox = new JEditorPane();
        this.jLabel10 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.userNameLabel = new JLabel();
        this.updateTimeLabel = new JLabel();
        this.locationLabel = new JLabel();
        this.jLabel9 = new JLabel();
        this.followingLabel = new JLabel();
        this.followerLabel = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.updateLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jScrollPane7 = new JScrollPane();
        this.userWebBox = new JEditorPane();
        this.jScrollPane8 = new JScrollPane();
        this.clientNameLabel = new JEditorPane();
        this.userImageLabel = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.tweetMessageBox = new JEditorPane();
        this.jLabel11 = new JLabel();
        this.informationLabel = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.setTitle("Following/Follower\u4e00\u89a7");
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowingFollowerDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jTable1.setModel(this.listTableModel);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabel1.setText("\u53d6\u5f97\u3057\u305f\u3044\u30e6\u30fc\u30b6\u540d");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Following", "Follower"}));
        this.jLabel2.setLabelFor(this.jButton1);
        this.jLabel2.setText("0");
        this.jLabel6.setText("\u4ef6\u307e\u3067\u306e\u60c5\u5831\u3092\u53d6\u5f97");
        this.jButton2.setText("\u6b21\u306e100\u4ef6\u306e\u60c5\u5831\u3092\u53d6\u5f97");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowingFollowerDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane6.setHorizontalScrollBarPolicy(31);
        this.userIntroBox.setContentType("text/html");
        this.userIntroBox.setEditable(false);
        this.userIntroBox.setMinimumSize(new Dimension(120, 20));
        this.jScrollPane6.setViewportView(this.userIntroBox);
        this.jLabel10.setText("\u7d39\u4ecb\u6587");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 158, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setPreferredSize(new Dimension(250, 216));
        this.userNameLabel.setText("UserName");
        this.updateTimeLabel.setText("Date");
        this.locationLabel.setText("Information");
        this.jLabel9.setText("Following");
        this.followingLabel.setText("0");
        this.followerLabel.setText("0");
        this.jLabel12.setText("Follower");
        this.jLabel13.setText("\u66f4\u65b0\u56de\u6570");
        this.updateLabel.setText("0");
        this.jLabel3.setText("\u30e6\u30fc\u30b6\u540d");
        this.jLabel5.setText("\u73fe\u5728\u5730");
        this.jLabel4.setText("\u66f4\u65b0\u65e5");
        this.jLabel7.setText("Web");
        this.jLabel8.setText("Client");
        this.jScrollPane7.setBorder(null);
        this.jScrollPane7.setHorizontalScrollBarPolicy(31);
        this.jScrollPane7.setVerticalScrollBarPolicy(21);
        this.userWebBox.setBorder(null);
        this.userWebBox.setContentType("text/html");
        this.userWebBox.setEditable(false);
        this.userWebBox.setEditable(false);
        this.userWebBox.addHyperlinkListener(new TweetHyperlinkHandler());
        try {
            doc = (HTMLDocument)this.userWebBox.getDocument();
            style = doc.getStyleSheet().getStyleSheets();
            i = style.length - 1;
            while (i >= 0) {
                body = style[i].getStyle("body");
                if (body != null) {
                    StyleConstants.setFontSize(body, 13);
                }
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.jScrollPane7.setViewportView(this.userWebBox);
        this.jScrollPane8.setBorder(null);
        this.jScrollPane8.setHorizontalScrollBarPolicy(31);
        this.jScrollPane8.setVerticalScrollBarPolicy(21);
        this.clientNameLabel.setBorder(null);
        this.clientNameLabel.setContentType("text/html");
        this.clientNameLabel.setEditable(false);
        this.clientNameLabel.setEditable(false);
        this.clientNameLabel.addHyperlinkListener(new TweetHyperlinkHandler());
        try {
            doc = (HTMLDocument)this.clientNameLabel.getDocument();
            style = doc.getStyleSheet().getStyleSheets();
            i = style.length - 1;
            while (i >= 0) {
                body = style[i].getStyle("body");
                if (body != null) {
                    StyleConstants.setFontSize(body, 13);
                }
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.jScrollPane8.setViewportView(this.clientNameLabel);
        this.userImageLabel.setBackground(Color.black);
        this.userImageLabel.setOpaque(true);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, 312, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userImageLabel, -2, 48, -2).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, 67, Short.MAX_VALUE).addComponent(this.jLabel12, -1, 67, Short.MAX_VALUE).addComponent(this.jLabel13, -1, 67, Short.MAX_VALUE).addComponent(this.jLabel8, -1, 67, Short.MAX_VALUE).addComponent(this.jLabel7, -1, 67, Short.MAX_VALUE).addComponent(this.jLabel4, -1, 67, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.updateTimeLabel, -1, 221, Short.MAX_VALUE).addComponent(this.updateLabel, -1, 221, Short.MAX_VALUE).addComponent(this.followerLabel, -1, 221, Short.MAX_VALUE).addComponent(this.followingLabel, -1, 221, Short.MAX_VALUE).addComponent(this.jScrollPane8, -1, 221, Short.MAX_VALUE).addComponent(this.userNameLabel, -1, 221, Short.MAX_VALUE).addComponent(this.locationLabel, GroupLayout.Alignment.TRAILING, -1, 221, Short.MAX_VALUE).addComponent(this.jScrollPane7, -2, 221, -2)))).addContainerGap()))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.userImageLabel, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -1, 23, Short.MAX_VALUE).addComponent(this.userNameLabel, -1, 23, Short.MAX_VALUE)).addGap(3, 3, 3).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -1, 23, Short.MAX_VALUE).addComponent(this.updateTimeLabel, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.locationLabel, -2, 21, -2)).addGap(12, 12, 12).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.followingLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.followerLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.updateLabel, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane7, -1, 23, Short.MAX_VALUE).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, -2, 15, -2).addComponent(this.jScrollPane8, -2, 23, -2)).addContainerGap()));
        jPanel3Layout.linkSize(1, this.followerLabel, this.followingLabel, this.jLabel12, this.jLabel13, this.jLabel3, this.jLabel4, this.jLabel5, this.jLabel7, this.jLabel8, this.jLabel9, this.jScrollPane7, this.jScrollPane8, this.locationLabel, this.updateLabel, this.updateTimeLabel, this.userNameLabel);
        this.jScrollPane5.setHorizontalScrollBar(null);
        this.tweetMessageBox.setContentType("text/html");
        this.tweetMessageBox.setEditable(false);
        this.tweetMessageBox.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                FollowingFollowerDialog.this.tweetMessageBoxComponentResized(evt);
            }
        });
        this.tweetMessageBox.addHyperlinkListener(this.hashTagHyperlinkListener);
        this.jScrollPane5.setViewportView(this.tweetMessageBox);
        this.jLabel11.setText("\u6700\u5f8c\u306e\u767a\u8a00");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel3, -2, 328, -2).addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane6, -1, 353, Short.MAX_VALUE).addComponent(this.jScrollPane5, GroupLayout.Alignment.LEADING, -1, 353, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 278, Short.MAX_VALUE)))).addGroup(jPanel1Layout.createSequentialGroup().addGap(101, 101, 101).addComponent(this.jPanel2, -2, -1, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -1, 144, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane6, -1, 120, Short.MAX_VALUE)).addComponent(this.jPanel3, -2, 311, -2)).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addGap(0, 0, 0)));
        this.informationLabel.setText("information");
        this.informationLabel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(2, 2, 2).addComponent(this.jTextField1, -1, 260, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, 0, 289, Short.MAX_VALUE).addContainerGap()).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 709, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.informationLabel, -1, 709, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel2).addGap(16, 16, 16).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -1, 197, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, 219, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 94, -2).addGap(14, 14, 14)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 246, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 344, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton1, -2, 27, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jLabel2)))).addGap(12, 12, 12).addComponent(this.informationLabel)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void tweetMessageBoxComponentResized(ComponentEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.updateThread == null || !this.updateThread.isAlive()) {
            this.updateThread = this.createFollowingFollowerGetThread();
            this.updateThread.start();
            this.setInformation("\u30c7\u30fc\u30bf\u53d6\u5f97\u3092\u958b\u59cb\u3057\u307e\u3059");
        } else {
            this.setInformation("\u73fe\u5728\u30c7\u30fc\u30bf\u3092\u53d6\u5f97\u4e2d\u3067\u3059");
        }
    }

    public void actionUserSearch(String username, boolean ff) {
        if (username != null) {
            this.jTextField1.setText(username);
        }
        if (ff) {
            this.jComboBox1.setSelectedIndex(0);
        } else {
            this.jComboBox1.setSelectedIndex(1);
        }
        this.jButton2ActionPerformed(null);
    }

    public void setInformation(String msg) {
        if (this.informationLabel != null) {
            this.informationLabel.setText(msg);
        }
    }

    private class InsertProgressListener {
        private JProgressBar progress;
        private int maxNum;
        private int currentNum;

        public InsertProgressListener(JProgressBar progress) {
            this.progress = progress;
        }

        public int getCurrentNum() {
            return this.currentNum;
        }

        public void setCurrentNum(int currentNum) {
            this.currentNum = currentNum;
            this.progress.setMaximum(this.maxNum);
            this.progress.setValue(this.currentNum);
        }

        public int getMaxNum() {
            return this.maxNum;
        }

        public void setMaxNum(int maxNum) {
            this.maxNum = maxNum;
        }
    }
}

