/*
 * Decompiled with CFR 0.152.
 */
package twitter.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class MultiSortedMap<T, V> {
    private SortedMap<T, SortedSet<V>> mmap;

    public MultiSortedMap() {
        this.mmap = Collections.synchronizedSortedMap(new TreeMap());
    }

    public MultiSortedMap(Comparator<? super T> cmprtr) {
        this.mmap = Collections.synchronizedSortedMap(new TreeMap(cmprtr));
    }

    public void add(T key, V value) {
        SortedSet mapValue = null;
        mapValue = this.mmap.containsKey(key) ? (SortedSet)this.mmap.get(key) : Collections.synchronizedSortedSet(new TreeSet());
        mapValue.add(value);
        this.mmap.put(key, mapValue);
    }

    public SortedSet<V> get(T key) {
        if (this.mmap == null) {
            return null;
        }
        SortedSet s = new TreeSet();
        s = (SortedSet)this.mmap.get(key);
        return s;
    }

    public Set<T> getKeys() {
        if (this.mmap == null) {
            return null;
        }
        return this.mmap.keySet();
    }

    public Collection<SortedSet<V>> getValues() {
        if (this.mmap == null) {
            return null;
        }
        return this.mmap.values();
    }

    public int size() {
        return this.mmap.size();
    }

    public boolean contains(T key, V value) {
        SortedSet<V> t = this.get(key);
        if (t != null) {
            return t.contains(value);
        }
        return false;
    }

    public boolean containsKey(T key) {
        return this.mmap.containsKey(key);
    }

    public SortedSet<V> remove(T key) {
        return (SortedSet)this.mmap.remove(key);
    }

    public boolean removeValue(T key, V value) {
        SortedSet<V> t = this.get(key);
        if (t != null) {
            return t.remove(value);
        }
        return false;
    }
}

