/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.component;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    protected transient Image image;
    protected transient TexturePaint texture;
    protected Rectangle rect = new Rectangle();
    protected transient Image cachedImage;
    private static final int RECTANGLE_INT = 1;
    private static final int RECTANGLE_FLOAT = 2;
    private static final int RECTANGLE_DOUBLE = 3;

    public ImagePanel() {
        this.setOpaque(false);
    }

    public ImagePanel(TexturePaint texture) {
        if (texture == null) {
            throw new IllegalArgumentException("argument is null !");
        }
        this.texture = texture;
        this.setOpaque(false);
    }

    public ImagePanel(Image img, boolean isTexture) {
        this.setBG(img, isTexture);
        this.setOpaque(false);
    }

    public ImagePanel(String filePath, boolean isTexture) {
        if (filePath == null || filePath.length() == 0) {
            throw new IllegalArgumentException("filePath is null or empty !");
        }
        ImageIcon imageIcon = new ImageIcon(filePath);
        this.setBG(imageIcon, isTexture);
        this.setOpaque(false);
    }

    public ImagePanel(ImageIcon imageIcon, boolean isTexture) {
        this.setBG(imageIcon, isTexture);
        this.setOpaque(false);
    }

    public void setImage(Image img) {
        if (img == null) {
            throw new IllegalArgumentException("argument is null !");
        }
        if (this.image == img) {
            return;
        }
        this.setBG(img, false);
        this.texture = null;
        this.cachedImage = null;
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public void setTexture(TexturePaint texture) {
        if (texture == null) {
            throw new IllegalArgumentException("argument is null !");
        }
        if (this.texture == texture) {
            return;
        }
        this.texture = texture;
        this.image = null;
        this.cachedImage = null;
        this.repaint();
    }

    public void setTextureFromImageIcon(ImageIcon imageIcon) {
        this.setBG(imageIcon, true);
        this.image = null;
        this.cachedImage = null;
        this.repaint();
    }

    public void setTextureFromImage(Image img) {
        if (img == null) {
            throw new IllegalArgumentException("argument is null !");
        }
        this.setBG(img, true);
        this.image = null;
        this.cachedImage = null;
        this.repaint();
    }

    public TexturePaint getTexture() {
        return this.texture;
    }

    public void removeBackgroundImage() {
        this.image = null;
        this.texture = null;
        this.cachedImage = null;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int tempW = this.rect.width;
        int tempH = this.rect.height;
        this.rect.width = this.getWidth();
        this.rect.height = this.getHeight();
        if (this.cachedImage != null && tempW == this.rect.width && tempH == this.rect.height) {
            g.drawImage(this.cachedImage, 0, 0, this);
            return;
        }
        if (this.image != null) {
            this.cachedImage = this.createImage(this.rect.width, this.rect.height);
            Graphics cachedG = this.cachedImage.getGraphics();
            cachedG.drawImage(this.image, 0, 0, this.rect.width, this.rect.height, this);
            cachedG.dispose();
            g.drawImage(this.cachedImage, 0, 0, this);
        } else if (this.texture != null) {
            this.cachedImage = this.createImage(this.rect.width, this.rect.height);
            Graphics2D cachedG = (Graphics2D)this.cachedImage.getGraphics();
            cachedG.setPaint(this.texture);
            cachedG.fill(this.rect);
            cachedG.dispose();
            g.drawImage(this.cachedImage, 0, 0, this);
        }
    }

    protected final void setBG(ImageIcon imageIcon, boolean isTexture) {
        if (imageIcon == null) {
            throw new IllegalArgumentException("argument (imageIcon) is null !");
        }
        if (isTexture) {
            this.texture = this.createTexturePaint(imageIcon);
        } else {
            this.image = imageIcon.getImage();
            if (this.image != null && (imageIcon.getIconWidth() <= 0 || imageIcon.getIconHeight() <= 0)) {
                this.image = null;
            }
        }
    }

    protected final void setBG(Image img, boolean isTexture) {
        if (img == null) {
            throw new IllegalArgumentException("argument (img) is null !");
        }
        int imageWidth = img.getWidth(this);
        int imageHeight = img.getHeight(this);
        if (imageWidth < 0 || imageHeight < 0) {
            this.setBG(new ImageIcon(img), isTexture);
            return;
        }
        if (isTexture) {
            this.texture = imageWidth <= 0 || imageHeight <= 0 ? null : this.createTexturePaint(img, imageWidth, imageHeight);
        } else {
            this.image = imageWidth <= 0 || imageHeight <= 0 ? null : img;
        }
    }

    protected final TexturePaint createTexturePaint(ImageIcon imageIcon) {
        if (imageIcon == null) {
            throw new IllegalArgumentException("argument (imageIcon) is null !");
        }
        Image img = imageIcon.getImage();
        int imageWidth = imageIcon.getIconWidth();
        int imageHeight = imageIcon.getIconHeight();
        if (img == null || imageIcon.getIconWidth() <= 0 || imageIcon.getIconHeight() <= 0) {
            return null;
        }
        return this.createTexturePaint(img, imageWidth, imageHeight);
    }

    protected final TexturePaint createTexturePaint(Image img, int imageWidth, int imageHeight) {
        if (img == null) {
            throw new IllegalArgumentException("argument (img) is null !");
        }
        if (imageWidth <= 0 || imageHeight <= 0) {
            throw new IllegalArgumentException("(imageWidth <= 0) || (imageHeight <= 0)");
        }
        BufferedImage textureImg = null;
        if (img instanceof BufferedImage) {
            textureImg = (BufferedImage)img;
        } else {
            textureImg = new BufferedImage(imageWidth, imageHeight, 2);
            Graphics2D textureG = textureImg.createGraphics();
            textureG.drawImage(img, 0, 0, imageWidth, imageHeight, this);
            textureG.dispose();
        }
        Rectangle rect = new Rectangle(0, 0, imageWidth, imageHeight);
        return new TexturePaint(textureImg, rect);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int width = in.readInt();
        int height = in.readInt();
        int[] pixels = (int[])in.readObject();
        if (pixels != null) {
            ColorModel colorModel = ColorModel.getRGBdefault();
            MemoryImageSource source = new MemoryImageSource(width, height, colorModel, pixels, 0, width);
            this.image = Toolkit.getDefaultToolkit().createImage(source);
        }
        int tpImageWidth = in.readInt();
        int tpImageHeight = in.readInt();
        int rectType = in.readInt();
        Rectangle2D rectangle = rectType == 1 ? new Rectangle(in.readInt(), in.readInt(), in.readInt(), in.readInt()) : (rectType == 2 ? new Rectangle2D.Float(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat()) : new Rectangle2D.Double(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble()));
        int[] tpPixels = (int[])in.readObject();
        if (tpPixels != null && tpPixels.length > 0) {
            BufferedImage bufferedImage = new BufferedImage(tpImageWidth, tpImageHeight, 2);
            bufferedImage.setRGB(0, 0, tpImageWidth, tpImageHeight, tpPixels, 0, tpImageWidth);
            this.texture = new TexturePaint(bufferedImage, rectangle);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Rectangle2D rect;
        out.defaultWriteObject();
        int imageWidth = -1;
        int imageHeight = -1;
        int[] imagePixels = null;
        if (this.image != null) {
            imageWidth = this.image.getWidth(this);
            imageHeight = this.image.getHeight(this);
            if (imageWidth > 0 && imageHeight > 0) {
                imagePixels = this.getImagePixels(imageWidth, imageHeight, this.image);
            }
        }
        out.writeInt(imageWidth);
        out.writeInt(imageHeight);
        out.writeObject(imagePixels);
        int tpImageWidth = -1;
        int tpImageHeight = -1;
        int rectType = 1;
        int[] tpPixels = null;
        Rectangle2D rectangle = null;
        if (this.texture != null) {
            rectangle = this.texture.getAnchorRect();
            rectType = rectangle instanceof Rectangle ? 1 : (rectangle instanceof Rectangle2D.Float ? 2 : 3);
            BufferedImage tpImage = this.texture.getImage();
            if (tpImage != null) {
                tpImageWidth = tpImage.getWidth();
                tpImageHeight = tpImage.getHeight();
                if (tpImageWidth > 0 && tpImageHeight > 0) {
                    tpPixels = tpImage.getRGB(0, 0, tpImageWidth, tpImageHeight, null, 0, tpImageWidth);
                }
            }
        }
        out.writeInt(tpImageWidth);
        out.writeInt(tpImageHeight);
        out.writeInt(rectType);
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        if (rectType == 1) {
            rect = (Rectangle)rectangle;
            out.writeInt(rect.x);
            out.writeInt(rect.y);
            out.writeInt(rect.width);
            out.writeInt(rect.height);
        } else if (rectType == 2) {
            rect = (Rectangle2D.Float)rectangle;
            out.writeFloat(((Rectangle2D.Float)rect).x);
            out.writeFloat(((Rectangle2D.Float)rect).y);
            out.writeFloat(((Rectangle2D.Float)rect).width);
            out.writeFloat(((Rectangle2D.Float)rect).height);
        } else {
            rect = (Rectangle2D.Double)rectangle;
            out.writeDouble(((Rectangle2D.Double)rect).x);
            out.writeDouble(((Rectangle2D.Double)rect).y);
            out.writeDouble(((Rectangle2D.Double)rect).width);
            out.writeDouble(((Rectangle2D.Double)rect).height);
        }
        out.writeObject(tpPixels);
    }

    private int[] getImagePixels(int width, int height, Image image) {
        int[] pixels = new int[width * height];
        try {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
            pg.grabPixels();
            if ((pg.getStatus() & 0x80) != 0) {
                pixels = null;
            }
        }
        catch (InterruptedException e) {
            pixels = null;
        }
        return pixels;
    }
}

