/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.form;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import twitter.gui.action.TweetMainAction;
import twitter.hashtag.HashtagSearcher;
import twitter.manage.TweetManager;
import twitter.util.MultiSortedMap;

public class HashtagSearchDialog
extends JDialog {
    private TweetMainAction mainAction;
    private TweetManager tweetManager;
    private DefaultListModel listModel = new DefaultListModel();
    private List<Integer> keywordAppearance = new ArrayList<Integer>();
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;

    public HashtagSearchDialog(Frame parent, boolean modal, TweetMainAction mainAction, TweetManager tweetManager) {
        super(parent, modal);
        this.initComponents();
        this.mainAction = mainAction;
        this.tweetManager = tweetManager;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("\u30cf\u30c3\u30b7\u30e5\u30bf\u30b0\u691c\u7d22");
        this.jLabel1.setText("\u30ad\u30fc\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                HashtagSearchDialog.this.jTextField1KeyPressed(evt);
            }
        });
        this.jLabel2.setText("\u30ad\u30fc\u30ef\u30fc\u30c9\u306b\u95a2\u9023\u3059\u308b\u30cf\u30c3\u30b7\u30e5\u30bf\u30b0\u4e00\u89a7");
        this.jList1.setModel(this.listModel);
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HashtagSearchDialog.this.jList1MouseClicked(evt);
            }
        });
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                HashtagSearchDialog.this.jList1ValueChanged(evt);
            }
        });
        this.jList1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                HashtagSearchDialog.this.jList1KeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jLabel3.setText("\u51fa\u73fe\u56de\u6570");
        this.jLabel4.setText("0");
        this.jButton1.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HashtagSearchDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setMnemonic('S');
        this.jButton2.setText("\u691c\u7d22(S)");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HashtagSearchDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setMnemonic('H');
        this.jButton3.setText("\u30cf\u30c3\u30b7\u30e5\u30bf\u30b0\u691c\u7d22(H)");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HashtagSearchDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setMnemonic('C');
        this.jButton4.setText("\u30af\u30ea\u30a2(C)");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HashtagSearchDialog.this.jButton4ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField1, -1, 461, Short.MAX_VALUE).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton3, -2, 162, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4, -2, 98, -2)).addComponent(this.jScrollPane1, -1, 461, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 177, Short.MAX_VALUE).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addGap(2, 2, 2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton2, -2, 98, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 98, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton4, -1, 31, Short.MAX_VALUE).addComponent(this.jButton3, -1, 31, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 287, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1, -1, 31, Short.MAX_VALUE).addComponent(this.jButton2, -1, 31, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.jTextField1.setText("");
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        String searchWord = this.jTextField1.getText();
        if (searchWord == null || searchWord.length() == 0) {
            JOptionPane.showMessageDialog(null, "\u30ad\u30fc\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044", "Search Error", 0);
        } else {
            this.listModel.clear();
            HashtagSearcher hashtagSearcher = new HashtagSearcher(this.tweetManager);
            MultiSortedMap<Integer, String> result = hashtagSearcher.getDescendantHashtagCount(searchWord);
            if (result == null) {
                JOptionPane.showMessageDialog(null, "\u6307\u5b9a\u3057\u305f\u30ad\u30fc\u30ef\u30fc\u30c9\u306b\u95a2\u9023\u3059\u308b\u30cf\u30c3\u30b7\u30e5\u30bf\u30b0\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f", "Search Result", 0);
            } else {
                this.keywordAppearance = new ArrayList<Integer>();
                for (Integer key : result.getKeys()) {
                    SortedSet<String> resultStrings = result.get(key);
                    for (String s : resultStrings) {
                        this.listModel.addElement(s);
                        this.keywordAppearance.add(key);
                    }
                }
                this.jList1.setSelectedIndex(0);
                this.jList1.requestFocus();
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jTextField1KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.jButton3ActionPerformed(null);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int selected = this.jList1.getSelectedIndex();
        if (selected >= 0) {
            String searchWord = (String)this.listModel.getElementAt(selected);
            this.setVisible(false);
            this.mainAction.actionShowKeywordSearchDialog(searchWord);
        } else {
            JOptionPane.showMessageDialog(null, "\u691c\u7d22\u3057\u305f\u3044\u30cf\u30c3\u30b7\u30e5\u30bf\u30b0\u3092\u30ea\u30b9\u30c8\u304b\u3089\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044", "Error", 0);
        }
    }

    private void jList1MouseClicked(MouseEvent evt) {
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        int selected = this.jList1.getSelectedIndex();
        if (selected >= 0) {
            this.jLabel4.setText("" + this.keywordAppearance.get(selected));
        }
    }

    private void jList1KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.jButton2ActionPerformed(null);
        }
    }
}

