/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.component;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import twitter.cache.TwitterImageCache;
import twitter4j.User;

public class UserTableModel
extends DefaultTableModel {
    private static final ColumnContext[] columnArray = new ColumnContext[]{new ColumnContext("User", ImageIcon.class, false), new ColumnContext("UserName", String.class, false), new ColumnContext("ScreenName", String.class, false)};
    private List<User> listInfo = new ArrayList<User>();

    public void clearStatus() {
        this.listInfo.clear();
        super.setRowCount(0);
    }

    @Override
    public Class<?> getColumnClass(int modelIndex) {
        return UserTableModel.columnArray[modelIndex].columnClass;
    }

    @Override
    public int getColumnCount() {
        return columnArray.length;
    }

    @Override
    public String getColumnName(int modelIndex) {
        return UserTableModel.columnArray[modelIndex].columnName;
    }

    public User getUserList(int row) {
        User s = null;
        try {
            s = this.listInfo.get(row);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public void insertUserList(User t) {
        TwitterImageCache imageCache = TwitterImageCache.getInstance();
        Object[] obj = new Object[]{imageCache.getProfileImage(t.getProfileImageURL().toString()), new String(t.getName()), new String(t.getScreenName())};
        try {
            super.addRow(obj);
            this.listInfo.add(t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertUserList(List<User> list) {
        TwitterImageCache imageCache = TwitterImageCache.getInstance();
        ImageIcon[] icons = new ImageIcon[list.size()];
        int i = 0;
        for (User t : list) {
            icons[i] = imageCache.getProfileImage(t.getProfileImageURL().toString());
            ++i;
        }
        int j = 0;
        for (User t : list) {
            Object[] obj = new Object[]{icons[j], new String(t.getName()), new String(t.getScreenName())};
            try {
                super.addRow(obj);
                this.listInfo.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++j;
        }
    }

    public int getTableSize() {
        return this.listInfo.size();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    private static class ColumnContext {
        public final Class columnClass;
        public final String columnName;
        public final boolean isEditable;

        public ColumnContext(String columnName, Class columnClass, boolean isEditable) {
            this.columnName = columnName;
            this.columnClass = columnClass;
            this.isEditable = isEditable;
        }
    }
}

