/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.component;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import twitter4j.UserList;

public class TweetListTableModel
extends DefaultTableModel {
    private static final ColumnContext[] columnArray = new ColumnContext[]{new ColumnContext("User", ImageIcon.class, false), new ColumnContext("ListName", String.class, false), new ColumnContext("ListUser", String.class, false), new ColumnContext("Description", String.class, false)};
    private List<UserList> listInfo = new ArrayList<UserList>();

    public void clearStatus() {
        this.listInfo.clear();
    }

    @Override
    public Class<?> getColumnClass(int modelIndex) {
        return TweetListTableModel.columnArray[modelIndex].columnClass;
    }

    @Override
    public int getColumnCount() {
        return columnArray.length;
    }

    @Override
    public String getColumnName(int modelIndex) {
        return TweetListTableModel.columnArray[modelIndex].columnName;
    }

    public UserList getUserList(int row) {
        UserList s = null;
        try {
            s = this.listInfo.get(row);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public void insertUserList(UserList t) {
        Object[] obj = new Object[]{new ImageIcon(t.getUser().getProfileImageURL()), new String(t.getName()), new String(t.getUser().getScreenName()), new String(t.getDescription())};
        try {
            super.insertRow(0, obj);
            this.listInfo.add(0, t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getTableSize() {
        return this.listInfo.size();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    private static class ColumnContext {
        public final Class columnClass;
        public final String columnName;
        public final boolean isEditable;

        public ColumnContext(String columnName, Class columnClass, boolean isEditable) {
            this.columnName = columnName;
            this.columnClass = columnClass;
            this.isEditable = isEditable;
        }
    }
}

