/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.component;

import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import twitter.gui.component.TweetTableModel;
import twitter4j.Status;

public class TweetInfoTable
extends JTable {
    public TweetInfoTable() {
    }

    public TweetInfoTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public TweetInfoTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public TweetInfoTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public TweetInfoTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public TweetInfoTable(TableModel dm) {
        super(dm);
    }

    public TweetInfoTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int row = this.rowAtPoint(e.getPoint());
        int column = this.columnAtPoint(e.getPoint());
        TableModel m = this.getModel();
        String retValue = null;
        if (m instanceof TweetTableModel) {
            Status s = ((TweetTableModel)m).getTweetStatus(row);
            if (column == 0) {
                String location = "";
                if (s.getUser().getLocation() != null && s.getUser().getLocation().length() > 0) {
                    location = "Location:" + s.getUser().getLocation() + "<br>";
                }
                String userURL = "";
                if (s.getUser().getURL() != null) {
                    userURL = s.getUser().getURL() + "<br>";
                }
                retValue = "<html><b>" + s.getUser().getName() + "</b><br><br>" + userURL + location + s.getUser().getFollowersCount() + " followers<br>" + s.getUser().getFriendsCount() + " following<br></html>";
            }
        } else {
            retValue = "<html>" + m.getValueAt(row, 0) + "<br>" + m.getValueAt(row, 1) + "</html>";
        }
        return retValue;
    }
}

