/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.component;

import java.awt.Desktop;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import twitter.gui.action.TweetMainAction;

public class TweetHashtagHyperlinkHandler
implements HyperlinkListener {
    private TweetMainAction mainAction;

    public void setMainAction(TweetMainAction mainAction) {
        this.mainAction = mainAction;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = e.getURL();
            String host = url.getHost();
            if (host.equals("search.twitter.com")) {
                String query = url.getQuery();
                String searchWord = null;
                if (query != null) {
                    try {
                        searchWord = URLDecoder.decode(query, "utf-8");
                        if (searchWord.startsWith("q=")) {
                            searchWord = searchWord.substring(2);
                        }
                    }
                    catch (UnsupportedEncodingException ex) {
                        Logger.getLogger(TweetHashtagHyperlinkHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.mainAction.actionAddNewSearchResultTab(searchWord, this.mainAction.getGetTimelinePeriod());
            } else {
                Desktop dp = Desktop.getDesktop();
                try {
                    dp.browse(url.toURI());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

