/*
 * Decompiled with CFR 0.152.
 */
package twitter.action;

import java.util.List;
import twitter.action.TweetGetter;
import twitter.manage.TweetManager;
import twitter4j.Status;

public class TweetSearchResultGetter
implements TweetGetter {
    private TweetManager tweetManager;
    private String searchWord;
    private long sinceID;

    public TweetSearchResultGetter(TweetManager tweetManager, String searchWord) {
        this.tweetManager = tweetManager;
        this.searchWord = searchWord;
    }

    @Override
    public List<Status> getTweetData(int num) {
        int lastnum;
        List<Status> status = this.tweetManager.getSearchResult(num, this.searchWord);
        if (status != null && (lastnum = status.size()) > 0) {
            this.sinceID = status.get(lastnum - 1).getId();
        }
        return status;
    }

    @Override
    public List<Status> getNewTweetData() {
        int lastnum;
        List<Status> status = this.tweetManager.getNewSearchResult(this.sinceID, this.searchWord);
        if (status != null && (lastnum = status.size()) > 0) {
            this.sinceID = status.get(lastnum - 1).getId();
        }
        return status;
    }
}

