/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.action;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.table.TableModel;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import twitter.action.TweetDirectMessageGetter;
import twitter.action.TweetFavoriteGetter;
import twitter.action.TweetGetter;
import twitter.action.TweetListGetter;
import twitter.action.TweetMentionGetter;
import twitter.action.TweetSearchResultGetter;
import twitter.action.TweetSendDirectMessageGetter;
import twitter.action.TweetTimelineGetter;
import twitter.action.TweetUserTimelineGetter;
import twitter.action.list.ListGetterSelection;
import twitter.action.list.UserListGetter;
import twitter.action.list.UserListMembershipsGetter;
import twitter.action.list.UserListSpecificUserListsGetter;
import twitter.action.list.UserListSubscriptionGetter;
import twitter.cache.TwitterImageCache;
import twitter.gui.component.DnDTabbedPane;
import twitter.gui.component.TweetTabbedTable;
import twitter.gui.component.TweetTableModel;
import twitter.gui.form.AboutDialog;
import twitter.gui.form.AccountDialog;
import twitter.gui.form.ConfigurationDialog;
import twitter.gui.form.DirectMessageDialog;
import twitter.gui.form.HashtagSearchDialog;
import twitter.gui.form.KeywordSearchDialog;
import twitter.gui.form.UserListDialog;
import twitter.manage.TweetManager;
import twitter.task.ExistTimerIDException;
import twitter.task.TimerID;
import twitter.task.TweetTaskException;
import twitter.task.TweetTaskManager;
import twitter.task.TweetUpdateTask;
import twitter.util.HTMLEncode;
import twitter4j.Status;
import twitter4j.TwitterException;

public class TweetMainAction {
    public static final String BASIC_SETTING_FILENAME = "setting.properties";
    private static final Pattern convURLLinkPtn = Pattern.compile("(http://|https://){1}[\\w\\.\\-/:\\#\\?\\=\\&\\;\\%\\~\\+]+", 2);
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    public static final String PROPERTIES_DIRECTORY = "properties";
    private static final String SEARCH_QUERY = "search?q=";
    private static final String SEARCH_TWITTER_URL = "http://search.twitter.com/";
    public static final String TAB_DIRECT_MESSAGE_STRING = "Message";
    public static final String TAB_MENTION_STRING = "Mention";
    public static final String TAB_TIMELINE_STRING = "Timeline";
    public static final String TAB_SEND_DIRECT_MESSAGE_STRING = "Send";
    private static final int TABLE_ELEMENT_MAX_SIZE = 200;
    private static final String TWITTER_URL = "http://twitter.com/";
    private ConfigurationDialog configurationDialog = null;
    private Status currentStatus = null;
    private Status replyStatus = null;
    private JPanel detailInfoPanel = null;
    private DirectMessageDialog directMessageDialog = null;
    private KeywordSearchDialog keywordSearchDialog = null;
    private HashtagSearchDialog hashtagSearchDialog = null;
    private Color newTableColor = new Color(224, 255, 255);
    private String tlFontName = "Takao P\u30b4\u30b7\u30c3\u30af";
    private int tlFontSize = 13;
    private String detailFontName = "Takao P\u30b4\u30b7\u30c3\u30af";
    private int detailFontSize = 13;
    private int tableElementHeight = 50;
    private int mainFrameWidth = 729;
    private int mainFrameHeight = 629;
    private JFrame mainFrame = null;
    private Properties property = null;
    private URL selectedUserImageURL = null;
    private String selectedUsername = null;
    private JLabel statusBarLabel = null;
    private JTextPane tweetBoxPane = null;
    private JPanel tweetBoxRegionPane = null;
    private JTabbedPane tweetMainTab = null;
    private TweetManager tweetManager = null;
    private JEditorPane tweetMessageBox = null;
    private JLabel tweetMessageCountLabel = null;
    private int uncheckedDirectMessageCount = 0;
    private int uncheckedMentionTweetCount = 0;
    private boolean isNotifyMentionMessage = true;
    private boolean isNotifyDirectMessage = true;
    private JLabel userImageLabel = null;
    private JLabel userNameLabel = null;
    private JLabel updateTimeLabel = null;
    private JLabel followerLabel = null;
    private JLabel followingLabel = null;
    private JLabel locationLabel = null;
    private JEditorPane clientNameLabel = null;
    private JLabel updateLabel = null;
    private JEditorPane userIntroBox = null;
    private JEditorPane userWebBox = null;
    private TrayIcon trayIcon = null;
    private JToggleButton timelineToggleButton;
    private JToggleButton mentionToggleButton;
    private JToggleButton dmToggleButton;
    private JToggleButton sendDMToggleButton;
    private JCheckBoxMenuItem timelineCheckBoxMenuItem;
    private JCheckBoxMenuItem mentionCheckBoxMenuItem;
    private JCheckBoxMenuItem dmCheckBoxMenuItem;
    private JCheckBoxMenuItem sendCheckBoxMenuItem;
    private int uncheckedTimelineTweetCount = 0;
    private AboutDialog aboutDialog = null;
    private AccountDialog accountDialog;
    private List<TweetTabbedTable> tweetTabbedTableList = new ArrayList<TweetTabbedTable>();
    private TweetTaskManager tweetTaskManager = new TweetTaskManager();
    private UserListDialog userListDialog = null;
    private int getTimelinePeriod = 60;
    private int getMentionPeriod = 180;
    private int getDirectMessagePeriod = 900;
    private int getSendDirectMessagePeriod = 1800;

    public TweetMainAction(JFrame mainFrame, TweetManager tweetManager, JLabel statusBarLabel, JTextPane tweetBoxPane, JPanel tweetBoxScrollPane, JLabel tweetMessageCountLabel, JPanel detailInfoPanel, JTabbedPane tweetMainTab, JEditorPane tweetMessageBox, JLabel userImageLabel, JLabel userNameLabel, JLabel updateTimeLabel, JLabel followerLabel, JLabel followingLabel, JLabel locationLabel, JEditorPane clientNameLabel, JLabel updateLabel, JEditorPane userIntroBox, JEditorPane userWebBox, JToggleButton timelineToggleButton, JToggleButton mentionToggleButton, JToggleButton dmToggleButton, JToggleButton sendToggleButton, JCheckBoxMenuItem timelineCheckBoxMenuItem, JCheckBoxMenuItem mentionCheckBoxMenuItem, JCheckBoxMenuItem dmCheckBoxMenuItem, JCheckBoxMenuItem sendCheckBoxMenuItem, TrayIcon trayIcon) {
        this.mainFrame = mainFrame;
        this.tweetManager = tweetManager;
        this.statusBarLabel = statusBarLabel;
        this.tweetBoxPane = tweetBoxPane;
        this.tweetMessageCountLabel = tweetMessageCountLabel;
        this.detailInfoPanel = detailInfoPanel;
        this.tweetMainTab = tweetMainTab;
        this.tweetMessageBox = tweetMessageBox;
        this.tweetBoxRegionPane = tweetBoxScrollPane;
        this.userImageLabel = userImageLabel;
        this.userNameLabel = userNameLabel;
        this.updateTimeLabel = updateTimeLabel;
        this.userIntroBox = userIntroBox;
        this.followerLabel = followerLabel;
        this.followingLabel = followingLabel;
        this.locationLabel = locationLabel;
        this.userWebBox = userWebBox;
        this.clientNameLabel = clientNameLabel;
        this.updateLabel = updateLabel;
        this.timelineCheckBoxMenuItem = timelineCheckBoxMenuItem;
        this.timelineToggleButton = timelineToggleButton;
        this.mentionCheckBoxMenuItem = mentionCheckBoxMenuItem;
        this.mentionToggleButton = mentionToggleButton;
        this.dmCheckBoxMenuItem = dmCheckBoxMenuItem;
        this.dmToggleButton = dmToggleButton;
        this.sendCheckBoxMenuItem = sendCheckBoxMenuItem;
        this.sendDMToggleButton = sendToggleButton;
        this.trayIcon = trayIcon;
        if (this.tweetMainTab instanceof DnDTabbedPane) {
            ((DnDTabbedPane)this.tweetMainTab).setMainAction(this);
        }
        try {
            this.loadProperties();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.updateFontInformationToComponent();
        mainFrame.setSize(this.mainFrameWidth, this.mainFrameHeight);
        mainFrame.setPreferredSize(new Dimension(this.mainFrameWidth, this.mainFrameHeight));
    }

    public void updateCheckboxInformation() {
        boolean timeline = this.isExistTimelineTab();
        boolean mention = this.isExistMentionTab();
        boolean dm = this.isExistDirectMessageTab();
        boolean send = this.isExistSendDirectMessageTab();
        this.timelineCheckBoxMenuItem.setSelected(timeline);
        this.timelineToggleButton.setSelected(timeline);
        this.mentionCheckBoxMenuItem.setSelected(mention);
        this.mentionToggleButton.setSelected(mention);
        this.dmCheckBoxMenuItem.setSelected(dm);
        this.dmToggleButton.setSelected(dm);
        this.sendCheckBoxMenuItem.setSelected(send);
        this.sendDMToggleButton.setSelected(send);
    }

    public void updatePeriodInformationToComponent() {
        for (TweetTabbedTable t : this.tweetTabbedTableList) {
            String timerID = t.getTimerID();
            if (timerID.equals(TimerID.createTimelineID())) {
                this.tweetTaskManager.updateTaskPeriod(timerID, this.getGetTimelinePeriod(), false);
                continue;
            }
            if (timerID.equals(TimerID.createMentionID())) {
                this.tweetTaskManager.updateTaskPeriod(timerID, this.getGetMentionPeriod(), false);
                continue;
            }
            if (timerID.equals(TimerID.createDirectMessageID())) {
                this.tweetTaskManager.updateTaskPeriod(timerID, this.getGetDirectMessagePeriod(), false);
                continue;
            }
            if (!timerID.equals(TimerID.createSendDirectMessageID())) continue;
            this.tweetTaskManager.updateTaskPeriod(timerID, this.getGetSendDirectMessagePeriod(), false);
        }
    }

    public void updateFontInformationToComponent() {
        try {
            Font tlFont = null;
            if (this.tlFontName != null) {
                tlFont = new Font(this.tlFontName, 0, this.tlFontSize);
            }
            Font detailFont = null;
            if (this.detailFontName != null) {
                detailFont = new Font(this.detailFontName, 0, this.detailFontSize);
            }
            for (TweetTabbedTable t : this.tweetTabbedTableList) {
                t.getTable().setFont(tlFont);
            }
            this.tweetMessageBox.setFont(detailFont);
            HTMLDocument doc = (HTMLDocument)this.tweetMessageBox.getDocument();
            StyleSheet[] style = doc.getStyleSheet().getStyleSheets();
            int i = style.length - 1;
            while (i >= 0) {
                Style body = style[i].getStyle("body");
                if (body != null) {
                    StyleConstants.setFontFamily(body, detailFont.getFontName());
                    StyleConstants.setFontSize(body, detailFont.getSize());
                }
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionAddTab(String timerID, int period, TweetGetter tweetGetter, String tabTitle) {
        if (period > 0) {
            try {
                final TweetTabbedTable table = new TweetTabbedTable(tweetGetter, tabTitle, this.tweetMainTab, this.tableElementHeight, this.tweetManager, this, this.newTableColor, 200, timerID);
                this.tweetTaskManager.addTask(timerID, new TweetUpdateTask(){

                    @Override
                    public void runTask() throws TweetTaskException {
                        table.updateTweetTable();
                    }
                });
                this.tweetTaskManager.startTask(timerID, (long)period * 1000L);
                table.addTableToTab();
                this.tweetTabbedTableList.add(table);
                this.actionRequestForusToLastTab();
            }
            catch (TweetTaskException ex) {
                Logger.getLogger(TweetMainAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.updateFontInformationToComponent();
        this.updateTableHeight(this.getTableElementHeight());
    }

    public void actionAddMentionTab(int period) {
        TimerID timerID = TimerID.getInstance();
        String id = TimerID.createMentionID();
        try {
            timerID.addID(id);
            if (this.isNotifyMentionMessage) {
                this.actionAddTab(id, period, new TweetMentionGetter(this.tweetManager, this.trayIcon), TAB_MENTION_STRING);
            } else {
                this.actionAddTab(id, period, new TweetMentionGetter(this.tweetManager), TAB_MENTION_STRING);
            }
        }
        catch (ExistTimerIDException ex) {
            JOptionPane.showMessageDialog(null, "\u305d\u306e\u30bf\u30d6\u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059", "Error", 0);
        }
    }

    public void actionAddFavoriteTab(String screenName) {
        TimerID timerID = TimerID.getInstance();
        String id = TimerID.createFavoriteID(screenName);
        try {
            timerID.addID(id);
            String favTitle = screenName == null ? "\u304a\u6c17\u306b\u5165\u308a" : String.valueOf(screenName) + "\u306e\u304a\u6c17\u306b\u5165\u308a";
            this.actionAddTab(id, Integer.MAX_VALUE, new TweetFavoriteGetter(this.tweetManager, screenName), favTitle);
        }
        catch (ExistTimerIDException ex) {
            JOptionPane.showMessageDialog(null, "\u305d\u306e\u30bf\u30d6\u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059", "Error", 0);
        }
    }

    public void actionAddTimelineTab(int period) {
        TimerID timerID = TimerID.getInstance();
        String id = TimerID.createTimelineID();
        try {
            timerID.addID(id);
            this.actionAddTab(id, period, new TweetTimelineGetter(this.tweetManager), TAB_TIMELINE_STRING);
        }
        catch (ExistTimerIDException ex) {
            JOptionPane.showMessageDialog(null, "\u305d\u306e\u30bf\u30d6\u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059", "Error", 0);
        }
    }

    public void actionAddDirectMessageTab(int period) {
        TimerID timerID = TimerID.getInstance();
        String id = TimerID.createDirectMessageID();
        try {
            timerID.addID(id);
            if (this.isNotifyDirectMessage) {
                this.actionAddTab(id, period, new TweetDirectMessageGetter(this.tweetManager, this.trayIcon), TAB_DIRECT_MESSAGE_STRING);
            } else {
                this.actionAddTab(id, period, new TweetDirectMessageGetter(this.tweetManager), TAB_DIRECT_MESSAGE_STRING);
            }
        }
        catch (ExistTimerIDException ex) {
            JOptionPane.showMessageDialog(null, "\u305d\u306e\u30bf\u30d6\u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059", "Error", 0);
        }
    }

    public void actionAddSendDirectMessageTab(int period) {
        TimerID timerID = TimerID.getInstance();
        String id = TimerID.createSendDirectMessageID();
        try {
            timerID.addID(id);
            this.actionAddTab(id, period, new TweetSendDirectMessageGetter(this.tweetManager), TAB_SEND_DIRECT_MESSAGE_STRING);
        }
        catch (ExistTimerIDException ex) {
            JOptionPane.showMessageDialog(null, "\u305d\u306e\u30bf\u30d6\u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059", "Error", 0);
        }
    }

    public void actionAddListTab(String username, int listID, String listFullname, int period) {
        TimerID timerID = TimerID.getInstance();
        String id = TimerID.createUserListID(username, listID);
        try {
            timerID.addID(id);
            this.actionAddTab(id, period, new TweetListGetter(this.tweetManager, username, listID), listFullname);
        }
        catch (ExistTimerIDException ex) {
            JOptionPane.showMessageDialog(null, "\u305d\u306e\u30bf\u30d6\u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059", "Error", 0);
        }
    }

    public void actionAddNewSearchResultTab(String searchWord, int period) {
        TimerID timerID = TimerID.getInstance();
        String id = TimerID.createSearchTimerID(searchWord);
        try {
            timerID.addID(id);
            this.actionAddTab(id, period, new TweetSearchResultGetter(this.tweetManager, searchWord), searchWord);
        }
        catch (ExistTimerIDException ex) {
            JOptionPane.showMessageDialog(null, "\u305d\u306e\u30bf\u30d6\u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059", "Error", 0);
        }
    }

    public void actionAddUserTimelineTab(String username, long userID, int period) {
        TimerID timerID = TimerID.getInstance();
        String id = TimerID.createUserTimelineID(userID);
        try {
            timerID.addID(id);
            this.actionAddTab(id, period, new TweetUserTimelineGetter(this.tweetManager, userID), String.valueOf(username) + "\u306e\u767a\u8a00");
        }
        catch (ExistTimerIDException ex) {
            JOptionPane.showMessageDialog(null, "\u305d\u306e\u30bf\u30d6\u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059", "Error", 0);
        }
    }

    public boolean isExistTimelineTab() {
        TimerID timerID = TimerID.getInstance();
        String id = TimerID.createTimelineID();
        return timerID.contains(id);
    }

    public boolean isExistMentionTab() {
        TimerID timerID = TimerID.getInstance();
        String id = TimerID.createMentionID();
        return timerID.contains(id);
    }

    public boolean isExistDirectMessageTab() {
        TimerID timerID = TimerID.getInstance();
        String id = TimerID.createDirectMessageID();
        return timerID.contains(id);
    }

    public boolean isExistSendDirectMessageTab() {
        TimerID timerID = TimerID.getInstance();
        String id = TimerID.createSendDirectMessageID();
        return timerID.contains(id);
    }

    public void actionBasicSettingDialog() {
        Point loc = this.getConfigurationDialog().getLocation();
        loc.translate(20, 20);
        ConfigurationDialog dialog = this.getConfigurationDialog();
        dialog.setLocation(loc);
        dialog.setVisible(true);
    }

    public void actionSetReplyStatusToTweetBoxPane() {
        this.setReplyStatus(this.currentStatus);
        Status s = this.getCurrentStatus();
        if (s.isRetweet()) {
            s = s.getRetweetedStatus();
        }
        String username = s.getUser().getScreenName();
        this.tweetBoxPane.setText("@" + username + " ");
        this.information(String.valueOf(username) + "\u3055\u3093\u306b\u8fd4\u4fe1");
    }

    public void actionSetReplyAllStatusToTweetBoxPane() {
        this.setReplyStatus(null);
        Status s = this.getCurrentStatus();
        if (s.isRetweet()) {
            s = s.getRetweetedStatus();
        }
        String username = s.getUser().getScreenName();
        this.tweetBoxPane.setText("@" + username + " ");
        this.information(String.valueOf(username) + "\u3055\u3093\u306b\u8fd4\u4fe1");
    }

    public void actionSetQuoteStatusToTweetBoxPane() {
        this.setReplyStatus(this.currentStatus);
        Status s = this.getCurrentStatus();
        if (s.isRetweet()) {
            s = s.getRetweetedStatus();
        }
        String username = s.getUser().getScreenName();
        String message = s.getText();
        this.tweetBoxPane.setText("QT @" + username + ": " + message);
        this.information(String.valueOf(username) + "\u3055\u3093\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u5f15\u7528\u30c4\u30a4\u30fc\u30c8");
    }

    public void actionCopySelectedStatusToTweetBoxPane() {
        Status s = this.getCurrentStatus();
        if (s.isRetweet()) {
            s = s.getRetweetedStatus();
        }
        String username = s.getUser().getScreenName();
        String message = s.getText();
        this.tweetBoxPane.setText("RT @" + username + ": " + message);
    }

    public void actionDetailInfoButton(ActionEvent e) {
        if (this.detailInfoPanel.isVisible()) {
            this.detailInfoPanel.setVisible(false);
        } else {
            this.detailInfoPanel.setVisible(true);
        }
    }

    public boolean isDetailInfoPanelVisible() {
        return this.detailInfoPanel.isVisible();
    }

    public void actionShowTweetboxButton(ActionEvent e) {
        if (this.tweetBoxRegionPane.isVisible()) {
            this.tweetBoxRegionPane.setVisible(false);
        } else {
            this.tweetBoxRegionPane.setVisible(true);
        }
    }

    public boolean isShowTweetBoxVisible() {
        return this.tweetBoxRegionPane.isVisible();
    }

    public void actionRemoveFocusedTabbedTable() {
        int selected = this.tweetMainTab.getSelectedIndex();
        this.actionRemoveTabbedTable(selected);
    }

    public void actionRemoveTabbedTable(String timerID) {
        int deleteTabIndex = -1;
        int i = 0;
        while (i < this.tweetTabbedTableList.size()) {
            TweetTabbedTable table = this.tweetTabbedTableList.get(i);
            if (table.getTimerID().equals(timerID)) {
                deleteTabIndex = i;
                break;
            }
            ++i;
        }
        if (deleteTabIndex >= 0) {
            int selected = this.tweetTabbedTableList.get(deleteTabIndex).getTabSetNum();
            this.tweetMainTab.remove(selected);
            this.tweetTabbedTableList.remove(deleteTabIndex);
            this.tweetTaskManager.shutdownTask(timerID);
            TimerID idManager = TimerID.getInstance();
            idManager.removeID(timerID);
            this.updateCheckboxInformation();
        }
    }

    public void actionRemoveTabbedTable(int removeTabIndex) {
        int selected = removeTabIndex;
        int deleteTabIndex = -1;
        int i = 0;
        while (i < this.tweetTabbedTableList.size()) {
            TweetTabbedTable table = this.tweetTabbedTableList.get(i);
            if (selected == table.getTabSetNum()) {
                deleteTabIndex = i;
                break;
            }
            ++i;
        }
        if (deleteTabIndex >= 0) {
            this.tweetMainTab.remove(selected);
            String timerID = this.tweetTabbedTableList.get(deleteTabIndex).getTimerID();
            this.tweetTabbedTableList.remove(deleteTabIndex);
            this.tweetTaskManager.shutdownTask(timerID);
            TimerID idManager = TimerID.getInstance();
            idManager.removeID(timerID);
            this.updateCheckboxInformation();
        }
    }

    public void actionExitButton(ActionEvent e) {
        System.exit(0);
    }

    public void actionOpenStatusURL() {
        try {
            String userName = this.getCurrentStatus().getUser().getScreenName();
            long statusID = this.getCurrentStatus().getId();
            Desktop.getDesktop().browse(new URI(TWITTER_URL + userName + "/statuses/" + statusID));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "\u30a8\u30e9\u30fc\u306b\u3088\u308a\u30d6\u30e9\u30a6\u30b6\u3092\u8d77\u52d5\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e", "Error", 0);
        }
    }

    public void actionOpenUserFav() {
        try {
            Status s = this.getCurrentStatus();
            if (s.isRetweet()) {
                s = s.getRetweetedStatus();
            }
            String userName = s.getUser().getScreenName();
            this.actionAddFavoriteTab(userName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void actionOpenFav() {
        String username = this.tweetManager.getScreenName();
        this.actionAddFavoriteTab(username);
    }

    public void actionOpenUserURL() {
        try {
            Status s = this.getCurrentStatus();
            if (s.isRetweet()) {
                s = s.getRetweetedStatus();
            }
            String userName = s.getUser().getScreenName();
            Desktop.getDesktop().browse(new URI(TWITTER_URL + userName));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "\u30a8\u30e9\u30fc\u306b\u3088\u308a\u30d6\u30e9\u30a6\u30b6\u3092\u8d77\u52d5\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e", "Error", 0);
        }
    }

    public void actionRefreshTime() {
        for (TweetTabbedTable t : this.tweetTabbedTableList) {
            TweetTableModel model = t.getModel();
            if (model == null) continue;
            model.refreshTime();
        }
    }

    public String actionReplaceTweetMessageBoxHashTab(String message) {
        Pattern userPtn = Pattern.compile("#[0-9A-Z_]+", 2);
        Matcher matcher = userPtn.matcher(message);
        TreeSet<String> findList = new TreeSet<String>();
        while (matcher.find()) {
            findList.add(matcher.group(0));
        }
        for (String f : findList) {
            try {
                message = message.replaceAll(String.valueOf(f) + "$|" + f + "\\s", "<a href=\"http://search.twitter.com/search?q=" + URLEncoder.encode(f, DEFAULT_CHARACTER_ENCODING) + "\">" + "$0</a>");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return message;
    }

    public String actionReplaceTweetMessageBoxURLLink(String message) {
        Matcher matcher = convURLLinkPtn.matcher(message);
        return matcher.replaceAll("<a href=\"$0\">$0</a>");
    }

    public String actionReplaceTweetMessageBoxUserInfo(String message) {
        Pattern userPtn = Pattern.compile("@[0-9A-Z_]+", 2);
        Matcher matcher = userPtn.matcher(message);
        TreeSet<String> findList = new TreeSet<String>();
        while (matcher.find()) {
            findList.add(matcher.group(0));
        }
        for (String f : findList) {
            message = message.replaceAll(f, "<a href=\"http://twitter.com/" + f.substring(1) + "\">" + f + "</a>");
        }
        return message;
    }

    public void actionResetUncheckedDirectMessageCount() {
        this.uncheckedDirectMessageCount = 0;
        this.tweetMainTab.setTitleAt(2, TAB_DIRECT_MESSAGE_STRING);
    }

    public void actionResetUncheckedMentionTweetCount() {
        this.uncheckedMentionTweetCount = 0;
        this.tweetMainTab.setTitleAt(1, TAB_MENTION_STRING);
    }

    public void actionResetUncheckedTimelineTweetCount() {
        this.uncheckedTimelineTweetCount = 0;
        this.tweetMainTab.setTitleAt(0, TAB_TIMELINE_STRING);
    }

    public void actionSelectedUserTimeline() {
        Status status = null;
        status = this.getCurrentStatus().isRetweet() ? this.getCurrentStatus().getRetweetedStatus() : this.getCurrentStatus();
        String username = status.getUser().getScreenName();
        long userID = status.getUser().getId();
        this.actionAddUserTimelineTab(username, userID, this.getGetTimelinePeriod());
    }

    public void actionShowSelectedUserList(ListGetterSelection selection) {
        Status status = null;
        status = this.getCurrentStatus().isRetweet() ? this.getCurrentStatus().getRetweetedStatus() : this.getCurrentStatus();
        String username = status.getUser().getScreenName();
        this.actionShowUserListDialog(status.getUser().getScreenName(), selection);
    }

    public void actionCreateFavorite() {
        int ret;
        Status status = null;
        status = this.getCurrentStatus().isRetweet() ? this.getCurrentStatus().getRetweetedStatus() : this.getCurrentStatus();
        long statusID = status.getId();
        String username = status.getUser().getScreenName();
        String message = status.getText();
        if (message.length() > 30) {
            message = String.valueOf(message.substring(0, 30)) + " ...(\u4ee5\u4e0b\u7565)";
        }
        if ((ret = JOptionPane.showConfirmDialog(this.mainFrame, String.valueOf(username) + " \u3055\u3093\u306e\u767a\u8a00:" + message + "\n\u3092\u304a\u6c17\u306b\u5165\u308a\u306b\u8ffd\u52a0\u3057\u307e\u3059\u304b?", "Fav\u306e\u78ba\u8a8d", 0)) == 0) {
            try {
                this.tweetManager.createFavorite(statusID);
            }
            catch (TwitterException e) {
                JOptionPane.showMessageDialog(null, "\u30a8\u30e9\u30fc\u306b\u3088\u308a\u304a\u6c17\u306b\u5165\u308a\u306b\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e", "Fav Error", 0);
            }
        }
    }

    public void actionDestroyFavorite() {
        int ret;
        Status status = null;
        status = this.getCurrentStatus().isRetweet() ? this.getCurrentStatus().getRetweetedStatus() : this.getCurrentStatus();
        long statusID = status.getId();
        String username = status.getUser().getScreenName();
        String message = status.getText();
        if (message.length() > 30) {
            message = String.valueOf(message.substring(0, 30)) + " ...(\u4ee5\u4e0b\u7565)";
        }
        if ((ret = JOptionPane.showConfirmDialog(this.mainFrame, String.valueOf(username) + " \u3055\u3093\u306e\u767a\u8a00:" + message + "\n\u3092\u304a\u6c17\u306b\u5165\u308a\u304b\u3089\u524a\u9664\u3057\u307e\u3059\u304b?", "Fav\u306e\u78ba\u8a8d", 0)) == 0) {
            try {
                this.tweetManager.destroyFavorite(statusID);
            }
            catch (TwitterException e) {
                JOptionPane.showMessageDialog(null, "\u30a8\u30e9\u30fc\u306b\u3088\u308a\u304a\u6c17\u306b\u5165\u308a\u304b\u3089\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e", "Fav Error", 0);
            }
        }
    }

    public void actionRetweet() {
        int ret;
        Status status = null;
        status = this.getCurrentStatus().isRetweet() ? this.getCurrentStatus().getRetweetedStatus() : this.getCurrentStatus();
        long statusID = status.getId();
        String username = status.getUser().getScreenName();
        String message = status.getText();
        if (message.length() > 30) {
            message = String.valueOf(message.substring(0, 30)) + " ...(\u4ee5\u4e0b\u7565)";
        }
        if ((ret = JOptionPane.showConfirmDialog(this.mainFrame, String.valueOf(username) + " \u3055\u3093\u306e\u767a\u8a00:" + message + "\n\u3092Retweet\u3057\u307e\u3059\u304b?", "Retweet\u306e\u78ba\u8a8d", 0)) == 0) {
            try {
                this.tweetManager.retweet(statusID);
            }
            catch (TwitterException e) {
                JOptionPane.showMessageDialog(null, "\u30a8\u30e9\u30fc\u306b\u3088\u308aRetweet\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e", "Retweet Error", 0);
            }
        }
    }

    public void updateTableHeight(int height) {
        this.tableElementHeight = height;
        for (TweetTabbedTable t : this.tweetTabbedTableList) {
            t.getTable().setRowHeight(this.tableElementHeight);
        }
    }

    public void actionShowDirectMessageDialog() {
        Point loc = this.getDirectMessageDialog().getLocation();
        DirectMessageDialog dialog = this.getDirectMessageDialog();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        dialog.setUserInformation(this.selectedUsername, this.selectedUserImageURL, this.tweetManager);
    }

    public void actionShowAboutDialog() {
        Point loc = this.getDirectMessageDialog().getLocation();
        AboutDialog dialog = this.getAboutDialog();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void actionShowAccountDialog() {
        Point loc = this.getDirectMessageDialog().getLocation();
        AccountDialog dialog = this.getAccountDialog();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void actionShowKeywordSearchDialog() {
        Point loc = this.getDirectMessageDialog().getLocation();
        KeywordSearchDialog dialog = this.getKeywordSearchDialog();
        dialog.setSearchWord("");
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void actionShowKeywordSearchDialog(String searchWord) {
        Point loc = this.getDirectMessageDialog().getLocation();
        KeywordSearchDialog dialog = this.getKeywordSearchDialog();
        dialog.setSearchWord(searchWord);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void actionShowHashtagSearchDialog() {
        Point loc = this.getDirectMessageDialog().getLocation();
        HashtagSearchDialog dialog = this.getHashtagSearchDialog();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void actionShowUserListDialog(String listUserName, ListGetterSelection selection) {
        UserListDialog dialog = this.getUserListDialog(listUserName, selection);
        Point loc = dialog.getLocation();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void actionTweet() {
        if (this.replyStatus != null) {
            this.tweetManager.replyTweet(this.tweetBoxPane.getText(), this.replyStatus.getId());
        } else {
            this.tweetManager.tweet(this.tweetBoxPane.getText());
        }
        this.information("\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u3064\u3076\u3084\u304d\u307e\u3057\u305f. \u767a\u8a00:" + this.tweetBoxPane.getText());
        this.tweetBoxPane.setText("");
    }

    public void actionUpdateButton(ActionEvent e) {
        try {
            for (TweetTabbedTable t : this.tweetTabbedTableList) {
                String timerID = t.getTimerID();
                this.tweetTaskManager.resetTask(timerID, true);
            }
            int remainingHits = this.tweetManager.getRateLimitStatus().getRemainingHits();
            this.information("\u65b0\u3057\u3044\u30c4\u30a4\u30fc\u30c8\u3092\u53d6\u5f97\u3057\u307e\u3057\u305f. (API\u30ea\u30af\u30a8\u30b9\u30c8\u6b8b\u6570\u306f" + remainingHits + "\u56de\u3067\u3059)");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void actionRequestForusToLastTab() {
        int lasttab = this.tweetMainTab.getTabCount() - 1;
        if (lasttab >= 0) {
            this.tweetMainTab.setSelectedIndex(lasttab);
        }
    }

    public void actionRequestFocusToTab(int index) {
        if (index >= 0) {
            this.tweetMainTab.setSelectedIndex(index);
        }
    }

    public void actionFocusedTableUpdate() {
        int selected = this.tweetMainTab.getSelectedIndex();
        try {
            if (selected >= 0) {
                TweetTabbedTable t = this.tweetTabbedTableList.get(selected);
                String timerID = t.getTimerID();
                this.tweetTaskManager.resetTask(timerID, true);
                int remainingHits = this.tweetManager.getRateLimitStatus().getRemainingHits();
                this.information(String.valueOf(t.getTitle()) + "\u30bf\u30d6\u306e\u30c4\u30a4\u30fc\u30c8\u3092" + t.getUncheckedTweet() + "\u4ef6\u53d6\u5f97\u3057\u307e\u3057\u305f. (API\u30ea\u30af\u30a8\u30b9\u30c8\u6b8b\u6570\u306f" + remainingHits + "\u56de\u3067\u3059)");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void actionUpdateTweetMessageCount() {
        int len = 140 - this.tweetBoxPane.getText().length();
        if (len < 0) {
            len = 0;
        }
        this.tweetMessageCountLabel.setText(String.valueOf(len));
        if (len == 140) {
            this.setReplyStatus(null);
        }
    }

    public ConfigurationDialog getConfigurationDialog() {
        if (this.configurationDialog == null) {
            this.configurationDialog = new ConfigurationDialog((Frame)this.mainFrame, true, this);
        }
        return this.configurationDialog;
    }

    public UserListDialog getUserListDialog(String listUserName, ListGetterSelection selection) {
        UserListGetter getter = null;
        switch (selection) {
            case CREATED: {
                getter = new UserListSpecificUserListsGetter(this.tweetManager);
                break;
            }
            case MEMBERSHIPS: {
                getter = new UserListMembershipsGetter(this.tweetManager);
                break;
            }
            default: {
                getter = new UserListSubscriptionGetter(this.tweetManager);
            }
        }
        this.userListDialog = new UserListDialog(this.mainFrame, true, this, getter, listUserName);
        return this.userListDialog;
    }

    public String getScreenName() {
        return this.tweetManager.getScreenName();
    }

    public KeywordSearchDialog getKeywordSearchDialog() {
        if (this.keywordSearchDialog == null) {
            this.keywordSearchDialog = new KeywordSearchDialog((Frame)this.mainFrame, true, this);
        }
        return this.keywordSearchDialog;
    }

    public HashtagSearchDialog getHashtagSearchDialog() {
        if (this.hashtagSearchDialog == null) {
            this.hashtagSearchDialog = new HashtagSearchDialog((Frame)this.mainFrame, true, this, this.tweetManager);
        }
        return this.hashtagSearchDialog;
    }

    public AccountDialog getAccountDialog() {
        if (this.accountDialog == null) {
            this.accountDialog = new AccountDialog((Frame)this.mainFrame, true, this.tweetManager, this);
        }
        return this.accountDialog;
    }

    public DirectMessageDialog getDirectMessageDialog() {
        if (this.directMessageDialog == null) {
            this.directMessageDialog = new DirectMessageDialog(this.mainFrame);
            this.directMessageDialog.setTitle("\u30c0\u30a4\u30ec\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u9001\u4fe1");
        }
        return this.directMessageDialog;
    }

    public void setDetailInformationFromTable(JTable table) {
        int sc = table.getSelectedRowCount();
        String infoMessage = "";
        if (sc == 1 && table != null) {
            Status st = this.getTweetTableInformation(table, table.getModel());
            if (st.isRetweet()) {
                st = st.getRetweetedStatus();
            }
            infoMessage = st.getText();
            infoMessage = HTMLEncode.encode(infoMessage);
            infoMessage = this.actionReplaceTweetMessageBoxURLLink(infoMessage);
            infoMessage = this.actionReplaceTweetMessageBoxUserInfo(infoMessage);
            infoMessage = this.actionReplaceTweetMessageBoxHashTab(infoMessage);
            this.tweetMessageBox.setText(infoMessage);
            ImageIcon icon = TwitterImageCache.getInstance().getProfileImage(st.getUser().getProfileImageURL().toString());
            this.userImageLabel.setIcon(icon);
            this.userNameLabel.setText(String.valueOf(st.getUser().getName()) + " / " + st.getUser().getScreenName());
            this.updateTimeLabel.setText(DateFormat.getInstance().format(st.getCreatedAt()));
            this.userIntroBox.setText(st.getUser().getDescription());
            this.followerLabel.setText(String.valueOf(st.getUser().getFollowersCount()));
            this.followingLabel.setText(String.valueOf(st.getUser().getFriendsCount()));
            this.locationLabel.setText(st.getUser().getLocation());
            if (st.getUser().getURL() != null) {
                this.userWebBox.setText("<a href=\"" + st.getUser().getURL() + "\">" + st.getUser().getScreenName() + "\u306eWeb\u3092\u958b\u304f" + "</a>");
            } else {
                this.userWebBox.setText("");
            }
            this.clientNameLabel.setText(" via " + st.getSource());
            this.updateLabel.setText(String.valueOf(st.getUser().getStatusesCount()));
        }
    }

    public AboutDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog((Frame)this.mainFrame, true);
        }
        return this.aboutDialog;
    }

    public Status getTweetTableInformation(JTable table, TableModel model) {
        int index = table.convertRowIndexToModel(table.getSelectedRow());
        Status status = null;
        if (model instanceof TweetTableModel) {
            status = ((TweetTableModel)model).getTweetStatus(index);
            this.selectedUsername = status.getUser().getScreenName();
            this.selectedUserImageURL = status.getUser().getProfileImageURL();
            this.setCurrentStatus(status);
        }
        return status;
    }

    public void information(String message) {
        this.statusBarLabel.setText(message);
    }

    public void loadProperties() throws FileNotFoundException, IOException {
        if (this.property == null) {
            this.property = new Properties();
        }
        this.property.load(new FileInputStream("./properties/setting.properties"));
        String gtp = this.property.getProperty("getTimelinePeriod");
        String gmp = this.property.getProperty("getMentionPeriod");
        String gdmp = this.property.getProperty("getDirectMessagePeriod");
        String gsdmp = this.property.getProperty("getSendDirectMessagePeriod");
        String ntrgb = this.property.getProperty("newTableColorRGB");
        this.tlFontName = this.property.getProperty("tlFontName");
        this.detailFontName = this.property.getProperty("detailFontName");
        String tfs = this.property.getProperty("tlFontSize");
        String dfs = this.property.getProperty("detailFontSize");
        String teh = this.property.getProperty("tableElementHeight");
        String mfw = this.property.getProperty("mainFrameWidth");
        String mfh = this.property.getProperty("mainFrameHeight");
        String nm = this.property.getProperty("notifyMessage");
        String ndm = this.property.getProperty("notifyDirectMessage");
        try {
            this.newTableColor = new Color(Integer.parseInt(ntrgb));
            this.tlFontSize = Integer.parseInt(tfs);
            this.detailFontSize = Integer.parseInt(dfs);
            this.tableElementHeight = Integer.parseInt(teh);
            this.mainFrameWidth = Integer.parseInt(mfw);
            this.mainFrameHeight = Integer.parseInt(mfh);
            this.getTimelinePeriod = Integer.parseInt(gtp);
            this.getMentionPeriod = Integer.parseInt(gmp);
            this.getDirectMessagePeriod = Integer.parseInt(gdmp);
            this.getSendDirectMessagePeriod = Integer.parseInt(gsdmp);
            this.isNotifyMentionMessage = Boolean.parseBoolean(nm);
            this.isNotifyMentionMessage = Boolean.parseBoolean(ndm);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void saveProperties() throws IOException {
        File logDir = new File("./properties");
        if (!logDir.exists() && !logDir.mkdir()) {
            throw new IOException("properties\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e");
        }
        if (this.property == null) {
            this.property = new Properties();
        }
        this.property.setProperty("getTimelinePeriod", String.valueOf(this.getTimelinePeriod));
        this.property.setProperty("getMentionPeriod", String.valueOf(this.getMentionPeriod));
        this.property.setProperty("getDirectMessagePeriod", String.valueOf(this.getDirectMessagePeriod));
        this.property.setProperty("getSendDirectMessagePeriod", String.valueOf(this.getSendDirectMessagePeriod));
        this.property.setProperty("newTableColorRGB", String.valueOf(this.newTableColor.getRGB()));
        this.property.setProperty("tlFontName", this.tlFontName);
        this.property.setProperty("tlFontSize", String.valueOf(this.tlFontSize));
        this.property.setProperty("detailFontName", this.detailFontName);
        this.property.setProperty("detailFontSize", String.valueOf(this.detailFontSize));
        this.property.setProperty("tableElementHeight", String.valueOf(this.tableElementHeight));
        if (this.mainFrame.getExtendedState() == 0) {
            this.mainFrameWidth = this.mainFrame.getWidth();
            this.mainFrameHeight = this.mainFrame.getHeight();
        }
        this.property.setProperty("mainFrameWidth", String.valueOf(this.mainFrameWidth));
        this.property.setProperty("mainFrameHeight", String.valueOf(this.mainFrameHeight));
        this.property.setProperty("notifyMention", String.valueOf(this.isNotifyMentionMessage));
        this.property.setProperty("notifyDirectMessage", String.valueOf(this.isNotifyDirectMessage));
        this.property.store(new FileOutputStream("./properties/setting.properties"), null);
    }

    public Color getNewTableColor() {
        return this.newTableColor;
    }

    public void setNewTableColor(Color newTableColor) {
        this.newTableColor = newTableColor;
    }

    public String getTlFontName() {
        return this.tlFontName;
    }

    public void setTlFontName(String tlFontName) {
        this.tlFontName = tlFontName;
    }

    public int getTlFontSize() {
        return this.tlFontSize;
    }

    public void setTlFontSize(int tlFontSize) {
        this.tlFontSize = tlFontSize;
    }

    public String getDetailFontName() {
        return this.detailFontName;
    }

    public void setDetailFontName(String detailFontName) {
        this.detailFontName = detailFontName;
    }

    public int getDetailFontSize() {
        return this.detailFontSize;
    }

    public void setDetailFontSize(int detailFontSize) {
        this.detailFontSize = detailFontSize;
    }

    public int getTableElementHeight() {
        return this.tableElementHeight;
    }

    public void setTableElementHeight(int tableElementHeight) {
        this.tableElementHeight = tableElementHeight;
    }

    public int getGetTimelinePeriod() {
        return this.getTimelinePeriod;
    }

    public void setGetTimelinePeriod(int getTimelinePeriod) {
        this.getTimelinePeriod = getTimelinePeriod;
    }

    public int getGetMentionPeriod() {
        return this.getMentionPeriod;
    }

    public void setGetMentionPeriod(int getMentionPeriod) {
        this.getMentionPeriod = getMentionPeriod;
    }

    public int getGetDirectMessagePeriod() {
        return this.getDirectMessagePeriod;
    }

    public void setGetDirectMessagePeriod(int getDirectMessagePeriod) {
        this.getDirectMessagePeriod = getDirectMessagePeriod;
    }

    public int getGetSendDirectMessagePeriod() {
        return this.getSendDirectMessagePeriod;
    }

    public void setGetSendDirectMessagePeriod(int getSendDirectMessagePeriod) {
        this.getSendDirectMessagePeriod = getSendDirectMessagePeriod;
    }

    public Status getCurrentStatus() {
        return this.currentStatus;
    }

    public void setCurrentStatus(Status currentStatus) {
        this.currentStatus = currentStatus;
    }

    public Status getReplyStatus() {
        return this.replyStatus;
    }

    public void setReplyStatus(Status status) {
        this.replyStatus = status;
    }
}

