/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import twitter4j.Location;
import twitter4j.LocationJSONImpl;
import twitter4j.ResponseList;
import twitter4j.Trend;
import twitter4j.TrendJSONImpl;
import twitter4j.Trends;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.ParseUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TrendsJSONImpl
implements Trends,
Serializable {
    private Date asOf;
    private Date trendAt;
    private Trend[] trends;
    private Location location;
    private static final long serialVersionUID = -7151479143843312309L;

    @Override
    public int compareTo(Trends that) {
        return this.trendAt.compareTo(that.getTrendAt());
    }

    TrendsJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        String jsonStr = res.asString();
        this.init(res.asString(), conf.isJSONStoreEnabled());
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jsonStr);
        }
    }

    TrendsJSONImpl(String jsonStr) throws TwitterException {
        this.init(jsonStr, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void init(String jsonStr, boolean storeJSON) throws TwitterException {
        try {
            JSONObject json;
            JSONArray array;
            if (jsonStr.startsWith("[")) {
                array = new JSONArray(jsonStr);
                if (array.length() <= 0) throw new TwitterException("No trends found on the specified woeid");
                json = array.getJSONObject(0);
            } else {
                json = new JSONObject(jsonStr);
            }
            this.asOf = TrendsJSONImpl.parseTrendsDate(json.getString("as_of"));
            this.location = TrendsJSONImpl.extractLocation(json, storeJSON);
            array = json.getJSONArray("trends");
            this.trendAt = this.asOf;
            this.trends = TrendsJSONImpl.jsonArrayToTrendArray(array);
            return;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage(), jsone);
        }
    }

    TrendsJSONImpl(Date asOf, Location location, Date trendAt, Trend[] trends) {
        this.asOf = asOf;
        this.location = location;
        this.trendAt = trendAt;
        this.trends = trends;
    }

    static List<Trends> createTrendsList(HttpResponse res, boolean storeJSON) throws TwitterException {
        JSONObject json = res.asJSONObject();
        try {
            Date asOf = TrendsJSONImpl.parseTrendsDate(json.getString("as_of"));
            JSONObject trendsJson = json.getJSONObject("trends");
            Location location = TrendsJSONImpl.extractLocation(json, storeJSON);
            ArrayList<Trends> trends = new ArrayList<Trends>(trendsJson.length());
            Iterator ite = trendsJson.keys();
            while (ite.hasNext()) {
                String key = (String)ite.next();
                JSONArray array = trendsJson.getJSONArray(key);
                Trend[] trendsArray = TrendsJSONImpl.jsonArrayToTrendArray(array);
                if (key.length() == 19) {
                    trends.add(new TrendsJSONImpl(asOf, location, ParseUtil.getDate(key, "yyyy-MM-dd HH:mm:ss"), trendsArray));
                    continue;
                }
                if (key.length() == 16) {
                    trends.add(new TrendsJSONImpl(asOf, location, ParseUtil.getDate(key, "yyyy-MM-dd HH:mm"), trendsArray));
                    continue;
                }
                if (key.length() != 10) continue;
                trends.add(new TrendsJSONImpl(asOf, location, ParseUtil.getDate(key, "yyyy-MM-dd"), trendsArray));
            }
            Collections.sort(trends);
            return trends;
        }
        catch (JSONException jsone) {
            throw new TwitterException(new StringBuffer().append(jsone.getMessage()).append(":").append(res.asString()).toString(), jsone);
        }
    }

    private static Location extractLocation(JSONObject json, boolean storeJSON) throws TwitterException {
        ResponseList<Location> locations;
        if (json.isNull("locations")) {
            return null;
        }
        try {
            locations = LocationJSONImpl.createLocationList(json.getJSONArray("locations"), storeJSON);
        }
        catch (JSONException e) {
            throw new AssertionError((Object)"locations can't be null");
        }
        Location location = 0 != locations.size() ? (Location)locations.get(0) : null;
        return location;
    }

    private static Date parseTrendsDate(String asOfStr) throws TwitterException {
        Date parsed;
        switch (asOfStr.length()) {
            case 10: {
                parsed = new Date(Long.parseLong(asOfStr) * 1000L);
                break;
            }
            case 20: {
                parsed = ParseUtil.getDate(asOfStr, "yyyy-mm-dd'T'HH:mm:ss'Z'");
                break;
            }
            default: {
                parsed = ParseUtil.getDate(asOfStr, "EEE, d MMM yyyy HH:mm:ss z");
            }
        }
        return parsed;
    }

    private static Trend[] jsonArrayToTrendArray(JSONArray array) throws JSONException {
        Trend[] trends = new Trend[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            JSONObject trend = array.getJSONObject(i);
            trends[i] = new TrendJSONImpl(trend);
        }
        return trends;
    }

    @Override
    public Trend[] getTrends() {
        return this.trends;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Date getAsOf() {
        return this.asOf;
    }

    @Override
    public Date getTrendAt() {
        return this.trendAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trends)) {
            return false;
        }
        Trends trends1 = (Trends)o;
        if (this.asOf != null ? !this.asOf.equals(trends1.getAsOf()) : trends1.getAsOf() != null) {
            return false;
        }
        if (this.trendAt != null ? !this.trendAt.equals(trends1.getTrendAt()) : trends1.getTrendAt() != null) {
            return false;
        }
        return Arrays.equals(this.trends, trends1.getTrends());
    }

    public int hashCode() {
        int result = this.asOf != null ? this.asOf.hashCode() : 0;
        result = 31 * result + (this.trendAt != null ? this.trendAt.hashCode() : 0);
        result = 31 * result + (this.trends != null ? Arrays.hashCode(this.trends) : 0);
        return result;
    }

    public String toString() {
        return new StringBuffer().append("TrendsJSONImpl{asOf=").append(this.asOf).append(", trendAt=").append(this.trendAt).append(", trends=").append(this.trends == null ? null : Arrays.asList(this.trends)).append('}').toString();
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((Trends)x0);
    }
}

