#ifndef NSIM_TEST_MODEL_H
#define NSIM_TEST_MODEL_H

namespace test
{

class model
{
public:
    model(double a = 0.344, double b = 0.4, double c = 4.5) :
        a(a), b(b), c(c) {}

    template <typename V1, typename V2>
        void deriv(double t, V1 const& x, V2& d) const
        {
            d[0] = - x[1] -          x[2];
            d[1] =   x[0] +        a*x[1];
            d[2] = b*x[0] - (c-x[0])*x[2];
        }

    template <typename V1, typename V2>
        double norm(V1& e, double t, V2 const& x) const
        {
            return norm_2(e);
        }

private:
    double a, b, c;
};

}

#endif

