// $Id: connectmodel.h 26 2004-07-03 06:22:39Z takekawa $
// Copyright (C) 2004  Takashi Takekawa
// This file is part of the Nsim Library.

// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// long with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307 USA.

#ifndef NSIM_CONNECTMODEL_H
#define NSIM_CONNECTMODEL_H

#include <vector>
#include <nsim/rangemodel.h>

namespace nsim
{

struct connection
{
    double const* s;
    double g;
    connection(double const* s, double g) : s(s), g(g) {}
};

template <typename T, std::size_t N>
struct connectmodel : public nsim::rangemodel<T>
{
    std::vector<connection> con[N];
    mutable double gsyn[N];
    mutable double isyn[N];
    void calc_gsyn() const
    {
        for (std::size_t n(0); n < N; ++n) {
            gsyn[n] = 0;
            for (std::size_t i(0); i < con[n].size(); ++i)
                gsyn[n] += (*con[n][i].s)*(con[n][i].g);
        }
    }
};

}

#endif
