// $Id: rangemodel.h 31 2004-07-04 04:58:12Z takekawa $
// Copyright (C) 2004  Takashi Takekawa
// This file is part of the Nsim Library.

// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// long with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307 USA.

#ifndef NSIM_RANGEMODEL_H
#define NSIM_RANGEMODEL_H

#include <boost/numeric/ublas/storage.hpp>

namespace nsim
{

template <typename M>
struct rangemodel : public M
{
    typedef M model_type;
    typedef boost::numeric::ublas::range range_type;
    range_type range;

    template <typename V>
        typename V::const_vector_range_type operator()(V const& x) const
        {
            return typename V::const_vector_range_type(x, range);
        }

    template <typename V>
        typename V::vector_range_type operator()(V& x) const
        {
            return typename V::vector_range_type(x, range);
        }

    template <typename V>
        void init(V& x) const
        {
            typename V::vector_range_type xr(x, range);
            M::init(xr);
        }

    template <typename V1, typename V2>
        void deriv(double t, V1 const& x, V2& f) const
        {
            typename V2::vector_range_type fr(f, range);
            M::deriv(t, x(range), fr);
        }

    template <typename V>
        void scale(V& e) const
        {
            typename V::vector_range_type er(e, range);
            M::scale(er);
        }
};

}

#endif
