// $Id: orbit.h 27 2004-07-03 07:03:56Z takekawa $
// Copyright (C) 2004  Takashi Takekawa
// This file is part of the Nsim Library.

// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// long with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307 USA.

#ifndef NSIM_ORBIT_H
#define NSIM_ORBIT_H

#include <map>
#include <nsim/interpolator.h>

namespace nsim
{

template <typename V>
class orbit : public std::map<double, interpolator<V> >
{
public:
    typedef interpolator<V> interp_type;
    typedef typename interp_type::state_type state_type;
    typedef typename interp_type::deriv_type deriv_type;

    typedef std::map<double, interp_type> base_type;
    typedef typename base_type::const_iterator const_iterator;

    template <typename Result>
        void insert(Result const& re)
        {
            if (re.dt() < 0.0)
                interp_type(re).swap(operator[](re.t1()));
            else
                interp_type(re).swap(operator[](re.t0()));
        }

    void insert_temporary(interp_type& interp)
    {
        if (interp.dt() < 0.0)
            interp.swap(operator[](interp.t1()));
        else
            interp.swap(operator[](interp.t0()));
    }

    state_type x(double t) const
    {
        const_iterator itr(this->upper_bound(t));
        if (itr != this->begin())
            --itr;
        if (itr != this->end())
            return itr->second.x(t);
        else
            throw std::runtime_error("orbit: no data");
    }

    deriv_type d(double t) const
    {
        const_iterator itr(this->upper_bound(t));
        if (itr != this->begin())
            --itr;
        if (itr != this->end())
            return itr->second.d(t);
        else
            throw std::runtime_error("orbit: no data");
    }
};

}

#endif

