// $Id: dopri853_const.h 26 2004-07-03 06:22:39Z takekawa $
// Copyright (C) 2004  Takashi Takekawa
// This file is part of the Nsim Library.

// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// long with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307 USA.

#ifndef NSIM_DOPRI853_CONST_H
#define NSIM_DOPRI853_CONST_H

#include <cmath> // std::sqrt

namespace nsim
{

namespace dopri853
{
double const SQRT6 = std::sqrt(6.0);

double const C1 = (12.0-2.0*SQRT6) / 135.0;
double const C2 =      (6.0-SQRT6) / 45.0;
double const C3 =      (6.0-SQRT6) / 30.0;
double const C4 =      (6.0+SQRT6) / 30.0;
double const C5 =              1.0 / 3.0;
double const C6 =              1.0 / 4.0;
double const C7 =              4.0 / 13.0;
double const C8 =            127.0 / 195.0;
double const C9 =              3.0 / 5.0;
double const C10 =             6.0 / 7.0;
double const C11 =             1.0;
double const C12 =             1.0;

double const A1_0 = (12.0-2.0*SQRT6) / 135.0;

double const A2_0 = (6.0-SQRT6) / 180.0;
double const A2_1 = (6.0-SQRT6) / 60.0;

double const A3_0 = (6.0-SQRT6) / 120.0;
double const A3_2 = (6.0-SQRT6) / 40.0;

double const A4_0 =  (462.0+107.0*SQRT6)/3000.0;
double const A4_2 = (-402.0-197.0*SQRT6)/1000.0;
double const A4_3 =   (168.0+73.0*SQRT6)/375.0;

double const A5_0 =          1.0/27.0;
double const A5_3 = (16.0+SQRT6)/108.0;
double const A5_4 = (16.0-SQRT6)/108.0;

double const A6_0 =           19.0/512.0;
double const A6_3 = (118.0+23.0*SQRT6)/1024.0;
double const A6_4 = (118.0-23.0*SQRT6)/1024.0;
double const A6_5 =           -9.0/512.0;

double const A7_0 =            13772.0/371293.0;
double const A7_3 = (51544.0+4784.0*SQRT6)/371293.0;
double const A7_4 = (51544.0-4784.0*SQRT6)/371293.0;
double const A7_5 =            -5688.0/371293.0;
double const A7_6 =             3072.0/371293.0;

double const A8_0 =                       58656157643.0/93983540625.0;
double const A8_3 = (-1324889724104.0-318801444819.0*SQRT6)/626556937500.0;
double const A8_4 = (-1324889724104.0+318801444819.0*SQRT6)/626556937500.0;
double const A8_5 =                       96044563816.0/3480871875.0;
double const A8_6 =                     5682451879168.0/281950621875.0;
double const A8_7 =                        -165125654.0/3796875.0;

double const A9_0 =                8909899.0/18653125.0;
double const A9_3 = (-4521408.0-1137963.0*SQRT6)/2937500.0;
double const A9_4 = (-4521408.0+1137963.0*SQRT6)/2937500.0;
double const A9_5 =               96663078.0/4553125.0;
double const A9_6 =             2107245056.0/137915625.0;
double const A9_7 =            -4913652016.0/147609375.0;
double const A9_8 =              -78894270.0/3880452869.0;

double const A10_0 =       -20401265806.0/21769653311.0;
double const A10_3 = (354216.0+94326.0*SQRT6)/112847.0;
double const A10_4 = (354216.0-94326.0*SQRT6)/112847.0;
double const A10_5 =       -43306765128.0/5313852383.0;
double const A10_6 =    -20866708358144.0/1126708119789.0;
double const A10_7 =     14886003438020.0/654632330667.0;
double const A10_8 =  35290686222309375.0/14152473387134411.0;
double const A10_9 =        -1477884375.0/485066827.0;

double const A11_0 =              39815761.0/17514443.0;
double const A11_3 = (-3457480.0-960905.0*SQRT6)/551636.0;
double const A11_4 = (-3457480.0+960905.0*SQRT6)/551636.0;
double const A11_5 =            -844554132.0/47026969.0;
double const A11_6 =            8444996352.0/302158619.0;
double const A11_7 =           -2509602342.0/877790785.0;
double const A11_8 =    -28388795297996250.0/3199510091356783.0;
double const A11_9 =             226716250.0/18341897.0;
double const A11_10 =           1371316744.0/2131383595.0;

double const B_0 =         104257.0/1920240.0;
double const B_5 =        3399327.0/763840.0;
double const B_6 =       66578432.0/35198415.0;
double const B_7 =    -1674902723.0/288716400.0;
double const B_8 = 54980371265625.0/176692375811392.0;
double const B_9 =        -734375.0/4826304.0;
double const B_10 =     171414593.0/851261400.0;
double const B_11 =        137909.0/3084480.0;

double const E0_0 =         116092271.0/8848465920.0;
double const E0_5 =          -1871647.0/1527680.0;
double const E0_6 =         -69799717.0/140793660.0;
double const E0_7 =     1230164450203.0/739113984000.0;
double const E0_8 = -1980813971228885.0/5654156025964544.0;
double const E0_9 =         464500805.0/1389975552.0;
double const E0_10 =    1606764981773.0/19613062656000.0;
double const E0_11 =          -137909.0/6168960.0;

double const E1_0 =         -364463.0/19202400.0;
double const E1_5 =         3399327.0/7638400.0;
double const E1_6 =        66578432.0/351984150.0;
double const E1_7 =     -1674902723.0/2887164000.0;
double const E1_8 = -74684743568175.0/1766923758113920.0;
double const E1_9 =         -734375.0/48263040.0;
double const E1_10 =      171414593.0/8512614000.0;
double const E1_11 =          69869.0/30844800.0;

double const C[12] = {
    0.0, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11
};

double const A[][11] = {
    {},
    { A1_0 },
    { A2_0, A2_1 },
    { A3_0,  0.0, A3_2 },
    { A4_0,  0.0, A4_2, A4_3 },
    { A5_0,  0.0,  0.0, A5_3, A5_4 },
    { A6_0,  0.0,  0.0, A6_3, A6_4, A6_5 },
    { A7_0,  0.0,  0.0, A7_3, A7_4, A7_5, A7_6 },
    { A8_0,  0.0,  0.0, A8_3, A8_4, A8_5, A8_6, A8_7 },
    { A9_0,  0.0,  0.0, A9_3, A9_4, A9_5, A9_6, A9_7, A9_8 },
    { A10_0, 0.0, 0.0, A10_3, A10_4, A10_5, A10_6, A10_7, A10_8, A10_9 },
    { A11_0, 0.0, 0.0, A11_3, A11_4, A11_5, A11_6, A11_7, A11_8, A11_9, A11_10 },
};

double const B[12] = {
   B_0, 0.0, 0.0, 0.0, 0.0, B_5, B_6, B_7, B_8, B_9, B_10, B_11
};

double const E[][12] = {
    { E0_0, 0.0, 0.0, 0.0, 0.0, E0_5, E0_6, E0_7, E0_8, E0_9, E0_10, E0_11 },
    { E1_0, 0.0, 0.0, 0.0, 0.0, E1_5, E1_6, E1_7, E1_8, E1_9, E1_10, E1_11 }
};

}
}

#endif
