// $Id: current.h 26 2004-07-03 06:22:39Z takekawa $
// Copyright (C) 2004  Takashi Takekawa
// This file is part of the Nsim Library.

// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// long with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307 USA.

#ifndef NSIM_CURRENT_H
#define NSIM_CURRENT_H

#include <nsim/pow.h>

namespace nsim
{

template <int P = 0, int Q = 0>
struct current
{
    double g_max;
    double e_rev;

    current(double g_max, double e_rev) :
        g_max(g_max), e_rev(e_rev) {}

    double operator()(double v, double m = 1.0, double h = 1.0) const
    {
        return g_max*pow<P>(m)*pow<Q>(h)*(v - e_rev);
    }
    double dv(double v, double m = 1.0, double h = 1.0) const
    {
        return g_max*pow<P>(m)*pow<Q>(h);
    }
    double dm(double v, double m = 1.0, double h = 1.0) const
    {
        return P*g_max*pow<P-1>(m)*pow<Q>(h)*(v - e_rev);
    }
    double dh(double v, double m = 1.0, double h = 1.0) const
    {
        return Q*g_max*pow<P>(m)*pow<Q-1>(h)*(v - e_rev);
    }
};

}

#endif
