<?php

    // ライブラリをインクルードする(TCPDFをインストールしたパスを指定）
    require_once('../TCPDF/tcpdf.php');
    
    // PDF オブジェクトを作成し、以降の処理で操作
    $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    
    // おかしな罫線がでることを防止
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
        
    // 1ページ目を準備
    $pdf->AddPage();
    
    // 日本語フォントを設定
    // $pdf->SetFont('cid0jp', '', 14);
    $pdf->SetFont('kozminproregular', '', 10);
    
    // 枠付で文字列を出力
    $colWidth = 100;
    $text = '東京都品川区荏原 4-4-2 大橋　克洋';
    $pdf->Cell($colWidth, 12, $text, 1, 1, 'C');
    /*
    $pdf->Cell($colWidth, 12, $text, 1, 1, 'R');
    $pdf->Cell($colWidth, 12, $text, 0, 1, 'L');
    $pdf->Cell(0, 12, $text, LB, 0, 'L');
     */

    // PDF を出力
    $pdf->Output("sample.pdf", "I");

?>
