
function templateNameSelected(menuItem){
	// テンプレート・ポップアップが選択された
	var templateF = document.getElementById("templateF");
	var labelF = document.getElementById("labelF");
	var item = menuItem.value;
    
    templateF.value = item;
    
    // buff のカンマ区切りを、改行区切りに変更して表示
	if (item == ""){
		templateF.value = "";
		templateF.focus();
		labelF.value = "";
        showRemoveIcon(); // ICON 表示しない
	} else if (item == "... 新規テンプレート"){
		templateF.value = "";
		templateF.focus();
		labelF.value = "";
        showRemoveIcon(); // ICON 表示しない
	} else {
		templateF.value = item;
        showRemoveIcon(true); // ICON 表示する

		// buff のカンマ区切りを、改行区切りに変更して表示
        var rec = recordForKey(item);
        var array = rec.value.split(_separator);
        labelF.value = array.join("\n");
	}
    
    function showRemoveIcon(status){
        // 削除アイコンを表示
        var elm = elmFor("removeIconArea");
        elm.innerHTML = "";
        if (!status) return;
        
        var img = newIMAGE(elm, "removeB", "./remove-field.png", "X");
        img.style.height = "13px";
        img.setAttribute("onclick", "removeTemplate()"); // pickup.js
        img.setAttribute("class", "expandIcon");
    }
}

function showEditor(){
	// pickup の編集ウインドーを開く
    var panel = new FloatPanel("_confirm", 5, 5, 220, "Pickup 編集パネル");
    panel.base.style.backgroundColor = "#ffe";
    var elm = panel.contents;
	
	// テンプレート名ポップアップ・メニュー
    var div = newDIV(elm, "");
    div.style.marginBottom = "5px";
    // ポップアップ・メニュー
    var sp = newSPAN(div, "");
    var pu = newPopupMenu(sp, "templatePopup", templateItems(), "");
    pu.setAttribute("onchange", "templateNameSelected(this)");
    // 削除アイコン
    var sp = newSPAN(div, "removeIconArea");
    sp.style.marginLeft = "5px";
    
    // ラベル設定欄
    var div = newDIV(elm, "");
    div.style.marginBottom = "5px";
	var fd = newFIELD(div, "templateF", "", 30, "");
    fd.setAttribute("placeholder", "ピックアップしたいラベル名"); // 入力ヒントを表示

    // 入力欄
    var div = newDIV(elm, "");
    div.style.marginBottom = "5px";
    var fd = newTEXTAREA(div, "labelF", "28", "20", "");
    fd.setAttribute("placeholder", "表示したい「ラベル名を１行ずつ」改行しながら入力してください"); 

    // FOOTER
    var div = newDIV(elm, "");
	div.style.textAlign = "right";
    var bt = newDIV(div,  "/whiteButton");
    bt.innerHTML = "確定";
	bt.setAttribute("onclick", "saveTemplate()");
    
    window.scroll(0, 0);
	
	function templateItems(){
		var items = new Array();
		var array = templateNames();
		for (num in array){
			items.push(array[num]);
		}
        items.push("... 新規テンプレート");
		return items;
	}
}

