
/////////////////////////
///// カルテからの継承値 ///

function groupTemplateMenus(){
    // テンプレート・メニュー・オブジェクトの配列から テンプレート・メニューを生成して返す
    var array = new Array();
    if (parent()){
        var templates = parent().groupTemplates();
        for (num in templates){
            var rec = templates[num];
            array.push(rec.menu);
        }
    }
    return array;
}

///// カルテからの継承値 ///
/////////////////////////


///////////////////////////////////
///// サムネイル ////////////////////

var _tnSize = {"250":"大","150":"中","50":"小"};
function set_ThumbNailSize(elm){
    // サムネイルのサイズを設定
    var label = elm.value;
    for (size in _tnSize){
        if (label == _tnSize[size]){
            setThumbNailSize(size);
            return;
        }
    }
}
function thumbNailLabel(size){
    // size に対応するサムネイルの大きさを示す ["大","中","小"] を返す
    return _tnSize[size];
}
function thumbNailLabels(){
    // サムネイルの大きさを示す ["大","中","小"] の配列を返す
    var array = new Array();
    for (size in _tnSize){
        array.push(thumbNailLabel(size));
    }
    return array;
}

///// サムネイル ////////////////////
///////////////////////////////////

function gotTemplate(answer){
    // グループ・テンプレートをサーバから読み込む
    var array = JSON.parse(answer);
    //alert("templates->"+encodeObject(array)); //##
    
    var menus = [""];
    for (num in array){
        var rec = array[num];
        menus.push(rec.menu);
    }
    
    var div = document.getElementById("templatePopArea");
    var pu = newPopupMenu(div, "", menus, newPageTemplate());
    pu.setAttribute("onchange", "setNewPageTemplate(this)");
}
function initPreference(){
    // 初期設定ペーンを開く
	var elm = document.getElementById("base");
    elm.innerHTML = "";

    // === HEADER ================================
    var div = newDIV(elm, "/tool-header");
    var tbl = newTABLE(div, "/base-table");
	var tr = newTR(tbl, "", "");
    // --- LEFT SIDE ---
	var td = newTD(tr, "/left-side", "");
    // TITLE
    var sp = newSPAN(td, "");
    sp.innerHTML = "初期設定";
    sp.style.fontSize = "10pt";
    // --- RIGHT SIDE ---
    // HELP ICON
	var td = newTD(tr, "/right-side", "");
    td.style.paddingRight = "20px";
    // HELP ICON
	var img = newIMAGE(td, "/expandIcon", "./help.png", "?");
	img.style.height = "17px";
	img.setAttribute("onclick", "openHelp('preferenceHelp.html')");

    // === BODY =================================
    var dv = newDIV(elm, "/tool-body");
    dv.style.fontSize = "10pt";
    dv.style.backgroundColor = "#fff";

    ///// 画面表示 -------------------------------
    makeSubTitle(dv, "カルテ画面表示");
    // 待受パネルを表示
    var status = (showWaitingPanel()) ? 1 : 0;
    makeLine(dv, "立ち上げ時に待ち受けパネルを表示", status, "setShowWaitingPanel(this)");
    // 水平・垂直 画面型式
    var dv2 = newDIV(dv, "");
    dv2.style.marginTop = "5px";
    dv2.style.marginLeft = "10px";
    var sp = newSPAN(dv2, "");
    sp.innerHTML = "画面のレイアウト型式 ";
    var styles = ["","水平","垂直"];
    var pu = newPopupMenu(dv2, "", styles, frameStyle());
    pu.setAttribute("onchange", "setFrameStyle(this)");
    makeLine(dv, "ステルス・モード（カルテ・ヘッダーを隠す）", stealthMode(), "setStealthMode(this)");
    makeLine(dv, "診療待ち黄色タグをポップアップしない", noCheckWaiting(), "setNoCheckWaiting(this)");
    // OMIT CHECK BOX： setOmitStatus(）は localStorage.js
    makeLine(dv, "黄色タグからカルテを別ウインドーで開く", openEachNOA(), "setOpenEachNOA(this)");
    //makeLine(dv, "診療録の過去履歴で空欄を表示しない", omitStatus(), "setOmitStatus(this)");
    makeLine(dv, "アレルギーをページ・ヘッダーに表示", showAllergy(), "setShowAllergy(this)");
    var dv2 = newDIV(dv, "");
    dv2.style.marginTop = "5px";
    dv2.style.marginLeft = "10px";
    var fd = newFIELD(dv2, "overFlowF", "カルテ画面のスクロール範囲を ", 3, overFlowHeight());
    fd.setAttribute("onchange", "setOverFlowHeight(this)");
    var sp = newSPAN(dv2, "");
    sp.style.paddingLeft = "5px";
    sp.innerHTML = "px に限定";
    // カルテのフォント・サイズ
    var dv2 = newDIV(dv, "");
    dv2.style.marginTop = "5px";
    dv2.style.marginLeft = "10px";
    var fd = newFIELD(dv2, "overFlowF", "カルテのフォント・サイズを ", 3, cellFontSize());
    fd.setAttribute("onchange", "setCellFontSize(this)");
    var sp = newSPAN(dv2, "");
    sp.style.paddingLeft = "5px";
    sp.innerHTML = "pt に限定";
    // サムネイル・サイズ
    var dv2 = newDIV(dv, "");
    dv2.style.marginTop = "5px";
    dv2.style.marginLeft = "10px";
    var sp = newSPAN(dv2, "");
    sp.innerHTML = "カルテに貼るサムネイル・サイズ ";
    var size = thumbNailSize();
    var pu = newPopupMenu(dv2, "", thumbNailLabels(), thumbNailLabel(size));
    pu.setAttribute("onchange", "set_ThumbNailSize(this)");
    // カルテ本文をクリックして編集できるようにする
    var status = (textClick()) ? 1 : 0;
    makeLine(dv, "カルテ本文をクリックして編集できるようにする", status, "setTextClick(this)");
    // HTML 編集ツールを表示
    var status = (HTMLEditor()) ? 1 : 0;
    makeLine(dv, "CELL エディター にHTML 編集ツール表示", status, "setHTMLEditor(this)");
    // PROBLEM LIST
    // OMIT CHECK BOX： showProblem(）は localStorage.js
    makeLine(dv, "プロブレム・リストの自動表示せず", omitProblem(), "setOmitProblem(this)");

    // 保険情報 ----------------------------------
    makeSubTitle(dv, "保険証");
    // var status = (openInsPage()) ? 1 : 0;
    // makeLine(dv, "保険情報が空なら保険情報入力欄を開く", status, "_setOpenInsPage(this)");

    var flag = openInsViewerStatus();
    makeLine(dv, "保険情報が空なら保険証画像入力パネルを開く", flag, "setOpenInsViewerStatus(this)");

    ///// 基準値 --------------------------------
    makeSubTitle(dv, "基準値");
    // 基準値
    var dv2 = newDIV(dv, "");
    dv2.style.margin = "8px 0 5px 30px";
    var bt = newDIV(dv2, "/whiteButton");
    bt.innerHTML = "基準値の設定パネルを開く";
    bt.setAttribute("onclick", "open_standard_center()");

    ///// 新規ページ追加 --------------------------
    makeSubTitle(dv, "新規ページ追加");
    var dv2 = newDIV(dv, "");
    dv2.style.marginTop = "5px";
    dv2.style.marginLeft = "10px";
    var sp = newSPAN(dv2, "");
    sp.innerHTML = "テンプレート ";
    var sp = newSPAN(dv2, "templatePopArea");
    var sp = newSPAN(dv2, "");
    sp.innerHTML = " を基に生成";
    makeLine(dv, "ピンクの予約タグでページ追加", isAddReservedPage(), "setIsAddReservedPage(this)");
    
    ///// 入力欄のキー・バインド ----------------
    makeSubTitle(dv, "入力欄のキー・バインド");
    makeLine(dv, "control + j で次欄へ移動", arrowKeyJump(), "setArrowKeyJump(this)");
    
    ///// 印刷関係 ----------------------------
    makeSubTitle(dv, "印刷");
    // PRINT PAGE FONT： pagePrintFontSize(）は localStorage.js
    makeLine(dv, "小フォントで印刷する", pagePrintFontSize(), "setPagePrintFontSize(this)");
    // PRINT PAGE WIDTH： pagePrintWidth(）setPagePrintWidth() は localStorage.js
    makeLine(dv, "小ページ巾で印刷する", pagePrintWidth(), "setPagePrintWidth(this)");

    ///// HELP -------------------------------
    makeSubTitle(dv, "NOA 立ち上げ時にヘルプを表示");
    // OMIT CHECK BOX： showHelp(）は localStorage.js
    makeLine(dv, "立ち上げ時のヘルプ表示せず", showHelp(), "setShowHelp(this)");
    
    // === FOOTER ===================================
    var dv = newDIV(elm, "/tool-footer");
    dv.innerHTML = "　";

    // iFrame なら toggleButton にツール名を表示
    var bt = tools().elmFor("toggleButton");
    if (bt) bt.innerHTML = "初期設定ツール";

    // テンプレートを読込みポップアップメニューに表示
    var args = new Object();
    args["owner"] = parent().owner();
    NRCall("GET_MENU_TEMPLATE", args, gotTemplate);

    function makeSubTitle(elm, label){
        // サブタイトルを生成
        var dv = newDIV(elm, "");
        dv.style.paddingLeft = "10px";
        dv.style.backgroundColor = "#caecdc"; // 淡グリーン
        dv.style.borderRadius = "10px";
        dv.style.marginTop = "5px";
        dv.innerHTML = label;
    }
}

function makeLine(elm, label, status, action, indent){
    // 設定行を生成
    var dv = newDIV(elm, "");
    dv.style.marginTop = "5px";
    dv.style.marginLeft = (indent) ? "30px" : "10px"; 
    var cb = newCHECKBOX(dv, "omitButton", label, status);
    cb.setAttribute("onchange", action);
}

function open_standard_center(){
    // NOA 側に基準値 設定パネルを開く
    parent().openStandardCenter();
}

