// Chief Complaint Anarizer

///////////////////////////////////////////////////////////
///// LOGIC ///////////////////////////////////////////////

var _analizeKey;
function ccAnarize(elm){
    // elm 内容を解析
    _analizeKey = elm.value;
    
    // 主訴欄に key を含むページを検索
    var args = new Object();
    args["owner"] = owner();
    args["key"] = _analizeKey;
    NRCall("GET_ANARIZE", args, gotCCAnarize);
}

///////////////////////////////////////////////////////////
///// GUI /////////////////////////////////////////////////

function gotCCAnarize(answer){
    // 解析結果を表示
    var obj = JSON.parse(answer);
    
    console.log("gotCCAnarize", obj);
    
    var elm = elmFor("resultArea");
    elm.innerHTML = "";
    for (label in obj){
        var rec = obj[label];
        
        var div = newDIV(elm, "");
        div.style.fontSize = "9pt";
        div.style.backgroundColor = "#ffa";
        div.innerHTML = label;
        var num = 0;
        for (name in rec){
            var div = newDIV(elm, "");
            div.style.fontSize = "9pt";
            var cb = newCHECKBOX(div, name + ".box", name, 1);
            
            if (++num >= 10) break; // 10件まで表示
        }
    }
}

function openCCAnarizer(){
    // 主訴解析システムを起動
    var w = 300;
	var x = 200; // 表示するx座標
	var y = 50; // 表示するy座標
    var title = "主訴解析システム";
    var panel = new FloatPanel("_floatPanel", x, y, w, title);
    if (!panel) return;
    var elm = panel.contents;
    elm.style.padding = "0 8px";
    
    // テキストエリア
    var div = newDIV(elm, "");
    //div.style.marginBottom = "2px";
    div.style.fontSize = "10pt";
    var fd = newFIELD(div, "ccF", "主訴", 30, "");
    fd.setAttribute("placeholder", "主訴を入れて下さい"); // 入力ヒントを表示
    fd.focus();
    fd.setAttribute("onchange", "ccAnarize(this)");
    
    // 結果表示エリア
    var div = newDIV(elm, "resultArea");
    
    // FOOTER
    var div = newDIV(elm, "");
    div.style.marginTop = "10px";
    div.style.fontSize = "9pt";
    div.style.color = "#aaa";
    div.innerHTML = ca_version();
}

function ca_version(){
    return "Ver.140808";
}

