
function toggleView(elm, status){
	// elm を status が true なら表示 false なら非表示
	if (status)
		elm.style.display = "block"; // 表示する
	else
		elm.style.display = "none"; // 表示しない
}

function newTABLE(elm, id){
	// elm の下に TABLE を生成して返す
	var tbl = document.createElement('TABLE');
	if (id.length) tbl.setAttribute("id", id);
	elm.appendChild(tbl); 
	return tbl;
}

function newTEXT(elm, value){
	// elm の下に TEXT を生成して返す
	var tx = document.createTextNode(value);
	elm.appendChild(tx); 
	return tx;
}

function newTR(elm, id, label){
	// elm の下に <TR></TR> を生成して返す
	var tr = document.createElement('TR');
	if (id.length) tr.setAttribute("id", id);
	elm.appendChild(tr); 
	if (label.length){
		var td = document.createElement('TD');
		tr.appendChild(td); 
		var tx = document.createTextNode(label);
		td.appendChild(tx); 
	}
	return tr;
}	

function newTH(elm, id, label){
	// elm の下に <TD></TD> を生成して返す
	var td = document.createElement('TH');
	if (id.length) td.setAttribute("id", id);
	if (label.length){
		var tx = document.createTextNode(label);
		td.appendChild(tx); 
	}
	elm.appendChild(td); 
	return td;
}	

function newTD(elm, id, label){
	// elm の下に <TD></TD> を生成して返す
	var td = document.createElement('TD');
	if (id.length) td.setAttribute("id", id);
	if (label.length){
		var tx = document.createTextNode(label);
		td.appendChild(tx); 
	}
	elm.appendChild(td); 
	return td;
}	

function newBR(elm){
	// elm の下に BR を生成して返す
	var br = document.createElement('BR');
	elm.appendChild(br); 
	return br;
}	

function newP(elm){
	// elm の下に BR を生成して返す
	var p = document.createElement('P');
	elm.appendChild(p); 
	return p;
}	

function newDIV(elm, id){
	// elm の下に DIV を生成して返す
	var dv = document.createElement('DIV');
	if (id.length) dv.setAttribute("id", id);
	elm.appendChild(dv); 
	return dv;
}	

function newJS(elm, id){
	// elm の下に JS を生成して返す
	var dv = document.createElement('JS');
	if (id.length) dv.setAttribute("id", id);
	elm.appendChild(dv); 
	return dv;
}	

function newSPAN(elm, id){
	// elm の下に span を生成して返す
	var sp = document.createElement('span');
	if (id.length) sp.setAttribute("id", id);
	elm.appendChild(sp);
	return sp;
}

function newFIELD(elm, id, label, size, value){
	// 入力フィールドを生成
	if (label.length){
		newTEXT(elm, label);
	}
	var ip = document.createElement('INPUT');
	ip.setAttribute("TYPE", "text");
	if (id.length) ip.setAttribute("id", id);
	ip.setAttribute("SIZE", size);
	ip.setAttribute("VALUE", value);
	elm.appendChild(ip); 
	
	return ip;
}

function newHIDDEN(elm, id, value){
	var ip = document.createElement('INPUT');
	elm.appendChild(ip); 
	ip.setAttribute("TYPE", "hidden");
	ip.setAttribute("VALUE", value);
	if (id.length) ip.setAttribute("id", id);
	
	return ip;
}

function newBUTTON(elm, id, label){
	// ボタンを生成
	var ip = document.createElement('INPUT');
	ip.setAttribute("TYPE", "button");
	if (id.length) ip.setAttribute("id", id);
	ip.setAttribute("VALUE", label);
	elm.appendChild(ip); 
	
	return ip;
}

function newCHECKBOX(elm, id, label, status){
	var ip = document.createElement('INPUT');
	elm.appendChild(ip); 
	ip.setAttribute("TYPE", "checkbox");
	if (id.length) ip.setAttribute("id", id);
	if (status > 0) ip.setAttribute("CHECKED" , true);
	if (label.length){
		var tx = document.createTextNode(label);
		elm.appendChild(tx); 
	}
	
	return ip;
}

function newTEXTAREA(elm, id, cols, rows, value){
	// TEXTAREAを生成
	var ip = document.createElement('TEXTAREA');
	if (id.length) ip.setAttribute("id", id);
	ip.setAttribute("id", id);
	ip.setAttribute("COLS", cols);
	ip.setAttribute("ROWS", rows);
	elm.appendChild(ip); 
	var tx = document.createTextNode(value);
	ip.appendChild(tx); 
	
	return ip;
}

function newA(elm, label, href, target){
	var a = document.createElement('A');
	elm.appendChild(a); 
	a.href=href;
	if (target.length) a.target=target;
	newTEXT(a, label);
	
	return a;
}

function newIMAGE(elm, id, src, alt){
    var img = document.createElement('IMG');
	elm.appendChild(img); 
	img.setAttribute("id", id);
	img.setAttribute("SRC", src);
	img.setAttribute("ALT", alt);

	return img;
}

function newHR(elm){
    var hr = document.createElement('HR');
	elm.appendChild(hr); 
	
	return hr;
}

function makePopupMenu(elm, label, array, selectedItem){
	var sl = document.createElement('SELECT');
	sl.setAttribute("id", label);
	elm.appendChild(sl);
	
	var count = array.length;
	for (var i=0; i < count; i++){
		var title = array[i];
		var op = document.createElement('OPTION');
		tx = document.createTextNode(title); op.appendChild(tx); 
		op.setAttribute("value",title); sl.appendChild(op); 
		if (title == selectedItem) op.setAttribute("selected", true);
	}
	return sl;
}

function currentDateFormat(){
	// 年月日ポップアップから西暦年月日を返す
	//### こちらは旧式につき makeDatePopUp(id, label, yy, mm, dd) を使うこと ###
	var elm = document.getElementById("wareki");
	var year = document.getElementById("year").value * 1;
	var month = document.getElementById("month").value;
	var day = document.getElementById("day").value;
	
	if (elm){ // 西暦/和暦ポップアップがある場合
		var koyomi = elm.value;
		if (isSame(koyomi,"平成"))
			year += 1988;
		else if (isSame(koyomi,"昭和"))
			year += 1925;
		else if (isSame(koyomi,"大正"))
			year += 1911;
		else if (isSame(koyomi,"明治"))
			year += 1867;
	}
	
	if (month.length < 2) month = "0"+month;
	if (day.length < 2) day = "0"+day;
	return year + "-" + month + "-" + day + " 00:00:00";
}
function makeYYMMDD(elm, koyomiLabel, yy, mm, dd){
	// yy,mm,dd の日付ポップアップメニューを "YYMMDD" node に貼付ける
	//### こちらは旧式につき makeDatePopUp(id, label, yy, mm, dd) を使うこと ###
	var date = yy + "-" + mm + "-" + dd;
	if (koyomiLabel.length > 0){
		var anArray = new Array("西暦","平成","昭和","大正","明治");
		var sl = makePopupMenu(elm, "wareki", anArray, koyomiLabel);
		//sl.setAttribute("onmouseup", "koyomiSelected('wareki')");
	}
	var js = newJS(elm, "yearBase");
	var array = date.split(" ");
	var array2 = array[0].split("-");
	if (array2.length > 2){
		var yy = array2[0];
		var mm = array2[1];
		var dd = array2[2];
		if (isSame(koyomiLabel, "平成")){
			yy -= 1988; start = 0; range = 100;
		} else if (isSame(koyomiLabel, "昭和")){
			yy -= 1925;
		} else if (isSame(koyomiLabel, "大正")){
			yy -= 1911;
		} else if (isSame(koyomiLabel, "明治")){
			yy -= 1867;
		}
		
		var start = yy - 100;
		if (start < 0) start = 0;
		var anArray = makeArray(start, 200);
		anArray.push("");
		var sl = makePopupMenu(js, "year", anArray, yy);
		
		anArray = makeArray(1, 12);
		anArray.push("");
		sl = makePopupMenu(elm, "month", anArray, mm);
		
		anArray = makeArray(1, 31);
		anArray.push("");
		sl = makePopupMenu(elm, "day", anArray, dd);
	}
}

function koyomiSelected(id){
	// 暦の選択に応じて年数ポップアップを変化させる
	var elm = document.getElementById(id);
	var label = document.getElementById(id+".koyomiLabel").value;
	var yy = document.getElementById(id+".year").value;
	var mm = document.getElementById(id+".month").value;
	var dd = document.getElementById(id+".day").value;
	makeDatePopUp(id, label, yy, mm, dd);
}
function yearChanged(id){
	// 「和暦」が変更されたなら、西暦：隠しフィールドも更新
	var label = document.getElementById(id+".koyomiLabel").value;
	var warekiYear = document.getElementById(id+".warekiYear").value * 1;
	var yy = warekiYear;
	if (isSame(label, "平成"))
		yy = warekiYear + 1988;
	else if (isSame(label, "昭和"))
		yy = warekiYear + 1925;
	else if (isSame(label, "大正"))
		yy = warekiYear + 1911;
	else if (isSame(label, "明治"))
		yy = warekiYear + 1867;
	document.getElementById(id+".year").value = yy;
}
function selectedYYMMDD(id){
	// 年月日ポップアップから西暦年月日を返す
	var koyomiLabel = document.getElementById(id+".koyomiLabel").value;
	var year = document.getElementById(id+".year").value;
	var month = document.getElementById(id+".month").value;
	var day = document.getElementById(id+".day").value;
	
	if (month.length < 2) month = "0"+month;
	if (day.length < 2) day = "0"+day;
	return year + "-" + month + "-" + day;
}
function makeDatePopUp(id, label, yy, mm, dd){
	// id で特定される element 上に label(和暦などのラベル),date をセット
	// yy は西暦で指定すること。labelの「西暦」、和暦に従って年を変換
	var warekiYear = yy;
	var range = 2020;
	if (isSame(label, "平成")){ warekiYear -= 1988; range = 30; }
	else if (isSame(label, "昭和")){ warekiYear -= 1925; range = 63; } 
	else if (isSame(label, "大正")){ warekiYear -= 1911; range = 14; } 
	else if (isSame(label, "明治")){ warekiYear -= 1867; range = 43; }

	// 以下は range 決定後実施
	if ((yy.length == 0) || (yy * 1 == 0)){
		warekiYear = ""; mm = ""; dd = "";
	} else if ((warekiYear < 0) || (warekiYear > range)){
		alert("西暦"+yy+"年は「"+label+"」に変換できません");
		range = 2020; warekiYear = yy; label = "西暦";
	}
	
	// ポップアップからの 暦表示・和暦年・年・月・日 は以下のように取得する
	// koyomiLabel は document.getElementById(id+".koyomiLabel").value
	// warekiYear は document.getElementById(id+".warekiYear").value
	// year は document.getElementById(id+".year").value
	// month は document.getElementById(id+".month").value
	// day は document.getElementById(id+".day").value
	var elm = document.getElementById(id);
	elm.innerHTML = "";
	var labels = new Array("西暦","平成","昭和","大正","明治");
	var js = newJS(elm, "_koyomiLabel");
	var sl = makePopupMenu(js, id+".koyomiLabel", labels, label);
	var action = "koyomiSelected('" + id + "')";
	sl.setAttribute("onmouseup", action);
	
	var hd = newHIDDEN(elm, id+".year", yy); // 西暦：隠しフィールド
	var years = makeArray(1, range); years.push("");
	var sl = makePopupMenu(elm, id+".warekiYear", years, warekiYear); // 和暦
	var action = "yearChanged('" + id + "')";
	sl.setAttribute("onmouseup", action);
	
	var months = makeArray(1, 12); months.push("");
	var sl = makePopupMenu(elm, id+".month", months, mm);
	
	var days = makeArray(1, 31); days.push("");
	var sl = makePopupMenu(elm, id+".day", days, dd);
}

function newRADIO(elm, id, groupName, names, selection){
	// ラジオボタンを生成
	// groupName: radio button グループの共通名称
	// # array['item1'] = "アイテム１";
	// # array['item2'] = "アイテム２"; のような array を作成しておく
	// # newRADIO(elm, "_radioArea", "radioButtons", array, "item1");
	// # elm 上の _dadioArea というエレメント上に "radioButtons" というグループ名で
	// # radio button を作成し "item1" が選択状態になる。
	// # 選択された値は checkedRADIO("_radioArea") でゲットできる（"アイテム１" など）
	elm.innerHTML = "";
	var js = newJS(elm, id); // radio button を収納する node
	for (num in names){
		var status = (isSame(num, selection)) ? true : false;
		makeRadio(js, groupName, names[num], status);
	}
	
	function makeRadio(elm, groupName, label, status){
		// radio ボタンを生成
		var ip = document.createElement('INPUT');
		ip.setAttribute("TYPE", "radio");
		ip.setAttribute("VALUE", label);
		ip.setAttribute("NAME", groupName); // radio button グループの共通名称
		if (status) { ip.setAttribute("CHECKED", true); }
		elm.appendChild(ip); 
		var tx = document.createTextNode(label);
		elm.appendChild(tx); 
	}
}
function checkedRADIO(id){
	// id で指定されたラジオボタンからチェックされた値を返す
	var radio = document.getElementById(id);
	var array = radio.childNodes;
	for (var i=0,count=array.length; i < count; i++){
		if (array[i].value){
			if (array[i].checked)
				return array[i].value;
		}
	}
	return "";
}
