
///////////////////////////////////
/// localStorage による処理 /////////

function getFinderWindowSize(){
	// DocMaker のウインドー位置とサイズを localStorage から取り出す
    if (window.name == "tools") return;

    var windowStatus = window.localStorage["finderWindowSize"];
    if (windowStatus){
        var array = windowStatus.split(",");
        var x = array[0];
        var y = array[1];
        var w = array[2];
        var h = array[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
    }
}

/// localStorage による処理 /////////
///////////////////////////////////

function _showPatientList(){
    // 検索キーに一致したカルテを検索
    
    // ウインドー位置とサイズをサーバへ記憶
    put_windowSize(0, -22, "finderWindowSize");

    var searchKey = document.getElementById("keyF").value;
    
    setStoragedKey(searchKey); // localStorage に記憶
    parent().getPatients(searchKey);
}
function makePatientFinder(){
    // カルテ検索の画面を生成
    var div = elmFor("patientFinderArea");
    div.innerHTML = "";
    var fd = newFIELD(div, "keyF", "", 40, storagedKey());
    fd.setAttribute("class", "searchField");
    fd.setAttribute("onchange", "_showPatientList()");
    fd.setAttribute("placeholder", "カルテ番号 or ローマ字 or かな or 漢字氏名"); // 入力ヒントを表示
    fd.focus();
    fd.select(); // 入力欄を全選択
    // 検索ボタン
    var bt = newSPAN(div, "/searchButton");
    bt.innerHTML = "検索";
    bt.setAttribute("onclick", "_showPatientList()");
}

function _showAnotherPanel(){
    // 別ウインドーに表示する
	window.open("./search.php","chartFinder"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function searchHelp(){
	window.open("./searchHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function makeInPatientArea(){
    // もし入院を扱っているなら入院検索エリアを生成
    // ===== 入院検索
    var elm = elmFor("inPatientArea");
    var pframe = new PictureFrame(elm, "50%", "90%");
    // === HEADER =======================
    pframe.headerLeft.innerHTML = "入院カルテの検索";
    // === BODY ================
    var dv = pframe.body;
    dv.setAttribute("id", "inPatientFinderArea");
    dv.style.margin = "5px 10px";
    makeInPatientFinder();
    // === FOOTER：表示しない =====
    pframe.footer.style.display = "none"; //###
}

function initSearch(){
	var elm = document.getElementById("base");
    
    // ====== カルテ検索
    var div = newDIV(elm, "");
    var pframe = new PictureFrame(div, "50%", "90%");
    // === HEADER ==================
    // --- LEFT SIDE
    pframe.headerLeft.innerHTML = "カルテ検索";
    // --- RIGHT SIDE
    var img = newIMAGE(pframe.headerRight, "outArrowIcon", "Help.png", "?");
    img.setAttribute("onclick", "searchHelp()");
    img.style.height = "17px";
    img.setAttribute("class", "expandIcon");
    // === BODY ================
	var dv = newDIV(pframe.body, "patientFinderArea");
    dv.style.margin = "5px 10px";
    makePatientFinder();
    // === FOOTER：表示しない =====
    pframe.footer.style.display = "none"; //###

    // ===== 条件検索
    var div = newDIV(elm, "");
    var pframe = new PictureFrame(div, "50%", "90%");
    // === HEADER =======================
    pframe.headerLeft.innerHTML = "条件検索";
    // === BODY ================
    var dv = pframe.body;
    dv.setAttribute("id", "chartFinderArea");
    dv.style.margin = "5px 10px";
    makeChartFinder();
    // === FOOTER：表示しない =====
    pframe.footer.style.display = "none"; //###
    
    // ===== 入院検索
    var div = newDIV(elm, "inPatientArea");
    
   // ===== 受診日検索
    var div = newDIV(elm, "");
    var pframe = new PictureFrame(div, "50%", "90%");
    // === HEADER =======================
    pframe.headerLeft.innerHTML = "受診日検索";
    // === BODY ================
    var dv = pframe.body;
    dv.setAttribute("id", "lvdSearchArea");
    dv.style.margin = "5px 10px";
    makeLvdSearcher();
    // === FOOTER ==================
    pframe.footerLeft.innerHTML = version();
    
    // カルテ検索のフィールドにフォーカスし直す
    var fd = elmFor("keyF");
    fd.focus();

    // iFrame なら toggleButton にツール名を表示
    var bt = tools().elmFor("toggleButton");
    if (bt) bt.innerHTML = "検索ツール";

    // window size を読み込む
    getFinderWindowSize();
    
    // 入院を扱っているなら入院検索ツールを表示
    getInPatient();
}

function version(){
	return "Ver.140713";
}

