

var _callTypes = ["メニューに設定","CELL に設定"];

function act_add(array){
    var sum = 0;
    for (num in array){
        sum += array[num] * 1;
    }
    return sum;
}

/////////////////////////////////////////////////////////////////
///// バックアップ ////////////////////////////////////////////////

function puttedCallBackupList(answer){
    //console.log("puttedCallBackupList", answer); //##

    setCalls(null); // サーバから再読み込みスタンバイ: dataCenter.js
    closeFloatPanel();
}
function putCallBackupList(){
    // CALL 構造をサーバへ保存
    var args = calls();
    args['_OWNER_'] = owner(); // owner は args へ埋込でないと正しく解凍されない
    
    NRCall("PUT_CALLS_BACKUP", args, puttedCallBackupList);
}

function gotCallBackupList(answer){
    // バックアップ・ファイル名の配列をポップアップ・メニュー表示
    var obj = JSON.parse(answer);
    //console.log("gotCallBackupList->", obj); //##
    
    var files = new Array();
    var array = obj.files;
    for (num in array){
        // ".", ".." を削除
        var filename = array[num];
        if (filename == ".") continue;
        if (filename == "..") continue;
        if (filename.charAt(0) == "_") continue; // 削除マークのついたファイル
        files.push(array[num]);
    }

    var elm = elmFor("backupPopArea");
    elm.innerHTML = "バックアップ";
    elm.style.fontSize = "9pt";
    // ポップアップ・メニュー
    var pu = newPopupMenu(elm, "backupPop", files, "");
    pu.style.marginLeft = "5px";
    var bt = newDIV(elm, "/whiteButton");
    bt.innerHTML = "から復元";
    bt.setAttribute("onclick", "restoreCallBackup()");
    // 削除ボタン
    var sp = newSPAN(elm, "");
    sp.setAttribute("onclick", "removeCallBackup()");
    var img = newIMAGE(sp, "", "remove-field.png", "remove");
    img.setAttribute("class", "expandIcon");
    img.style.height = "10px";
}
function getCallBackupList(){
    // CALL のバックアップをサーバへリクエスト
    var args = new Object();
    args["owner"] = owner(); // localStorage.js
    
    NRCall("GET_CALLS_BACKUP", args, gotCallBackupList);
}

function savedRestore(answer){
    elmFor("backupArea").innerHTML = "";
}
function saveRestore(){
    // 復元した CALLS をサーバへ保存
    var array = [];
    var recs = calls();
    for (menu in recs){
        var rec = recs[menu];
        var args = new Object();
        args["owner"] = owner();
        args["type"] = rec.type;
        args["name"] = menu;
        args["calls"] = rec.value;
        
        array.push(args);
    }

    // 復元した全ての call をサーバのものと置換
    elmFor("backupArea").innerHTML = "データを復元中...";
    NRCall("PUT_CALLS_ARRAY", array, savedRestore);
}
function restoredCallBackup(answer){
    // 復元された CALLS を再表示し、本日の日付で保存
    //console.log("restoredCallBackup", answer, "====="); //##
    
    var obj = decodeObject(answer);
    //console.log("restoredCallBackup", obj); //##
    
    var recs = new Object();
    for (title in obj){
        if (title == '_OWNER_') continue; // 埋込 owner はスキップ
        
        var rec = obj[title];
        var obj1 = new Object();
        obj1.type = rec.type;
        obj1.value = rec.value;
        recs[title] = obj1;
    }
    
    setCalls(recs);
    
    // ポップアップ・メニューを再表示
    var div = elmFor("callMenuPopArea");
    div.innerHTML = "";
    var obj = calls(); // dataCenter.js
    var menus = allKeys(obj);
    menus.splice(0, 0, "");
    var pu = newPopupMenu(div, "", menus, "");
    pu.setAttribute("onchange", "selectedCallsMenu(this)");
    
    elmFor("nameF").value = "";
    elmFor("textF").value = "";
    
    // 復元した CALLS をサーバへ保存
    saveRestore();
}
function restoreCallBackup(){
    // CALLS をバックアップから復元
    var filename = elmFor("backupPop").value;
    
    var args = new Object();
    args["owner"] = owner(); // localStorage.js
    args["filename"] = filename;
    
    NRCall("GET_CALLS_BACKUP", args, restoredCallBackup);
}

function removedCallBackup(answer){
    // 削除後のファイル名の配列を表示
    getCallBackupList();
}
function removeCallBackup(){
    // CALL を削除
    var filename = elmFor("backupPop").value;
    //console.log("removeCallBackup", filename); //##
    
    var args = new Object();
    args["owner"] = owner(); // localStorage.js
    args["value"] = filename;
    
    NRCall("REMOVE_CALLS_BACKUP", args, removedCallBackup);
}

function openCallBackup(){
    // バックアップ・ペーンを開く
    var elm = elmFor("backupArea");
    if (elm.innerHTML.length){
        elm.innerHTML = "";
        return;
    }
    elm.innerHTML = "";
    var div = newDIV(elm, "");
    div.style.fontSize = "9pt";
    div.style.backgroundColor = "#ffe";
    div.style.margin = "0 10px 10px 10px";
    div.style.padding = "10px 10px";
    div.style.border = "thin solid #ccc";
    div.style.borderRadius = "8px";
    
    // バックアップ・ファイルのポップアップ・メニュー
    var dv = newDIV(div, "");
    var sp = newSPAN(dv, "backupPopArea");
    
    getCallBackupList();
}

/////////////////////////////////////////////////////////////////
///// 編集パネル /////////////////////////////////////////////////

function savedCalls(){
    putCallBackupList();
}
function saveCalls(){
    // 編集された call をサーバへ保存
    var st = elmFor("typePop").value;
    var type = (st == _callTypes[0]) ? 0 : 1;
    var name = elmFor("nameF").value;
    var calls = elmFor("textF").value;
    
    if (name.length == 0){
        alert("名前が設定されていません");
        return;
    } else if (calls.length == 0){
        alert("call が空です");
        return;
    }
    
    var args = new Object();
    args["owner"] = owner();
    args["type"] = type;
    args["name"] = name;
    args["calls"] = (calls) ? calls : null;
    
    NRCall("PUT_CALLS", args, savedCalls);
}

function removeCalls(){
    // 現在表示されている一括処理を削除
    var name = elmFor("nameF").value;
    if (name.length == 0){
        alert("名前が空なので削除できません");
        return;
    }
    
    // calls が null の場合は削除になる
    var args = new Object();
    args["owner"] = owner();
    args["type"] = null;
    args["name"] = name;
    args["calls"] = null;

    NRCall("PUT_CALLS", args, savedCalls);
}

function selectedCallsMenu(elm){
    // 編集パネルのポップアップが選択された
    var menu = elm.value;
    var obj = calls()[menu]; // obj={"type":[0,1],"value":"script"}
    var type = (obj) ? obj.type : 0; 
    
    var sp = elmFor("typePopArea");
    sp.innerHTML = "";
    var pu = newPopupMenu(sp, "typePop", _callTypes, _callTypes[type]);
    
    elmFor("nameF").value = menu;
    elmFor("textF").value = (obj) ? obj.value : "";
}
function openCallEditor(){
    // call のシナリオを作成するパネルを開く
    var x = 20;
    var y = 20;
    var w = 380;
    var title = "動作一括処理 編集パネル";
    var action = "openHelp('./callHelp.html')";
    var panel = new FloatPanel("_floatPanel", x, y, w, title);
    if (!panel) return;
    var elm = panel.contents;

    var div = newDIV(elm, "callMenuPopArea");
    var obj = calls(); // dataCenter.js
    var menus = allKeys(obj);
    menus.splice(0, 0, "");
    var pu = newPopupMenu(div, "", menus, "");
    pu.setAttribute("onchange", "selectedCallsMenu(this)");
    
    var div = newDIV(elm, "");
    div.style.fontSize = "10pt";
    var sp = newSPAN(div, "typePopArea");
    var pu = newPopupMenu(sp, "typePop", _callTypes, "");
    var value = "";
    var name = "";
    var fd = newFIELD(div, "nameF", "", 30, name);
    fd.setAttribute("placeholder", "この一括処理につける名前"); // 入力ヒントを表示
    fd.focus();
    
    var div = newDIV(elm, "");
    var value = "";
    var ta = newTEXTAREA(div, "textF", 50, 15, value);
    
    // コントロール・ボタン
    var div = newDIV(elm, "/clearfix");
    div.style.margin = "3px 0";
    var dv = newDIV(div, "/left-side");
    dv.style.width = "150px";
    var bt = newDIV(dv, "/listMember");
    bt.innerHTML = "バックアップ";
    bt.setAttribute("onclick", "openCallBackup()");

    var dv = newDIV(div, "/right-side");
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "この一括処理を削除";
    bt.setAttribute("onclick", "removeCalls()");
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "保存";
    bt.setAttribute("onclick", "saveCalls()");
    
    // バックアップ・エリア
    var div = newDIV(elm, "backupArea");
}

///// 編集パネル /////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////
///// 動作一括処理パネル ///////////////////////////////////////////

function selectCallsMenu(elm){
    // メニューが選択された
    var menu = inner_text(elm); // FireFox 対応
    var buff = calls()[menu].value; // dataCenter.js
    
    // eval(buff) で closeFloatPanel() とバッティングすることがあるので eval() より先に実行
    closeFloatPanel();
    
    eval(buff);
}

function showCalls(){
    // calls のポップアップを表示
    var elm = elmFor("callsPop");
    elm.innerHTML = "";

    var recs = calls();
    for (menu in recs){
        var rec = recs[menu];
        if (rec.type > 0) continue; // CELL タイプはスキップし メニュー・タイプのみ表示
        
        var div = newDIV(elm, "");
        var bt = newDIV(div, "/blueButton");
        bt.innerHTML = menu;
        bt.setAttribute("onclick", "selectCallsMenu(this)");
    }
    
    var div = newDIV(elm, "");
    div.style.marginTop = "5px";
    div.style.fontSize = "9pt";
    var bt = newDIV(div, "/listMember");
    bt.innerHTML = "メニューを編集";
    bt.setAttribute("onclick", "openCallEditor()");
}
function gotCalls(answer){
    // サーバから返された値を元に calls のポップアップを表示
    var obj = JSON.parse(answer);
    setCalls(obj); // dataCenter.js
    showCalls();
}
function openCalls(){
    // call 一括処理パネルを表示
    var x = 20;
    var y = 80;
    var w = 200;

    // アクティブなページ位置に合わせパネルを開く
    var elm = elmFor(currentDate() + ".page");
    if (elm){
        var pos = getPosition(elm);
        y += pos.y;
    }

    var title = "SCRIPT";
    var action = "openHelp('./callHelp.html')";
    var panel = new FloatPanel("_floatPanel", x, y, w, title);
    if (!panel) return;
    var elm = panel.contents;
    
    var div = newDIV(elm, "callsPop");
    div.style.padding = "5px";
    div.style.fontSize = "10pt";

    if (calls()){ // dataCenter.js
        showCalls();
    } else {
        var args = new Object();
        args["owner"] = owner();
        
        NRCall("GET_CALLS", args, gotCalls);
    }
}

///// 動作一括処理パネル ///////////////////////////////////////////
/////////////////////////////////////////////////////////////////
