
var _staffs;
function setStaffList(array){
	_staffs = array;
}
function addSaffList(name){
	for (var i=0,ct=_staffs.length; i < ct; i++){
		if (_staffs[i] == name) return _staffs;
	}
	_staffs.splice(ct-2,0,name);
	return _staffs;
}
function staffList(){
	return _staffs;
}

var _staffRecord;
function setStaffRecord(rec){
    //alert("setStaffRecord->"+encodeObject(rec)); //##
    var code = rec.sectionCode; // 部署コード = "23" 形式
    
	_staffRecord = rec;
}
function staffRecord(){
	return _staffRecord;
}
function staffValueForKey(key){
	return _staffRecord[key];
}
function setStaffValueForKey(val, key){
	_staffRecord[key] = val;
}

function MML0026(){
	// 記録者分類および医療資格コード: groupCode
	return { "doctor":"医師","dentist":"歯科医師","nurse":"看護師","assistantNurse":"准看護師","lab":"臨床検査技師","rad":"レントゲン技師","pharmacist":"薬剤師","pt":"理学療法士","ot":"作業療法士","psy":"精神保健福祉士","cps":"臨床心理技術者","nutritionist":"栄養士","dentalHygienist":"歯科衛生士","dentalTechician":"歯科技工士","clinicalEngineer":"臨床工学技士","careManager":"介護支援専門員","other":"その他の医療従事者","acupuncturist":"鍼灸師","patient":"患者およびその代理人","clerk":"書記","office worker":"事務" };
}

function MML0028(){
	// 医科診療科コード: sectionCode
	return { "01":"内科","02":"精神科","03":"神経科","04":"神経内科","05":"呼吸器科","06":"消化器科","07":"胃腸科","08":"循環器科","09":"小児科","10":"外科","11":"整形外科","12":"形成外科","13":"美容外科","14":"脳神経外科","15":"呼吸器外科","16":"心臓血管外科","17":"小児外科","18":"皮膚泌尿器科","19":"皮膚科","20":"泌尿器科","21":"性病科","22":"肛門科","23":"産婦人科","24":"産科","25":"婦人科","26":"眼科","27":"耳鼻咽喉科","28":"気管食道科","29":"理学療法科","30":"放射線科","31":"麻酔科","32":"人工透析科","33":"心療内科","34":"アレルギー","35":"リウマチ","36":"リハビリ","A1":"鍼灸","00":"その他" };
}

function userCodes(){
    // アクセス許可区分: userCode に割り振る
    return { "read":"参照のみ許可","write":"参照・修正を許可","all":"参照・修正・管理者権限" }
    // function MML0034(){
    // return { "none":"すべてのアクセスを不許可","read":"参照を許可","write":"参照，修正を許可","delete":"参照，削除を許可","all":"修正，削除を許可" }
}

////////////////////////////////////////////////////
///// Ajax /////////////////////////////////////////

var _loadedKanjiName;
function gotStaffList(answer){
	// 職員リストを表示
    //alert("gotStaffList ===\n"+answer);//###
    var obj = eval('(' + answer + ')');
    var items = new Array();
    for (i in obj){
        var rec = obj[i];
        items.push(rec.kanjiName);
    }
    //alert("gotStaffList ===\n"+encodeObject(items));//###
    setStaffList(items);
    items.splice(0,0,"");
    items.push("...その他");
    
    // 職員リストを表示
    showStaffPopup(items);
}
function getStaffList(kanjiName){
	// 職員リストを DB へリクエスト
    _loadedKanjiName = kanjiName;

    var args = new Object();
    args["hospitalId"] = hospitalId();
    
    _callServer("GET_USERS", "sysServer.php", args, gotStaffList);
}

var _isNew;
function gotStaff(answer){
	// 職員のレコードを表示
    //alert("gotStaff ===\n"+answer);//###
    var record = JSON.parse(answer);
    record.hospitalId = hospitalId();
    setStaffRecord(record);
    
    // スタッフ編集パネルを開く
    showStaffEditor(record, _isNew);
    
    // 職員リストのポップアップを更新
    var kanjiName = record.kanjiName;
    var items = staffList();
    if (indexOfArray(items, kanjiName) < 0){
        var pos = items.length - 1;
        items.splice(pos, 0, kanjiName);
        showStaffPopup(items);
    }
}
function getStaff(name, isNew){
	// スタッフのレコードを DB へリクエスト
    var args = new Object();
    args['hospitalId'] = hospitalId();
    args['kanjiName'] = name;
    if (isNew) args['isNew'] = 1;
    
    _callServer("GET_USER", "sysServer.php", args, gotStaff);
}

function savedStaff(answer){
    //alert("savedStaff->"+answer); //##
    // 職員ポップアップを再読み込み kanjiName を選択し、その編集ペーンを開く
    var rec = staffRecord();
    getStaffList(rec.kanjiName);
}
function saveStaff(){
	// スタッフのレコードを DB へ保存
	var rec = staffRecord();
	if (incompleteStaffInfo(rec)) return;
	
    var args = new Object();
    args['userCode'] = rec['userCode']; // ACCESS CODE
    //args['userCode'] = 4; // 読み書き可に決め打ち
    args['sectionCode'] = rec['sectionCode'];
    args['groupCode'] = rec['groupCode'];
    args['loginName'] = rec['loginName'];
    args['kanjiName'] = rec['kanjiName'];
    if (rec['identifier'])
        args['identifier'] = rec['identifier'];
    args['hospitalId'] = hospitalId();
    args['memo'] = rec['memo'];
    args['entryDate'] = rec['entryDate'];
    args['updateTime'] = rec['updateTime'];
    args['owner'] = owner();
    
    _callServer("PUT_USER", "sysServer.php", args, savedStaff);
	
	function incompleteStaffInfo(rec){
		// スタッフ情報の入力内容が不十分なら true を返す
		if (!rec.sectionCode || (rec.sectionCode.length == 0)){
			alert("「部署」が空欄なので保存できません");
			return true;
		} else if (!rec.groupCode || (rec.groupCode.length == 0)){
			alert("「職種」が空欄なので保存できません");
			return true;
		} else if (!rec.kanjiName || (rec.kanjiName.length == 0)){
			alert("「氏名」が空欄なので保存できません");
			return true;
		} else if (!rec.loginName || (rec.loginName.length == 0)){
			alert("「ログイン名」が空欄なので保存できません");
			return true;
		}
		return false;
	}
}

function removeStaff(loginName){
	// スタッフのレコードを DB から削除
	if (!confirm(loginName + " を登録職員から削除していいですか")) return;
	
    var args = new Object();
    args['hospitalId'] = hospitalId();
    args['loginName'] = loginName;
    
    _callServer("REMOVE_USER", "sysServer.php", args, gotStaffList);
}

///// Ajax /////////////////////////////////////////
////////////////////////////////////////////////////



function showStaffHelp(){
	var elm = document.getElementById("staffHelpArea");
    if (elm.innerHTML.length){
        elm.innerHTML = "";
    } else {
        elm.innerHTML = "";
        var st = "職員を選択し編集してください。新規に職員を登録するには「...その他」を選択します。<br>　ログイン名を変更した場合、旧ログイン名のユーザ情報はそのまま残り<br>　新たなログイン名で新規ユーザとして別個に追加されます。";
        var sp = newSPAN(elm, "");
        sp.innerHTML = st;
        sp.style.color = "#a63"; // brown
        sp.style.padding = "5px 10px";
    }
}

function changeStaffValue(key){
    // key に対応する staffValue を更新し「保存」ボタンを表示
    if (key == "loginName")
        var val = document.getElementById("stf."+key).value;
    else if (key == "userCode")
        var val = document.getElementById("stf."+key).value;
    else
        var val = document.getElementById("stf."+key).innerHTML;
	setStaffValueForKey(val, key);
	
	var elm = document.getElementById("saveStaffButtonArea");
	elm.innerHTML = "";
	var bt = newBUTTON(elm, "", "保存");
	bt.setAttribute("onclick", "saveStaff()");
}

function clickedStaffList(elm){
    // 職員名がポップアップから選択された
	var name = elm.value;
	if (name.length == 0){
		document.getElementById("staffEditorArea").innerHTML = "";
		return;
	} else if (name == "...その他"){
		var array = hospitalIdTableInDB();
		var hid = hospitalId();
		if (indexOfArray(array, hid) < 0){
			alert("施設ID：" + hid + " がサーバに保存されていないので、その施設の職員を登録することはできません");
		} else {
			var name = window.prompt("スタッフ名（漢字）を入力してください","");
			if (name.length == 0) return;
			getStaff(name, true);
		}
	} else {
		getStaff(name, false);
    }
}
function showStaffPopup(items, kanjiName){
	// 職員リストを表示（kanjiName が存在すればその名前を選択）
    var elm = document.getElementById("staffInfoArea");
    elm.innerHTML = "";
//    alert("showStaffPopup ->"+items+"->"+elm);//###

    // 職員ポップアップ・エリア
    var dv = newDIV(elm, "yellow-bar");
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "5px";
    sp.innerHTML = "職員 ID";
    // 職員ポップアップ
    var sp = newSPAN(dv, "staffPopUpArea");
    sp.style.paddingRight = "5px";
    var item = (kanjiName) ? kanjiName : "";
	var pu = newPopupMenu(sp, "", items, item);
	pu.setAttribute("onchange", "clickedStaffList(this)");
    // ヘルプ・アンカー
    var a = newA(dv, "職員の登録について", "#", "");
    a.setAttribute("onclick", "showStaffHelp()");
    a.style.fontSize = "9pt";
    a.style.paddingLeft = "10px";
        
    // ヘルプ・エリア
    var dv = newDIV(elm, "staffHelpArea");
    
	// 職員編集エリア
    var dv = newDIV(elm, "staffEditorArea");

    if (kanjiName){
        // kanjiName があればその編集ペーンを開く
        getStaff(kanjiName);
    }
}

function clickedSectionCode(elm, key){
	// 診療科コードのポップアップメニューがクリックされた
	var name = elm.value;
	var table = MML0028();
	var code = "";
	for (cd in table){
		if (name == table[cd]){
			code = cd;
			break;
		}
	}
	document.getElementById("stf." + key).innerHTML = code;
	changeStaffValue(key);
}
function makeSectionCode(tbl, key, label, record){
	// 診療科コードのポップアップメニューを生成
    //alert("makeSectionCode->"+encodeObject(record)); //##
    
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", label);
	td.style.padding = "0px 5px";
	var td = newTD(tr, "", "");
	var items = new Array();
	var table = MML0028();
	items.push("");
	for (cd in table){
		items.push(table[cd]);
	}
	var val = "";
	var code = "";
	if (record){
		if (record.sectionCode){
			code = record.sectionCode;
			val = table[code];
		}
	}
    // 職種ポップアップ
	var pu = newPopupMenu(td, "", items, val);
	pu.setAttribute("onchange", "clickedSectionCode(this,'" + key + "')");
    
    // 職種入力欄
    var sp = newSPAN(td, "stf." + key);
    sp.style.paddingLeft = "10px";
    sp.innerHTML = code;
}

function clickedGroupCode(elm, key){
	// 医療資格コードのポップアップメニューがクリックされた
	var name = elm.value;
	var table = MML0026();
	var code = "";
	for (cd in table){
		if (name == table[cd]){
			code = cd;
			break;
		}
	}
	document.getElementById("stf." + key).innerHTML = code;
	changeStaffValue(key);
}
function makeGroupCode(tbl, key, label, record){
	// 医療資格コードのポップアップメニューを生成
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", label);
	td.style.padding = "0px 5px";
	var td = newTD(tr, "", "");

	var items = [""];
	var table = MML0026();
	for (cd in table){
		items.push(table[cd]);
	}
	var val = "";
	var code = "";
	if (record){
		if (record.groupCode){
			code = record.groupCode;
			val = table[code];
		}
	}
	var pu = newPopupMenu(td, "", items, val);
	pu.setAttribute("onchange", "clickedGroupCode(this,'" + key + "')");
    var sp = newSPAN(td, "stf." + key);
    sp.style.paddingLeft = "10px";
    sp.innerHTML = code;
}

function clickedUserCode(elm, key){
	// アクセス許可区分のポップアップメニューがクリックされた
	var name = elm.value;
    var table = userCodes();
	var code = "";
	for (cd in table){
		if (name == table[cd]){
			code = cd;
			break;
		}
	}
	document.getElementById("stf." + key).value = code;
	changeStaffValue(key);
}
function makeUserCode(tbl, key, label, record){
	// アクセス許可区分のポップアップメニューを生成: userCode に割り振る
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", label);
	td.style.padding = "0px 5px";
	var td = newTD(tr, "", "");

	var items = [""];
	var table = userCodes();
	for (cd in table){
		items.push(table[cd]);
	}
	var val = "";
	var code = "";
	if (record){
		if (record.userCode){
			code = record.userCode;
			val = table[code];
		}
	}
	var pu = newPopupMenu(td, "", items, val);
	pu.setAttribute("onchange", "clickedUserCode(this,'" + key + "')");
    var sp = newSPAN(td, "");
    sp.style.paddingLeft = "10px";
    var fd = newFIELD(td, "stf." + key, "", 20, code);
    fd.setAttribute("onchange", "changeStaffValue('" + key + "')");
}

function removePasswd(){
    // パスワードを削除
    _staffRecord.identifier = "";
    saveStaff();
}

function showStaffEditor(record, isNew){
    // 職員情報編集パネルを開く
	//alert("showStaffEditor:"+encodeObject(record)); //##
    
    // 施設情報編集パネルを閉じる
    document.getElementById("hospitalEditorArea").innerHTML = "";
    
	var elm = document.getElementById("staffEditorArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "base-table");
	tbl.style.fontSize = "10pt";
	tbl.style.marginTop = "5px";
	
	if (!record)
		record.hospitalInfo = hospitalId();
    
	// contents
	makeStaffValue(tbl, "kanjiName", "氏名（漢字）", record);
	makeStaffValue(tbl, "loginName", "ログイン名 (アルファベット)", record, "");
    
    // パスワード
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "パスワード");
    td.style.padding = "0px 5px";
    td.style.width = "220px";
	var td = newTD(tr, "", "");
    if (record.identifier){
        td.innerHTML = "設定済みパスワードを ";
        var bt = newBUTTON(td, "", "削除");
        bt.setAttribute("onclick", "removePasswd()");
    } else {
        td.innerHTML = "未設定";
    }
	var tr = newTR(tbl, "passwordHelpArea", "");
    showPasswordHelp();

	makeSectionCode(tbl, "sectionCode", "部署", record);
	makeGroupCode(tbl, "groupCode", "職種", record);
	makeUserCode(tbl, "userCode", "アクセス許可区分", record);
	var tr = newTR(tbl, "authorityHelpArea", "");
    showAuthoritydHelp();
    
    // ### 暫定ヘルプ ###
	var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    var td = newTD(tr, "", "");
    td.innerHTML = "アクセス許可区分は手でも修正できますが、通常はポップアップメニューからの選択に従ってください。旧バージョンNOAを使う場合のみ、ここに半角数値の 1 を入れると全権限を持つ設定になります。";
    td.style.padding = "10px 0px 0px 20px";
    td.style.fontSize = "9pt";
    td.style.color = "#888"; //brown
    // ### 暫定ヘルプ ###
	
	makeStaffValue(tbl, "memo", "メモ", record);
    
    makeStaffInfo(tbl, "登録年月日", record["entryDate"]);
    makeStaffInfo(tbl, "更新年月日", record["updateTime"]);
    makeStaffInfo(tbl, "オーナー", owner());

    var div = newDIV(elm, "yellow-bar");
	var bt = newBUTTON(div, "", "このユーザを削除");
	bt.setAttribute("onclick", "removeStaff('" + record['loginName'] + "')");
	var sp = newSPAN(div, "saveStaffButtonArea");
	
	function makeStaffValue(tbl, key, label, record, comment, disabled){
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "label-left", label);
		var val = "";
		if (record){
			if (record[key])
				val = record[key];
			else
				record[key] = ""; // record の値未設定なら空値で補完
		}
		
		var td = newTD(tr, "", "");
		if (key == "loginName"){
            var fd = newFIELD(td, "stf." + key, "", 20, val);
            fd.setAttribute("onchange", "changeStaffValue('" + key + "')");
            fd.focus();
        } else {
            var sp = newSPAN(td, "stf." + key);
            sp.innerHTML = val;
        }

		if (comment){
			td.style.color = "#a63"; //brown
			var tx = newTEXT(td, comment);
		}
		
		return td;
	}

	function makeStaffInfo(tbl, key, value){
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "label-left", key);
		var td = newTD(tr, "", value);
    }
    
    function showPasswordHelp(){
        // パスワード設定の説明
        var tr = document.getElementById("passwordHelpArea");
        var td = newTD(tr, "", "");
        var td = newTD(tr, "", "");
        td.innerHTML = "　パスワードの設定はここでは行いません。初回ログイン時にパスワード設定パネルが開き、そこで設定できます。<br>　既存のパスワードを変更したい場合のみ、ここで「パスワードを削除」してください。そうすると再びログイン時にパスワードを新規設定できます。";
        td.style.fontSize = "10pt";
        td.style.color = "#a63"; //brown
    }
    
    function showAuthoritydHelp(){
        // パスワード設定の説明
        var tr = document.getElementById("authorityHelpArea");
        var td = newTD(tr, "", "");
        var td = newTD(tr, "", "");
        td.innerHTML = "　NOA や FRONT の管理者には必ず「修正 削除を許可」の権限を与えてください。この権限がないと NOA や FRONT のレイアウト設定をすることができません。通常は NOA をインストール・メンテナンスする人が管理者になると思います。<br>　NOA の基本設定にタッチして欲しくないユーザは「参照、修正を許可」などの権限とします。";
        td.style.fontSize = "10pt";
        td.style.color = "#a63"; //brown
    }
}

function closeStaffInfo(){
    var elm = document.getElementById("staffInfoArea");
    elm.innerHTML = "";
}

