
////////////////////////////////////////////////////////
///// localStorage /////////////////////////////////////

function putListMakerWindowSize(){
    // ウインドー位置とサイズをサーバへ記憶
    put_windowSize(0, -22, "listMakerWindowSize");
}
function getListMakerWindowSize(){
    // ウインドウ・サイズを localStorage から復元
    var windowStatus = window.localStorage["listMakerWindowSize"];
    if (windowStatus){
        var array = windowStatus.split(",");
        var x = array[0];
        var y = array[1];
        var w = array[2];
        var h = array[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
    }
}

///// localStorage /////////////////////////////////////
////////////////////////////////////////////////////////

var _recordObj;
function setRecordObj(obj){
    //console.log("setRecordObj", obj["06308101"]); //##
    
    _recordObj = obj;
}
function recordObj(){
    // 検索結果オブジェクトを返す
    return _recordObj;
}

////////////////////////////////////////////////////////
///// AJAX /////////////////////////////////////////////

function gotSearchTable(answer){
    var obj = JSON.parse(answer);
    setRecordObj(obj);
    
    // 検索結果を表示
    makeList();
}
function getSearchTable(){
    // 設定されたレイアウトで検索結果を表示
    var elm = elmFor("listMakerContntsArea");
    elm.innerHTML = "";
    var sp = newSPAN(elm, "");
    sp.innerHTML = "検索結果を読み込んでいます...";
    sp.style.fontSize = "9pt";
    sp.style.color = "#f00";
    
    var args = new Object();
    args["owner"] = owner();
    args["keys"] = listMakerSrc();
    NRCall("GET_SEARCH_TABLE", args, gotSearchTable);
}

var _templateObj;
function gotTemplates(answer){
    // 表示項目のテンプレート群を受取り記憶
    //alert("gotTemplates->"+answer); //##
    _templateObj = new Object();
    var results = JSON.parse(answer);
    for (num in results){
        var rec = results[num];
        _templateObj[rec.menu] = rec.value.split(",");
    }
    
    // default テンプレートが無ければ追加
    if (! _templateObj["カルテ検索"]){
        _templateObj["カルテ検索"] = 
        ["ProgressSection.patientId","ProgressSection.entryDate"];
    }
    if (! _templateObj["条件検索"]){
        _templateObj["条件検索"] = 
        ["ProgressSection.patientId","ProgressSection.entryDate"];
    }
    if (! _templateObj["受診日検索"]){
        _templateObj["受診日検索"] = 
        ["ProgressSection.patientId","ProgressSection.entryDate"];
    }        
    
    // listMakerSrc の patientId,entryDate に該当するレコードをサーバへリクエスト
    getSearchTable();
}
function getTemplates(){
    // 表示項目のテンプレート群をサーバへリクエスト
    var tag = "LIST_MAKER";
    get_menu(owner(), tag, gotTemplates);
}

var _layoutObj;
function gotNoaLayouts(answer){
    // レイアウトをサーバから受取り表示
    var array = JSON.parse(answer);
    
    var obj = new Object();
    for (num in array){
        var rec = array[num];
        obj[rec.tag] = rec;
    }
    // サーバから得たオブジェクトにないものをテンプレートから補完
    var cellObj = cellTemplate();
    for (tag in cellObj){
        if (!obj || !obj[tag]){
            obj[tag] = cellObj[tag];
        }
    }
    
    // オブジェクトの中のタグとラベル名を _layoutObj に記憶
    _layoutObj = new Object();
    _layoutObj["ProgressSection.entryDate"] = "受診日"; // 決め打ちで追加
    _layoutObj["ProgressSection.patientId"] = "カルテID"; // 決め打ちで追加
    for (tag in obj){
        var rec = obj[tag];
        if (rec.disabled > 1) continue;
        
        _layoutObj[tag] = rec.label;
    }
    
    // 表示項目のテンプレート群をサーバへリクエスト
    getTemplates();
}
function getNoaLayouts(){
    // サーバからレイアウトを取得
    // NRGetLayout(owner(), gotNoaLayouts);
    var args = new Object();
    args["owner"] = owner();
    NRCall("GET_LAYOUT", args, gotNoaLayouts);
}

function savedListMakerLayout(answer){
    // 設定されたレイアウトで再描画
    makeList();
}
function saveListMakerLayout(){
    // 初期設定をサーバに保存
    var array = tagArray();
    var templateName = elmFor("searchTypePop").value;
    setCurrentType(templateName);  
    makeSearchTypePop("templatePopArea");

    closeFloatPanel();
    
    var tag = "LIST_MAKER";
    var menuItem = currentType();
    var value = array.join(",");
    put_menu(owner(), tag, menuItem , "", value, savedListMakerLayout);
}

function removedTemplate(answer){
    var obj = JSON.parse(answer);
    
    // 項目選択ポップアップ・メニューを表示
    makeSearchTypePop("templatePopArea");
    makeSearchTypePop("searchTypePopArea", "editMode");
}
function removeTemplate(){
    // 現在表示されているテンプレートをサーバから削除
    var menuItem = elmFor("templatePop").value;
    if (confirm(menuItem + " テンプレートを削除します")){
        delete _templateObj[menuItem]; // テンプレート群の記憶を更新

        var tag = "LIST_MAKER";
        remove_menu(owner(), tag, menuItem, "", removedTemplate);
    }
}

///// AJAX /////////////////////////////////////////////
////////////////////////////////////////////////////////


////////////////////////////////////////////////////////
///// DRAG and DROP ////////////////////////////////////

function d_dragstart(event){
    // ドラッグ開始時の処理
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
    event.dataTransfer.setData("text", event.target.id);
}

function d_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function d_drop(event, deleteFlag){
    // ドロップ時の処理
    // ドラッグされたデータのid名をDataTransferオブジェクトから取得
    var id_name = event.dataTransfer.getData("text"); // ラベル名
    
    if (deleteFlag){ // labelArray() から id_name のラベルを削除
        var labels = labelArray();
        var pos = indexOfArray(labels, id_name);
        if (pos >= 0){
            var tags = _templateObj[currentType()];
            tags.splice(pos, 1);
        }

        // ラベルを再表示
        showLabels(); 
    } else {
        //id名からドラッグされた要素を取得
        //ドロップ先にドラッグされた要素を追加
        move_to(id_name, event.currentTarget.innerHTML);
        
        //エラー回避のため、ドロップ処理の最後にdropイベントをキャンセルしておく
        event.preventDefault();
    }
}
var _labels;
function move_to(drop_name, target_name){
    // ドロップされたエレメントをドロップされたターゲット・エレメント位置へ移動
    // drop_name を削除
    var tags = _templateObj[currentType()];
    var drop_tag = tagForLabel(drop_name);
    var target_tag = tagForLabel(target_name);

    // drop_name に相当する tag を tags から一旦削除
    var pos1 = indexOfArray(tags, drop_tag);
    if (pos1 >= 0)
        tags.splice(pos1, 1);
    
    // drop_name に相当する tag を target_name に相当する tag の前に挿入
    var pos2 = indexOfArray(tags, target_tag);
    if (pos2 >= 0){
        if (pos1 <= pos2) pos2++;
        tags.splice(pos2, 0, drop_tag);
    }

    // ラベルを再表示
    showLabels(); 
}

///// DRAG and DROP ////////////////////////////////////
////////////////////////////////////////////////////////

////////////////////////////////////////////////////////
///// テンプレート編集パネル ///////////////////////////////

function setSearchTypes(type, tags){
    _templateObj[type] = tags;
}
function searchTypes(){
    // カルテ検索・条件検索・受診日検索など
    return allKeys(_templateObj);
}

var _currentType;
function setCurrentType(type){
    _currentType = type;
}
function currentType(){
    // 現在選択されている検索タイプを返す
    if (!_currentType){
        var st = listMakerHeader(); // "条件検索（...）" 型式
        var ary = st.split("（ ");
        _currentType = ary[0];
    }
    
    return _currentType;
}

function tagForLabel(aLabel){
    // label に相当する tag を返す
    for (tag in _layoutObj){
        var label = _layoutObj[tag];
        
        if (aLabel == label) return tag;
    }
    return null;
}

function showPopup(){
    // 項目選択ポップアップ・メニューを表示
    var elm = elmFor("popupArea");
    elm.innerHTML = "";
    
    var labels = [""];
    for (tag in _layoutObj){
        var label = _layoutObj[tag];
        labels.push(label);
    }
    
    var pu = newPopupMenu(elm, "", labels, "");
    pu.setAttribute("onchange", "addLabel(this)");
}
function showLabels(){
    // 選択されたラベル群を表示
    var elm = elmFor("layoutArea");
    elm.innerHTML = "";
    
    var div = newDIV(elm, "");
    div.style.fontSize = "9pt";
    div.style.marginBottom = "5px";
    var cb = newCHECKBOX(div, "", "付箋カラーを表示", postItColorForListCheck());
    cb.setAttribute("onchange", "setPostItColorForListCheck(this)");
    
    var div = newDIV(elm, "labelArea/clearfix");
    var array = labelArray();
    for (num in array){
        var label = array[num];
        var dv = newDIV(div, label + "/grayButton");
        dv.innerHTML = label;
        dv.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
        dv.setAttribute("ondragstart", "d_dragstart(event)");
        dv.setAttribute("ondragover", "d_dragover(event)");
        dv.setAttribute("ondrop", "d_drop(event)");
    }
    var sp = newSPAN(div, "popupArea");
    sp.style.mpaddingLeft = "5px";
    var dv = newDIV(sp, "/flatButton");
    dv.setAttribute("onclick", "showPopup()");
    var img = newIMAGE(dv, "", "./add-field.png", "x");
    img.style.height = "12px";
    img.style.marginRight = "5px";
    img.style.position = "relative";
    img.style.top = "2px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = "追加";
}

function addLabel(elm){
    // 項目選択ポップアップが選択された
    var tag = tagForLabel(elm.value);
    _templateObj[currentType()].push(tag);
    
    // ラベル配列を再表示
    showLabels();
}

function templateSelected(elm){
    // テンプレート・ポップアップが選択された
    setCurrentType(elm.value);
    showLabels();
}
function searchTypeChanged(elm){
    // ポップアップ・メニューが変更された
    if (elm.value == "...その他"){
        var templateName = prompt("このテンプレートに名前をつけてください");
        if (templateName.length){
            if (indexOfArray(searchTypes(), templateName) < 0){
                // 重複するテンプレート名はなかった
             //   setCurrentType(templateName);
                setSearchTypes(templateName, tagArray());
             //   makeSearchTypePop("templatePopArea");
                makeSearchTypePop("searchTypePopArea", "editMode", templateName);
            } else {
                alert(templateName + "というテンプレートはすでに存在します");
            }
        }
    }
}
function makeSearchTypePop(eid, editMode, templateName){
    // カルテ検索・条件検索・受診日検索などのポップアップ・メニューを生成
    var elm = elmFor(eid);
    elm.innerHTML = "";
    
    var array = [];
    array = array.concat(searchTypes());
    if (editMode){
        array.push("...その他");
        var menu = (templateName) ? templateName : currentType();
        var pu = newPopupMenu(elm, "searchTypePop", array, menu);
        pu.setAttribute("onchange", "searchTypeChanged(this)");
    } else {
        var pu = newPopupMenu(elm, "templatePop", array, currentType());
        pu.setAttribute("onchange", "templateSelected(this)");
    }
}

function openListMakerPreference(){
    // 初期設定パネルを生成
    var w = 800;
	var x = 10; // 表示するx座標
	var y = 30; // 表示するy座標
    var title = "テンプレート編集パネル";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, "openHelp('listMakerPrefHelp.html')");
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "8px";
    
    // テンプレート名ポップアップ・エリア
    var div = newDIV(elm, "");
    div.style.marginBottom = "5px";
    var sp = newSPAN(div, "templatePopArea");
    makeSearchTypePop("templatePopArea");
    // テンプレート削除ボタン
    var dv = newSPAN(div, "/flatButton");
    dv.setAttribute("onclick", "removeTemplate()");
    var img = newIMAGE(dv, "", "./remove-field.png", "x");
    img.style.height = "12px";
    img.style.position = "relative";
    img.style.top = "3px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = "このテンプレートを削除";
    sp.style.fontSize = "9pt";
    sp.style.padding = "0 10px";

    // レイアウト表示エリア
    var div = newDIV(elm, "layoutArea");
    div.style.margin = "5px 0";
    showLabels();

    // 確定ボタン
    var div = newDIV(elm, "/clearfix");
    div.style.marginTop = "10px";
    dv = newDIV(div, "/left-side"); // LEFT ==================
    dv.style.paddingLeft = "0";
    dv.style.width = "50%";
    var bt = newDIV(dv, "/flatButton");
    bt.setAttribute("ondragover", "d_dragover(event)");
    bt.setAttribute("ondrop", "d_drop(event,'delete')");
    var img = newIMAGE(bt, "", "./remove-field.png", "x");
    img.style.height = "12px";
    img.style.marginRight = "5px";
    var sp = newSPAN(bt, "");
    sp.innerHTML = "ここにラベルをドロップして削除";
    dv = newDIV(div, "/right-side"); // RIGHT ================
    dv.style.padding = "0";
    var sp = newSPAN(dv, "searchTypePopArea");
    makeSearchTypePop("searchTypePopArea", "editMode");
    var sp = newSPAN(dv, "");
    sp.innerHTML = "のテンプレートとして";
    sp.style.fontSize = "9pt";
    sp.style.padding = "0 5px";
    sp.style.position = "relative";
    sp.style.top = "2px";
    var bt = newSPAN(dv, "/fixButton");
    bt.innerHTML = "保存";
    bt.setAttribute("onclick", "saveListMakerLayout()");

    // debug エリア
    var div = newDIV(elm, "debug_area");
    div.style.fontSize = "9pt";
}

///// テンプレート編集パネル ///////////////////////////////
////////////////////////////////////////////////////////

function tagArray(){
    // 表示項目のタグ配列
    return _templateObj[currentType()];
}
function labelArray(){
    // 表示項目のラベル配列：tagArray() の変動が反映される
    var array = [];
    var tags = tagArray();
    for (num in tags){
        var tag = tags[num];
        var label = _layoutObj[tag];
        array.push(label);
    }
    return array;
}

function listValueForTag(tag, entryDate, rec){
    // tag に対応する値を返す
    var ary = tag.split(".");
    
    // table 名を DB のものと整合させる
    var table = ary[0];
    var field = (ary.length > 1) ? ary[1] : "";
    if (table == "MalitalSection"){ // ミスプリだがその名前の DB が既存なので
        table = "maritalSection";
    } else {
        var ch = table.substr(0,1).toLowerCase();
        table = ch + table.substr(1); // AddressSection を addressSection に変換
    }
    
    var val = "";
    if (rec[table]){
        var val = rec[table];
        if (table == "patientTable"){
            if (val && (typeof(val) == "object")) 
                val = val[field];
        } else if (table == "progressSection"){
            var rc = val[entryDate]; // entryDate は chartFinder.js から受け継いだ受診日
            
            if (rc[field] && rc[field].val){
                var val = rc[field].val;
                return transferCR(val);
            }
            val = ""; // データが空だった
        } else if (val && (typeof(val) == "object")) {
            if (val[field]){
                val = (val[field].val) ? val[field].val : "";
            } else {
                val = ""; // データが空だった
            }
        }
    }
    return val;
}

function listForms(){
    // リスト出力のデータを生成
    
    // タイトルを生成
    var listObj = new Object();
    var array = new Array();
    var tags = tagArray();
    for (num in tags){
        var tag = tags[num];
        var label = _layoutObj[tag];
        
        array.push(label);
    }
    listObj["TITLE"] = array;
    
    // コンテンツを生成
    var listSrc = listMakerSrc(); // localStorage.js: obj[patientId] = entryDate
    var obj = recordObj();
    for (patientId in obj){
        var rec = obj[patientId];
        var entryDate = listSrc[patientId];
        var array = new Array();
        var tags = tagArray();
        for (num in tags){
            var tag = tags[num];
            var val = tag;
            if (tag == "ProgressSection.patientId") 
                val = patientId;
            else if (tag == "ProgressSection.entryDate") 
                val = entryDate;
//                val = entryDateOfRec(rec.progressSection);
            else 
                val = listValueForTag(tag, entryDate, rec);
            
            array.push(val);
        }
        listObj[patientId] = array;
    }
    return listObj;
/*    
    function entryDateOfRec(obj){
        // obj 中の entryDate を返す
        for (edate in obj){
            return edate;
        }
        return "***";
    }*/
}

function csv(){
    // CSV 出力
    var w = 800;
	var x = 10; // 表示するx座標
	var y = 30; // 表示するy座標
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, "CSV");
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "10px";
    
    var buff = "";
    var obj = listForms();
    
    // TITLE
    var array = obj['TITLE'];
    buff += '"' + array.join('","') + '"<br>';

    // LIST
    for (patientId in obj){
        if (patientId == 'TITLE') continue;
        
        var array = obj[patientId];
        buff += '"' + array.join('","') + '"<br>';
    }
    var base = newDIV(elm, "csvArea");
    base.style.fontSize = "10pt";
    base.style.backgroundColor = "#fff";
    base.style.borderRadius = "8px";
    base.innerHTML = buff;

    var div = newDIV(elm, "");
    div.style.marginTop = "5px";
    div.style.fontSize = "9pt";
    div.style.color = "brown";
    div.innerHTML = "この CSV 型式の文字列をコピーして保存し EXCEL などに読み込ますことができます";
}

function makeList(){
    // リストを表示
    var elm = elmFor("listMakerContntsArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "10pt";
    
    var obj = listForms();
    var recObj = recordObj();
    
    // TITLE
    var tr = newTR(tbl, "", "");
    tr.style.borderBottom = "thin solid #ccc";
    tr.style.backgroundColor = "#eee";
    if (postItColorForListCheck()){ // 付箋カラー
        var td = newTD(tr, "", "");
        td.style.width = "10px";
    }
    var array = obj['TITLE'];
    for (num in array){
        var value = array[num];
        var td = newTD(tr, "", "");
        td.innerHTML = value;
        td.style.paddingLeft = "3px";
        td.style.verticalAlign = "top";
    }

    var count = 0;
    for (patientId in obj){
        if (patientId == "TITLE") continue;

        var tr = newTR(tbl, "/row", "");
        tr.style.borderBottom = "thin solid #ccc";
        var action = "parent().openChart('" + patientId + "')";
        tr.setAttribute("onclick", action);

        if (postItColorForListCheck()){ // 付箋カラー
            var td = newTD(tr, "", "");
            td.style.width = "10px";
            td.style.verticalAlign = "top";
            var colorNumber = recObj[patientId].postItColor;
            
            if (colorNumber != null){
                var dot = newDIV(td, "");
                dot.innerHTML = colorNumber;
                dot.style.padding = "0 2px";
                switch (colorNumber * 1){
                    case 1: dot.setAttribute("class", "postItDotBlue"); break;
                    case 2: dot.setAttribute("class", "postItDotYellow"); break;
                    case 3: dot.setAttribute("class", "postItDotRed"); break;
                    default: dot.setAttribute("class", "postItDotGreen"); break;
                }
            }
        }

        var array = obj[patientId];
        for (num in array){
            var value = array[num];
            var td = newTD(tr, "", "");
            td.innerHTML = value;
            td.style.paddingLeft = "3px";
            td.style.verticalAlign = "top";
        }
        count++;
    }

    var tr = newTR(tbl, "", "");
    tr.style.backgroundColor = "#eee";
    // ヒット表示
    var st = count + " 件みつかりました";
    st += "（ " + currentType() + " ）形式で表示";
    var td = newTD(tr, "", st);
    var colmuns = obj["TITLE"].length + 1;
    td.setAttribute("colspan", colmuns);
    td.style.paddingLeft = "10px";
    td.style.fontSize = "9pt";
	// 印刷：window.print() は javascript のメソッド
	var bt = newDIV(td, "/listMember");
    bt.innerHTML = "印刷";
	bt.setAttribute("onclick", "print()");
    bt.style.marginLeft = "10px";
    // CSV
	var bt = newDIV(td, "/listMember");
    bt.innerHTML = "CSV";
	bt.setAttribute("onclick", "csv()");
    // ウインドウ・サイズ
	var bt = newDIV(td, "/listMember");
    bt.innerHTML = "ウインドウ・サイズを記憶";
	bt.setAttribute("onclick", "putListMakerWindowSize()");
    
}

///////////////////////////////////////////////////////////////////
///// TEMPLATE SELECTOR ///////////////////////////////////////////

function redrowWithTemplate(label){
    // 選択されたテンプレートでリストを再描画
    setCurrentType(label);
    
    // 設定されたテンプレートで再描画
    makeList();
    closeFloatPanel();
}
function showTemplateSelector(elm){
    // テンプレート選択メニューを表示
    var w = 200;
	var x = 10; // 表示するx座標
	var y = 30; // 表示するy座標
    var title = "表示形式を選択";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title);
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "8px";
    
    var array = searchTypes();
    for (num in array){
        var label = array[num];
        
        var div = newDIV(elm, "");
        var bt = newDIV(div, "/listMember");
        bt.innerHTML = label;
        bt.setAttribute("onclick", "redrowWithTemplate('" + label + "')");
    }
    var div = newDIV(elm, "");
    div.style.marginLeft = "10px";
    div.style.marginTop = "10px";
    var bt = newDIV(div, "/listMember");
    bt.innerHTML = "メニュー編集";
    bt.style.fontSize = "9pt";
    bt.style.color = "#aaa";
    bt.setAttribute("onclick", "openListMakerPreference()");
}

///// TEMPLATE SELECTOR ///////////////////////////////////////////
///////////////////////////////////////////////////////////////////


function initListMaker(){
	var elm = document.getElementById("base");
    
    // === HEADER ==================
	var div = newDIV(elm, "/tool-header");
    // --- LEFT SIDE ---------------
    dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    dv.style.marginLeft = "10px";
    var img = newIMAGE(dv, "", "./menu.png", "?");
    img.style.height = "12px";
    img.setAttribute("onclick", "showTemplateSelector(this)");
    img.setAttribute("class", "expandIcon");
    var sp = newSPAN(dv, "");
    sp.innerHTML = listMakerHeader();
    sp.style.paddingLeft = "10px";
    // --- RIGHT SIDE --------------
    dv = newDIV(div, "/right-side");
    var img = newIMAGE(dv, "", "./help.png", "?");
    img.style.height = "17px";
    img.setAttribute("onclick", "openHelp('listMakerHelp.html')");
    img.setAttribute("class", "expandIcon");
    
    // === CONTENTS ================
	var div = newDIV(elm, "listMakerContntsArea");
    div.style.padding = "10px 10px";
    
    // === FOOTER ==================
	var div = newDIV(elm, "/tool-footer");
    dv = newDIV(div, "/left-side");
    dv.innerHTML = version();
    dv = newDIV(div, "/right-side");
    var img = newIMAGE(dv, "", "./hammer.png", "X");
    img.style.height = "15px";
    img.setAttribute("onclick", "openListMakerPreference()");
    img.setAttribute("class", "expandIcon");
    
    // window size を読み込む
    getListMakerWindowSize();
    
    getNoaLayouts();
}

function version(){
	return "Ver.140709";
}

