

function patientId(){
    return document.getElementById("_patientId").value;
}

function copyIt(elm){
    // 選択された処方を処方箋ツールへコピー
    if (confirm("この処方を処方箋へ転記しますか")){
        var obj = prescription(elm.innerHTML); // prescription.js
        
        var parent = window.opener;
        parent.setPrescriptionObject(obj);
        parent.setCursorPosition(0);
        parent.showShohou();
        window.close();
    }
}

function gotHistory(answer){
    var obj = JSON.parse(answer);
    //alert("gotHistory->"+encodeObject(obj)); //##
    
    var elm = document.getElementById("contentsArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "");
    tbl.style.fontSize = "10pt";
    tbl.style.width = "100%";
    
    for (entryDate in obj){
        var rec = obj[entryDate];
        var tr = newTR(tbl, "", "");
        // 受診年月
        var td = newTD(tr, "", "");
        td.style.width = "85px";
        td.style.verticalAlign = "top";
        td.style.padding = "5px 10px";
        td.style.backgroundColor = "#aec";
        td.style.borderBottom = "thin solid #aaa";
        td.style.textAlign = "right";
        var dv = newDIV(td, "");
        dv.innerHTML = entryDate.substr(0,10);
        var dv = newDIV(td, "");
        dv.innerHTML = rec.owner;
        // 処方
        var td = newTD(tr, "/change-red", "");
        td.style.borderBottom = "thin solid #aaa";
        td.style.padding = "2px 10px";
        td.setAttribute("onclick", "copyIt(this)");
        var array = rec.prescription.split('\n');
        for (num in array){
            var st = array[num];
            var dv = newDIV(td, "");
            dv.innerHTML = st;
        }
    }
}

function historyHelp(){
	window.open("./historyHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initHistory(){
    //_initDebug(true); //##
    
    var base = document.getElementById("base");
    base.innerHTML = "";
    
    // HEADER ================================
    var div = newDIV(base, "/tool-header");
    // -- LEFT ------------
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    // ラベル
    var sp = newSPAN(dv, "");
    sp.innerHTML = patientId() + " 処方箋 過去履歴";
    // -- RIGHT ----------
    var dv = newDIV(div, "/right-side");
    // HELP
    var img = newIMAGE(dv, "", "Help.png", "Help");
    img.setAttribute("onclick","historyHelp()");
    img.style.width = "19px";
    img.setAttribute("class", "expandIcon");
    // docMaker BODY =====================================
    var div = newDIV(base, "contentsArea");
    div.style.padding = "3px 0 5px 0";
    
    // FOOTER ==========================================
    var div = newDIV(base, "/tool-footer");
    // --- LEFT SIDE ---------------
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    // --- RIGHT SIDE ---------------
    var dv = newDIV(div, "/right-side");
    dv.innerHTML = version();
    
    var args = new Object();
    args["patientId"] = patientId();
    
    NRCall("GET_PRESCRIPTION_HISTORY", args, gotHistory);
}

function version(){
    // Development started at 2013-11-03.
    return "Ver.140705";
}

