
function gotSuffixMenu(answer){
    // サーバから接尾語リストを取得
    var obj = JSON.parse(answer);
    setSuffixMenus(obj); // 接尾語メニューを記憶
	makeDiseseRow();
}
function gotPrefixMenu(answer){
    // サーバから接頭語リストを取得
    var obj = JSON.parse(answer);
    setPrefixMenus(obj); // 接頭語メニューを記憶
    get_menu(owner(), _suffix, gotSuffixMenu);
}
function got_disesesMenu(answer){
    // サーバから病名リストを取得
    //_debug("=== got_disesesMenu"); //##
    var obj = JSON.parse(answer);
    //alert("got_disesesMenu->"+encodeObject(obj)); //##

    setDiseaseMenus(obj); // メニューを記憶
    get_menu(owner(), _prefix, gotPrefixMenu);
}

var _prefix = "接頭語";
var _suffix = "接尾語";

var _menus
var _diseaseMenuObj
function setDiseaseMenus(obj){
    _menus = [""];
    _diseaseMenuObj = new Object();
    
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length){
            _menus.push(rec.menu);
            _diseaseMenuObj[rec.menu] = rec.value;
            //console.log("setDiseaseMenus", rec.menu, rec.value); //##
        }
    }
    _menus.push("...その他");
}
function diseaseMenus(){
    return _menus;
}
function diseaseMenuObj(){
    return _diseaseMenuObj;
}
function aliasForMenu(menu){
    // menu に対応する alias を返す
    return _diseaseMenuObj[menu];
}
function setValueForMenu(val, menu){
    // menu に対応する val を記憶
    alert("setValueForMenu は使わないはず->"+menu+"->"+val); //##
    _diseaseMenuObj[menu] = val;
}

var _prefixMenus
function setPrefixMenus(obj){
    //alert("setPrefixMenus->"+encodeObject(obj)); //##
    _prefixMenus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length)
            _prefixMenus.push(rec.menu);
    }
    _prefixMenus.push("...その他");
}
function prefixMenus(){
    // 接頭語メニュー配列を返す
    return _prefixMenus;
}

var _suffixMenus
function setSuffixMenus(obj){
    //alert("setPrefixMenus->"+encodeObject(obj)); //##
    _suffixMenus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length)
            _suffixMenus.push(rec.menu);
    }
    _suffixMenus.push("...その他");
}
function suffixMenus(){
    // 接尾語メニュー配列を返す
    return _suffixMenus;
}

var _diseases;
function setDiseases(buff){
    // buff を日付ごとのオブジェクトに展開して記憶
    _diseases = new Array();
    if (trim(buff).length == 0) return;
    
    var records = buff.split("<br>");
    //console.log("setDiseases", encodeObject(records)); //##
    
    for (num in records){
        var ln = trim(records[num]); // 開始日 病名 -- 終了日 転帰" 型式
        if (ln.length == 0) continue;
        
        var rec = new Object();
        var array = ln.split("--");
        
        // 開始日と病名
        var leftSide = trim(array[0]); // " -- " の余白を削除
        var cols = leftSide.split(" ");
        if (cols.length < 2){
            alert(leftSide + " には「開始日」か「病名」が欠けています");
            continue; // 開始日・病名 の両方がなければ無視
        }
        
        rec.start = cols[0]; // 開始日
        cols.shift(); // 開始日を削除
        rec.name = cols.join(" "); // 病名
        
        // 終了日と転帰
        rec.end = ""; // 終了日
        rec.conclusion = ""; // 転帰
        if (array.length > 1){
            var rightSide = trim(array[1]); // " -- " の余白を削除
            var cols = rightSide.split(" ");
            rec.end = cols[0]; // 終了日
            rec.conclusion = (cols.length > 1) ? cols[1] : ""; // 転帰
        }
        _diseases.push(rec);
    }
}
function diseases(sorted){
    // sorted が指定されていれば、主病名を先頭にした病名の配列にして返す
    if (sorted){
        var array = [];
        for (num in _diseases){
            var rec = _diseases[num];
            if (rec.name.indexOf("*") == 0){
                array.splice(0,0,rec);
            } else {
                array.push(rec);
            }
        }
        _diseases = array;
    }
    return _diseases;
}
function diseaseAt(row){
    // row 番目の病名オブジェクトを返す
    if (row < _diseases.length)
        return _diseases[row];
    else
        return null;
}

function diseasesToString(hasMainDisease){
    // 病名オブジェクトを NOA 病名欄用の文字列にして返す
    // hasMainDisease が true なら主病名を先頭にした病名配列
    var records = diseases(hasMainDisease); 
    //console.log("diseasesToString", encodeObject(records)); //##
    
    var array = new Array();
    for (num in records){
        var ary = [];
        var rec = records[num];
        if (trim(rec.start).length > 0) ary.push(rec.start);
        if (rec.name.length > 0) ary.push(rec.name);
        if (trim(rec.end).length > 0){
            ary.push("--");
            ary.push(rec.end);
            if (rec.conclusion.length > 0) ary.push(rec.conclusion);
        }
        array.push(ary.join(" "));
    }
    
    if (array.length == 0)
        return "　"; // 全角スペースでないと HTML で無視される可能性あり
    else
        return array.join("\n");
}
function addDisease(){
    // 新規病名行を追加
    var rec = new Object();
    rec.start = shortDate(today());
    rec.name = "";
    rec.end = "";
    rec.conclusion = "";
    _diseases.push(rec);
    
    // リスト内容を更新
    var row = _diseases.length - 1;
    makeDiseseRow();
    
    // 編集パネルが立ち上がる
    openDiseaseEditor(row);
}
function removeDisease(num){
    // num 番目の病名オブジェクトを削除
    var rec = _diseases[num];
    _diseases.splice(num, 1);
    
    // リスト内容を更新
    makeDiseseRow();
    
    // CELL の入力欄（隠しフィールド）に転記
    var elm = elmFor(currentTag() + ".value");
    elm.innerHTML = diseasesToString();
}

function changedConclusion(elm, num){
    // 転記ポップアップが変更された
    // 転帰を更新
    _diseases[num].conclusion = elm.value;
    
    // 終了日を更新
    if (elm.value.length > 0)
        _diseases[num].end = shortDate(today(), false); // 本日の日付
    else
        _diseases[num].end = ""; // 転帰が無い場合
    var node = elmFor(num+".end");
    if (typeof node.textContent != "undefined") {
        node.textContent = _diseases[num].end
    } else {
        node.innerText = _diseases[num].end
    }
    
    // CELL の入力欄（隠しフィールド）に転記
    var elm = elmFor(currentTag() + ".value");
    elm.innerHTML = diseasesToString();
    
    console.log("changedConclusion", elm.innerHTML); //##
    console.log("conclusion", num, _diseases[num].conclusion); //##
}

function removed_disease(answer){
    var obj = JSON.parse(answer);
    //alert("got_disesesMenu->"+encodeObject(obj)); //##

    setDiseaseMenus(obj); // メニューを記憶
    
    // 病名リストを再表示
    showMenuTable();
}
function remove_disease(menu){
    // 病名 menu を MenuTable から削除
    // removeDisease() はメモリー上だけの削除だが、こちらは DB から削除
    if (confirm(menu + " を削除していいですか")){
        var tag = "ProgressSection.disease";
        elmFor("workMessageArea").innerHTML = "サーバから削除中...";
        remove_menu(owner(), tag, menu, "", removed_disease);
    }
}

////////////////////////////////////////////////////////
///// DRAG and DROP ////////////////////////////////////

function d_dragstart(event){
    // ドラッグ開始時の処理
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
    event.dataTransfer.setData("text", event.target.id);
}

function d_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function d_drop(event){
    // ドロップ時の処理
    // ドラッグされたデータのid名をDataTransferオブジェクトから取得
    var id_name = event.dataTransfer.getData("text");
    
    //id名からドラッグされた要素を取得
    var drag_elm = document.getElementById(id_name);
    
    //ドロップ先にドラッグされた要素を追加
    // event.currentTarget.appendChild(drag_elm);
    move_to(id_name, event.currentTarget);
    
    //エラー回避のため、ドロップ処理の最後にdropイベントをキャンセルしておく
    event.preventDefault();
}
function move_to(drop_id, target_node){
    // ドロップされたエレメントをドロップされたターゲット・エレメント位置へ移動
    var target_id = target_node.id;
    if (drop_id == target_node.id) return; // 自分自身は無視
    
    var dropNum = numberOf(drop_id);
    var targetNum = numberOf(target_id);
    
    // ドロップするオブジェクトを抜かした配列を生成
    var dropRec;
    var anArray = new Array();
    var recs = diseases();
    for (num in recs){
        var rec = recs[num];
        if (num == dropNum){
            dropRec = rec; // ドロップすべきオブジェクトを記憶
            continue;
        }
        anArray.push(rec);
    }
    
    // ドロップすべきオブジェクトをドロップする位置に挿入した配列を生成
    var newRecords = new Array();
    for (num in anArray){
        var rec = anArray[num];
        if (num == targetNum)
            newRecords.push(dropRec);
        newRecords.push(rec);
    }
    if (targetNum >= anArray.length)
        newRecords.push(dropRec);
    
    // レイアウトの mode() に該当する部分だけを newRecords 要素と置換
    _diseases = newRecords;
    
    // レイアウトを再表示
    makeDiseseRow();
    
    // CELL の入力欄（隠しフィールド）に転記
    var elm = elmFor(currentTag() + ".value");
    elm.innerHTML = diseasesToString();
    
    function numberOf(id){
        // 2.name のような id から 2 だけを取り出して返す
        var array = id.split('.');
        
        return array[0] * 1;
    }
}

///// DRAG and DROP ////////////////////////////////////
////////////////////////////////////////////////////////

function modifiedDisase(name){
    // 病名をフィルターに通す
    var parts = name.split('$gw');
    if (parts.length > 1){
        var obj = parent().valueForTag("ProgressSection.subject");
        var val = (obj) ? obj.value : null;
        
        if (val){
            // 最終月経から現在の週数を計算
            var array = val.split("lmp:");
            if (array.length > 1){
                // "lmp:120825 (7w2d) ..." から "2012, 08, 25" を取り出し Date() 生成
                var ary = [];
                ary[0] = ("20" + trim(array[1]).substr(0, 2)) * 1; 
                ary[1] = trim(array[1]).substr(2, 2) * 1; 
                ary[2] = trim(array[1]).substr(4, 2) * 1; 
                var lmp = ary.join('-') + " 00:00:00";
                
                // currentDate() から Date() 生成
                var date = parent().currentDate();
                
                // 最終月経から本日までの週数を計算
                var sec = secondsBetween(lmp, date);
                var weeks = Math.floor(sec / (60 * 60 *24) / 7);
                
                //_initDebug(true); //##
                _debug("weeks->"+ weeks); //##
                
                name = parts.join(weeks);
                
                _debug("name->"+ name); //##
            }
        }
    }
    
    return name;
}

function makeRow(row){
    // リストの row 行を生成
    var rec = diseaseAt(row);
    var tr = elmFor(row + ".row");
    tr.innerHTML = "";
    // 開始年月日
    var td = newTD(tr, "/startDate", rec.start);
    // 病名
    var disease = modifiedDisase(rec.name); // 病名をフィルターに通す
    var td = newTD(tr, row+".name/response-colum", disease);
    td.setAttribute("onclick", "openDiseaseEditor('" + row + "')");
    td.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
    td.setAttribute("ondragstart", "d_dragstart(event)");
    td.setAttribute("ondragover", "d_dragover(event)");
    td.setAttribute("ondrop", "d_drop(event)");
    td.style.paddingLeft = "5px";
    // 終了年月日
    var td = newTD(tr, row+".end/endDate", rec.end);
    // 転帰
    var td = newTD(tr, row + ".conclusionPopArea/conclusion", "");
    var array = ["","治癒","中止"];
    var pu = newPopupMenu(td, "conclusionPop", array, rec.conclusion);
    pu.setAttribute("onchange", "changedConclusion(this,'" + row +"')");
    // 削除アイコン
    var td = newTD(tr, "/mark", "");
    td.style.paddingLeft = "3px";
    var img = newIMAGE(td, "", "./remove-field.png", "remove");
    img.style.height = "13px";
    img.setAttribute("onclick", "removeDisease('" + row + "')");
    img.setAttribute("class", "expandIcon");
}

function showDiseaseField(elm){
    // 入力欄を表示・非表示
    setShowDisaseField(elm.checked); // localStorage.js 
    
    var dv = elmFor(currentTag() + ".value");
    dv.style.display = (elm.checked) ? "block" : "none";
}

function makeDiseseRow(removeStatus){
    // 病名リストを生成
    var dv = elmFor(currentTag() + ".value");
    dv.style.display = (showDisaseField() * 1 > 0) ? "block" : "none";
    
    // 病名リスト・エリアを生成 ====================================
	var elm = document.getElementById("editorArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "9pt";
    tbl.style.marginBottom = "10px";
    
    // タイトル ======================================
    var tr = newTR(tbl, "disease_header", "");
    tr.style.backgroundColor = "#f7eeb8";
    var td = newTD(tr, "", "開始日"); td.style.paddingLeft = "5px";
    var td = newTD(tr, "", "病名"); td.style.paddingLeft = "5px";
    var td = newTD(tr, "", "終了日"); td.style.paddingLeft = "5px";
    var td = newTD(tr, "", "転帰"); td.style.paddingLeft = "5px";
    var td = newTD(tr, "", "");
	var im = newIMAGE(td, "", "./help.png", "?");
	im.setAttribute("onclick", "openHelp('./diseaseHelp.html')");
	im.style.height = "16px";
	im.style.marginBottom = "2px";
	im.style.marginRight = "4px";
    im.setAttribute("class", "expandIcon");
    
    // 病名リスト ====================================
    var array = diseases();
    for (row in array){
        // 一行分のエレメントを生成
        var tr = newTR(tbl, row + ".row", "");
        makeRow(row);
    }
    
    // FOOTER ======================================
    var tr = newTR(tbl, "", "");
    tr.style.backgroundColor = "#f7eeb8";
    var td = newTD(tr, "", "");
    // 新規病名追加
    var td = newTD(tr, "/add-new-item", "");
    td.style.paddingLeft = "5px";
    td.setAttribute("onclick", "addDisease()");
	var im = newIMAGE(td, "", "./add-field.png", "?");
	im.style.height = "12px";
	im.style.position = "relative";
	im.style.top = "3px";
    var sp = newSPAN(td, "newDiseaseButton");
    sp.innerHTML = "病名を追加";
    sp.style.paddingLeft = "5px";
    // 空コラム
    var td = newTD(tr, "", "");
    td.setAttribute("colspan", "3");
    var sp = newSPAN(td, "");
    sp.style.marginRight = "10px";
    var cb = newCHECKBOX(sp, "", "入力欄を表示", showDisaseField());
    cb.style.fontSize = "9pt";
    cb.setAttribute("onchange", "showDiseaseField(this)");
    // 病名管理 
    var sp = newSPAN(td, "menuTableUnker");
    setInfoTip("menuTableUnker", "病名管理ツールを開く"); // HELP
    var a = newA(sp, "病名検索キー管理", "#", "");
    a.setAttribute("onclick", "showMenuTable()");
    a.style.fontSize = "9pt";
    
    // 病名がひとつもなければ新規病名の追加モードにする
    if (!removeStatus && (diseases().length == 0)) addDisease();
}

////////////////////////////////////////////////////////////
///// 病名管理 //////////////////////////////////////////////

function redrawMenu(answer){
    var obj = JSON.parse(answer);
    //alert("redrawMenu->"+encodeObject(obj)); //##
    
    setDiseaseMenus(obj); // メニューを記憶
    
    // 病名管理パネルを再表示
    showMenuTable();
    
    alert("登録しました");
}
function puttedMenu(answer){
    //alert("puttedMenu->"+answer); //##
    
    get_menu(owner(), "ProgressSection.disease", redrawMenu);
}
function saveMenu(){
    // メニュー構造をサーバへ保存
    var tag = "ProgressSection.disease";
    var freq = "";
    
    for (menu in _changedMenu){
        var value = document.getElementById(menu + ".romaji").innerText;
        //alert("saveMenu-> "+ menu+"("+value+")"); //##
        
        elmFor("workMessageArea").innerHTML = "サーバへ保存中...";
        put_menu(owner(), tag, menu, freq, value, puttedMenu);
    }
    _changedMenu = null; // 変更履歴を初期化
}

function addNewMenu(){
    // 新規メニューを追加
    var name = prompt("新規病名を入力してください");
    if (name && name.length){
        _diseaseMenuObj[name] = "";
    }
    //document.getElementById("workArea").innerHTML = "";
    showMenuTable();
}

var _changedMenu;
function setEditable(elm, name){
    // 病名に対応する検索キーを編集可能にする
    elm.contentEditable = true; // TEXT を編集可能状態にする
    elm.focus();
    
    // 変更履歴に記憶：重複を避けるため Array ではなく Object を使う
    if (!_changedMenu) _changedMenu = new Object();
    _changedMenu[name] = "dummy";
}

function showMenuTable(){
    // 病名と検索キーの対象テーブルを表示
    var w = 500;
	var x = 5; // 表示するx座標
	var y = 5; // 表示するy座標
    var title = "病名管理：検索キー登録";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title);
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "8px";

    var tbl = newTABLE(elm, "", "/base-table");
    tbl.style.fontSize = "9pt";
    tbl.style.width = "100%";
    
    // HEADER ==============================
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/titleCol", "病名");
    td.style.width = "120px";
    var td = newTD(tr, "/titleCol", "検索キー（アルファベット）");
    td.style.width = "180px";
    var td = newTD(tr, "/titleCol", "");
    td.style.width = "15px";
	var im = newIMAGE(td, "", "./help.png", "?");
	im.setAttribute("onclick", "openHelp('./aliasHelp.html')");
	im.style.height = "16px";
    im.setAttribute("class", "expandIcon");
    
    // CONTENTS ============================
    for (dname in _diseaseMenuObj){ 
        // dname でなく name を使うと cellEditor.js とカブるらしく Editor が閉じなくなる
        var romaji = _diseaseMenuObj[dname];
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, dname + ".disease", dname);
        var td = newTD(tr, dname + ".romaji", romaji);
        td.setAttribute("onclick", "setEditable(this,'" + dname + "')");
        var td = newTD(tr, "/mark", "");
        var img = newIMAGE(td, "", "./remove-field.png", "remove");
        img.style.height = "13px";
        img.setAttribute("onclick", "remove_disease('" + dname + "')");
        img.setAttribute("class", "expandIcon");
    }
    
    // FOOTER ==============================
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/add-disease", "");
    td.setAttribute("onclick", "addNewMenu()");
	var im = newIMAGE(td, "", "./add-field.png", "?");
	im.style.height = "12px";
    im.style.position = "relative";
    im.style.top = "3px";
    var sp = newSPAN(td, "");
    sp.innerHTML = "病名を追加";
    sp.style.paddingLeft = "5px";
    var td = newTD(tr, "", "");
    td.style.textAlign = "right";
    var bt = newDIV(td, "/fixButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "saveMenu()");
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "workMessageArea", "");
    td.style.fontSize = "12px";
    td.style.color = "#f00";
}

///// 病名管理 //////////////////////////////////////////////
////////////////////////////////////////////////////////////


function openPreference(){
    // 初期設定を開く
    parent().openCellPreference();
}

function openDisease(elm){
    // 病名リストを表示するパネルを生成
	// ===== 編集エリア ==================================
    elm.innerHTML = ""; // elm は CellEditor の表示エリア
    var div = newDIV(elm, "editorArea");
    div.style.backgroundColor = "#fff";
    var sp = newSPAN(div, "");
    sp.innerHTML = "Loading ...";
    sp.style.padding = "10px";
    sp.style.color = "#f88";
    sp.style.fontSIze = "9pt";
    
    var obj = valueForTag("ProgressSection.disease");
    var buff = (obj) ? obj.value : "";
    buff = convertSTRING(buff, "\n", "<br>"); // 改行 "\n" を "<br>" に変換
    buff = convertSTRING(buff, "</span>", "<br>"); // 改行 "</span>" を "<br>" に変換
    buff = trim(buff);
    
    // NOA の病名欄を読込み、病名リストを表示
    setDiseases(buff);
    
    get_menu(owner(), "ProgressSection.disease", got_disesesMenu);
} 

function di_version(){
	return "Ver.140115";
}
