<?php
    
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("\'", $array);
        return $val;
    }
    
    function fileBox($owner){
        // 画像ファイルを保存する directory を返す
        $dir = "../Users/$owner/INFO_SACK";
        if (! file_exists($dir)) mkdir($dir);
        
        $dir = "$dir/file";
        if (! file_exists($dir)) mkdir($dir);
        
        return $dir;
    }
    
    function fwrite_stream($fp, $string) {
        for ($written = 0; $written < strlen($string); $written += $fwrite) {
            $fwrite = fwrite($fp, substr($string, $written));
            if ($fwrite === false) {
                return $written;
            }
        }
        return $written;
    }
    
    function getDir($dir){
        // $dir 内のファイルをリストアップ
        $results = array();
        $array = array();
        $files = scandir($dir);
        for ($i=0,$count=count($files); $i < $count; $i++){
            $filename = $files[$i];
            if ($filename == ".") continue;
            if ($filename == "..") continue;
            
            // folder は除外する
            $path = "$dir/$filename";
            if (scandir($path)) continue;
            
            $array[] = $filename;
        }
        rsort($array); // 逆順にソート
        $results['path'] = $dir;
		$results['files'] = $array;
        
        return $results;
    }
	
    
    /* ########################################
     ### 以下でも $_POST['key'] と同じに機能する ###
     if (isset($_REQUEST['key'])) {
     $key = $_REQUEST['key'];
     }
     ########################################## */
    
    $key = $_POST['key'];
    $suffix = $_POST['suffix'];
    $fileId = $_POST['fileId'];
    $owner = $_POST['owner'];

    if ($key == "SAVE_IMAGE"){
        $files = $_FILES['files']['name'];
        $tmpFiles = $_FILES['files']['tmp_name'];
        
        $count = count($files);
        for ($i=0; $i < $count; $i++){
            $filename = $files[$i];
            $path = fileBox($owner)."/$fileId";
            
            // 接尾語があれば path につける
            if ($suffix) $path = "$path.$suffix";
            
            $tmp = $tmpFiles[$i];
            if (strlen($filename) > 0){
                if (!is_uploaded_file($tmp)){
                    echo "$filename を保存できません";
                    break;
                } else {
                    copy($tmp, $path);
                    echo "$path を保存しました";
                }
            }
        }
        
        $uri = $_SERVER['HTTP_REFERER'];
    } else {
        echo "<p>key( $key ) is wrong *****</p>";
    }
    
?>