
function clickedToolMenu(url, win){
    // TOOL MENU がクリックされた
    if (floatToolMenu())
        closeFloatPanel();
    
    kickMenuCell(url, win);
}

function showToolMenu(){
    // メニューを表示
    var elm = document.getElementById("toolMenuArea");
    elm.innerHTML = "";
    
    var menuRow;
    var array = toolMenus();
    for (num in array){
        var cell = array[num];
        if (cell.menuType * 1 != _tool) continue;
        if (cell.disabled * 1) continue;
        
        _debug(cell.label+"->"+encodeObject(cell)); //##

        if (cell.subTitle * 1) {
            // グループ行とサブ・タイトルを生成
            // URL AREA
            menuRow = newDIV(elm, "/toolSection");
            menuRow.setAttribute("class", "clearfix");
            menuRow.style.padding = "2px 0";
            var bt = newDIV(menuRow, cell.id);
            bt.innerHTML = cell.label;
            // どういうわけか CSS がここでは機能しないので
            bt.style.float = "left";
            bt.style.fontSize = "9pt";
            bt.style.marginRight = "5px";
            bt.style.padding = "0 5px";
            bt.style.backgroundColor = "#ff8";
            bt.style.borderRadius = "10px";
            bt.style.border = "thin solid #aaa";
        } else {
            // メニュー項目を生成
            if (cell.url){
                if (! isSuperUser()){ // dataCenter.js
                    // superUser でなければ実行できないメニューをスキップ
                    if (cell.url.indexOf("layout.php") >= 0) continue;
                }
                
                // url による action を伴う
                if (!menuRow){
                    menuRow = newDIV(elm, "/toolSection");
                    var bt = newDIV(menuRow, cell.id);
                    bt.innerHTML = cell.label;
                    bt.style.float = "left";
                    bt.setAttribute("class", "toolLabel");
                }
                
                // メニュー・ボタン
                var bt = newDIV(menuRow, cell.id);
                bt.innerHTML = cell.label;
                bt.setAttribute("class", "blueButton");
                var action = "clickedToolMenu('"+cell.url+"','"+cell.window+"')";
                bt.setAttribute("onclick", action);
                bt.style.float = "left";
            } else {
                // label のみの表示
                var bt = newDIV(menuRow, cell.id);
                bt.innerHTML = cell.label;
                bt.setAttribute("class", "disabledButton");
                bt.innerHTML = cell.label;
            }
        }
    }
}

function openFloatTools(){
    // TOOL MENU を floating panel で開く
    var win = window.top.noa;
    var w = 200;
	var x = win.innerWidth - w - 30; // 表示するx座標
	var y = 35; // 表示するy座標
    var title = "TOOL MENU";
    var action = "openHelp('toolMenuHelp.html')";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, action);
    if (!elm) return;
    
    makeToolMenu(elm);
}

function closeToolArea(){
    // ProblemList と基本情報を開く
    elmFor("toolArea").innerHTML = ""; // toolArea を閉じる
    initBasicPage();
}

function openApp(url){
    // url アプリを toolArea に iFrame として開く
    var elm = elmFor("toolArea");
    elm.innerHTML = "";

    var fr = newIFRAME(elm, "iframe", url);
    fr.style.width = "100%";
    fr.style.height = "100%";
    
    // ProblemList を収縮
    foldProblem();
}

function openToolEditor(){
	//window.open("./toolEditor.php","tools");
    openTool("./toolEditor.php");
}

function checkedFloatBox(elm){
    // float チェックボックスが変更された
    setFloatToolMenu(elm);

    if (floatToolMenu()){  // localStorage.js
        elmFor("toolArea").innerHTML = "";
        parent().openFloatTools();
    } else {
        closeFloatPanel();
        
        var tools = window.top.tools;
        var elm = tools.document.getElementById("toolArea");
        elm.innerHTML = "";
        tools.makeToolMenu(elm);
    }
}

function gotTools(answer){
    // TOOL MENU 構造をサーバから受取り記憶
    //_debug("gotTools->"+answer); //##
    var obj = JSON.parse(answer);
    //_initDebug(true); //##
    _debug("gotTools->"+encodeObject(obj)); //##
    
    setToolMenus(obj);
    
    showToolMenu();
}
function makeToolMenu(elm){
    // TOOL MENU のコンテンツを生成
    elm.innerHTML = "";
    
    if (! floatToolMenu()){
        // === HEADER =======================
        var div = newDIV(elm, "/tool-header");
        div.style.height = "20px";
        // --- LEFT SIDE ---
        var dv = newDIV(div, "/left-side");
        dv.style.width = "70%";
        var tl = newSPAN(dv, "");
        tl.innerHTML = "TOOL MENU";
        // --- RIGHT SIDE ---
        var dv = newDIV(div, "/right-side");
        // HELP ICON
        var img = newIMAGE(dv, "", "./Help.png", "?");
        img.style.height = "17px";
        img.setAttribute("onclick", "toolMenutHelp()");
        img.setAttribute("class", "expandIcon");
        dv.style.position = "relative";
        dv.style.marginTop = "2px";
    }

    // === CONTENTS =====================
    var div = newDIV(elm, "toolMenuArea/clearfix");
    div.style.padding = "5px";

    // === FOOTER =======================
    var div = newDIV(elm, "/clearfix");
    div.style.fontSize = "9pt";
    div.style.color = "#888";
    div.style.marginBottom = "5px";
    div.style.borderTop = "thin solid #ddd";
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.width = "45%";
    // check box
    var cb = newCHECKBOX(dv, "", "float", floatToolMenu());
    cb.style.height = "14px";
    cb.style.position = "relative";
    cb.style.top = "2px";
    cb.setAttribute("onchange", "checkedFloatBox(this)");
    // HAMMER ICON
    if (isSuperUser()){
        var sp = newSPAN(dv, "");
        sp.style.paddingLeft = "5px";
        var img = newIMAGE(sp, "", "./hammer.png", "X");
        img.style.height = "14px";
        img.style.position = "relative";
        img.style.top = "2px";
        img.setAttribute("onclick", "openToolEditor()");
        img.setAttribute("class", "expandIcon");
    }
    // --- RIGHT SIDE ---
    var dv = newSPAN(div, "/right-side");
    dv.innerHTML = toolVersion();
    dv.style.position = "relative";
    dv.style.marginTop = "3px";
    
    var args = new Object();
    args["owner"] = owner();
    NRCall("GET_TOOL_MENU", args, gotTools);
}

function showTool(initTool){
    // toolArea に initTool で初期化される tool を開く
    var elm = document.getElementById("toolArea");
    elm.innerHTML = "";
    
    initTool(elm);
}

function initTools(){
    //　dataCenter の記憶を login.js と共有できないので localStorage を
    // 経由して hospitalTable のデータを受け取り dataCenter に記憶
    if (! floatToolMenu()){
        showTool(makeToolMenu);
    }
}

function toolVersion(){
    return "Ver.140211";
}

