
/////
///// 患者ごとの記述を司るクラス
/////

///// 以下のパラメータは chart.js でしか使わないので dataCentar.js には収容しない

var _addPageMode;
function setAddPageMode(mode){
    _addPageMode = mode;
}
function addPageMode(){
    return _addPageMode;
}

function editorElementForTag(tag){
    // tag に相当する 入力欄 エレメントを返す
    var elm = window.top.noa.document.getElementById(tag + ".value");
    if (elm)
        return elm;
    else
        return window.top.tools.document.getElementById(tag + ".value");
}

function valueElementForTag(dateTime, tag){
    // dateTime, tag に相当する 値表示欄 エレメントを返す
    var elm = window.top.noa.document.getElementById(dateTime+"."+tag+".val");
    if (elm)
        return elm;
    else
        return window.top.tools.document.getElementById(dateTime+"."+tag+".val");
}



//////////////////////////////////////////////
///// マルチスレッド ////////////////////////////

function WKGetPage(owner, patientId, dateTime){
    // WK で始まる関数名は multi thread
    // Worker を使いマルチスレッドで 基本情報ページを更新
    // DB とのやりとりは getPageWorker.js で設定
    _debug("== WKGetPage"); //##
    
    var obj = new Object();
    obj["owner"] = owner;
    obj["patientId"] = patientId;
    obj["dateTime"] = dateTime;
    var noaString = encodeObject(obj);
    _debug("noaString->"+noaString); //##
    
    var worker = new Worker('./getPageWorker.js');
    worker.postMessage(noaString); // ### worker に命令書 noaString を送る ###
    
    worker.onmessage = function (event) {
        // ### worker の処理したデータを受け取る ###
        var answer = event.data; // ### worker からの返答 ###
        document.getElementById("alertArea").innerHTML = answer;

        openBasicPage(answer);
    }
}

///// マルチスレッド ////////////////////////////
//////////////////////////////////////////////

///////////////////////////////////////////////////////
///// PAGE ////////////////////////////////////////////

function removedPage(answer){
    // ページ削除を画面に反映させる
    openChart(patientId(), patientKanjiName());
}
function removePage(dateTime){
    // dateTime のページを削除
	if (userCode() != "all"){
		alert("アクセス・コード: "+userCode()+" なのでページ削除権限がありません");
	} else if (confirm(dateTime + " のページを削除しますか")){
		setCurrentDate("");
		NRRemovePage(owner(),patientId(),dateTime,timeLimit(), removedPage);
	}
}
function removeTodayPage(){
    // レッド・マイナス・アイコンから起動される
    removePage(currentDate());
}

function addedPage(answer){
    // 新規ページを追加
    _debug("addedPage->"+patientKanjiName()); //##
    
    openChart(patientId(), patientKanjiName()); // ### old NOA ###
}
function addPage(dateTime){
    // dateTime の新規ページを追加
    _debug("== addPage"); //##
    _debug("dateTime->"+dateTime); //##

    if (!patientId()){
        alert("カルテが読込まれていません");
    } else if (userCode() != "all"){
		// アクセスコード４（参照・修正・削除許可）以外ならページ追加をしない
		alert("アクセス・コード: "+userCode()+" なので新規ページ追加権限がありません");
    } else if (isSameDate(dateTime, currentDate())){
		// 同じ日付のページがすでに存在する
		if (confirm(dateTime + " と同じ日付のページ（ "+currentDate()+" ）はすでにあります。同日再診として追加しますか？")){
            add_page(dateTime);
		}
	} else {
		// dateTime のページが存在しなかった
		if (isSameDate(dateTime, today())){
			// dateTime が本日なら、新規ページを追加
            add_page(dateTime);
		} else {
			// dateTime が本日ではなかった
			if (confirm(dateTime + " は本日ではありません。追加しますか？")){
                add_page(dateTime);
			}
		}
	}
   
    function add_page(dateTime){
        // dateTime のページを追加
        //_initDebug(true); //##
        _debug("== add_page->"+dateTime); //##
        
        setCurrentDate(dateTime);
        
        var templateTitle = newPageTemplate(); // localStorage.js
        if (templateTitle){
            // ページ・テンプレートを反映したページを追加
            addPageWithTemplate(templateTitle);
        } else {
            // 白紙のページを追加
            var pid = patientId();
            var container = new Array();
            
            NRPutPage(owner(), pid, dateTime, timeLimit(), container, addedPage);
        }
    }
}

var _templateTitle;
function addPageWithTemplateDone(answer){
    // ページ・テンプレートを反映したページを追加
    var array = JSON.parse(answer);
    setTemplateMenu(array);
    
    addPageWithTemplate(_templateTitle);
}
function addPageWithTemplate(templateTitle){
    // ページ・テンプレートを反映したページを追加
    // すでにページ・テンプレートが記憶されていればサーバへ取りに行かない
    var obj = groupTemplateObjectForTitle(templateTitle);
    if (obj && obj.value){
        // obj.value に tag 毎にセットする値が入っている
        var dateTime = currentDate();
        var container = decodeObject(obj.value);
        NRPutPage(owner(),patientId(),dateTime,timeLimit(),container,addedPage);
    } else {
        _templateTitle = templateTitle;
        
        NRGetTemplateMenu(owner(), addPageWithTemplateDone);
    }
}

function addTodayPage(){
    // グリーン・プラス・アイコンから起動される
    openAddPagePanel();
}

///// PAGE ////////////////////////////////////////////
///////////////////////////////////////////////////////


function showReadWriteMarker(elm, isActive, dateTime){
    // ページの読書状態を表すコントローラ表示
    elm.innerHTML = "";
    if (isActive){
        if (isSameDate(dateTime, today())){
            // 本日なら無条件に readOnly を否定
            setIsReadOnly(false, dateTime);
        } else {
            // 本日以外なら setIsReadOnly() の判断に任せる
            setIsReadOnly(isReadOnly(), dateTime);
            var bid = "pageReadOnlyStatus";
            var sp = newSPAN(elm, bid);
            if (isReadOnly())
                var bt = newOffButton(bid, "編集可/編集不可", "getOnOff");
            else
                var bt = newOnButton(bid, "編集可/編集不可", "getOnOff");
        }
    }
}

function showPageIcons(elm, isActive){
    // ページ・ヘッダーにアイコン・ギャラリーを表示・非表示
    if (isActive){
        //elm.innerHTML = "ICONS";
        var array = toolMenus();
        for (num in array){
            var cell = array[num];
            
            if (cell.menuType * 1 != _page) continue;
            if (cell.disabled * 1) continue;
            if (cell.subTitle * 1) continue;
            
            // メニュー項目を生成
            var sp = newSPAN(elm, cell.id);
            sp.style.marginLeft = "15px";
            sp.style.fontSize = "10pt";
            // cell.editor に infoTip に表示する内容が入っている
            setInfoTip(cell.id, cell.editor); // HELP
            
            if (cell.icon){
                // ICON があれば ICON を表示
                var img = newIMAGE(sp, "", cell.icon, "icon");
                img.style.height = "15px";
                var action = "kickMenuCell('"+cell.url+"','"+cell.window+"',this)";
                img.setAttribute("onclick", action);
                img.setAttribute("class", "expandIcon");
            } else {
                // アンカー表示
                var a = newA(sp, cell.label, "#", "");
                if (cell.url){
                    var action = "kickMenuCell('"+cell.url+"','"+cell.window+"',this)";
                    a.setAttribute("onclick", action);
                }
            }
        }
    } else {
        elm.innerHTML = "";
    }
}

function openBasicPage(answer){
    // 基本情報ページを開く
    //alert("== openBasicPage->"+answer); //##
    
    var array = answer.split("<SEPARATOR>");
    if (array.length > 1){
        var obj = JSON.parse(array[1]);
        //alert("obj->"+encodeObject(obj)); //##
        
        setAddressObj(obj.addressSection);
        setBasicObj(obj.basicSection);
        setMaritalObj(obj.maritalSection);
        setHealthInsuranceObj(obj.healthInsurance);
        setPublicInsuranceObj(obj.publicInsurance);
        setUniversalObj(obj.universalSection);
        
        // 「...のカルテを開きつつあります」のメッセージを消去
        document.getElementById("alertArea").innerHTML = "";
        
        window.open("basicPage.php", "tools");
    } else { // ERROR
        alert("== openBasicPage->"+answer); //##
    }
}

function openPage(dateTime, isActive, isFirst){
    // dateTime のページを生成
    //_debug("== openPage == "+dateTime+"->"+isActive); //##
    
    var elm = document.getElementById(dateTime + ".page");
    elm.innerHTML = "";
    if (isActive){
        elm.setAttribute("class","currentPage");
        
        // 他にアクティブなページがあればインアクティブにする
        if ((_activeDate) && (_activeDate != dateTime))
            openPage(_activeDate); // インアクティブにする
        _activeDate = dateTime;
    } else {
        elm.setAttribute("class","page");
    }
    
    // ページ・ヘッダーの受診日や氏名の表示行
    var div = newDIV(elm, "/clearfix");
    div.style.paddingBottom = "2px";
    // 受診日エリア
    var dv = newDIV(div, "/dateLabel");
    var num = weekOfDate(dateTime);
    dv.innerHTML = dateTime + " " + _weeks[num];
    dv.setAttribute("onclick", "openPage('" + dateTime +"','true')");
    // 氏名エリア
    var dv = newDIV(div, dateTime + ".name");
    // 漢字氏名 ---------------------
    var sp = newSPAN(dv, "/nameLabel");
    var obj = valueForTag("NameSection.patientKanjiName", dateTime);
    var kanji = (obj && obj.value) ? obj.value : "";
    sp.innerHTML = kanji;
    // 仮名氏名 ---------------------
    var sp = newSPAN(dv, "/kanaLabel");
    var obj = valueForTag("NameSection.patientKanaName", dateTime);
    var kana = (obj && obj.value) ? obj.value : "";
    sp.innerHTML = kana;
    // 年齢 -------------------------
    var sp = newSPAN(dv, "/ageLabel");
    sp.innerHTML = ageAtDate(birthDate(), dateTime) + " 才"
    
    // ページ・ヘッダーのアイコン・ギャラリー表示行
    var div = newDIV(elm, "/clearfix");
    div.style.paddingBottom = "5px";
    var dv = newDIV(div, "/left-side");
    dv.style.width = "90px";
    dv.style.paddingLeft = "3px";
    dv.style.marginTop = "5px";
    showReadWriteMarker(dv, isActive, dateTime);
    var dv = newDIV(div, "/right-side");
    dv.style.paddingRight = "0";
    dv.style.marginTop = "5px";
    showPageIcons(dv, isActive);
    
    // 各フィールドを表示
    var array = layoutForMode(_progress_);
    //alert("openPage array->"+encodeObject(array)); //##
    for (num in array){
        var cell = array[num];
        cell.editorIsOpen = false; // 中途でコケてゾンビ化した editorIsOpen を一掃
        if (cell.hitAndRun * 1) continue; // 非表示セルをスキップ

        openCell(elm, cell, dateTime, isActive);
    }

    if (isActive && !isFirst){
        // 本日以外のページを開く場合に呼ばれる
        // 基本情報を読込中のメッセージ表示した後、基本情報を表示
        var elm = window.top.tools.base;
        elm.innerHTML = "";
        var sp = newSPAN(elm, "alert");
        sp.innerHTML = "読込中...";
        
        // 基本情報を表示
        setCurrentDate(dateTime);
        
        // currentDate の付箋があれば開く：currentDate() が設定されている必要あり
        showPostIt(); // postIt.js
        
        WKGetPage(owner(), patientId(), dateTime);
    }
}

function makeCalendar(answer){
    // calendar を生成
    var array = JSON.parse(answer);
    if (array)
        _debug("makeCalendar->"+encodeObject(array)); //##
    else 
        _debug("makeCalendar array->"+array); //##
    
    openCalendar(array); // calndar.js
}

var _activeDate;
function openPages(answer){
    // サーバから得られた ProgressSection データで各ページを生成
    var obj = JSON.parse(answer);
    //_initDebug(true); //##
    _debug("== openPages ->"+encodeObject(obj)); //return; //##
    
    setPatientTable(obj.patientTable);
    setNameObj(obj.nameSection);
    setPatientName(obj.nameSection.patientKanjiName.val); // name を記憶
    setProgressObj(obj.progressSection);
    setFrontObj(obj.frontTable);
    setPostItObjects(obj.postIt);
    _activeDate = null; // 初期化して置かなければならない
    
    // 全てのページを表示
    var div = document.getElementById("contents");
    div.innerHTML = "";
    var hasRecord = false; // obj にレコードが存在するか否か
    var hasTodayPage = false;
    var array = history();
    _debug("history ->"+array); //return; //##
    
    for (num in array){
        var dateTime = array[num];
        var dv = newDIV(div, dateTime + ".page");
        
        // ここで生成した dv にページを表示
        var isActive = (num == 0) ? true : false;
        openPage(dateTime, isActive, true); // openBasicPage をスキップ
        if (isSameDate(dateTime, today())) hasTodayPage = true;
        hasRecord = true;
    }
    
    // 最終受診日を currentDate() に設定
    if (array.length > 0) setCurrentDate(array[0]);
    
    // 基本情報を読込中のメッセージ表示
    var elm = window.top.tools.base;
    elm.innerHTML = "";
    var sp = newSPAN(elm, "alert");
    sp.innerHTML = "読込中...";
    
    if (!hasRecord){
        // カルテに１頁もない場合は自動的に頁追加
        addPage(todayAndTime());  // Ajax を起動するので openBasicPage() 実行しない
    } else if (addPageMode() && !hasTodayPage){
       // 待受リストや待受タグから開かれ、本日のページがない場合のみ
        addPage(todayAndTime()); // Ajax を起動するので openBasicPage() 実行しない
    } else {
        if (noCalendar() == 0) // localStorage.js
            NRGetBooking(patientId(), currentDate(), makeCalendar);
        
        // currentDate の付箋があれば開く：currentDate() が設定されている必要あり
        showPostIt(); // postIt.js
        
        // 基本情報を取得し表示：マルチ・スレッドを使う
        WKGetPage(owner(), patientId(), currentDate());
    }
}
function openChart(patientId, name, addPageFlag){
    // patientId name のカルテを開く
    _debug("== openChart == "+patientId+"->"+name+"->"+addPageFlag); //##
    
    // workArea の検索リストから起動されることがあるので workArea をクリア
    var elm =document.getElementById("workArea");
    elm.innerHTML = "";
    var elm = document.getElementById("calendarArea");
    elm.innerHTML = "";
    
    setPatientId(patientId); // patientId を記憶
    setAddPageMode((addPageFlag) ? true : false);
    
    var elm = document.getElementById("patientIdArea");
    elm.innerHTML = patientId;
    
    // 作業中であることを示すメッセージ
    var div = document.getElementById("contents");
    div.innerHTML = "";
    var elm = document.getElementById("alertArea");
    elm.innerHTML = patientId + " のカルテを開きつつあります...";
    
    // Ajax がカブらないようシリアルに実行
    NRGetPages(owner(), patientId, openPages);
}

