
/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** window.opener としての NOA が見つかりません");
        return null;
    }
}

function owner(){
    return noa().owner();
}

function cellText(){
    // CellEditor の入力部分を返す
    var tag = noa().currentTag();
    return noa().document.getElementById(tag + ".value");
}

///// NOA からの継承値 /////////////////////////
/////////////////////////////////////////////

function gotSuffixMenu(answer){
    // サーバから接尾語リストを取得
    //alert("gotSuffixMenu->"+answer); //##
    var obj = JSON.parse(answer);
    setSuffixMenus(obj); // 接尾語メニューを記憶
	makeDiseseRow();
}
function gotPrefixMenu(answer){
    // サーバから接頭語リストを取得
    //alert("gotPrefixMenu->"+answer); //##
    var obj = JSON.parse(answer);
    setPrefixMenus(obj); // 接頭語メニューを記憶
    NRGetMenu(noa().owner(), _suffix, gotSuffixMenu);
}
function gotDisesesMenu(answer){
    // サーバから病名リストを取得
    var obj = JSON.parse(answer);
    //alert("gotDisesesMenu->"+encodeObject(obj)); //##
    setMenus(obj); // メニューを記憶
    NRGetMenu(noa().owner(), _prefix, gotPrefixMenu);
}

var _prefix = "接頭語";
var _suffix = "接尾語";

var _menus
var _menuObj
function setMenus(obj){
    _menus = [""];
    _menuObj = new Object();
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length){
            _menus.push(rec.menu);
            _menuObj[rec.menu] = rec.value;
        }
    }
    _menus.push("...その他");
}
function menus(){
    // 病名の配列を返す
    return _menus;
}
function setValueForMenu(val, menu){
    // menu に対応する val を記憶
    _menuObj[menu] = val;
}
function valueForMenu(menu){
    // menu に対応する value（ローマ字）を返す
    return _menuObj[menu];
}

var _prefixMenus
function setPrefixMenus(obj){
    //alert("setPrefixMenus->"+encodeObject(obj)); //##
    _prefixMenus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length)
            _prefixMenus.push(rec.menu);
    }
    _prefixMenus.push("...その他");
}
function prefixMenus(){
    // 接頭語メニュー配列を返す
    return _prefixMenus;
}

var _suffixMenus
function setSuffixMenus(obj){
    //alert("setPrefixMenus->"+encodeObject(obj)); //##
    _suffixMenus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length)
            _suffixMenus.push(rec.menu);
    }
    _suffixMenus.push("...その他");
}
function suffixMenus(){
    // 接尾語メニュー配列を返す
    return _suffixMenus;
}

var _diseases;
function setDiseases(buff){
    // buff を日付ごとのオブジェクトに展開して記憶
    _diseases = new Array();
    if (trim(buff).length == 0) return;
    
    var records = buff.split("<br>");
    for (num in records){
        var ln = trim(records[num]); // 開始日 病名 -- 終了日 転帰" 型式
        if (ln.length == 0) continue;
        
        var rec = new Object();
        var array = ln.split("--");
        
        // 開始日と病名
        var leftSide = trim(array[0]); // " -- " の余白を削除
        var cols = leftSide.split(" ");
        if (cols.length < 2){
            alert(leftSide + " には「開始日」か「病名」が欠けています");
            continue; // 開始日・病名 の両方がなければ無視
        }
        
        rec.start = cols[0]; // 開始日
        cols.shift(); // 開始日を削除
        rec.name = cols.join(" "); // 病名
        
        // 終了日と転帰
        rec.end = ""; // 終了日
        rec.conclusion = ""; // 転帰
        if (array.length > 1){
            var rightSide = trim(array[1]); // " -- " の余白を削除
            var cols = rightSide.split(" ");
            rec.end = cols[0]; // 終了日
            rec.conclusion = (cols.length > 1) ? cols[1] : ""; // 転帰
        }
        _diseases.push(rec);
    }
}
function diseases(){
    return _diseases;
}
function diseaseAt(row){
    // row 番目の病名オブジェクトを返す
    if (row < _diseases.length)
        return _diseases[row];
    else
        return null;
}

function diseasesToString(){
    // 病名オブジェクトを NOA 病名欄用の文字列にして返す
    var array = new Array();
    for (num in _diseases){
        var rec = _diseases[num];
        if (rec.name.length == 0) continue; // 病名が空ならスキップ
        
        var ary = new Array();
        ary.push(rec.start);
        ary.push(rec.name);
        if (rec.end.length > 5) ary.push("--"); // 終了日とのセパレータ
        ary.push(rec.end);
        ary.push(rec.conclusion);
        array.push(ary.join(" "));
    }
    return array.join("<br>");
}
function addDisease(){
    // 新規病名行を追加
    var rec = new Object();
    rec.start = shortDate(today());
    rec.name = "";
    rec.end = "";
    rec.conclusion = "";
    _diseases.push(rec);
    
    // リスト内容を更新
    var row = _diseases.length - 1;
    makeDiseseRow();
    
    // 編集パネルが立ち上がる
    openEditor(null, row);
}
function removeDisease(num){
    // num 番目の病名オブジェクトを削除
    var rec = _diseases[num];
    _diseases.splice(num, 1);
    
    // リスト内容を更新
    makeDiseseRow();
}

function removed_disease(answer){
    //alert("removed_disease->"+answer); //##
    document.getElementById("workArea").innerHTML = "";
 //   showMenuTable();
}
function remove_disease(menu){
    // 病名 menu を MenuTable から削除
    // removeDisease() はメモリー上だけの削除だが、こちらは DB から削除
    if (confirm(menu + " を削除していいですか")){
        var tag = "ProgressSection.disease";
        NRRemoveMenu(noa().owner(), tag, menu, "", removed_disease);
    }
}

function setExpiredDateAt(row){
    // row 行の終了日を _disease へ反映させる
    var rec = _diseases[row];
    rec.end = shortDate(document.getElementById("end").value);
    rec.conclusion = document.getElementById("conclusion").value;
    
    // エディターを閉じリスト内容を更新
    closeEditorRow(row);
}
function openExpiredDatePanel(elm, row){
    // 終了日設定パネルを開く

    // 元データをハイライト表示
    if (elm) elm.style.color = "#f55";

    var tr = document.getElementById(row + ".editor");
    if (tr.innerHTML.length){
        closeEditorRow(row);
        return;
    }
    // すでに開いているエディターがあれば閉じる
    if (currentRow()) closeEditorRow(currentRow());
    setCurrentRow(row);

    tr.innerHTML = "";
    
    var td = newTD(tr, "", "");
    td.setAttribute("colspan", "5");
    
    var pane = newDIV(td, "/editorPane");
    pane.style.textAlign = "center";

    var div = newDIV(pane, "");
    var rec = diseaseAt(row);
	// 年月日
	var datetime = (rec && rec.end) ? longDate(rec.end) : todayAndTime();
	var yy = datetime.substr(0, 4) * 1;
	var mm = datetime.substr(5, 2) * 1;
	var dd = datetime.substr(8, 2) * 1;
	var label = nengou(yy); // 西暦に相当する年号
    var pop = newDatePopUp(div, "end", label, yy, mm, dd, false);
    // 転帰
    var conclusion = (rec) ? rec.conclusion : "";
    var array = ["","治癒","中止"];
    if (conclusion.length == 0){
        conclusion = "治癒";
    }
    var pu = newPopupMenu(div, "conclusion", array, conclusion);
    pu.style.marginLeft = "5px";
    
    // ボタン
    //var div = newDIV(pane, "");
    var bt = newDIV(div, "/fixButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "setExpiredDateAt(" + row + ")");
    bt.style.marginLeft = "5px";
}


////////////////////////////////////////////////////////
///// DRAG and DROP ////////////////////////////////////

function f_dragstart(event){
    // ドラッグ開始時の処理
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
    event.dataTransfer.setData("text", event.target.id);
}

function f_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function f_drop(event){
    // ドロップ時の処理
    // ドラッグされたデータのid名をDataTransferオブジェクトから取得
    var id_name = event.dataTransfer.getData("text");
    
    //id名からドラッグされた要素を取得
    var drag_elm = document.getElementById(id_name);
    
    //ドロップ先にドラッグされた要素を追加
    // event.currentTarget.appendChild(drag_elm);
    moveTo(id_name, event.currentTarget);
    
    //エラー回避のため、ドロップ処理の最後にdropイベントをキャンセルしておく
    event.preventDefault();
}
function moveTo(drop_id, target_node){
    // ドロップされたエレメントをドロップされたターゲット・エレメント位置へ移動
    var target_id = target_node.id;
    if (drop_id == target_node.id) return; // 自分自身は無視
    
    //_initDebug(true); //##
    _debug("moveTo->"+drop_id+"->"+target_id); //##
    
    var dropNum = numberOf(drop_id);
    var targetNum = numberOf(target_id);
    _debug(dropNum+"->"+targetNum); //##
    
    // ドロップするオブジェクトを抜かした配列を生成
    var dropRec;
    var anArray = new Array();
    var recs = diseases();
    for (num in recs){
        var rec = recs[num];
        if (num == dropNum){
            dropRec = rec; // ドロップすべきオブジェクトを記憶
            continue;
        }
        anArray.push(rec);
    }
    
    // ドロップすべきオブジェクトをドロップする位置に挿入した配列を生成
    var newRecords = new Array();
    for (num in anArray){
        var rec = anArray[num];
        if (num == targetNum)
            newRecords.push(dropRec);
        newRecords.push(rec);
    }
    if (targetNum >= anArray.length)
        newRecords.push(dropRec);
    
    // レイアウトの mode() に該当する部分だけを newRecords 要素と置換
    _diseases = newRecords;
    
    // レイアウトを再表示
    makeDiseseRow();
    
    function numberOf(id){
        // 2.name のような id から 2 だけを取り出して返す
        var array = id.split('.');
        
        return array[0] * 1;
    }
}

///// DRAG and DROP ////////////////////////////////////
////////////////////////////////////////////////////////

function makeDiseseRow(){
    // 病名リストを生成
	var elm = document.getElementById("editorArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "9pt";
    
    // タイトル
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "editorTitle/", "開始日");
    var td = newTD(tr, "editorTitle", "病名");
    var td = newTD(tr, "editorTitle/endDate", "終了日");
    var td = newTD(tr, "editorTitle/conclusion", "転帰");
    var td = newTD(tr, "editorTitle/mark", "");
    
    // 病名リスト
    var array = diseases();
    for (num in array){
        // 一行分のエレメントを生成
        var rec = diseaseAt(num);
        var tr = newTR(tbl, num + ".row", "");
        var td = newTD(tr, "/startDate", rec.start);
        var td = newTD(tr, num+".name/name", rec.name);
        td.setAttribute("onclick", "openEditor(this,'" + num + "')");
        td.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
        td.setAttribute("ondragstart", "f_dragstart(event)");
        td.setAttribute("ondragover", "f_dragover(event)");
        td.setAttribute("ondrop", "f_drop(event)");
        var td = newTD(tr, num+".end/endDate", rec.end);
        td.setAttribute("onclick", "openExpiredDatePanel(this,'" + num + "')");
        var td = newTD(tr, num+".conclusion/conclusion", rec.conclusion);
        var td = newTD(tr, "/mark", "");
        var img = newIMAGE(td, "", "./remove-field.png", "remove");
        img.style.height = "13px";
        img.setAttribute("onclick", "removeDisease('" + num + "')");
        
        // エディター・エリア
        var tr = newTR(tbl, num + ".editor", "");
    }
    
    // 新規病名追加
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    var td = newTD(tr, "/addField", "");
    td.setAttribute("onclick", "addDisease()");
    td.style.paddingTop = "3px";
	var im = newIMAGE(td, "", "./add-field.png", "?");
	im.style.height = "14px";
    im.style.position = "relative";
    im.style.top = "2px";
    var sp = newSPAN(td, "");
    sp.innerHTML = "病名を追加";
    sp.style.paddingLeft = "5px";
}

function ok(){
    // 病名記入ツールの編集内容を NOA へ書き戻す
    var status = diseaseTouchAndGo() ? true : false;
    
    noa().gotValueFromTool(diseasesToString(), status);
}


////////////////////////////////////////////////////////////
///// 病名管理 //////////////////////////////////////////////

function saveMenu(){
    // メニュー構造をサーバへ保存
    var owner = noa().owner();
    var tag = "ProgressSection.disease";
    var freq = "";
    
    //_initDebug(true) //##
    
    for (menu in _changedMenu){
        var value = document.getElementById(menu + ".romaji").innerText;
        
        NRPutMenu(owner, tag, menu, freq, value, NRNoAction);
    }
    _changedMenu = null; // 変更履歴を初期化
    initDisease();
}

function addNewMenu(){
    // 新規メニューを追加
    var name = prompt("新規病名を入力してください");
    if (name && name.length){
        _menuObj[name] = "";
    }
    document.getElementById("workArea").innerHTML = "";
    showMenuTable();
}

var _changedMenu;
function setEditable(elm, name){
    // 病名に対応する検索キーを編集可能にする
    elm.contentEditable = true; // TEXT を編集可能状態にする
    elm.focus();
    
    // 変更履歴に記憶：重複を避けるため Array ではなく Object を使う
    if (!_changedMenu) _changedMenu = new Object();
    _changedMenu[name] = "dummy";
}

function showMenuTable(){
    // 病名と検索キーの対象テーブルを表示
    var elm = document.getElementById("workArea");
    if (elm.innerHTML.length){
        elm.innerHTML = "";
        return;
    }
    elm.innerHTML = "";
    
    var tbl = newTABLE(elm, "", "/base-table");
    tbl.style.fontSize = "9pt";
    tbl.style.width = "100%";
    
    // HEADER ==============================
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/titleCol", "病名");
    var td = newTD(tr, "/titleCol", "検索キー（アルファベット）");
    var td = newTD(tr, "/titleCol", "");
    td.style.width = "15px";
    
    // CONTENTS ============================
    for (name in _menuObj){
        var romaji = _menuObj[name];
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, name + ".disease", name);
        var td = newTD(tr, name + ".romaji", romaji);
        td.setAttribute("onclick", "setEditable(this,'" + name + "')");
        var td = newTD(tr, "/mark", "");
        var img = newIMAGE(td, "", "./remove-field.png", "remove");
        img.style.height = "13px";
        img.setAttribute("onclick", "remove_disease('" + name + "')");
    }
    
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/addField", "");
    td.setAttribute("onclick", "addNewMenu()");
	var im = newIMAGE(td, "", "./add-field.png", "?");
	im.style.height = "14px";
    im.style.position = "relative";
    im.style.top = "3px";
    var sp = newSPAN(td, "");
    sp.innerHTML = "病名を追加";
    sp.style.paddingLeft = "5px";
    var td = newTD(tr, "", "");
    
    // FOOTER ==============================
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/titleCol", "");
    var td = newTD(tr, "/titleCol", "");
    td.style.textAlign = "right";
    td.setAttribute("colspan", "2");
    var bt = newDIV(td, "/fixButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "saveMenu()");
    
}

///// 病名管理 //////////////////////////////////////////////
////////////////////////////////////////////////////////////


function diseaseHelp(){
	// 別途ヘルプをパネル表示
	window.open("./diseaseHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initDisease(){
    // 病名リストを表示するパネルを生成
    //_initDebug(true); //##
    _debug("== showDisease =="); //##
    
	var base = document.getElementById("base");
    base.innerHTML = "";
    
    // ===== 病名 表示エリア ==========================
    var elm = newDIV(base, "");
    // === HEADER =======================
    var div = newDIV(elm, "/tool-header");
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.width = "50%";
    var sp = newSPAN(dv, "");
    sp.innerHTML = "病名入力ツール";
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side");
    // HELP ICON
	var im = newIMAGE(dv, "", "./help.png", "?");
	im.setAttribute("onclick", "diseaseHelp()");
	im.style.height = "18px";
    
	// ===== 編集エリア ==================================
    var div = newDIV(elm, "editorArea");
    var sp = newSPAN(div, "");
    sp.innerHTML = "Loading ...";
    sp.style.padding = "15px";
    sp.style.color = "#f88";
    sp.style.fontSIze = "9pt";
    
    // === FOOTER =======================
    var div = newDIV(elm, "/tool-footer");
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.width = "130px";
    dv.style.position = "relative";
    dv.style.top = "3px";
    // OPTION -----------
    var sp = newSPAN(dv, "");
    sp.innerHTML = di_version();
    sp.style.fontSize = "9pt";
    var a = newA(dv, "病名管理", "#", "");
    a.setAttribute("onclick", "showMenuTable()");
    a.style.marginLeft = "10px";
    a.style.fontSize = "9pt";
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side");
    // 確定保存チェックボックス
    var sp = newSPAN(dv, "");
    sp.style.marginRight = "10px";
    sp.style.position = "relative";
    sp.style.top = "2px";
    var cb = newCHECKBOX(sp, "touchAndGoCheck", " 確定保存", diseaseTouchAndGo());
    cb.setAttribute("onchange", "setDiseaseTouchAndGo(this)");
    // カルテへ転記ボタン
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "カルテへ";
    bt.setAttribute("onclick", "ok()");
    bt.style.fontSize = "9pt";
    bt.style.position = "relative";
    bt.style.top = "2px";
    
    // WORK AREA =====================
    var div = newDIV(elm, "workArea");
    
    // NOA の病名欄を読込み、病名リストを表示
    var buff = cellText().innerHTML; // NOA の CellEditor の内容
    buff = decodeHTML(buff); // &nbsp; などを空白に戻す
    buff = trim(buff);
    setDiseases(buff);

    NRGetMenu(noa().owner(), "ProgressSection.disease", gotDisesesMenu);
}

function di_version(){
	return "Ver.131019";
}
