
/////////////////////////////////////////////////////////////
///// Ajax //////////////////////////////////////////////////

var _patientId;
function gotConditionalInsFiles(answer){
    var obj = JSON.parse(answer);
    
    showResults(obj);
}
function getConditionalInsFiles(from, to){
    // from to の期間にコピーした保険証画像を検索
    document.getElementById("dataArea").innerHTML = "検索中：しばらくお待ちください";

    NRGetImagFileBetween(from, to, gotConditionalInsFiles);
}

function gotImage(answer){
    window.open(answer,"Image","width=900,height=630");
}
function getImage(elm, filename){
    // filename のイメージをリクエスト
    NRGetImageFile(filename, gotImage);
}

function closeMessage(){
    document.getElementById("_debug").innerHTML = "";
}
function removedImage(answer){
    //alert(answer); //##
    var elm = document.getElementById("_debug");
    elm.innerHTML = "";
    
    var dv = newDIV(elm, "");
    dv.style.padding = "5px 5px";
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "5px";
    var img = newIMAGE(sp, "icon", "./close.png", "close");
    img.setAttribute("onclick", "closeMessage()");
    img.style.width = "12px";
    var sp = newSPAN(dv, "");
    sp.style.color = "#00f";
    sp.innerHTML = "画像は以下のように処理されました（安全のため本格削除ではなく他へ移動）";

    var dv = newDIV(elm, "");
    dv.style.paddingLeft = "20px";
    var sp = newSPAN(dv, "");
    sp.style.color = "#00f";
    sp.style.fontSize = "10pt";
    sp.innerHTML = answer; // for debug
    
    var pos = getPosition(dv);
    window.scroll(0, pos.y);
}
function removeImage(){
    // チェックした画像を削除
    var recs = new Array();
    for (var i=0; i < _rows; i++){ // for (i in _rows) は駄目
        var cb = document.getElementById(i + ".cb");
        if (cb.checked){
            var filename = document.getElementById(i + ".fname").innerHTML;
            
            recs.push(filename);
        }
    }
    var files = recs.join(",");
    
    NRRemoveFiles(files, removedImage);
}

///// Ajax //////////////////////////////////////////////////
/////////////////////////////////////////////////////////////

function changeAllChecks(elm){
    // 全てのチェックボックスのステータスをトグル式に変更
    var status = elm.checked;
    for (var i=0; i < _rows; i++){
        var sp = document.getElementById(i + ".cbArea");
        sp.innerHTML = "";
        var cb = newCHECKBOX(sp, "", "", status);
    }
}

var _rows;
function showResults(obj){
    // 検索結果を表示
    if (obj == null){
        document.getElementById("dataArea").innerHTML = "該当するものはありません";
    } else {
        var elm = document.getElementById("dataArea");
        elm.innerHTML = "";
        
        var tbl = newTABLE(elm, "base-table");
        
        // タイトル
        var tr = newTR(tbl, "yellow-bar", "");
        var td = newTD(tr, "label-left", "カルテID");
        td.style.width = "250px";
        var td = newTD(tr, "", "");
        var sp = newSPAN(td, "");
        sp.style.paddingRight = "5px";
        var cb = newCHECKBOX(sp, "", "", 0);
        cb.setAttribute("onchange", "changeAllChecks(this)");
        var sp = newSPAN(td, "");
        sp.innerHTML = "保険証画像ファイル名";
        
        // レコード
        _rows = 0;
        var count = 0;
        for ($pid in obj){
            var rec = obj[$pid];
            var tr = newTR(tbl, "", "");
            tr.style.borderTop = "thin solid #ccc";
            var td = newTD(tr, "label-left", rec.pid + " " + rec.name);
            td.style.verticalAlign = "top";
            
            var td = newTD(tr, "", "");
            var tbl2 = newTABLE(td, "base-table");
            for (num in rec.files){
                var filename = rec.files[num];
                var tr2 = newTR(tbl2, "", "");
                var td2 = newTD(tr2, "", "");
                var sp = newSPAN(td2, _rows + ".cbArea");
                sp.style.paddingRight = "5px";
                var cb = newCHECKBOX(sp, _rows + ".cb", "", 0);
                var sp = newSPAN(td2, _rows + ".fname");
                sp.innerHTML = filename;
                setChangeColor(sp, '#000','#fff');
                var action = "getImage(this,'"+filename+"')";
                sp.setAttribute("onclick", action);
                _rows++;
            }
            count++;
        }
        
        var tr = newTR(tbl, "yellow-bar", "");
        var td = newTD(tr, "label-left", count + " 名");
        var td = newTD(tr, "", "");
        var bt = newBUTTON(td, "", "チェックした画像を削除");
        bt.setAttribute("onclick", "removeImage()");
    }
}

function search(){
    // 指定された期間にコピーした保険証画像を検索
    var from = "";
    var val = document.getElementById("fromPop").value;
    var array = val.split("-");
    if (array.length == 3){
        from = val + " 00:00:00";
    }
    
    var to = "";
    var val = document.getElementById("toPop").value;
    var array = val.split("-");
    if (array.length == 3){
        to = val + " 23:59:59";
    }
    
    if (!from && !to){
        alert("年月日が指定されていません");
    } else {
        if (from == "")
            from = "0000-00-00 00:00:00";
        if (to == "")
            to = todayAndTime();
        getConditionalInsFiles(from, to);
    }
}

function help(){
	window.open("./fileCleanerHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initFileCleaner(){
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
	// header
	var tbl = newTABLE(elm, "base-table");
	var tr = newTR(tbl, "title-bar", "");
    var td = newTD(tr, "left-side", "");
    // from popup
    var array = today().split("-");
    var yyyy = array[0] - 3;
    var mm = 1;
    var dd = 1;
    var pm = newDatePopUp(td, "fromPop", "", yyyy, mm, dd, false, null);
    //
    var sp = newSPAN(td, "");
    sp.style.padding = "0px 5px";
    sp.innerHTML = "から";
    // to popup
    var yyyy = array[0];
    var mm = array[1];
    var dd = array[2];
    var pm = newDatePopUp(td, "toPop", "", yyyy, mm, dd, false, null);
    //
    var sp = newSPAN(td, "");
    sp.style.padding = "0px 5px";
    sp.innerHTML = "までの保険証画像を";
    // button
    var bt = newBUTTON(td, "", "リストアップ");
    bt.setAttribute("onclick", "search()");

    // HELP
	var td = newTD(tr, "right-side", "");
	var im = newIMAGE(td, "", "./Help.png", "?");
	im.setAttribute("onclick", "help()");
	im.style.height = "18px";

	// データ表示エリア
    var div = newDIV(elm, "dataArea");
    div.style.padding = "5px 5px";
    div.style.fontSize = "10pt";
    var sp = newSPAN(div, "");
    sp.innerHTML = "一定期間にコピーした保険証をリストアップし確認後「削除」します";
	
	// footer
    var div = newDIV(elm, "title-bar");
    var sp = newSPAN(div, "left-side");
    sp.innerHTML = version();
}

function version(){
	return "Ver.121007";
}
