


///////////////////////////////////////////////////////
///// Preferences /////////////////////////////////////

function sortBookingList(){
    // 受付日時で逆ソートする
    var status = (bookingReverse()) ? "" : "1";
    setBookingReverse(status);
    
    // その条件で受診者リストを再表示
    showWaitingList();
}

function bookingCheckChanged(elm){
    // 診療済のレコードを表示/非表示に切り替え
    setBookingCheck(elm);
    
    // その条件で受診者リストを再表示
    showWaitingList();
}

function setBookingTodayCheanged(elm){
    // 本日のみ表示/非表示
    setBookingTodayCheck(elm);
    
    // その条件で受診者リストを再表示
    showWaitingList();
}

function setCostColumnCheanged(elm){
    // 金額欄表示/非表示
    setCostColumnCheck(elm);
    
    // その条件で受診者リストを再表示
    showWaitingList();
}

function insColumnCheckChanged(elm){
    // 保険証欄表示/非表示
    setInsColumnCheck(elm);
    
    // その条件で受診者リストを再表示
    showWaitingList();
}

function setFlexibleList(elm){
    // 待受リストの表示数を制限するか否かを設定
    setFlexibleWaitingList(elm);
    
    // その条件で受診者リストを再表示
    showWaitingList();
}

function showControls(){
    // フッター上のコントロール類を表示
    var info = document.getElementById("controlInfoArea");
    var elm = document.getElementById("controlBar");
    if (info.innerHTML.length){
        info.innerHTML = "";
        elm.innerHTML = "";
        return;
    }
    
    makeControls(info, elm);
    
    function makeControls(info, ctrl){
        // フッター上のコントロール類を生成
        info.innerHTML = "";
        ctrl.innerHTML = "";
        
        // 適用
        var div = newSPAN(info, "");
        var sp = newSPAN(div, "");
        sp.style.margin = "0 6px";
        sp.innerHTML = "予約者 表示色";
        sp.setAttribute("class", "reserved");
        var sp = newSPAN(div, "");
        sp.innerHTML = "診療待 表示色";
        sp.setAttribute("class", "accepted");
        var sp = newSPAN(div, "");
        sp.style.marginLeft = "6px";
        sp.innerHTML = "診療済 表示色";
        sp.setAttribute("class", "finished");
        var sp = newSPAN(div, "");
        sp.style.marginLeft = "3px";
        sp.setAttribute("onclick", "waitingListHelp()");
        var img = newIMAGE(sp, "", "./Help.png", "?");
        img.style.height = "18px";
        img.style.position = "relative";
        img.style.top = "4px";
        
        // 表示・非表示
        var div = newDIV(ctrl, "");
        div.style.marginLeft = "30px";
        div.style.color = "#fff";
        var sp = newSPAN(div, "");
        sp.style.marginRight = "5px";
        var cb = newCHECKBOX(sp, "", "診療済を非表示", bookingCheck());
        cb.setAttribute("onchange", "bookingCheckChanged(this)");
        var cb = newCHECKBOX(div, "", "本日の受診者のみ表示", bookingTodayCheck());
        cb.setAttribute("onchange", "setBookingTodayCheanged(this)");
        var sp = newSPAN(div, "");
        sp.style.marginLeft = "8px";
        var cb = newCHECKBOX(div, "", "パネル枠固定せず", flexibleWaitingList());
        cb.setAttribute("onchange", "setFlexibleList(this)");
        
        // 表示欄の設定
        var div = newDIV(ctrl, "");
        div.style.marginLeft = "30px";
        div.style.color = "#fff";
        var sp = newSPAN(div, "");
        sp.style.marginRight = "5px";
        var cb = newCHECKBOX(sp, "", "金額欄 表示", costColumnCheck());
        cb.setAttribute("onchange", "setCostColumnCheanged(this)");
        var cb = newCHECKBOX(div, "", "保険証確認 表示", insColumnCheck());
        cb.setAttribute("onchange", "insColumnCheckChanged(this)");
        var sp = newSPAN(div, "");
        sp.style.marginLeft = "5px";
        sp.style.padding = "3px 0 0 3px";
        sp.style.backgroundColor = "#fff";
        sp.setAttribute("onclick", "showWaitingListPanel()");
        var img = newIMAGE(sp, "", "./outArrow.png", "?");
        img.style.height = "10px";
        var sp = newSPAN(div, "/bookingActor");
        sp.setAttribute("onclick", "showWaitingListPanel()");
        sp.innerHTML = "別ウインドーで開く";
    }
}

///// Preferences /////////////////////////////////////
///////////////////////////////////////////////////////


function openInsViewer(pid, date){
    // InsViewer を開く
    var url = "../InsViewer?patientId=" + pid + "&currentDate=" + date;
    window.open(url, "_blank");
}

function refleshWaitingList(obj){
    // 待受リストの内容を更新
    var dv = document.getElementById("waitingTableArea");
    if (!dv) return; // polling から呼ばれ待受リスト・パネル表示されていない場合

    if (! flexibleWaitingList()){
        dv.style.height = "200px"; // パネルの高さ
        dv.style.overflow = "auto"; // 内部がスクロールするよう設定
    }
    // polling での画面更新はブラウザーをクラッシュさせることがあるので
    // パネルのコンテンツ部分をクリックすると画面更新するようにする
    //dv.setAttribute("onclick", "backgroundClicked()");
    
	dv.innerHTML = "";
    var tbl = newTABLE(dv, "/bookingTable");
    
    if (!obj || (obj.length == 0)) return;
    
    // bookingReverse() が指定されているなら obj を逆順ソート
    if (bookingReverse()) obj = obj.reverse();
    
    var ignoreFinished = bookingCheck(); // 診療済を非表示
    var total = 0;
    var sum = 0;
    for (num in obj){
        var rec = obj[num];
        // 終了時刻が NULL なら「診療待ち」時刻があれば「診療済み」と判定
        var isFinished = (rec.endTime && rec.endTime.toString().length) ? true : false;
        var isToday = isSameDate(rec.entryDate, today());
        
        if (ignoreFinished && isFinished) continue; // 診療済をスキップ
        if (bookingTodayCheck() && !isToday) continue; // 本日以外をスキップ
        
        var tr = newTR(tbl, "", "");
        // entryDate
        var td = newTD(tr, "dateCol/bookingColumn", rec.entryDate);
        td.style.width = "120px";
        if (rec.reserved * 1 > 0){
            td.setAttribute("class", "reserved"); // 予約
            var action = "opneLogChart(1,'" + rec.patientId + "','" + rec.kanjiName + "')"
        } else if (isFinished){
            td.setAttribute("class", "finished"); // 診療済み
            var action = "opneLogChart(1,'" + rec.patientId + "','" + rec.kanjiName + "')"
        } else {
            td.setAttribute("class", "accepted"); // 診療待ち
            var action = "opneLogChart(1,'" + rec.patientId + "','" + rec.kanjiName + "','addPage')"
        }
        // patientId
        var st = rec.patientId + " " + rec.kanjiName;
        var td = newTD(tr, "/bookingActor", st);
        td.style.width = "180px";
        td.setAttribute("onclick", action);
        
        if (costColumnCheck()){
            // 合計欄
            var cost = (rec.endTime) ? rec.insFee * 1 + rec.ownFee  * 1 + "" : "";
            sum += rec.insFee * 1 + rec.ownFee  * 1;
            total++;
            var td = newTD(tr, "/bookingColumn", cost); // 合計
            td.style.textAlign = "right";
            td.style.width = "50px";
        }
        
        if (insColumnCheck()){
            // 保険証欄
            var td = newTD(tr, "/bookingActor", ""); // 保険証
            setScanDateWith(td, rec.scanDateTime);
            var action = "openInsViewer('"+rec.patientId+"','"+rec.entryDate+"')";
            td.setAttribute("onclick", action);
            td.style.width = "70px";
        }
    }
    
    if (costColumnCheck() && bookingTodayCheck()){
        // 本日のみの表示であれば合計を表示
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "dateCol", "");
        var td = newTD(tr, "/bookingColumn", "Total ( " + total + " )");
        td.style.textAlign = "right";
        var td = newTD(tr, "/bookingColumn", sum + "");
        td.style.textAlign = "right";
    }
    
    function setScanDateWith(elm, filename){
        // filename から 日付を抽出して返す
        // filename = "03234202_20120113165123.JPG" 形式
        if (filename){
            elm.style.textAlign = "right";
            var array = filename.split("_");
            if (array.length > 1){
                var st = array[1];
                var yyyy = st.substr(0, 4);
                var mm = st.substr(4, 2);
                var dd = st.substr(6, 2);
                var hour = st.substr(8, 2);
                var min = st.substr(10, 2);
                var sec = st.substr(12, 2);
                var dateTime = yyyy+"-"+mm+"-"+dd+" "+hour+":"+min;
                
                var today = (currentDate()) ? currentDate() : todayAndTime();
                var pastDays = daysBetween(dateTime, today);
                if (pastDays > 30){
                    // 一定日数を越えたものは「経過日数」表示
                    elm.innerHTML = pastDays + " 日経過";
                } else {
                    elm.innerHTML = yyyy+"-"+mm+"-"+dd;
                }
            } else {
                elm.innerHTML = filename; // 本来このようなことは無いはず
            }
        } else {
            elm.innerHTML = "画像なし";
            elm.setAttribute("class", "bookingYellowActor"); // 黄色表示
        }
    }
    
    function daysBetween(datetime1, datetime2){
        // datetime1, datetime2 間の日数を返す
        // 両日の０時０分０秒同士で計算するので、多少誤差が出る可能性あり
        var date1 = datetime1.substr(0, 10) + " 00:00:00";
        var date2 = datetime2.substr(0, 10) + " 00:00:00";
        var seconds = secondsBetween(date1, date2);
        
        return (seconds) ? seconds / (60 * 60 * 24) : 0;
    }
}

function waitingListHelp(){
	// 別途ヘルプをパネル表示
	window.open("./waitingListHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function showWaitingListPanel(){
    // 別ウインドーに表示する
	window.open("./waitingPanel.php","waitingPanel"
				,"width=500,height=270,scrollbars=yes,dependent=yes");
    
    // footer のツール領域を閉じる
//    showWaitingList();
}

function showBookingList(){
    // 外部から呼ばれる関数名
    initWaitingList("_confirm");
}
function showWaitingList(){
    // 受診者リストを表示
    initWaitingList();
}

var _isOutPanel;
var _waitingListArea;
function initWaitingList(id){
    // 受診者リストを表示
    _waitingListArea = (id) ? id : "_confirm";
    
    if (_waitingListArea == "_confirm"){
        // NOA 画面に表示される通常の waitingList
        var elm = window.top.noa.document.getElementById(_waitingListArea);
        elm.style.visibility = "visible";
        elm.style.left = 10; // 表示するx座標
        elm.style.top = 90; // 表示するy座標
        setFloatPanel(elm);
        _isOutPanel = false;
    } else {
        // 別ウインドーとして表示される waitingList
        var elm = document.getElementById(_waitingListArea);
        _isOutPanel = true;
        polling();
    }
    elm.innerHTML = "";
    
    var div = newDIV(elm, "");
    div.style.background = "#77f";
    div.style.border = "thin solid #44f";
    
    // === TITLE ===
	var tbl = newTABLE(div, "/bookingTable");
    var tr = newTR(tbl, "", "");
    tr.style.fontSize = "9pt";
    var td = newTD(tr, "bookingSortTab/bookingTitle", "受付日時");
    td.style.width = "120px";
    td.setAttribute("onclick", "sortBookingList()");
    var td = newTD(tr, "/bookingTitle", "カルテ");
    td.style.width = "180px";
    if (costColumnCheck()){
        var td = newTD(tr, "/bookingTitle", "計");
        td.style.width = "50px";
    }
    if (insColumnCheck()){
        var td = newTD(tr, "/bookingTitle", "保険証");
        td.style.width = "70px";
    }
    
    // === コンテンツ表示エリア ===
    var dv = newDIV(div, "waitingTableArea");
    
    if (_isOutPanel == false){
        // NOA 画面に表示される通常の waitingList
        // === FOOOTER ===
        var dv = newDIV(div, "");
        dv.style.background = "#55f";
        dv.style.fontSize = "9pt";
        // --- ハンマー・アイコン ---
        var sp = newSPAN(dv, "bookingOpen");
        sp.setAttribute("onclick", "showControls()");
        setInfoTip("bookingOpen", "摘要や初期設定を表示"); // HELP
        var img = newIMAGE(sp, "", "./hammer.png", "?");
        img.style.height = "14px";
        img.style.verticalAlign = "middle";
        // --- インフォ・エリア ---
        var sp = newSPAN(dv, "controlInfoArea");
        // --- CLOSE BUTTON ---
        var sp = newSPAN(dv, "");
        sp.style.padding = "4px 5px 0px 0px";
        sp.style.display = "inline";
        sp.style.float = "right";
        var bt = newDIV(sp, "/closeButton");
        bt.innerHTML = "X";
        bt.setAttribute("onclick", "closeFloatPanel()");
    }
    
    // === 設定コントロール・エリア ===
    var ctrl = newDIV(dv, "controlBar/bookingControls");
    
    function polling(){
        // ### WaitingList が別ウインドーで開く場合にのみ動作 ###
        // 受付の患者登録を Worker を使い裏プロセスの polling でチェック
        // DB とのやりとりや polling は polling.js で設定
        var worker = new Worker('./polling.js');
        
        worker.onmessage = function (event) {
            // 新たに受け付けられた受診者データを受け取る
            var obj = event.data;
            var records = obj.records; // 本日の日計表レコード

            // 待受リストを更新
            refleshWaitingList(records);
        }
    }
}
