

var _menuArray;
function setMenuForTag(array, tag){
    if (!_menuArray) _menuArray = new Object();
    _menuArray[tag] = array;
}
function menuForTag(tag){
    return (_menuArray) ? _menuArray[tag] : null;
}

/////////////////////////////////////////////////
///// MENU //////////////////////////////////////

function show_menu(menuType, tag){
    // メニューを生成
    var elm = document.getElementById("menuArea");
    var menus = menuForTag(tag);
    switch (menuType){
        case _group_:
            // グループ・メニュー
            var sp = newSPAN(elm, "menuPopArea");
            var pu = makePopupMenu(sp, "menuPop", menus, "");
            pu.setAttribute("onchange", "groupPopup_changed(this)");
            var bt = newDIV(elm, "/whiteButton");
            bt.innerHTML = "挿入";
            bt.setAttribute("onclick", "insert_groupItems()");
            break;
        case _date_:
            var yy = "";
            var mm = "";
            var dd = "";
            var value = cell.trimValue;
            if (value && value.length){
                var dateArray = value.split("-");
                yy = dateArray[0];
                mm = (dateArray.length > 1) ? dateArray[1] : "";
                dd = (dateArray.length > 2) ? dateArray[2] : "";
            }
            // 年月日ボタン表示エリア
            var sp = newSPAN(elm, "");
            var cid = editorId() + ".hidden"; // 隠しフィールドの ID
            newDatePopUp(sp, cid, "平成", yy, mm, dd, false, dateChanged);
            break;
        case _panel_:
            var elm = document.getElementById("panelMenuArea");
            elm.style.fontSize = "9pt";
            elm.style.paddingBottom = "10px";
            for (num in menus){
                var item = menus[num];
                if (item.length == 0) continue;
                
                var sp = newDIV(elm, "/blueButton");
                sp.innerHTML = item;
                sp.setAttribute("onclick", "insert_menuItem('"+item+"')");
            }
            break;
        case _rotary_:
            // ポップアップ・メニュー
            var sp = newSPAN(elm, "menuPopArea");
            sp.style.paddingRight = "3px";
            var pu = makePopupMenu(sp, "menuPop", menus, "");
            pu.setAttribute("onchange", "popup_chaged(this)");
            // 絞り込み
            var fd = newFIELD(elm, "focusF", "", 10, "");
            fd.setAttribute("placeholder", "絞り込み"); // 入力ヒントを表示
            fd.setAttribute("onkeyup", "focusPressed()");
            break;
        case _none_:
        case _calendar_:
        default:
            break;
    }
}

function show_freq(answer){
	// メニューの頻度がインクリメントされたレスポンスを得る
	// ポップアップメニューを再描画
	var obj = JSON.parse(answer);
    //alert("show_freq --\n"+encodeObject(obj)); //##
    
    // increment_freq() で戻ってくる menuItems は attributes で記憶しているもの
    // とは形式が異なるので、attributes で記憶している形式に修正
    var array = new Array();
	for (num in obj){
        var rec = obj[num];
        array.push(rec.freq + "^$^" + rec.menu);
	}
    array.sort(compareFreq); // freq でソート
    
    // array の freq を取り除いた配列をつくる
    var menus = [""];
    for (num in array){
        var st = array[num];
        var ary = st.split("^$^");
        var freq = ary[0];
        var item = ary[1];
        menus.push(item);
    }
    
    // ポップアップ・メニューを再描画
    var elm = document.getElementById("menuPopArea");
    if (elm){ // _rotary_ type 以外では不要
        elm.innerHTML = "";
        var pu = makePopupMenu(elm, "menuPop", menus, "");
        pu.setAttribute("onchange", "popup_chaged(this)");
    }
}
function increment_freq(tag, menuItem, value){
	// 選択されたメニューの頻度を１つ増やす
	// ### menuItem が MenuTable に存在しない場合 menuItem の新規登録も行う
	NRPutMenu(owner(), tag, menuItem , "", value, show_freq);
}

function insert_menuItem(item){
    // メニューの選択内容が変更された
    if (item == "...その他"){
//        addMenu();
        return;
    }
    
    // フィールドの種類により item をモディファイ
    // ProgressSection.treatment などの場合は年月日をつける
	// ## item 自体を変更すると最後の increment_freq() で
	// ## 新規登録されてしまうので menuItem に名称を変え使用する
    var menuItem = modifyItem(currentTag(), item);
    
	// 選択されたアイテムを文中に挿入
    var elm = document.getElementById(currentTag() + ".text"); // 文章
    var html = elm.innerHTML;
    var field = fieldForTag(currentTag());
	if (pureSize(html) == 0){ // 入力先が空欄の場合
		elm.innerHTML = menuItem;
	} else {
		switch (field.menuAction * 1){ // insert position
			case _menu_to_tail_: // 0: 文末へ追加
				elm.innerHTML = html + " " + menuItem;
				break;
			case _menu_to_last_row_: // 1: 最終行へ追加
				elm.innerHTML = html + "<br>" + menuItem;
				break;
			default: // 2 _menu_replace_: 置換
				elm.innerHTML = menuItem;
				break;
		}
	}
    
    // 使用されたメニュー項目の頻度を increment
    increment_freq(currentTag(), item, "");
    
    // 一回のみ選択なら次フィールドへジャンプ
    if (field.buttonType * 1 > 0){
//        saveAndJumpEditor(currentTag());
    }
    
    function pureSize(html){
        // HTML をプレーンテキストにした trim サイズ を返す
        var doc = htmlForValue(html); // "<br>" を "\n" へ変換
        doc = convertSTRING(doc, "&nbsp;", "");
        
        return trim(doc).length;
    }
}
function popup_chaged(elm){
    // ポップアップメニューが選択された
    var item = elm.value;
    
    insert_menuItem(item);
}

///// MENU //////////////////////////////////////
/////////////////////////////////////////////////

/////////////////////////////////////////////
///// ADRESS ///////////////////////////////

function put_Address(){
    // 住所メニューの町村が選択された時、メニューの都道府県を入力欄へ転記
    var tag = "AddressSection.address";
    var prefecture = document.getElementById("prefPop").value;
    var city = document.getElementById("cityPop").value;
    var village = document.getElementById("villagePop").value;
    
    if (isSame(village, "...その他")){
		village = window.prompt("町村名(のみ)を入力してください", "");
		if (village.length == 0) return;
        
        // 町村を登録
        // 選択アイテムが存在しなければ登録、存在すれば頻度をインクリメント
        NRPutMenu(owner(), city, village, 1, "", got_VILLAGE);
	} else {
        // 選択されたアイテムを文中に挿入
        var elm = document.getElementById(currentTag() + ".text"); // 文章
        elm.value = prefecture + " " + city + " " + village + " ";
        // 選択された欄の文末にカーソルを置く
        elm.focus();
        var sel = window.getSelection();
        sel.collapseToEnd();
    }
}

var _selectedAddress;
function got_VILLAGE(answer){
	var obj = JSON.parse(answer);
    var shiku = document.getElementById("cityPop").value;
    if (shiku.length == 0){
        return; // 町村のポップアップメニューを表示しない
    } else {
        var menuItems = [""]; // 最初に空メニューを入れておく
        for (num in obj){
            var rec = obj[num];
            menuItems.push(rec.menu); // メニューアイテム
        }
        menuItems.push("...その他");
    }
    
	// 町村ポップアップを更新
    var elm = document.getElementById("_chouson");
    elm.innerHTML = "";
    var value = trim(document.getElementById(currentTag()+".text").value);
    var val = "";
    if (value){
        var addressArray = value.split(" ");
        val = addressArray[2];
    }
    
    var pu = makePopupMenu(elm, "villagePop", menuItems, val);
    // 町村 が変更されたら 都道府県 を入力欄に転記
    pu.setAttribute("onchange", "put_Address()");
}
function get_VILLAGE(elm){
    // 町村のポップアップを設定
    var shiku = elm.value;
	if (isSame(shiku, "...その他")){
		shiku = window.prompt("市区名(のみ)を入力してください", "");
		if (shiku.length == 0) return;
        var tag = document.getElementById("prefPop").value;
        _selectedAddress = shiku;
        // todoufuken を登録
        // 選択アイテムが存在しなければ登録、存在すれば頻度をインクリメント
        NRPutMenu(owner(), tag, shiku, 1, "", got_CITY);
	} else {
        NRGetMenu(owner(), shiku, got_VILLAGE);
    }
}

function got_CITY(answer){
	var obj = JSON.parse(answer);
    var todoufuken = document.getElementById("prefPop").value;
    
    if (todoufuken.length == 0){
        return; // 市区のポップアップメニューを表示しない
    } else {
        var menuItems = [""]; // 最初に空メニューを入れておく
        for (num in obj){
            var rec = obj[num];
            menuItems.push(rec.menu); // メニューアイテム
        }
        menuItems.push("...その他");
    }
    
	// 町村ポップアップを更新
    var elm = document.getElementById("_shiku");
    elm.innerHTML = "";
    var value = trim(document.getElementById(currentTag()+".text").value);
    var val = "";
    if (value){
        var addressArray = value.split(" ");
        val = addressArray[1];
    }
    
    var pu = makePopupMenu(elm, "cityPop", menuItems, val);
    // 市区 が変更されたら 町村 のメニューを取り寄せる
    pu.setAttribute("onchange", "get_VILLAGE(this)");
    get_VILLAGE(pu);
}
function get_CITY(elm){
    // 市区のポップアップを設定
    var todoufuken = elm.value;
	if (isSame(todoufuken, "...その他")){
		todoufuken = window.prompt("都道府県名(のみ)を入力してください", "");
		if (todoufuken.length == 0) return;
        _selectedAddress = todoufuken;
        // todoufuken を登録
        // 選択アイテムが存在しなければ登録、存在すれば頻度をインクリメント
        NRPutMenu(owner(), "都道府県", todoufuken, 1, "", got_CITY);
	} else {
        NRGetMenu(owner(), todoufuken, got_CITY);
    }
}

///// ADRESS ///////////////////////////////
/////////////////////////////////////////////

/////////////////////////////////////////////////
///// GROUP_MENU ////////////////////////////////

var _group_tag;
function set_groupTag(tag){
    //showToolMessage("set_groupTag-> "+status);
    _group_tag = tag;
}
function groupTag(){
//function groupEditor_open(){
    // グループ・メニューのサブ・エディターが開いていれば true を返す
    return _group_tag;
}

function groupPopup_changed(elm){
    // グループ・メニューの選択内容が変更された
    var item = elm.value;
	if (isSame(item, "...その他")){
        // グループ・メニューに新しい項目を追加
        window.open("groupMenuEditor.php", "tools"); // CELL PREFERENCE
	} else {
        // freq = "" なら、使用されたメニュー項目の頻度を increment
        NRPutGroupMenu(owner(), item, "", null);
    }
}

function closed_groupSubEditor(answer){
    // 全てのサブ・エディターを閉じサーバの保存内容を表示
    var obj = JSON.parse(answer);
    
    set_groupTag(null);
    
    // 各欄にグループ・メニュー内容を追加
    var array = layoutArray(_progress);
    for (num in array){
        var layoutObj = array[num];
        
        // 非表示セルはスキップ
        if (layoutObj.hitAndRun * 1) continue;
        
        var tag = layoutObj.tag;
        
        // Editor を削除し value エリアを通常表示にする
        var val = (obj[tag]) ? obj[tag] : "";
        setValueForStructure(currentDate(), tag, val);
        show_cell_value(currentDate(), tag);
    }
}
function close_groupSubEditor(needSave){
    // subEditor を閉じる：needSave が true なら変更内容を保存してから閉じる
    if (groupTag()){
        // サブ・エディターが開いているなら
        setEditorId(null);
        set_groupTag(null);
        var array = progressTagArray();
        
        if (needSave){
            var container = new Object();
            for (num in array){
                var tag = array[num];
                var node = document.getElementById(tag + ".text");
                
                // 非表示セルはスキップ
                if (!node) continue;
                
                // 内容に変更あれば container に取り込む
                var oldVal = cell_value(currentDate(), tag);
                var newVal = document.getElementById(tag + ".text").innerHTML;
                if (oldVal != newVal){
                    newVal = seeAsNOAFormat(newVal);
                    container[tag] = newVal; // 変更されたデータ
                }
            }
            
            // 変更内容をサーバへ送る：saved_editor() でサーバから結果を CELL へ書き戻す
            NRPutPage(owner(),patient_id(),currentDate(),timeLimit(),container,closed_groupSubEditor);
        } else {
            // 全ての欄の表示を編集前に戻す
            for (num in array){
                var tag = array[num];
                var node = document.getElementById(tag + ".text");
                
                // 非表示セルはスキップ
                if (!node) continue;
                
                // Editor を削除し value エリアを通常表示にする
                show_cell_value(currentDate(), tag);
            }
        }
        setCurrentTag(null);
    } else {
        // グループ・メニューのあるエディターだけが開いているなら
        close_and_save_editor(needSave); // 何もせずエディターを閉じる
    }
}

function inserted_groupMenuItems(answer){
	// グループメニューのテンプレートを各フィールドに挿入
    //alert("inserted_groupMenuItems->"+answer); //##
    var obj = JSON.parse(answer);
    
    _debug("inserted_groupMenuItems->"+encodeObject(obj)); //##
    _debug("currentTag->"+currentTag()); //##
    
    // 各編集フィールドにメニュー内容を追加し、それを save する
    var array = layoutArray(_progress);
    for (num in array){
        var layoutObj = array[num];
        _debug("layoutObj->"+encodeObject(layoutObj)); //##
        
        // 非表示セルはスキップ
        if (layoutObj.hitAndRun * 1) continue;
        
        var tag = layoutObj.tag;
        var ary = tag.split('.');
        var fieldName = ary[1];
        var menuItem = (obj[fieldName]) ? obj[fieldName] : "";
        _debug("tag->"+tag+" menuItem->"+menuItem); //##
        
        if (tag == currentTag()){
            // tag の編集フィールド内データに menuItem を挿入
            var elm = document.getElementById(tag + ".text");
            elm.innerHTML = addGroupItem(tag, elm.innerHTML, menuItem);
        } else {
            _debug("will showSubEditor"); //##
            // tag に相当する cell.value に menuItem を挿入
            var rec = valueForStructure(date, tag);
            var value = (rec.value) ? rec.value : "";
            _debug("value->"+value); //##

            showSubEditor(tag, value, menuItem);
        }
    }
    set_groupTag(currentTag());
    
    function addGroupItem(tag, cVal, mVal){
        // 元々の値にグループ・メニューの値を加える
        // mVal の改行を <br> に変換し、文字列前後の <br> を取り去る
        mVal = convertSTRING(mVal, "\n", "<br>");
        mVal = trim(mVal); // mVal 前後の改行や空白を取り去る
        
        // tag の値である cValue にメニュー・アイテムの文字列を追加
        cVal = convertSTRING(cVal, "\n", "<br>");
        cVal = trim(cVal); // cVal 前後の改行や空白を取り去る
        
        if (tag == "ProgressSection.subject"){
			// 入力欄に存在する #problemNumber の最大値のひとつ上の値
			// を付した #problemNumber で template を文頭に挿入
            // ### maxNum() には cVal が '\n' で区切られていることが必要 ###
            mVal = "#" + maxNum(cVal) + " " + mVal;
            
            // メニュー項目を先頭に挿入
            return (trim(cVal).length > 0) ? mVal + '<br>' + cVal : mVal;
        } else if (tag == "ProgressSection.disease"){
            var array = new Array();
            var ary = mVal.split('<br>');
            for (num in ary)
                array.push(modifyItem(tag, ary[num]));
            mVal = array.join('<br>');
            cVal = (cVal.length > 0) ? convertSTRING(cVal, '\n', "<br>") : "";
            
            // メニュー項目を末尾に追加
            return (trim(cVal).length > 0) ? cVal + '<br>' + mVal : mVal;
        } else {
            cVal = (cVal.length > 0) ? convertSTRING(cVal, '\n', "<br>") : "";
            
            // メニュー項目を末尾に追加
            return (trim(cVal).length > 0) ? cVal + '<br>' + mVal : mVal;
        }
        
        function maxNum(doc){
            // 各行をチェックして最大番号を取り出す
            var array = doc.split("#"), max=0;
            for (i in array){
                var ln = array[i];
                var ary = ln.split(" ");
                num = ary[0] * 1;
                if (num > max) max = num;
            }
            return max + 1;
        }
    }
    
    function showSubEditor(tag, orgVal, val){
        // GROUP MENU により従属するフィールドの CELL EDITOR を開く
        var elm = document.getElementById(currentDate() + "_" + tag);
        elm.innerHTML = "";
        var div = newDIV(elm, "");
        div.style.padding = "0px 5px";
        div.style.backgroundColor = "#ffd";
        
        // TEXT
        var dv = newDIV(div, tag + ".text");
        dv.style.padding = "3px 5px";
        dv.style.backgroundColor = "#fff";
        dv.innerHTML = addGroupItem(tag, orgVal, val);
        dv.contentEditable = true; // TEXT を編集可能状態にする
    }
}
function insert_groupItems(){
	// グループメニューのクリックによりテンプレート内容を各フィールドに挿入
	// グループメニューの頻度をインクリメント
	var item = document.getElementById("menuPop").value;

    _initDebug(true); //##
    _debug("insert_groupItems->"+item); //##

	NRGetGroupMenuItems(owner(), item, inserted_groupMenuItems);
}

///// GROUP_MENU ////////////////////////////////
/////////////////////////////////////////////////

/////////////////////////////////////////////////
///// GROUP_TEMPLATE ////////////////////////////

function set_groupTemplates(answer){
    // グループ・テンプレートのメニューを更新しテンプレートを再表示
    setGroupTemplates(answer);
    show_groupTemplates();
}

function added_groupTemplate(answer){
    // 更新されたメニューを再表示
	NRGetMenu(owner(), _templateTag, set_groupTemplates);
}
function add_groupTemplate(){
	// テンプレート規定値を追加
    var title = window.prompt("この入力値セットのタイトルをつけてください", "");
    if (!title) return;
    
    // メニューに対応するオブジェクトに各欄の値を入れ、それを save する
    var obj = new Object();
    var array = layoutArray(_progress);
    for (num in array){
        var layoutObj = array[num];
        
        // 非表示セルはスキップ
        if (layoutObj.hitAndRun * 1) continue;
        
        // グループ・メニューのある CELL はスキップ
        if (currentTag() == layoutObj.tag) continue;

        var rec = valueForStructure(currentDate(), layoutObj.tag);
        if (rec){
            // 過去が透けて見えるセルはスキップ
            if (rec.isPast) continue;
            if (!rec.value) continue;
            
            obj[layoutObj.tag] = rec.value;
        }
    }
    
    var val = encodeSTRING(encodeObject(obj));
    NRPutMenu(owner(), _templateTag, title, "", val, added_groupTemplate);
}

function removed_groupTemplate(answer){
    // 更新されたメニューを再表示
	NRGetMenu(owner(), _templateTag, set_groupTemplates);
}
function remove_groupTemplate(label){
    // label に対応するメニューを削除
    if (confirm("「" + label + "」メニューを削除します")){
        NRRemoveMenu(owner(), _templateTag, label, removed_groupTemplate);
    }
}

function show_afterTemplate(answer){
    // テンプレート処理後のページを再表示
    var obj = JSON.parse(answer);
    var entryDate = currentDate();
    
    // structure() を新しいページで更新しておく：でないと再表示でおかしな表示が出る
    var rec = new Object();
    for (tag in obj){
        var value = obj[tag];
        if (hasPast(value)) value = "";

        setValueForStructure(entryDate, tag, value);
    }

    // entryDate のページを再表示
    show_page(entryDate);

    // テンプレートを起動した CellEditor を再度開く
    show_editor();
}
function selected_groupTemplate(answer){
    setEditorId(null);
    closeFloatPanel();
    
    var tags = progressTagArray().join(",");
    NRGetPage(owner(),patient_id(),currentDate(), "", tags, show_afterTemplate);
}
function select_groupTemplate(elm){
    // テンプレート・メニューが選択された
    var title = elm.innerText;
    
    if (title == "...その他"){
        add_groupTemplate();
    } else {
        // 選択されたテンプレートで各フィールドを上書きする
        var rec = groupTemplateObjectForTitle(title);
        if (rec){
            if (rec.value){
                // 選択されたメニュー内容で各欄を上書きする
                var obj = decodeObject(rec.value);
                
                // 各欄の value 中の '(',')' が表示時 object に展開されないよう encode
                var rec = new Object();
                for (tag in obj){
                    var val = obj[tag];
                    if (typeof(val) == "object"){
                        val = encodeObject(val); // object を文字列にする
                        val = encodeValue(val); // '(',')' を encode
                    }
                    rec[tag] = val;
                }
                //alert("select_groupTemplate->"+encodeObject(rec)); //##
                
                NRPutPage(owner(), patient_id(), currentDate(), timeLimit(), rec, selected_groupTemplate);
            } else {
                // テンプレートの内容がなかったので table のみで field のない tag を指定
                // これは currentDate の table の field データすべてを削除する指令となる
                var rec = new Object();
                rec['ProgressSection'] = "";
                NRPutPage(owner(), patient_id(), currentDate(), timeLimit(), rec, selected_groupTemplate);
            }
        } else {
            alert(title + " に対応するメニュー・オブジェクトがありません");
        }
    }
}

function show_groupTemplates(){
    // テンプレート・パネルにメニューを表示
    var obj = groupTemplates();
    var templates = new Array();
    templates = templates.concat(obj);
    var rec = new Object();
    rec.menu = "...その他";
    templates.push(rec);
    
    var elm = document.getElementById("groupTemplateMenuArea");
    elm.innerHTML = "";
    elm.style.padding = "5px 5px 0 5px";
    elm.style.fontSize = "9pt";
    
    var action = "select_groupTemplate(this)";
    for (num in templates){
        var rec = templates[num];
        
        var div = newDIV(elm, "/clearfix");
        // --- LEFT ---
        var dv = newDIV(div, "/left-side");
        dv.style.padding = "2px 0px";
        dv.style.width = "80%";
        var bt = newDIV(dv, "/blueButton");
        bt.innerHTML = rec.menu;
        bt.setAttribute("onclick", action);
        // --- RIGHT ---
        var dv = newDIV(div, "/right-side");
        dv.style.padding = "2px 0px";
        if (num < templates.length - 1){
            var img = newIMAGE(dv, "icon", "./remove-field.png", "X");
            var act = "remove_groupTemplate('" + rec.menu + "')";
            img.setAttribute("onclick", act);
        }
    }
}
function show_groupTemplatePanel(button){
    // テンプレートを各欄に挿入
    var pos = getPosition(button);
    var w = 150;
	var x = pos.x - w + 10; // 表示するx座標
	var y = pos.y; // 表示するy座標
    var elm = openSeeThroughPanel("_floatPanel", x, y, w);
    var div = newDIV(elm, "groupTemplateMenuArea");
    
    show_groupTemplates();
}

///// GROUP_TEMPLATE ////////////////////////////
/////////////////////////////////////////////////


/////////////////////////////////////////////////
///// 周辺ツール //////////////////////////////////

function open_gestateCalendar(){
    // 妊娠歴を開く
    var url = encodeSTRING("../../ReproductiveHistory?elementId=" + currentTag() + ".text");
	var win = window.open(url ,"tools"
						  ,"width=330,height=900,scrollbars=yes,resizable=yes");
	win.focus();
}

///// 周辺ツール //////////////////////////////////
/////////////////////////////////////////////////



function open_cellPreference(){
    // tag の CELL 属性編集パネルを開く
	window.open("cellPreference.php?tag=" + currentTag(), "tools");
}

function decode_imageLink(buff){
    // 表示用に変換された openImage() の入ったイメージ・アンカーを <IMG:url> 形式に戻す
    if (buff.indexOf("openImage(") < 0) return buff;

    var array = buff.split("<a onclick=");
    if (array.length == 1) return buff;
    
    var results = new Array();
    for (num in array){
        var st = array[num];
        if (num * 1 == 0){
            results.push(st);
        } else {
            // <a onclick=openImage()...>foo<img src=url height=20px>bar</a>
            var fromPos = st.indexOf(">");
            var toPos = st.lastIndexOf("</a>");
            // anchorContents = "foo<img src=url height=20px>bar"
            var anchorContents = st.substr(fromPos + 1, toPos - fromPos - 1);
            
            var ary = anchorContents.split("<img ");
            var beforImage = ary[0];
            // beforImage = "foo"
            results.push(beforImage);
            
            if (ary.length > 1){
                // ary[1] = "src=url height=20px>bar"
                var toPos = ary[1].indexOf(">");
                // imageContents = "src=url height=20px"
                var imageContents = ary[1].substr(0, toPos);
                var ary2 = imageContents.split(" "); // ary2[0] = "src=url"
                var ary3 = ary2[0].split("=");
                if (ary3.length > 1){
                    var url = trimQuotation(ary3[1]);
                    results.push("<IMG:" + url + ">"); // ary3[1] = "url"
                }
                
                // lest = "bar"
                var afterImage = ary[1].substr(toPos + 1);
                results.push(afterImage);
            }
            
            var toPos = st.lastIndexOf("</a>");
            if (toPos >=0){
                // st = "after"
                st = st.substr(toPos + 4);
                results.push(st);
            }
        }
    }
    return results.join("");
}

function _showAlert(msg){
    // debug 用のメッセージを表示
    document.getElementById("alertArea").innerHTML = msg;
}

var _saveDate;
var _saveTag;
function getUpdatedValue(){
    // サーバで更新された値を CELL へ書き戻す
    var obj = new Object();
    obj.owner = owner();
    obj.patientId = patient_id();
    obj.hospitalId = hospitalId();
    obj.currentDate = _saveDate;
    obj.tags = _saveTag;
    
    var str = encodeObject(obj);
    
    document.getElementById("alertArea").innerHTML = "";
    
    // ワーカーを起動しバックグラウンドで処理
    var worker = new Worker('getValue.js'); // /POLLING/getValue.js
    worker.postMessage(encodeSTRING(str)); // Send data to our worker.
    
    worker.onmessage = function (event) {
        // Worker からのメッセージを受け取る
        var value = event.data;
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            var obj = JSON.parse(array[1]);
            
            for (tag in obj){
                var rec = obj[tag];
                
                // サーバから受け取った更新値で noaStructure() を更新
                setValueForStructure(rec.entryDate, tag, rec.value);
                
                // value エリアを通常表示にする
                show_cell_value(rec.entryDate, tag);
            }
		}
    }
}
function save_editor(){
    // 編集内容を保存しエディターを閉じる
    _saveDate = currentDate(); // 処理途中で変更される可能性あるので一時記憶
    _saveTag = currentTag(); // 処理途中で変更される可能性あるので一時記憶

    // 編集内容が更新されていれば保存
    var oldVal = cell_value(currentDate(), currentTag());
    oldVal = htmlForValue(oldVal); // 比較のため editor 表示形式にする
    var newVal = document.getElementById(currentTag() + ".text").innerHTML; // 文章

    if (oldVal != newVal){
        // 編集画面の値が以前の CELL の値と異なるならサーバへ保存
        var st = "==== save_editor: old<br>"+oldVal+"<br>==== new<br>"+newVal;
        _showAlert(st);

        if (currentTag() == "ProgressSection.object"){
            // val にイメージデータがペーストされた場合 < > を実データに変換
            newVal = replaceAll(newVal, "&lt;", "<");
            newVal = replaceAll(newVal, "&gt;", "/>");
            
            // val 中に表示用イメージ・アンカーがあった場合、元の保存形式に戻す
            newVal = decode_imageLink(newVal);
        }
        
        // HTML 型式の改行やスペースを '\n',' ' へ変換
        newVal = seeAsNOAFormat(newVal);

        // 変更内容をサーバへ送る：saved_editor() でサーバから結果を CELL へ書き戻す
        var array = new Object();
        array[currentTag()] = newVal; // 編集されたデータ
        NRPutPage(owner(),patient_id(),currentDate(),timeLimit(),array);

        // すぐ起動するとまだ DB の更新が行われていない可能性があるのでタイマーで起動
        setTimeout("getUpdatedValue()", 1000);
    } else {
        document.getElementById("_debug").innerHTML = "";
    }
}

function save_and_jump(){
    // 編集内容を保存し次欄のエディターを開く
    // close_and_save_editor() で currentTag() が null になる前に記憶
    var _curerntTag = currentTag();
    // 編集内容を保存しエディターを閉じる
    close_and_save_editor(true);
    
    // 次欄のエディターを開く
    var ntag = nextTag(_curerntTag);
    if (ntag){
        setCurrentTag(ntag);
        
        var field = fieldForTag(ntag);
        if (field.menuType * 1 == _none_){
            // メニュー無しなら直ちに CellEditor を開く
            show_editor();
        } else if (menuForTag(ntag)){ // menu が記憶されていれば直ちに CellEditor を開く
            show_editor();
        } else { // tag 用 menu が記憶されていなければ DB から取り寄せ CellEditor を開く
            NRGetMenu(owner(), ntag, got_menu);
        }
    } else {
        showFadeoutInfo("alertArea", _curerntTag + " の次の欄はありません", 800);
    }
    
    function nextTag(targetTag){
        // targetTag の次の tag を返す
        var found = false;
        var array = layoutArray(_progress);
        
        for (num in array){
            var rec = array[num];
            
            if (rec.hitAndRun * 1 > 0) continue; // 不可視欄はスキップ
            if (found) return rec.tag;
            if (rec.tag == targetTag) found = true;
        }
        return null;
    }
}

function remove_value(){
    // 編集内容を空にする
    var elm = document.getElementById(currentTag() + ".text");
    elm.innerHTML = " ";
    elm.focus();
}

function cleard_value(answer){
    //alert(answer); //##
    var obj = JSON.parse(answer);
    setCurrentTag(null);
    
    // カルテを再表示
    open_chart(obj.patientId, patientKanjiName());
}
function clear_value(){
    // 編集内容を削除し前回受診時の記述が透けて見えるようにする
    var elm = document.getElementById(currentTag() + ".text");
    elm.innerHTML = "";
    
    var container = new Object();
    container[currentTag()] = "";
    NRPutPage(owner(),patient_id(),currentDate(),timeLimit(),container,cleard_value);
}

function check_keyUp(tag){
    // CTRL-j が入力されたら saveJumpEditor() を実行
    if (! arrowKeyJump()) return;
    
    if (window.event.ctrlKey){
        if (window.event.keyCode == 74){ // CTRL-J
            save_and_jump();
        }
    }
}

function close_and_save_editor(doSave){
    // エディターを閉じて通常表示にする
    if (doSave)
        save_editor();
    
    // value エリアを通常表示にする
    show_cell_value(currentDate(), currentTag());
    
    // 再度このエディターを開けるようにするため currentTag() を null にしておく
    setCurrentTag(null);
}
function show_editor(value){
    // CELL エディターを生成
    // elm: CELL VALUE 表示エレメント
    var elm = document.getElementById(currentDate() + "_" + currentTag());
    var obj = valueForStructure(currentDate(), currentTag());
    
    var field = fieldForTag(currentTag());
    if (field.disabled > 0){
        alert("この欄は参照のみで編集はできません");
        setCurrentTag(null);
        return;
    }
    elm.innerHTML = "";
    
    // === EDITOR の背景を生成 ===============
    var editorBase = newDIV(elm, "");
    editorBase.style.backgroundColor = "#ffd";
    editorBase.style.padding = "5px 5px";

    // === HEADER ==========================
    var div = newDIV(editorBase, "/clearfix");
    // === LEFT SIDE ==========
    var dv = newDIV(div, "/left-side", "");
    dv.style.paddingBottom = "7px";
    dv.style.width = "70%";
    // REMOVE ICON
    var sp = newSPAN(dv, "removeFieldTip");
    sp.style.paddingRight = "8px";
    setInfoTip("removeFieldTip", "空欄にする"); // HELP
    var img = newIMAGE(sp, "", "./remove-field.png", "X");
    img.style.height = "12px";
    img.setAttribute("onclick", "remove_value()");
    // CLEAR ICON
    var sp = newSPAN(dv, "clearFieldTip");
    sp.style.paddingRight = "8px";
    setInfoTip("clearFieldTip", "前回記述が透けて見えるようにする"); // HELP
    var img = newIMAGE(sp, "", "./selection.png", "X");
    img.style.height = "12px";
    img.setAttribute("onclick", "clear_value()");
    // グループ・メニューならテンプレート・アイコン
    if (field.menuType == _group_){
        var sp = newSPAN(dv, "template");
        sp.style.paddingRight = "8px";
        setInfoTip("template", "テンプレートを挿入"); // HELP
        var img = newIMAGE(sp, "icon", "./menu.png", "+");
        img.setAttribute("onclick", "show_groupTemplatePanel(this)");
        img.style.height = "10px";
    }
    // POPUP MENU
    var sp = newSPAN(dv, "menuArea");
    sp.style.paddingRight = "8px";
    
    // === RIGHT SIDE ===========
    var dv = newDIV(div, "/right-side", "");
    dv.style.verticalAlign = "top";
    if (currentTag() == "ProgressSection.subject"){
        // 「GestateCalendar」アイコン
        var obj = valueForStructure(currentDate(), currentTag());
        if (obj.value){
            // 文中に "lmp:" 文字列があれば「妊娠歴アンカー」を表示
            var array = obj.value.split("lmp:");
            if (array.length > 1){
                var sp = newSPAN(dv, " ");
                sp.style.fontSize = "9pt";
                sp.style.paddingRight = "10px";
                var a = newA(sp, "妊娠歴", "#", "");
                a.setAttribute("onclick", "open_gestateCalendar()");
            }
        }
    } else if (currentTag() == "ProgressSection.object"){
        // 「画像読込ツール」アイコン
        var sp = newSPAN(dv, "pictTip");
        sp.style.paddingRight = "10px";
        setInfoTip("pictTip", "画像読込"); // HELP
        var img = newIMAGE(sp, "", "./camera.png", "pict");
        img.style.height = "20px";
        img.setAttribute("onclick", "openPictureTool()");
        img.style.verticalAlign = "bottom";
    }
    // PREFERENCE ICON
    var sp = newSPAN(dv, "fieldPrefTip");
    setInfoTip("fieldPrefTip", "初期設定"); // HELP
    var img = newIMAGE(sp, "", "./hammer.png", "X");
    img.style.height = "15px";
    img.setAttribute("onclick", "open_cellPreference()"); // ### 工事中 ###
    // HELP ICON
    var sp = newSPAN(dv, "helpTip");
    setInfoTip("helpTip", "HELP"); // HELP
    sp.style.paddingLeft = "2px";
    var img = newIMAGE(sp, "", "./Help.png", "help");
    img.style.height = "16px";
    img.setAttribute("onclick", "cellEditorHelp('" + field.menuType * 1 + "')");
    
    var dv = newDIV(editorBase, "panelMenuArea");
    
    // === BODY ==================================
    var dv = newDIV(editorBase, currentTag() + ".text");
    dv.setAttribute("class", "editorField");
    var val = (value) ? value : cell_value(currentDate(), currentTag());
//    alert("value->"+htmlForValue(val)); //##
    dv.innerHTML = htmlForValue(val);
//    alert("dv.innerHTML->"+dv.innerHTML); //##

    dv.contentEditable = true; // TEXT を編集可能状態にする
    dv.setAttribute("onkeyup", "check_keyUp('" + currentTag() + "')");
    // HTML5：node 末尾を選択
    var sel = window.getSelection();
    sel.selectAllChildren(dv);
    sel.collapseToEnd(); // 文末にカーソルを置く: node ではうまく機能しない
    
    // FOOTER ====================================
    var div = newDIV(editorBase, "");
    var dv = newDIV(div, "");
    dv.style.textAlign = "right";
    dv.style.paddingTop = "7px";
    dv.style.paddingRight = "5px";
    
    if (field.menuType == _group_){
        // グループ・メニューの とりやめボタン
        var bt = newDIV(dv, "/whiteButton");
        bt.innerHTML = "とりやめ";
        bt.setAttribute("onclick", "close_groupSubEditor()");
        // グループ・メニューの確定ボタン
        var bt = newDIV(dv, "/whiteButton");
        bt.innerHTML = " 確定 ";
        bt.setAttribute("onclick", "close_groupSubEditor(true)");
    } else {
        // 通常のメニューの確定ボタン
        var bt = newDIV(dv, "/whiteButton");
        bt.innerHTML = "とりやめ";
        bt.setAttribute("onclick", "close_and_save_editor()");
        var bt = newDIV(dv, "/whiteButton");
        bt.innerHTML = " 確定 ";
        bt.setAttribute("onclick", "close_and_save_editor(true)");
        var bt = newDIV(dv, "/whiteButton");
        bt.innerHTML = " 確定し次欄へ ";
        bt.setAttribute("onclick", "save_and_jump()");
    }
    
    // ポップアップメニューなどを生成
    show_menu(field.menuType * 1, currentTag());
    
	if (field.editor){
        // field.editor が設定されていれば tools エリアに開く
		eval( field.editor + '()');
    }
}

function close_warm_and_open_cell(entryDate, tag){
    // 警告ペーンを閉じて、チェックボックスを「編集可」状態にし CELL エディターを開く
    closeWarm();
    removeCheck(); // 編集不可のチェックをはずす
    
    open_editor(entryDate, tag);
}

function got_menu(answer){
    // メニュー属性をサーバから受け取り CELL に設定
    // obj=[{"menu":"下腹痛","value":"","public":"","freq":"55","menu":"下腹痛"},,,]
    // obj は freq で降順ソートされている
    // メニューデータ obj は記憶せず使い捨て
    var obj = JSON.parse(answer);
    var menus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length)
            menus.push(rec.menu);
    }
    menus.push("...その他");
    
    setMenuForTag(menus, currentTag()); // メニューを記憶
    show_editor(); // CellEditor を開く
}
function open_editor(dateTime, tag, value){
    // CELL EDITOR を開く：value があれば cell.htmlValue でなく value を編集内容とする
    if (groupTag() && (groupTag() != tag)){
        showFadeoutInfo("alertArea", "グループ・メニュー操作中は使えません", 800);
        return;
    }
    
    var _currentTag = currentTag(); // close_and_save_editor() で null になる前に記憶
    if (currentTag())
        close_and_save_editor(true); // 開いていた CELL があれば閉じる
    
    if ((dateTime == currentDate()) && (tag == _currentTag)){
        // いま閉じた CELL と同じ CELL なので、何もせず対象 tag を消去
        setCurrentTag(null);
    } else {
        var el = document.getElementById("_alerm");
        if (isSameDate(dateTime, currentDate()) == 0){
            alert(dateTime + " の日付をクリックし アクティブにしてからやり直してください");
            return;
        } else if (el.style.visibility == "visible"){
            // すでに警告パネルが開いているなら警告パネルを閉じるだけで終了
            closeWarm();
            return;
        } else if (isReadOnly()){
            // readOnly モードなら警告パネルを開くだけで終了
            var node = document.getElementById(dateTime+"_"+tag);
            var pos = getPosition(node);
            var y = pos.y + 20;
            openWarm("close_warm_and_open_cell('" + dateTime+"','"+tag + "')", y);
            return;
        }
        
        // dateTime のページを白い背景に、以前のページをグレイの背景にする
        var tr = document.getElementById(currentDate() + ".pageFrame");
        if (tr) tr.style.backgroundColor = "#ddd"; // 過去ページ
        var tr = document.getElementById(dateTime + ".pageFrame");
        tr.style.backgroundColor = "#fff";

        // いま閉じた CELL が開こうとした CELL と異なるので新たにエディターを開く
        setCurrentDate(dateTime);
        setCurrentTag(tag);
        var field = fieldForTag(tag);
        if (field.menuType * 1 == _none_){
            // メニュー無しなら直ちに CellEditor を開く
            show_editor();
        } else if (menuForTag(tag)){ // menu が記憶されていれば直ちに CellEditor を開く
            show_editor(value);
        } else { // tag 用 menu が記憶されていなければ DB から取り寄せ CellEditor を開く
            NRGetMenu(owner(), tag, got_menu);
        }
    }
}
