
function remakePrefixMenus(){
    // 接頭語リストを再表示
    var elm = document.getElementById("prefixPopArea");
    elm.innerHTML = "";
    
    var pu = makePopupMenu(elm, "prefixPop", prefixMenus(), "");
    pu.setAttribute("onchange", "prefixPopupChanged(this)");
}
function addedPrefixMenu(answer){
   var obj = JSON.parse(answer);
    setPrefixMenus(obj);
    
    // 接頭語リストを再表示
    remakePrefixMenus();
}
function addPrefixMenu(){
    // 接頭語メニューに item を新規追加
    var item = prompt("新規に追加するメニュー項目");
    if (item.length > 0){
        // item をサーバへ登録するために incrementFrequency() を使う
        NRPutMenu(owner(), _prefix, item, "", "", addedPrefixMenu);
    }
}

function removedPrefixMenu(answer){
    var obj = JSON.parse(answer);
    setPrefixMenus(obj);
    
    // 接頭語リストを再表示
    remakePrefixMenus();
}
function removePrefixMenu(){
    // 選択された接頭語をメニューから削除
    var item = document.getElementById("prefixPop").value;
    
    if (item == "") return;
    if (item == "...その他") return;
    if (confirm(item + " をメニューから削除していいですか"))
        NRRemoveMenu(owner(), _prefix, item, removedPrefixMenu);
}

function remakeSuffixMenus(){
    // 接尾語リストを再表示
    var elm = document.getElementById("suffixPopArea");
    elm.innerHTML = "";
    
    var pu = makePopupMenu(elm, "suffixPop", suffixMenus(), "");
    pu.setAttribute("onchange", "suffixPopupChanged(this)");
}
function addedSuffixMenu(answer){
    var obj = JSON.parse(answer);
    setSuffixMenus(obj);
    
    // 接尾語リストを再表示
    remakeSuffixMenus();
}
function addSuffixMenu(){
    // 接尾語メニューに item を新規追加
    var item = prompt("新規に追加するメニュー項目");
    if (item.length > 0){
        // item をサーバへ登録するために incrementFrequency() を使う
        NRPutMenu(owner(), _suffix, item, "", "", addedSuffixMenu);
    }
}

function removedSuffixMenu(answer){
    var obj = JSON.parse(answer);
    setSuffixMenus(obj);
    
    // 接尾語リストを再表示
    remakeSuffixMenus();
}
function removeSuffixMenu(){
    // 選択された接尾語をメニューから削除
    var item = document.getElementById("suffixPop").value;
    
    if (item == "") return;
    if (item == "...その他") return;
    if (confirm(item + " をメニューから削除していいですか"))
        NRRemoveMenu(owner(), _suffix, item, removedSuffixMenu);
}

function remakeMenus(){
    // 病名リストを再表示
    var elm = document.getElementById("menuPopArea");
    elm.innerHTML = "";
    
    var pu = makePopupMenu(elm, "namePop", menus(), "");
    pu.setAttribute("onchange", "popupChanged(this)");
}
function addedMenu(answer){
    var obj = JSON.parse(answer);
    setMenus(obj);
    
    // 病名リストを再表示
    remakeMenus();
}
function addMenu(){
    // 病名メニューに item を新規追加
    var item = prompt("新規に追加するメニュー項目");
    if (item.length > 0){
        // item をサーバへ登録するために incrementFrequency() を使う
        NRPutMenu(owner(), "ProgressSection.disease", item, "", "", addedMenu);
    }
}

function removedMenu(answer){
    var obj = JSON.parse(answer);
    setMenus(obj);
    
    // 病名リストを再表示
    remakeMenus();
}
function removeMenu(){
    // 選択された病名をメニューから削除
    var item = document.getElementById("namePop").value;
    
    if (item == "") return;
    if (item == "...その他") return;
    if (confirm(item + " をメニューから削除していいですか"))
        NRRemoveMenu(owner(), "ProgressSection.disease", item, removedMenu);
}


function setDiseaseAt(row){
    // 編集パネルの結果を _disease へ反映させる
    var rec = _diseases[row];
    rec.start = shortDate(document.getElementById("start").value);
    rec.name = document.getElementById("name").value;
    rec.end = shortDate(document.getElementById("end").value);
    rec.conclusion = document.getElementById("conclusion").value;
    
    //alert("setDiseaseAt->"+encodeObject(rec)); //##
    
    // floatPanel を消しリスト内容を更新
    closeFloatPanel();
    makeDiseseRow();
}

function menuItems(menuArray, key){
    // メニュー・データを表示用にカスタマイズして返す
    var array = new Array();
    for (num in menuArray){
        var item = menuArray[num];
        // 絞り込みキーにマッチしないものはスキップ
        if (key && (item.indexOf(key) < 0)) continue;
        
        array.push(menuArray[num]);
    }
    return array;
}

function focusPressed(){
    // 絞り込みフィールドでキーが押される度に実行
    var elm = document.getElementById("menuPopArea");
    elm.innerHTML = "";
    
    var key = document.getElementById("focusF").value;
    var pu = makePopupMenu(elm, "namePop", menuItems(menus(), key), "");
    pu.setAttribute("onchange", "popupChanged(this)");
    popupChanged(pu);
}

function popupChanged(elm){
    // name ポップアップが変更された
    if (elm.value == "...その他"){
        addMenu();
    } else {
        var fd = document.getElementById("name");
        var name = fd.value;
        var array = name.split(" ");
        if (array.length >1){
            array[1] = elm.value;
            fd.value = array.join(" ");
        } else {
            fd.value = elm.value;
        }
    }
}
function prefixPopupChanged(elm){
    // 接頭語ポップアップが変更された
    if (elm.value == "...その他"){
        addPrefixMenu();
    } else {
        var fd = document.getElementById("name");
        var name = fd.value;
        var array = name.split(" ");
        if (array.length == 1){
            fd.value = elm.value + " ";
        } else {
            array.shift(); // 先頭の開始日を削除
            fd.value = elm.value + " " + array.join(" ");
        }
    }
}
function suffixPopupChanged(elm){
    // 接尾語ポップアップが変更された
    if (elm.value == "...その他"){
        addSuffixMenu();
    } else {
        var fd = document.getElementById("name");
        var name = fd.value;
        var array = name.split(" ");
        if (array.length > 2){
            array[2] = elm.value;
            fd.value = array.join(" ");
        } else {
            fd.value = name + " " + elm.value;
        }
    }
}

function openFloatEditor(targetElement, row){
    // 病名編集パネルを開く
    var pos = getPosition(targetElement);
    var x = 10;
    var y = pos.y + 25;
    var w = 280;
    var elm = openSeeThroughPanel("_floatPanel", x, y, w);
    elm.style.fontSize = "9pt";
    
    var rec = diseaseAt(row);
    var start = (rec) ? rec.start : shortDate(today());
    var names = (rec) ? rec.name : "";
    var end = (rec) ? rec.end : "";
    var conclusion = (rec) ? rec.conclusion : "";
    
    var ary = names.split(" ");
    var prefix = (ary.length > 1) ? ary[0] : "";
    var name = (ary.length > 1) ? ary[1] : names;
    var suffix = (ary.length > 2) ? ary[2] : "";
    
    // 開始日
    if (start == ""){
        var array = dateTimeArray(todayAndTime());
        var yyyy = array[0];
        var mm = array[1];
        var dd = array[2];
    } else {
        var yyyy = "20" + start.substr(0, 2);
        var mm = start.substr(2, 2);
        var dd = start.substr(4, 2);
    }
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "開始日 ";
    newDatePopUp(div, "start", "西暦", yyyy, mm, dd, false, null);
    
    // 病名接頭語 -------------
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "接頭語 ";
    var sp = newSPAN(div, "prefixPopArea");
    var pu = makePopupMenu(sp, "prefixPop", prefixMenus(), prefix);
    pu.setAttribute("onchange", "prefixPopupChanged(this)");
    // 削除アイコン
    var img = newIMAGE(div, "", "./remove-field.png", "remove");
    img.setAttribute("onclick", "removePrefixMenu()");
    img.style.height = "12px";
    img.style.marginLeft = "3px";
    img.style.position = "relative";
    img.style.top = "3px";
    // 病名 ---------------
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "病　名 ";
    var sp = newSPAN(div, "menuPopArea");
    var pu = makePopupMenu(sp, "namePop", menus(), name);
    pu.setAttribute("onchange", "popupChanged(this)");
    var fd = newFIELD(div, "focusF", "", 10, "");
    fd.setAttribute("placeholder", "絞込み"); // 入力ヒントを表示
    fd.setAttribute("onkeyup", "focusPressed()");
    // 削除アイコン
    var img = newIMAGE(div, "", "./remove-field.png", "remove");
    img.setAttribute("onclick", "removeMenu()");
    img.style.height = "12px";
    img.style.marginLeft = "3px";
    img.style.position = "relative";
    img.style.top = "3px";
    // 病名接尾語 -------------
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "接尾語 ";
    var sp = newSPAN(div, "suffixPopArea");
    var pu = makePopupMenu(sp, "suffixPop", suffixMenus(), suffix);
    pu.setAttribute("onchange", "suffixPopupChanged(this)");
    // 削除アイコン
    var img = newIMAGE(div, "", "./remove-field.png", "remove");
    img.setAttribute("onclick", "removeSuffixMenu()");
    img.style.height = "12px";
    img.style.marginLeft = "3px";
    img.style.position = "relative";
    img.style.top = "3px";
    // 病名欄 ---------------
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "　　　 ";
    var fd = newFIELD(div, "name", "", 40, names);
    
    // 終了日
    if (end == ""){
        // yyyy は start と同じ年を表示
        // mm は start と同じ月を表示
        var dd = 0;
    } else {
        var yyyy = "20" + end.substr(0, 2);
        var mm = end.substr(2, 2);
        var dd = end.substr(4, 2);
    }
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "終了日 ";
    newDatePopUp(div, "end", "西暦", yyyy, mm, dd, false, null);
    // 転帰
    var array = ["","治癒","中止",conclusion];
    var pu = makePopupMenu(div, "conclusion", array, conclusion);
    pu.style.marginLeft = "5px";
    
    // 確定ボタン
    var div = newDIV(elm, "");
    div.style.textAlign = "right";
    div.style.marginTop = "5px";
    var bt = newDIV(div, "/whiteButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "setDiseaseAt('" + row + "')");
}
