/*============================================================================*
 *  FILE: 
 *     windows.c
 *
 *  Description: 
 *     window control functions for NNsh.
 *
 *===========================================================================*/
#define WINDOWS_C

#include "local.h"

/*=========================================================================*/
/*   Function : NNsi_EraseRectangle                                        */
/*                                                    `̈NA */
/*=========================================================================*/
void NNsi_EraseRectangle(RectangleType *dimF)
{
    RectangleType area;

#ifdef USE_CLIE 
    // CLIEnC][ĥƂ́Â܂ܗ^ꂽ̈NA
    if (NNshGlobal->hrRef != 0)
    {
        area.topLeft.x  = dimF->topLeft.x;
        area.extent.x   = dimF->extent.x;
        area.extent.y   = dimF->extent.y;
        area.topLeft.y  = dimF->topLeft.y;
        HRWinEraseRectangle(NNshGlobal->hrRef, dimF, 0);
        return;
    }
#endif

#ifdef USE_HIGHDENSITY
    // 𑜓xɂ킹ď̈𒲐
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
        area.topLeft.x  = dimF->topLeft.x / 2;
        area.extent.x   = dimF->extent.x  / 2;
        area.extent.y   = dimF->extent.y  / 2;
        area.topLeft.y  = dimF->topLeft.y / 2;
        break;

      case kDensityTriple:
        area.topLeft.x  = dimF->topLeft.x / 3;
        area.extent.x   = dimF->extent.x  / 3;
        area.extent.y   = dimF->extent.y  / 3;
        area.topLeft.y  = dimF->topLeft.y / 3;
        break;

      case kDensityQuadruple:
        area.topLeft.x  = dimF->topLeft.x / 4;
        area.extent.x   = dimF->extent.x  / 4;
        area.extent.y   = dimF->extent.y  / 4;
        area.topLeft.y  = dimF->topLeft.y / 4;
        break;

      case kDensityOneAndAHalf:
        area.topLeft.x  = dimF->topLeft.x * 3 / 2;
        area.extent.x   = dimF->extent.x  * 3 / 2;
        area.extent.y   = dimF->extent.y  * 3 / 2;
        area.topLeft.y  = dimF->topLeft.y * 3 / 2;
        break;

      case kDensityLow:
      default:
        area.topLeft.x  = dimF->topLeft.x;
        area.extent.x   = dimF->extent.x;
        area.extent.y   = dimF->extent.y;
        area.topLeft.y  = dimF->topLeft.y;
        break;
    }
#else
    area.topLeft.x  = dimF->topLeft.x;
    area.extent.x   = dimF->extent.x;
    area.extent.y   = dimF->extent.y;
    area.topLeft.y  = dimF->topLeft.y;
#endif // #ifdef USE_HIGHDENSITY
    WinEraseRectangle(&area, 0);
    return;
}

/*=========================================================================*/
/*   Function : NNsi_UpdateRectangle                                       */
/*                                          `̈ƃtHg̏XV */
/*=========================================================================*/
void NNsi_UpdateRectangle(RectangleType *dimF, UInt16 fontType, UInt16 *fontID,
                         UInt16 *fontHeight, UInt16 *nlines)
{
    // tHg̐ݒ
#ifdef USE_CLIE
    if (NNshGlobal->hrRef != 0)
    {
        // PɂQ{ɂėǂ̂ȁH (ƂŌ...)
        dimF->extent.x   = dimF->extent.x  * 2;
        dimF->extent.y   = dimF->extent.y  * 2;
        dimF->topLeft.x  = dimF->topLeft.x * 2;
        dimF->topLeft.y  = dimF->topLeft.y * 2;

        // \̈NA
        // HRWinEraseRectangle(NNshGlobal->hrRef, dimF, 0);

        // tHg̐ݒ
        if (fontType == 0)
        {
            // CLIEnC][htHgłȂ΁A{𑜓xtHggp
            *fontID = HRFntSetFont(NNshGlobal->hrRef, 
                                   (NNshParam->currentFont + hrStdFont));
        }
        else
        {
            // `tHg̐ݒ
            *fontID = HRFntSetFont(NNshGlobal->hrRef, *fontID);
        }

        // CLIE NXȍ~ł́AtHg̍߂֐قȂ̂Œ
        if (NNshGlobal->hrVer < HR_VERSION_SUPPORT_FNTSIZE)
        {
            *fontHeight = FntCharHeight();
        }
        else
        {
            *fontHeight = HRFntCharHeight(NNshGlobal->hrRef);
        }
    }
    else
#endif
    {
        // `tHgݒ肷
        // WinEraseRectangle(dimF, 0);
        *fontID       = FntSetFont(*fontID);
        *fontHeight   = FntCharHeight();
    }

#ifdef USE_HIGHDENSITY
    // 𑜓xɂ킹ĕ`̈𒲐
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
        dimF->extent.x   = dimF->extent.x  * 2;
        dimF->extent.y   = dimF->extent.y  * 2;
        dimF->topLeft.x  = dimF->topLeft.x * 2;
        dimF->topLeft.y  = dimF->topLeft.y * 2;
        break;

      case kDensityTriple:
        dimF->extent.x   = dimF->extent.x  * 3;
        dimF->extent.y   = dimF->extent.y  * 3;
        dimF->topLeft.x  = dimF->topLeft.x * 3;
        dimF->topLeft.y  = dimF->topLeft.y * 3;
        break;

      case kDensityQuadruple:
        dimF->extent.x   = dimF->extent.x  * 4;
        dimF->extent.y   = dimF->extent.y  * 4;
        dimF->topLeft.x  = dimF->topLeft.x * 4;
        dimF->topLeft.y  = dimF->topLeft.y * 4;
        break;

      case kDensityOneAndAHalf:
        dimF->extent.x   = dimF->extent.x  * 3 / 2;
        dimF->extent.y   = dimF->extent.y  * 3 / 2;
        dimF->topLeft.x  = dimF->topLeft.x * 3 / 2;
        dimF->topLeft.y  = dimF->topLeft.y * 3 / 2;
        break;

      case kDensityLow:
      default:
        break;
    }
#endif    // #ifdef USE_HIGHDENSITY

    // 𑜓xɂ킹ĕ\\s(nlines)vZ
    *nlines = ((dimF->extent.y) / (*fontHeight));
    return;
}

/*=========================================================================*/
/*   Function : NNsi_FrmDrawForm                                           */
/*                                                        tH[̍ĕ` */
/*=========================================================================*/
void NNsi_FrmDrawForm(FormType *frm, Boolean redraw)
{
    UInt16     formId;
    FieldType *fldP;

    // ĕ`֎~ȂAȂ
    if (redraw == false)
    {
        return;
    }

    // nC]\[hꍇ́AɉʍXV
    if (NNshParam->useSonyTinyFont != 0)
    {
        // tH[̂hc擾
        formId = FrmGetActiveFormID();
        switch (formId)
        {
          case FRMID_MESSAGE:
            // `FbNOKAɂ
            break;

          case FRMID_THREAD:
          default:
            // XQƉʂłȂΔB
            goto FUNC_END;
        }

        // bZ[W\͔̈\ɂĉʂĕ`悷
        fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_MESSAGE));
        FldSetUsable(fldP, false);
        if (NNshGlobal->updateHR == NNSH_UPDATE_DISPLAY)
        {
            // CLIEŃVÑTCYύXꂽƂɂ͈UtH[
            FrmEraseForm(frm);
        }
        FrmDrawForm(frm);
        if (NNshGlobal->totalLine != 0)
        {
            // tB[h̕`(nC])
            NNsi_HRFldDrawField(fldP, false);

            // XN[o[̍XV
            NNsi_HRSclUpdate(FrmGetObjectPtr(frm, 
                             FrmGetObjectIndex(frm, SCLID_MESSAGE)));
        }
        return;
    }

FUNC_END:
    // tH[(ʂ)`悷
    FrmDrawForm(frm);

    // Xꗗ`悷
    NNsi_RedrawThreadList();

    return;
}

/*=========================================================================*/
/*   Function : NNsi_HRSclUpdate                                           */
/*                                      XN[o[̕`(nC]\) */
/*=========================================================================*/
void NNsi_HRSclUpdate(ScrollBarType *barP)
{
    SclSetScrollBar(barP, (NNshGlobal->currentPage + 1), 1,
                        (NNshGlobal->nofPage + 1), 1);
    return;
}

/*=========================================================================*/
/*   Function : NNsi_HRFldDrawField                                        */
/*                                          tB[h̕`(nC]\) */
/*=========================================================================*/
void NNsi_HRFldDrawField(FieldType *fldP, UInt16 isBottom)
{
    Char          *ptr,   *top;
    UInt16         fontID, lineLen, i, nlines, fontHeight = 0;
    Int16          len, line, startLine;
    MemHandle      txtH;
    RectangleType  dimF;

    // \̎擾
    txtH = FldGetTextHandle(fldP);
    if (txtH == 0)
    {
        // ̈擾Ɏs
        goto END_FUNC;
    }
    ptr  = MemHandleLock(txtH);
    if (ptr == NULL)
    {
        // ̈擾ɎsAʏ̃tB[h\ďI
        goto END_FUNC;
    }
    top = ptr;

    // tB[ḧ̗TCYĂ
    FldGetBounds(fldP, &dimF);

    // tB[h\ɂ
    FldReleaseFocus(fldP);
    FldSetUsable(fldP, false);

    // `̈ƃtHg̏A\\sXV
    fontID = NNshParam->sonyHRFont;
    NNsi_UpdateRectangle(&dimF, NNshParam->useSonyTinyFont,
                         &fontID, &fontHeight, &nlines);

    // \̈NA
    NNsi_EraseRectangle(&dimF);

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        // FntSetFont(NNshParam->sonyHRFont);   // UpdateRectangle()Ŏ{
        break;

      case kDensityLow:
      default:
        break;
    }
#endif    // #ifdef USE_HIGHDENSITY

    // \svZH
    if (NNshGlobal->totalLine == 0)
    {
#ifdef STRIP_MEANINGLESS_LINE
        /////// ʂ()󔒂鏈() ///////
        /////// (xCɂȂ̂ŁAƂ肠Rg) ///// 
        Char *tmpP;

        len  = StrLen(ptr);
        tmpP = ptr + len - 1;
            
        while ((len > 1)&&
               ((*tmpP == ' ')||(*tmpP == 0xd)||(*tmpP == 0xa)))
        {
            tmpP--;
            len--;
        }
        *(tmpP + 1) = NULL;
        lineLen = len;
        ///////// ʂ()󔒂鏈(܂) ///////
#else /// #ifdef STRIP_MEANINGLESS_LINE
        lineLen = StrLen(ptr);
#endif  /// #ifdef STRIP_MEANINGLESS_LINE

        NNshGlobal->currentPage = 0;
        NNshGlobal->prevHRLines = nlines;

#ifdef USE_CLIE
        // nC]`惂[hłACLIE NX̂Ƃ
        if ((NNshGlobal->hrRef != 0)&&
            (NNshGlobal->hrVer >= HR_VERSION_SUPPORT_FNTSIZE))
        {
            // \郁bZ[W̍s𐔂AgNumTotalLineɊi[
            while(lineLen > 0)
            {
                len = HRFntWordWrap(NNshGlobal->hrRef, ptr, dimF.extent.x);
                (NNshGlobal->totalLine)++;
                ptr = ptr + len;
                lineLen -= len;
            }
        }
        else
#endif
        {
            // \郁bZ[W̍s𐔂AgNumTotalLineɊi[
            while(lineLen > 0)
            {
                len = FntWordWrap(ptr, dimF.extent.x);
                (NNshGlobal->totalLine)++;
                ptr = ptr + len;
                lineLen -= len;
            }
        }

        // bZ[W̑y[WvZAnofPageɊi[
        // gpBBSIʂ玝ĂvZ@
        NNshGlobal->nofPage = ((NNshGlobal->totalLine) / (nlines - 1));
        if (NNshGlobal->nofPage != 0)
        {
            NNshGlobal->nofPage--;

            if (((NNshGlobal->totalLine) % (nlines - 1)) > 1)
            {
                //  XN[lƁA1y[WɎ(nlines - 1)s
                // \ł邪Aŏ̃y[W nliness\ł邽߁A
                // ̕lĂ܂y[W߂B
                (NNshGlobal->nofPage)++;
            }
        }
        ptr = top;
    }

    // bZ[W̍Ōォ\wꍇ
    if (isBottom != 0)
    {
        // X𖖔y[W\悤
        NNshGlobal->currentPage = NNshGlobal->nofPage;
        NNshGlobal->prevHRLines = nlines;
    }

    // \JnČvZ
    if (NNshGlobal->currentPage == 0)
    {
        // ŏ̃y[W
        startLine = 0;
    }
    else
    {
        // 2y[Wڈȍ~̌vZ
        startLine = NNshGlobal->currentPage * 
                       (NNshGlobal->prevHRLines - 1); /* winDown or winUp */
    }

    // \\sۑ
    NNshGlobal->prevHRLines = nlines;

    // \y[W̍s̐擪܂œǂݔ΂
    line = 0;

    lineLen = StrLen(ptr);
#ifdef USE_CLIE
    // nC]`惂[hłACLIE NX̂Ƃ
    if ((NNshGlobal->hrRef != 0)&&
        (NNshGlobal->hrVer >= HR_VERSION_SUPPORT_FNTSIZE))
    {
        while((lineLen > 0)&&(line != startLine))
        {
            len = HRFntWordWrap(NNshGlobal->hrRef, ptr, dimF.extent.x);
            line++;
            ptr = ptr + len;
            lineLen -= len;
        }
    }
    else
#endif
    {
        while((lineLen > 0)&&(line != startLine))
        {
            len = FntWordWrap(ptr, dimF.extent.x);
            line++;
            ptr = ptr + len;
            lineLen -= len;
        }
    }
 
    // ʂɕĂ(\镶AC܂ŕ\)
    i       = 0;
/*     lineLen = StrLen(ptr); */
    while ((lineLen > 0)&&(i < nlines))
    {
#ifdef USE_CLIE
        // nC]`惂[hłACLIE NX̂Ƃ
        if ((NNshGlobal->hrRef != 0)&&
            (NNshGlobal->hrVer >= HR_VERSION_SUPPORT_FNTSIZE))
        {
            len = HRFntWordWrap(NNshGlobal->hrRef, ptr, dimF.extent.x);
        }
        else
#endif
        {
            len = FntWordWrap(ptr, dimF.extent.x);
        }

#ifdef USE_CLIE
        if (NNshGlobal->hrRef != 0)
        {
            if (lineLen >= len)
            {
                // s܂ŕ\ꍇ
                if ((*(ptr + (len - 3)) == '\x0a')&&
                    (*(ptr + (len - 2)) == '\x0d')&&
                    (*(ptr + (len - 1)) == '\x0a'))
                {
                    // ssR[hꍇɂ́AsR[h\Ȃ
                    HRWinDrawChars(NNshGlobal->hrRef, ptr, (len - 3),
                                   dimF.topLeft.x, dimF.topLeft.y);
                }
                else if ((*(ptr + (len - 2)) == '\x0d')&&
                         (*(ptr + (len - 1)) == '\x0a'))
                {
                    // ssR[hꍇɂ́AsR[h\Ȃ
                    HRWinDrawChars(NNshGlobal->hrRef, ptr, (len - 2),
                                   dimF.topLeft.x, dimF.topLeft.y);
                }
                else if (*(ptr + (len - 1)) == '\x0a')
                {
                    // ssR[hꍇɂ́AsR[h\Ȃ
                    HRWinDrawChars(NNshGlobal->hrRef, ptr, (len -1),
                                   dimF.topLeft.x, dimF.topLeft.y);
                }
                else
                {
                    HRWinDrawChars(NNshGlobal->hrRef, ptr, len,
                                   dimF.topLeft.x, dimF.topLeft.y);
                }
            }
            else
            {
                // [hbvōs܂ŕ\Ȃꍇ
                HRWinDrawChars(NNshGlobal->hrRef, ptr, lineLen,
                               dimF.topLeft.x,dimF.topLeft.y);
            }
        }
        else
#endif
        {
            if (lineLen >= len)
            {
                // s܂ŕ\ꍇ
                if ((*(ptr + (len - 2)) == '\x0d')&&
                    (*(ptr + (len - 1)) == '\x0a'))
                {
                    // ssR[hꍇɂ́AsR[h\Ȃ
                    WinDrawChars(ptr,(len - 2),dimF.topLeft.x,dimF.topLeft.y);
                }
                else if (*(ptr + (len - 1)) == '\x0a')
                {
                    // ssR[hꍇɂ́AsR[h\Ȃ
                    WinDrawChars(ptr,(len -1),dimF.topLeft.x,dimF.topLeft.y);
                }
                else
                {
                    WinDrawChars(ptr, len, dimF.topLeft.x, dimF.topLeft.y);
                }
            }
            else
            {
                // [hbvōs܂ŕ\Ȃꍇ
                WinDrawChars(ptr, lineLen,dimF.topLeft.x,dimF.topLeft.y);
            }
        }

        // ̍sɕ`ʒuړ
        dimF.topLeft.y = dimF.topLeft.y + fontHeight;
        
        // ̍sɕ\镶ւ
        i++;
        ptr     = ptr + len;
        lineLen = StrLen(ptr);
    }
    MemHandleUnlock(txtH);

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),
                      NNshGlobal->os5HighDensity);
        WinSetCoordinateSystem(kCoordinatesStandard);
        // FntSetFont(NNshParam->sonyHRFont);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif  // #ifdef USE_HIGHDENSITY
    return;

END_FUNC:
    // ʏ̃tB[h\ďI
    FldDrawField(fldP);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :  NNsi_HRFieldPageScroll                                    */
/*                              SONYnC]`惂[hł̃y[WXN[ */
/*-------------------------------------------------------------------------*/
static Boolean NNsi_HRFieldPageScroll(UInt16 fldID, UInt16 sclID,
                                      UInt16 lines, WinDirectionType direction)
{
    FormType  *frm;
    FieldType *fldP;

    // y[WXV̕mF
    if (direction == winDown)
    {
        // Py[W
        if (NNshGlobal->currentPage >= NNshGlobal->nofPage)
        {
            // アςA\͈ړȂ
            return (false);
        }
        (NNshGlobal->currentPage)++;
    }
    else
    {
        // Py[W
        if (NNshGlobal->currentPage == 0)
        {
            // ςA\͈ړȂ
            return (false);
        }
        (NNshGlobal->currentPage)--;
    }

    // IuWFNg̎擾
    frm  = FrmGetActiveForm();
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, fldID));

    // nC]`
    NNsi_HRFldDrawField(fldP, false);

    // XN[o[̕\XV
    NNsi_HRSclUpdate(FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, sclID)));

    return (true);
}

/*=========================================================================*/
/*   Function :   NNshWinClearList                                         */
/*                                                     Xgf[^  */
/*=========================================================================*/
void NNshWinClearList(FormType *frm, UInt16 lstID)
{
    ListType  *lstP;

    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, lstID));
    if (lstP != NULL)
    {
        LstEraseList(lstP);
    }
    return;
}

/*=========================================================================*/
/*   Function :   NNshWinSetListItems                                      */
/*                                                   XgɃf[^ݒ  */
/*=========================================================================*/
void NNshWinSetListItems(FormType *frm, UInt16 lstID, Char *list,
                         UInt16 cnt, UInt16 selItem, 
                         MemHandle *memH, Char **listP)
{
    Char      *ptr;
    MemHandle  oldMemH;
    ListType  *lstP;

    if (cnt == 0)
    {
        // Xg̃ACe[̂ƂAXg͍sȂB
        return;
    }
    else if (cnt == 1)
    {
        // XgPȂꍇAIACePɌ肷B
        selItem = 0;
    }
    else if (cnt <= selItem)
    {
        // ACeIACeُȏꍇAɃtH[JX킹
        selItem = cnt - 1;
    }

    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, lstID));
    if (lstP == NULL)
    {
        return;
    }

    oldMemH = *memH;
    *memH   = SysFormPointerArrayToStrings(list, cnt);
    if (*memH == 0)
    {
        return;
    }

    ptr = MemHandleLock(*memH);
    LstSetListChoices(lstP, (Char **) ptr, cnt);
    LstSetSelection  (lstP, selItem);
    LstSetTopItem    (lstP, selItem);

    LstDrawList(lstP);
    if (oldMemH != 0)
    {
        MemHandleUnlock(oldMemH);
        MemHandleFree(oldMemH);
    }
    if (listP != NULL)
    {
        *listP = ptr;
    }
    return;
}

/*=========================================================================*/
/*   Function :   NNshWinUpdateListItems                                   */
/*                                   XgɃf[^ݒ(Xg\zς)  */
/*=========================================================================*/
void NNshWinUpdateListItems(FormType *frm, UInt16 lstID, Char *ptr,
                            UInt16 cnt, UInt16 selItem)
{
    ListType  *lstP;

    if (cnt == 0)
    {
        // Xg̃ACe[̂ƂAXg͍sȂB
        return;
    }
    else if (cnt == 1)
    {
        // XgPȂꍇAIACePɌ肷B
        selItem = 0;
    }
    else if (cnt <= selItem)
    {
        // ACeIACeُȏꍇAɃtH[JX킹
        selItem = cnt - 1;
    }

    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, lstID));
    if (lstP == NULL)
    {
        return;
    }

    LstSetListChoices(lstP, (Char **) ptr, cnt);
    LstSetSelection  (lstP, selItem);
    LstSetTopItem    (lstP, selItem);
    LstDrawList(lstP);

    return;
}



/*=========================================================================*/
/*   Function :  NNshWinSetFieldText                                       */
/*                                                tB[heLXg̍XV */
/*=========================================================================*/
void NNshWinSetFieldText(FormType *frm, UInt16 fldID, Boolean redraw, 
                         Char *msg, UInt32 size)
{
    MemHandle  txtH, oldTxtH;
    Char      *txtP;
    FieldType *fldP;

    // bZ[W\̈ɃRs[
    txtH = MemHandleNew(size + MARGIN);
    if (txtH == 0)
    {
        // ̈̊mۂɎs
        return;
    }
    txtP = (Char *) MemHandleLock(txtH);
    if (txtP == NULL)
    {
        // ̈̊mۂɎs
        MemHandleFree(txtH);
        return;
    }
    (void) MemSet(txtP,  size + MARGIN, 0x00);
    if (size != 0)
    {
        (void) StrNCopy(txtP, msg, size);
    }
    MemHandleUnlock(txtH);

    // tB[h̃IuWFNg|C^擾
    fldP = (FieldType *) FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, fldID));

    // tB[h̃eLXgnhւAÂ̂폜
    oldTxtH = FldGetTextHandle(fldP);
    FldSetTextHandle(fldP, NULL);
    FldSetTextHandle(fldP, txtH);
    if (oldTxtH != 0)
    {
        (void) MemHandleFree(oldTxtH);
    }

    // tH[̍ĕ`
    NNsi_FrmDrawForm(frm, redraw);
    return;
}


/*=========================================================================*/
/*   Function : NNshWinSetPopItemsWithList                                 */
/*                    |bvAbvgK̃xݒ(Xg킹Đݒ) */
/*=========================================================================*/
void NNshWinSetPopItemsWithList(FormType *frm, UInt16 popId, UInt16 lstId, 
                                NNshWordList *wordList, UInt16 item)
{
    ListType    *lstP;
    ControlType *ctlP;
    Char        *ptr;

    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, popId));
    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, lstId));
    if ((lstP == NULL)||(wordList == NULL)||(wordList->nofWord == 0)||
        (wordList->wordString == NULL)||(ctlP == NULL))
    {
        // XgwŃG[ɂȂ肻ȏԂ͔r
        return;
    }

    if (wordList->nofWord < item)
    {
        // Iԍn~oĂꍇɂ́A擪ɂ킹
        item = 0;
    }

    ptr = MemHandleLock(wordList->wordmemH);
    LstSetListChoices(lstP, (Char **) ptr, wordList->nofWord);

    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, lstId));

    LstSetTopItem    (lstP, item);
    LstSetSelection  (lstP, item);
    CtlSetLabel      (ctlP, LstGetSelectionText(lstP, item));

    return;
}

/*=========================================================================*/
/*   Function : NNshWinSetPopItemsWithListArray                            */
/*                |bvAbvgK̃xAݒ(Xg킹Đݒ) */
/*=========================================================================*/
void NNshWinSetPopItemsWithListArray(FormType *frm, NNshListItem *target,
                                     Char *listArray, UInt16 num, UInt16 *items)
{
    ListType    *lstP;
    ControlType *ctlP;

    while ((target != NULL)&&(target->popId != 0)&&(target->lstId != 0))
    {
        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, target->popId));
        lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, target->lstId));

        if (num < *items)
        {
            // Iԍn~oĂꍇɂ́A擪ɂ킹
            *items = 0;
        }
        LstSetListChoices(lstP, (Char **) listArray, num);
        LstSetTopItem    (lstP, *items);
        LstSetSelection  (lstP, *items);
        CtlSetLabel      (ctlP, LstGetSelectionText(lstP, *items));

        // ̐ݒf[^Ɉړ
        target++;
        items++;
    }
    return;
}


/*=========================================================================*/
/*   Function : NNshWinSetPopItems                                         */
/*                                          |bvAbvgK̃xݒ */
/*=========================================================================*/
void NNshWinSetPopItems(FormType *frm, UInt16 popId, UInt16 lstId, UInt16 item)
{
    ListType    *lstP;
    ControlType *ctlP;

    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, popId));
    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, lstId));
                          
    LstSetTopItem  (lstP, item);
    LstSetSelection(lstP, item);
    CtlSetLabel    (ctlP, LstGetSelectionText(lstP, item));

    return;
}

/*=========================================================================*/
/*   Function :  NNshWinGetFieldText                                       */
/*                                                tB[heLXg̎擾 */
/*=========================================================================*/
void NNshWinGetFieldText(FormType *frm, UInt16 fldID, Char *area, UInt32 len)
{
    MemHandle  txtH;
    Char      *txtP;
    FieldType *fldP;

    // tB[hi[̈
    MemSet(area, len, 0x00);

    // tB[h̃IuWFNg|C^擾
    fldP = (FieldType *) FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, fldID));

    // tB[h̃eLXgnh擾
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        if (txtP != NULL)
        {
            StrNCopy(area, txtP, (len - 1));
            MemHandleUnlock(txtH);
        }
    }
    return;
}

/*=========================================================================*/
/*   Function : SetMsg_BusyForm                                            */
/*                                                     BUSYeLXg̐ݒ  */
/*=========================================================================*/
void SetMsg_BusyForm(Char *msg)
{
#ifdef USE_ORIGINAL_WINDOW
    FormType *busyFrm;
    UInt16    length;

    // \镶񒷂̃`FbN
    length = StrLen(msg);
    length = (length > NNSH_BUSYWIN_MAXLEN) ? NNSH_BUSYWIN_MAXLEN : length;

    busyFrm = FrmGetActiveForm();
    NNshWinSetFieldText(busyFrm, FLDID_BUSY, true, msg, length);
    return;
#else  // #ifdef USE_ORIGINAL_WINDOW
    UInt16         len;
    RectangleType  r;

#ifdef USE_COLOR
    RGBColorType  color;
#endif  // #ifdef USE_COLOR
    
    // ʒ
    r.topLeft.x = 8;
    r.topLeft.y = 70;
    r.extent.x  = 140;
    r.extent.y  = 22;

    // ʂ
    WinEraseRectangle(&r, 0);

#ifdef USE_COLOR
    // OS 3.5ȏ̏ꍇ
    if (NNshGlobal->palmOSVersion >= 0x03503000)
    {
        // FԂۑ
        WinPushDrawState();

        // ͍
        MemSet(&color, sizeof(color), 0x00);
        WinSetTextColor(WinRGBToIndex(&color));

        // g͐
        color.b = 140;
        WinSetForeColor(WinRGBToIndex(&color));
    
        // g\
        WinDrawRectangleFrame(dialogFrame, &r);

        // \
        len = FntWordWrap(msg, (r.extent.x - (MARGIN * 2)));
        WinDrawChars(msg, len, (r.topLeft.x + MARGIN), (r.topLeft.y + MARGIN - 1));

        // FԂ𕜋A
        WinPopDrawState();
    }
    else
#else  // #ifdef USE_COLOR
    {
        // g\
        WinDrawRectangleFrame(dialogFrame, &r);

        // \
        len = FntWordWrap(msg, (r.extent.x - (MARGIN * 2)));
        WinDrawChars(msg, len, (r.topLeft.x + MARGIN), (r.topLeft.y + MARGIN - 1));
    }
#endif // #ifdef USE_COLOR
    return;
#endif // #ifdef USE_ORIGINAL_WINDOW
}

/*=========================================================================*/
/*   Function : Show_BusyForm                                              */
/*                                                      BUSYtH[̕\ */
/*=========================================================================*/
void Show_BusyForm(Char *msg)
{
#ifdef USE_ORIGINAL_WINDOW
    FormType  *busyFrm;
    UInt16    length;

    // łBUSYEBhE\Ăꍇ
    if (FrmGetActiveFormID() == FRMID_BUSY)
    {
        NNsh_DebugMessage(ALTID_ERROR, "ALREADY SHOW BUSY WINDOW!", "", 0);
        return (SetMsg_BusyForm(msg));
    }

    // ݂̃tH[ۑ
    NNshGlobal->prevBusyForm = FrmGetActiveForm();

    // BUSY_CAOtH[𐶐AANeBuɂ
    busyFrm = FrmInitForm(FRMID_BUSY);
#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        VgaFormModify(busyFrm, vgaFormModify160To240);
    }
#endif // #ifdef USE_HANDERA
#ifdef USE_PIN_DIA
    if (NNshGlobal->device == NNSH_DEVICE_DIASUPPORT)
    {
        VgaFormModify_DIA(busyFrm, vgaFormModifyNormalToWide);
        PINSetInputAreaState(pinInputAreaClosed);  // SILKŏ...̂ȁH
    }
#endif // #ifdef USE_PIN_DIA
    FrmSetActiveForm(busyFrm);

    // \镶񒷂̃`FbN
    length = StrLen(msg);
    length = (length > NNSH_BUSYWIN_MAXLEN) ? NNSH_BUSYWIN_MAXLEN : length;

    // tB[hɕݒ
    NNshWinSetFieldText(busyFrm, FLDID_BUSY, true, msg, length);
    return;
#else  // #ifdef USE_ORIGINAL_WINDOW
    // ݂̃tH[ۑ
    NNshGlobal->prevBusyForm = FrmGetActiveForm();
    if (NNshGlobal->prevBusyForm != NULL)
    {
        // \p^[
        SetMsg_BusyForm(msg);
    }
    return;
#endif // #ifdef USE_ORIGINAL_WINDOW
}

/*=========================================================================*/
/*   Function : Hide_BusyForm                                              */
/*                                                      BUSYtH[̍폜 */
/*=========================================================================*/
void Hide_BusyForm(Boolean redraw)
{
#ifdef USE_ORIGINAL_WINDOW
    FormType *busyFrm;

    // BUSYtH[폜ABUSYtH[̑Oɕ\ĂtH[J
    if (NNshGlobal->prevBusyForm != NULL)
    {
        busyFrm = FrmGetActiveForm();
        FrmEraseForm(busyFrm);
        FrmSetActiveForm(NNshGlobal->prevBusyForm);
        NNsi_FrmDrawForm(NNshGlobal->prevBusyForm, redraw);
        FrmDeleteForm   (busyFrm);
    }
    NNshGlobal->prevBusyForm = NULL;

    return;
#else  // #ifdef USE_ORIGINAL_WINDOW
    if (NNshGlobal->prevBusyForm != NULL)
    {
        NNsi_FrmDrawForm(NNshGlobal->prevBusyForm, redraw);
    }
    return;
#endif // #ifdef USE_ORIGINAL_WINDOW
}

/*=========================================================================*/
/*   Function :   NNsh_DialogMessage                                       */
/*                                             bZ[W_CAO̕\  */
/*=========================================================================*/
UInt16 NNsh_DialogMessage(UInt16 level, UInt16 altID, Char *mes1, Char *mes2, UInt32 num)
{
    Char logBuf[MINIBUF];

    switch (level)
    {
      case NNSH_LEVEL_ERROR:
        // G[bZ[W(K\)
        break;

      case NNSH_LEVEL_WARN:
        // xbZ[W
        if ((NNshParam->confirmationDisable & (NNSH_OMITDIALOG_WARNING)) != 0)
        {
            // x\Ȃꍇɂ́A"OK"(== 0)Ԃ
            return (0);
        }
        break;

      case NNSH_LEVEL_CONFIRM:
        // mFbZ[W
        if ((NNshParam->confirmationDisable & (NNSH_OMITDIALOG_CONFIRM)) != 0)
        {
            // mF\Ȃꍇɂ́A"OK"(== 0)Ԃ
            return (0);
        }
        break;

      case NNSH_LEVEL_DEBUG:
#ifdef DEBUG
        // fobOIvVtŃRpCꍇɂ́AK\B
#else
        if (NNshParam->debugMessageON == 0)
        {
            // DEBUG\Ȃꍇɂ́A"OK"(== 0)Ԃ
            return (0);
        }
#endif
        break;

      case NNSH_LEVEL_INFO:
      default:
        // 񃁃bZ[W
        if ((NNshParam->confirmationDisable & (NNSH_OMITDIALOG_INFORMATION))
                                                                          != 0)
        {
            // \Ȃꍇɂ́A"OK"(== 0)Ԃ
            return (0);
        }
        break;
    }

    // _CAO\
    MemSet (logBuf, sizeof(logBuf), 0x00);
    if (num != 0)
    {
        StrCopy(logBuf, "(0x");
        NUMCATH(logBuf, num);
        StrCat (logBuf, "/");
        NUMCATI(logBuf, num);
        StrCat (logBuf, ")");
    }
    return (FrmCustomAlert(altID, mes1, mes2, logBuf));
}

#if 0   // \[XDYNAMICSIZE̎wOƕsvBBBVbNBBB
// tB[hTCY̕ύXFMAIL(SDK 4.0t)̃Tv玝ĂĕύX
/***********************************************************************
 *
 * FUNCTION:    NewViewResizeFieldHeight
 *
 * DESCRIPTION: This routine is called when the height of a line in
 *              the Edit View is changed as a result of user input.
 *              If the new height of the field is shorter,  more items
 *              may need to be added to the top of the list.
 *              
 * PARAMETERS:  event  - a pointer to an EventType structure
 *
 * RETURNED:    nothing
 *
 * REVISION HISTORY:
 *                        Name        Date                Description
 *                        ----        ----                -----------
 *                        art        6/6/96        Initial Revision
 *
 ***********************************************************************/
void NNshWinViewResizeFieldHeight(EventType *event, UInt16 fldID, UInt16 sclID)
{
    // }|Cgݒ
    FldSetInsPtPosition(event->data.fldHeightChanged.pField,
                        event->data.fldHeightChanged.currentPos);

    // XN[o[̍XV
    NNshWinViewUpdateScrollBar(fldID, sclID);

    return;
}
#endif

// y[WXN[\FMEMO(SDK 4.0t)̃Tv玝ĂĕύX
/***********************************************************************
 *
 * FUNCTION:    EditViewUpdateScrollBar
 *
 * DESCRIPTION: This routine update the scroll bar.
 *
 * PARAMETERS:
 *              fldP      field object
 *              barP      scroll bar object
 *
 * RETURNED:    nothing
 *
 * REVISION HISTORY:
 *
 *  Name        Date                Description
 *  ----        ----                -----------
 *   art        07/01/96        Initial Revision
 *   gap        11/02/96        Fix case where field and scroll bars
 *                              get out of sync.
 *  nnsh        25/04/02        tunes for nanashi.
 ***********************************************************************/
void NNshWinViewUpdateScrollBar(UInt16 fldID, UInt16 sclID)
{
    FormType *frm;
    void     *fldP, *barP;
    UInt16    scrollPos;
    UInt16    textHeight;
    UInt16    fieldHeight;
    Int16     maxValue;

    frm  = FrmGetActiveForm();
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, fldID));
    barP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, sclID));

    FldGetScrollValues(fldP, &scrollPos, &textHeight, &fieldHeight);
    if (textHeight > fieldHeight)
    {
       // On occasion, such as after deleting a multi-line selection of text,
       // the display might be the last few lines of a field followed by some
       // blank lines. To keep the current position in place and allow the user
       // to "gracefully" scroll out of the blank area, the number of blank
       // lines visible needs to be added to max value.  Otherwise the scroll
       // position may be greater than maxValue, get pinned to maxvalue
       // in SclSetScrollBar resulting in the scroll bar and the display being
       // out of sync.
       maxValue = (textHeight - fieldHeight) + FldGetNumberOfBlankLines(fldP);
    }
    else
    {
        // Pʂɕ\łꍇAXN[o[\Ȃ悤׍H
        maxValue = (scrollPos == 0) ? 0 : scrollPos;
    }
    SclSetScrollBar (barP, scrollPos, 0, maxValue, fieldHeight - 1);

    return;
}

// y[WXN[FMEMO(SDK 4.0t)̃Tv玝ĂĕύX
/***********************************************************************
 *
 * FUNCTION:    EditViewPageScroll
 *
 * DESCRIPTION: This routine scrolls the message a page winUp or winDown.
 *              When the top of a memo is visible, scrolling up will
 *              display the display the botton of the previous memo.
 *              If the bottom of a memo is visible, scrolling down will
 *              display the top of the next memo.
 *
 * PARAMETERS:
 *              fldP          field object
 *              sclP          scroll object
 *              direction     winUp or winDown
 *
 * RETURNED:    nothing
 *
 * REVISION HISTORY:
 *  Name      Date        Description
 *  ----      -------        -----------
 *  art       7/1/96        Initial Revision
 *  grant     2/4/99        Use EditViewScroll() to do actual scrolling.
 *  nnsh     25/4/02    tunes for nanashi.
 ***********************************************************************/
Boolean NNshWinViewPageScroll(UInt16 fldID, UInt16 sclID, 
                              UInt16 lines, WinDirectionType direction)
{
    FormType *frm;
    void     *fldP, *sclP;
    UInt16    linesToScroll;
    Int16     value, min, max, pageSize;
    Boolean   ret;

    //  OtBbN`惂[hŁAbZ[WQƎɃtB[hXV
    // ꍇɂ͕ʊ֐ŏB
    if ((NNshParam->useSonyTinyFont != 0)&&(fldID == FLDID_MESSAGE))
    {
        return (NNsi_HRFieldPageScroll(fldID, sclID, lines, direction));
    }

    // IuWFNg̎擾
    frm  = FrmGetActiveForm();
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, fldID));

    if (sclID == 0)
    {
        // tB[hXN[
        FldScrollField(fldP, lines, direction);
        return (true);
    }

    // XN[sw肳Ă邩mF
    if (lines == 0)
    {
        // XN[sw肳ĂȂꍇAXN[\`FbN
        ret = FldScrollable(fldP, direction);
        if (ret != true)
        {
            return (ret);
        }

        // XN[s擾(\s - 1)
        linesToScroll = FldGetVisibleLines(fldP) - 1;

        // XN[o[̍XV
        sclP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, sclID));
        SclGetScrollBar(sclP, &value, &min, &max, &pageSize);  
        if (direction == winUp)
        {
            value = value - linesToScroll;
        }
        else
        {
            value = value + linesToScroll;
        }
        SclSetScrollBar(sclP, value, min, max, pageSize);
    }
    else
    {
        // w肳ꂽsXN[o[̍sɊ蓖Ă
        linesToScroll = lines;
        ret = true;
    }

    // tB[hXN[
    FldScrollField(fldP, linesToScroll, direction);
    return (ret);
}

/*=========================================================================*/
/*   Function : NNsh_MenuEvt_Edit                                          */
/*                                        ҏWj[Iꂽ̏ */
/*=========================================================================*/
Boolean NNsh_MenuEvt_Edit(EventType *event)
{
    FormType  *frm;
    FieldType *fldP;
    UInt16     frmId;
    
    // IĂtB[hǂ`FbN
    frm   = FrmGetActiveForm();
    frmId = FrmGetFocus(frm);
    if (frmId == noFocus)
    { 
        // tH[JXIĂȂ̂ŁAԂ
        return (false);
    }
    if (FrmGetObjectType(frm, frmId) != frmFieldObj)
    {
        // ItB[hł͂Ȃ̂ŁAԂ
        return (false);
    }
    fldP = FrmGetObjectPtr(frm, frmId);

    // ҏWj[{
    switch (event->data.menu.itemID)
    {
      case MNUID_EDIT_UNDO:
        FldUndo(fldP);
        break;
      case MNUID_EDIT_CUT:
        FldCut(fldP);
        break;
      case MNUID_EDIT_COPY:
        FldCopy(fldP);
        break;
      case MNUID_EDIT_PASTE:
        FldPaste(fldP);
        break;
      case MNUID_SELECT_ALL:
        FldSetSelection(fldP, 0, FldGetTextLength(fldP));
        break;
      default:
        // ȂɂȂAƂRRɂ͗Ȃ
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   Hander_DialogAction                                      */
/*                                   _CAOp̃Cxgnh  */
/*=========================================================================*/
Boolean Handler_DialogAction(EventType *event)
{
    UInt16       keyCode;
    FormType    *frm;
    ControlType *ctlP;

    // ݂̃tH[擾
    switch (event->eType)
    { 
      // j[I
      case menuEvent:
        return (NNsh_MenuEvt_Edit(event));
        break;

      case keyDownEvent:
        // L[R[hɂď𕪊򂳂
        keyCode = KeyConvertFiveWayToJogChara(event);
        switch (keyCode)
        {
          // JOG PUSH/ZL[Ƃ̏
          case vchrJogRelease:
          case vchrThumbWheelPush:
            // OK{^Ƃɂ
            frm  = FrmGetActiveForm();
            ctlP = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,BTNID_DIALOG_OK));
            CtlHitControl(ctlP);
            return (true);
            break;

          case chrCarriageReturn:
          case chrLineFeed:
          case chrLeftArrow:
          case vchrJogLeft:
          case chrEscape:
          default:
            break;
        }
        break;

      case ctlSelectEvent:
      default: 
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   Hander_JumpSelection                                     */
/*                                           Wvp̃Cxgnh  */
/*-------------------------------------------------------------------------*/
Boolean Handler_JumpSelection(EventType *event)
{
    FormType         *frm;
    ListType         *lstP;
    EventType        *dummyEvent;
    UInt16            max, keyCode;

    // _~[Cxg
    dummyEvent = &(NNshGlobal->dummyEvent);

    // ݂̃tH[擾
    switch (event->eType)
    { 
      // XgICxg
      case lstSelectEvent:
        if (NNshGlobal->jumpSelection == event->data.lstSelect.selection)
        {
            // _u^bvo(OK{^Ƃɂ)
            goto JUMP_SELECTION;
        }
        NNshGlobal->jumpSelection = event->data.lstSelect.selection;
        break;

      // L[_E({^)̑I
      case keyDownEvent:
        // ݑIĂ郊XgACeԍ擾
        frm  = FrmGetActiveForm();
        lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm,LSTID_JUMPLIST));
        NNshGlobal->jumpSelection = LstGetSelection(lstP);
        max  = LstGetNumberOfItems(lstP);

        //tungsten T 5way navigator (281AӁI)
        keyCode = KeyConvertFiveWayToJogChara(event);

        // L[R[hɂď𕪊򂳂
        switch (keyCode)
        {
          case vchrJogRelease:
          case chrCarriageReturn:
          case chrLineFeed:
          case vchrThumbWheelPush:
          case chrRightArrow:
          case vchrJogRight:
            // Jog Push/EnterL[ꂽƂ(OK{^Ƃɂ)
            goto JUMP_SELECTION;
            break;

          case chrLeftArrow:
          case vchrJogLeft:
          case chrEscape:
          case chrBackspace:
          case chrCapital_X:
          case chrSmall_X:
          case vchrJogBack:
          case vchrThumbWheelBack:
            // ESCL[/XL[/5way̍{^ꂽƂ
            // (Cancel{^Ƃɂ)
            MemSet(dummyEvent, sizeof(EventType), 0x00);
            dummyEvent->data.ctlSelect.pControl  
                = (ControlType*) FrmGetObjectPtr(frm,
                                     FrmGetObjectIndex(frm, BTNID_JUMPCANCEL));
            dummyEvent->data.ctlSelect.controlID = BTNID_JUMPCANCEL;
            dummyEvent->eType                    = ctlSelectEvent;
            EvtAddEventToQueue(dummyEvent);
            return (true);
            break;

          case vchrPageDown:
          case vchrJogDown:
          case vchrTrgJogDown:
          case vchrNextField:
          case vchrThumbWheelDown:
          case chrDownArrow:
            // n[hL[AWO
            if (NNshGlobal->jumpSelection < (max - 1))
            {
                (NNshGlobal->jumpSelection)++;
                LstSetSelection(lstP, NNshGlobal->jumpSelection);
            }
            else
            {
                // IXg̐擪ֈړ
                NNshGlobal->jumpSelection = 0;
                LstSetSelection(lstP, NNshGlobal->jumpSelection);
                LstSetTopItem  (lstP, 0);
            }
            return (true);
            break;

          case vchrPageUp:
          case vchrJogUp:
          case vchrTrgJogUp:
          case vchrPrevField:
          case vchrThumbWheelUp:
          case chrUpArrow:
            // n[hL[AWO㑗
            if (NNshGlobal->jumpSelection > 0)
            {
                (NNshGlobal->jumpSelection)--;
                LstSetSelection(lstP, NNshGlobal->jumpSelection);
            }
            else
            {
                // IXg̖ֈړ
                NNshGlobal->jumpSelection = max - 1;
                LstSetSelection(lstP, NNshGlobal->jumpSelection);
            }
            return (true);
            break;

          default:
            // LȊÕL[ł͉Ȃ
            break;

        }
        return (false);
        break;

      // Rg[({^)̑I
      case ctlSelectEvent:
        // Ȃ
        break;

      default: 
        // Ȃ
        break;
    }
    return (false);

JUMP_SELECTION:
    // OK{^Ƃɂ
    frm = FrmGetActiveForm();
    MemSet(dummyEvent, sizeof(EventType), 0x00);
    dummyEvent->data.ctlSelect.pControl  
                = (ControlType*) FrmGetObjectPtr(frm,
                                       FrmGetObjectIndex(frm, BTNID_JUMPEXEC));
    dummyEvent->data.ctlSelect.controlID = BTNID_JUMPEXEC;
    dummyEvent->eType                    = ctlSelectEvent;
    EvtAddEventToQueue(dummyEvent);
    return (true);
}

/*=========================================================================*/
/*   Function :  NNshWinSelectionWindow                                    */
/*                                                    IEBhE̕\ */
/*=========================================================================*/
UInt16 NNshWinSelectionWindow(UInt16 frmId, Char *listItemP, UInt16 nofItems, UInt16 selection)
{
    FormType  *prevFrm, *diagFrm;
    UInt16     btnId;
    MemHandle  listH;
    ListType  *lstP;

    // ACe̊mF([A߂)
    if (nofItems == 0)
    {
        // LZꂽ̂Ɠ̉R[hԂ
        return (BTNID_JUMPCANCEL);
    }
    // Iԍُ킾A擪̔ԍɂ
    if (nofItems <= selection)
    {
        selection = 0;
    }

    // 
    listH   = 0;
    btnId   = BTNID_JUMPCANCEL;
    prevFrm = FrmGetActiveForm();

    // _CAO\
    PrepareDialog_NNsh(frmId, &diagFrm, false);
    if (diagFrm == NULL)
    {
        return (false);
    }

    // Xg̐ݒ
    lstP  = FrmGetObjectPtr(diagFrm,
                                FrmGetObjectIndex(diagFrm, LSTID_JUMPLIST));
    listH = SysFormPointerArrayToStrings(listItemP, nofItems);
    if (listH != 0)
    {
        LstSetListChoices(lstP, (Char **) MemHandleLock(listH), nofItems);
        LstSetSelection  (lstP, selection);
        LstSetTopItem    (lstP, selection);
    }

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_JumpSelection);

    // WvNA
    NNshGlobal->jumpSelection = 0;

    // _CAÕI[vA̓͂҂
    btnId = FrmDoDialog(diagFrm);

    // _CAO\̌Еt
    PrologueDialog_NNsh(prevFrm, diagFrm, false);

    if (listH != 0)
    {
        MemHandleUnlock(listH);
        MEMFREE_HANDLE (listH);
    }

    FrmDrawForm(prevFrm);
    return (btnId);
}

/*=========================================================================*/
/*   Function : DataInputDialog                                            */
/*                                                NNsiʂ̓̓_CAO */
/*=========================================================================*/
Boolean DataInputDialog(Char *title, Char *area, UInt16 size, UInt16 usage, void *valueP)
{
    Boolean       ret = false;
    FormType     *prevFrm, *diagFrm;
    UInt16        btnId;
    ControlType  *chkObj;
    FieldType    *fldP;

    // ʂ
    ret     = false;
    prevFrm = FrmGetActiveForm();

    // _CAO\
    PrepareDialog_NNsh(FRMID_INPUTDIALOG, &diagFrm, true);
    if (diagFrm == NULL)
    {
        return (false);
    }

    // ^CgRs[
    FrmCopyTitle(diagFrm, title);

    if (usage != NNSH_DIALOG_USE_SEARCH_MESSAGE)
    {
        // @\Ȃ
        FrmHideObject(diagFrm, FrmGetObjectIndex(diagFrm, POPTRID_SEARCH_METHOD));
        FrmHideObject(diagFrm, FrmGetObjectIndex(diagFrm, LSTID_SEARCH_METHOD));
    }

    // ʕ\̐ݒ
    switch (usage)
    {
      case NNSH_DIALOG_USE_SEARCH:
        // ݂̌ݒp[^EBhEɔf
        SetControlValue(diagFrm, CHKID_CASELESS, &(NNshParam->searchCaseless));

        // wvbZ[W͕\Ȃ
        FrmHideObject(diagFrm, FrmGetObjectIndex(diagFrm, LBLID_HELPMSG));
        break;

      case NNSH_DIALOG_USE_GETMESNUM:
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObj = FrmGetObjectPtr(diagFrm,
                                 FrmGetObjectIndex(diagFrm, CHKID_CASELESS));
        CtlSetUsable(chkObj, false);
        break;

      case NNSH_DIALOG_USE_SETNGWORD:
      case NNSH_DIALOG_USE_MODIFYTITLE:
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObj = FrmGetObjectPtr(diagFrm,
                                 FrmGetObjectIndex(diagFrm, CHKID_CASELESS));
        CtlSetUsable(chkObj, false);
        FrmHideObject(diagFrm, FrmGetObjectIndex(diagFrm, LBLID_HELPMSG));
        break;

      case NNSH_DIALOG_USE_SEARCH_MESSAGE:
        // u啶ʂȂṽ`FbN{bNX\Ȃ
        FrmHideObject(diagFrm, FrmGetObjectIndex(diagFrm, CHKID_CASELESS));

        // wvbZ[W͕\Ȃ
        FrmHideObject(diagFrm, FrmGetObjectIndex(diagFrm, LBLID_HELPMSG));

        // @\
        FrmShowObject(diagFrm, FrmGetObjectIndex(diagFrm, POPTRID_SEARCH_METHOD));
        FrmShowObject(diagFrm, FrmGetObjectIndex(diagFrm, LSTID_SEARCH_METHOD));
        break;

      default:
        // (ݒ荀ڎ̂ʂɕ\Ȃ)
        chkObj = FrmGetObjectPtr(diagFrm,
                                 FrmGetObjectIndex(diagFrm, CHKID_CASELESS));
        CtlSetUsable(chkObj, false);

        // wvbZ[W͕\Ȃ
        FrmHideObject(diagFrm, FrmGetObjectIndex(diagFrm, LBLID_HELPMSG));
        break;
    }

    // w肳ꂽEBhEɔf
    NNshWinSetFieldText(diagFrm, FLDID_INPUTFIELD, true, area, size);
    FrmSetFocus(diagFrm, FrmGetObjectIndex(diagFrm, FLDID_INPUTFIELD));


    fldP = FrmGetObjectPtr(diagFrm, FrmGetObjectIndex(diagFrm, FLDID_INPUTFIELD));
    // IĂ
    FldSetSelection(fldP, 0, FldGetTextLength(fldP));

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_DialogAction);

    btnId = FrmDoDialog(diagFrm);
    if (btnId == BTNID_DIALOG_OK)
    {
        ListType *lstP;

        // OK{^ꂽƂɂ́A擾
        NNshWinGetFieldText(diagFrm, FLDID_INPUTFIELD, area, size);
        ret = true;

        switch (usage)
        {
          case NNSH_DIALOG_USE_SEARCH:
            // ݂̌ݒp[^p[^ɔf
            UpdateParameter(diagFrm, CHKID_CASELESS,
                            &(NNshParam->searchCaseless));
            break;

          case NNSH_DIALOG_USE_SEARCH_MESSAGE:
            // ʂ擾
            lstP = FrmGetObjectPtr(diagFrm,
                                   FrmGetObjectIndex(diagFrm, LSTID_SEARCH_METHOD));

            *(UInt16 *)valueP = LstGetSelection(lstP);
            break;

          case NNSH_DIALOG_USE_GETMESNUM:
          case NNSH_DIALOG_USE_MODIFYTITLE:
          default:
            // Ȃ
            break;
        }
        NNsh_DebugMessage(ALTID_INFO,"String:", area, 0);
    }

    // _CAO\̌Еt
    PrologueDialog_NNsh(prevFrm, diagFrm, true);

    return (ret);
}

/*=========================================================================*/
/*   Function : Handler_IDpwAction                                         */
/*                                     pX[h͗p̃Cxgnh  */
/*=========================================================================*/
Boolean Handler_IDpwAction(EventType *event)
{
    FormType *frm;

    // ݂̃tH[擾
    switch (event->eType)
    { 
      // j[I
      case menuEvent:
        return (NNsh_MenuEvt_Edit(event));
        break;

      case ctlSelectEvent:
        if (event->data.ctlSelect.controlID == SELTRID_PASSWORD)
        {
            // pX[h͗̈\ďI
            frm = FrmGetActiveForm();
            FrmHideObject(frm, FrmGetObjectIndex(frm, SELTRID_PASSWORD));
            FrmShowObject(frm, FrmGetObjectIndex(frm, FLDID_PASSWORD_INPUT));            
            FrmSetFocus  (frm, FrmGetObjectIndex(frm, FLDID_PASSWORD_INPUT));
            return (true);
        }

      case keyDownEvent:
      default: 
        // Ȃ
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function : DataInputPassword                                          */
/*                                 NNsiʂ̓̓_CAO(ID & Password) */
/*=========================================================================*/
Boolean DataInputPassword(Char *title, Char *id, UInt16 idSize, Char *pw, UInt16 pwSize, Char *info)
{
    Boolean       ret = false;
    FormType     *prevFrm, *diagFrm;
    UInt16        btnId;
    ControlType  *ctlP;

    // ʂ
    ret     = false;
    prevFrm = FrmGetActiveForm();

    // _CAO\
    PrepareDialog_NNsh(FRMID_USERID_INPUT, &diagFrm, true);
    if (diagFrm == NULL)
    {
        return (false);
    }

    // ^CgRs[
    FrmCopyTitle(diagFrm, title);

    // 炩ID΃Rs[
    if (*id != '\0')
    {
        NNshWinSetFieldText(diagFrm, FLDID_USERID_INPUT, false, id, idSize);
    }

    // 炩pw΃Rs[
    if (*pw != '\0')
    {
        NNshWinSetFieldText(diagFrm, FLDID_PASSWORD_INPUT, false, pw, pwSize);
    }

    // pX[hݒ肳Ă邩ǂ\
    ctlP = FrmGetObjectPtr(diagFrm, FrmGetObjectIndex(diagFrm, SELTRID_PASSWORD));
    if (ctlP != NULL)
    {
        if (*pw != '\0')
        {
            CtlSetLabel(ctlP, "* * * * * *");
        }
#if 0
        else
        {
            CtlSetLabel(ctlP, "");
        }
#endif
    }

    // Information\
    if ((info == NULL)||(*info == '\0'))
    {     
        info = " ";
    }
    NNshWinSetFieldText(diagFrm, FLDID_LOGIN_INFO, true, info, StrLen(info));

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_IDpwAction);

    // _CAO̕\
    btnId = FrmDoDialog(diagFrm);
    if (btnId == BTNID_LOGIN_OK)
    {
        // OK{^ꂽƂɂ́AIDƃpX[h擾
        NNshWinGetFieldText(diagFrm, FLDID_USERID_INPUT, id, idSize);
        NNshWinGetFieldText(diagFrm, FLDID_PASSWORD_INPUT, pw, pwSize);
    }

    // _CAO\̌Еt
    PrologueDialog_NNsh(prevFrm, diagFrm, true);

    return (ret);
}


/*=========================================================================*/
/*   Function : Handler_ViewLineAction                                     */
/*                                                       Cxgnh  */
/*=========================================================================*/
Boolean Handler_ViewLineAction(EventType *event)
{
    UInt16 command;

    // R}h
    command = NNSH_STEP_REDRAW;

    // ݂̃tH[擾
    switch (event->eType)
    { 
      case ctlRepeatEvent:
        // 1y[W
        if (event->data.ctlRepeat.controlID == BTNID_FIELDUP)
        {
            command = NNSH_STEP_PAGEUP;
        }

        // 1y[W
        if (event->data.ctlRepeat.controlID == BTNID_FIELDDOWN)
        {
            command = NNSH_STEP_PAGEDOWN;
        }
        break;

      case keyDownEvent:
        // L[R[hɂď𕪊򂳂
        switch (KeyConvertFiveWayToJogChara(event))
        {
          case vchrPageDown:
          case vchrJogDown:
          case vchrTrgJogDown:
          case vchrNextField:
          case vchrThumbWheelDown:
          case chrDownArrow:
            // 1y[W
            command = NNSH_STEP_PAGEDOWN;
            break;

          case vchrPageUp:
          case vchrJogUp:
          case vchrTrgJogUp:
          case vchrPrevField:
          case vchrThumbWheelUp:
          case chrUpArrow:
            // 1y[W
            command = NNSH_STEP_PAGEUP;
            break;

          default:
            // LȊÕL[ł͉Ȃ
            break;

        }
        break;

      case ctlSelectEvent:
      case menuEvent:
      default: 
        // Ȃ
        break;
    }

    if (command != NNSH_STEP_REDRAW)
    {
        // y[Wړ
        NNsi_putLine(FrmGetActiveForm(), command);
        return (true);
    }
    // Ȃ
    return (false);
}

/*=========================================================================*/
/*   Function : DataViewForm                                               */
/*                                               NNsiʂ̎Qƃ_CAO  */
/*=========================================================================*/
Boolean DataViewForm(Char *title, UInt16 nofLine, Char **dataLine)
{
    Boolean       ret = false;
    UInt16        btnId;
    FormType     *prevFrm, *diagFrm;

    // ʂ
    ret     = false;
    prevFrm = FrmGetActiveForm();

    // _CAO\
    PrepareDialog_NNsh(FRMID_VIEW_MODAL, &diagFrm, false);
    if (diagFrm == NULL)
    {
        return (false);
    }
    HandEraMoveDialog(diagFrm);

    // ^CgRs[
    FrmCopyTitle(diagFrm, title);

    // work1 ́A\JnCAwork2́A\\Ci[
    // featureList̓f[^̎́AfeatureLockCnt́Af[^̃Ci[
    NNshGlobal->work1 = 0;
    NNshGlobal->featureLockCnt = nofLine;
    NNshGlobal->featureList    = (NNshWordList *) dataLine;

    // xʂ`悷(v...)
    FrmDrawForm(diagFrm);

    // f[^C(\)ݒ
    NNsi_putLine(diagFrm, NNSH_STEP_TO_TOP);

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_ViewLineAction);

    // _CAO̕\
    btnId = FrmDoDialog(diagFrm);
    if (btnId == BTNID_VIEW_OK)
    {
        // OK{^ꂽƂ...

    }

    // _CAO\̌Еt
    PrologueDialog_NNsh(prevFrm, diagFrm, false);

    // f[^
    NNshGlobal->featureLockCnt = 0;
    NNshGlobal->featureList    = NULL;

    return (ret);
}

/*=========================================================================*/
/*   Function :   NNsi_putLine                                             */
/*                                                                ʕ\ */
/*=========================================================================*/
void NNsi_putLine(FormType *frm, UInt16 command)
{
    RectangleType dimF;
    UInt16        fontID, nlines, fontHeight;
    UInt16        dataLines, startLine, lineStatus, lp, len;
    Char        **lineDatas;

    // Ԃ̏
    lineStatus = NNSH_DISP_ALL;
    
    // f[^\[X擾
    dataLines  = (UInt16)  NNshGlobal->featureLockCnt;
    lineDatas  = (Char **) NNshGlobal->featureList;


    // ʂ̑傫ƕ\\s擾
    FrmGetObjectBounds(frm,
                   FrmGetObjectIndex(frm, GADID_INFORMATION_FIELD), &dimF);
    fontID = (NNshParam->useSonyTinyFontTitle == 0) ?
                           NNshParam->currentFont : NNshParam->sonyHRFontTitle;
    NNsi_UpdateRectangle(&dimF, NNshParam->useSonyTinyFontTitle,
                                                &fontID, &fontHeight, &nlines);

    // R}h\ʒu̐擪ƕ\Ԃ肷
    switch (command)
    {
      case NNSH_STEP_TO_TOP:
        // 擪y[W\
        startLine  = 0;
        lineStatus = NNSH_DISP_UPPERLIMIT;
        break;

      case NNSH_STEP_PAGEUP:
        // Py[W\
        if (NNshGlobal->work1 <= nlines)
        {
            startLine  = 0;
            lineStatus = NNSH_DISP_UPPERLIMIT;
        }
        else
        {
            startLine = NNshGlobal->work1 - nlines;
            lineStatus = NNSH_DISP_HALFWAY;
        }
        break;

      case NNSH_STEP_PAGEDOWN:
        // Py[W\
        if ((NNshGlobal->work1 + nlines) >= dataLines)
        {
            startLine  = NNshGlobal->work1;
            lineStatus = NNSH_DISP_LOWERLIMIT;
        }
        else
        {
            startLine  = NNshGlobal->work1 + nlines;
            lineStatus = NNSH_DISP_HALFWAY;
        }
        break;

      case NNSH_STEP_TO_BOTTOM:
      default:
        // y[W\
        startLine  = (dataLines >= nlines) ? 0 : dataLines - nlines;
        lineStatus = NNSH_DISP_LOWERLIMIT;
        break;
    }

    // y[WԂ𔽉f
    if (lineStatus != NNSH_DISP_UPPERLIMIT)
    {
        if (startLine + nlines >= dataLines)
        {
            lineStatus = NNSH_DISP_LOWERLIMIT;
        }
        else
        {
            lineStatus = NNSH_DISP_HALFWAY;
        }
    }
    if (dataLines <= nlines)
    {
        lineStatus = NNSH_DISP_ALL;
    }

    // \̈NA
    NNsi_EraseRectangle(&dimF);

    // ㉺{^̕\ݒ
    NNsh_UpDownButtonControl(FrmGetActiveForm(), lineStatus,
                             BTNID_FIELDUP, BTNID_FIELDDOWN);

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        // FntSetFont(NNshParam->sonyHRFontTitle);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif   // #ifdef USE_HIGHDENSITY

    // ̕`isPʂŕ`悷j
    for (lp = 0; lp < dataLines; lp++)
    {
        if ((lp < startLine)||(lineDatas[lp][0] == '\0'))
        {
            // \f[^ł͂ȂÃf[^T
            continue;
        }
        if (lp >= startLine + nlines)
        {
            // \\̈搔𒴂ꍇɂ̓[v𔲂
            break;
        }

#ifdef USE_CLIE
        if (NNshGlobal->hrRef != 0)
        {
            // tHg̃[hbv(`̈ɓe}邽)
            if (NNshGlobal->hrVer >= HR_VERSION_SUPPORT_FNTSIZE)
            {
                len = HRFntWordWrap(NNshGlobal->hrRef, lineDatas[lp], dimF.extent.x);
            }
            else
            {
                len = FntWordWrap(lineDatas[lp], dimF.extent.x);
            }
            // CLIEnC]`(Truncateĕ\)
            HRWinDrawTruncChars(NNshGlobal->hrRef, 
                           lineDatas[lp], StrLen(lineDatas[lp]),
                           dimF.topLeft.x, dimF.topLeft.y, dimF.extent.x);
        }
        else
#endif
        {
            // ʏ탂[h`(Truncateĕ\)
            len = FntWordWrap(lineDatas[lp], dimF.extent.x);
            WinDrawTruncChars(lineDatas[lp],len,dimF.topLeft.x,
                              dimF.topLeft.y, dimF.extent.x);
        }

        // ̍sɕ`ʒuړ
        dimF.topLeft.y = dimF.topLeft.y + fontHeight;
    }

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),
                      NNshGlobal->os5HighDensity);
        WinSetCoordinateSystem(kCoordinatesStandard);
        // FntSetFont(NNshParam->sonyHRFont);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif   // #ifdef USE_HIGHDENSITY

    // 擪swork1ɋL
    NNshGlobal->work1 = startLine;

    return;
}

/*=========================================================================*/
/*   Function :   NNsh_UpDownButtonControl                                 */
/*                                             ㉺{^̕\/\ݒ */
/*=========================================================================*/
void NNsh_UpDownButtonControl(FormType *frm, UInt16 btnState, UInt16 upBtnID, UInt16 downBtnID)
{
    // /̃{^\
    // (㉺{^\/\ɂ)
    switch (btnState)
    {
      case NNSH_DISP_NOTHING:
        // ꗗȂ
        FrmHideObject(frm, FrmGetObjectIndex(frm, upBtnID));
        FrmHideObject(frm, FrmGetObjectIndex(frm, downBtnID));
        break;

      case NNSH_DISP_UPPERLIMIT:
        // 
        FrmHideObject(frm, FrmGetObjectIndex(frm, upBtnID));
        FrmShowObject(frm, FrmGetObjectIndex(frm, downBtnID));
        break;

      case NNSH_DISP_LOWERLIMIT:
        // 
        FrmShowObject(frm, FrmGetObjectIndex(frm, upBtnID));
        FrmHideObject(frm, FrmGetObjectIndex(frm, downBtnID));
        break;

      case NNSH_DISP_ALL:
        // S
        FrmHideObject(frm, FrmGetObjectIndex(frm, upBtnID));
        FrmHideObject(frm, FrmGetObjectIndex(frm, downBtnID));
        break;

      case NNSH_DISP_HALFWAY:
      default:
        // r
        FrmShowObject(frm, FrmGetObjectIndex(frm, upBtnID));
        FrmShowObject(frm, FrmGetObjectIndex(frm, downBtnID));
        break;
    }
    return;
}

/*=========================================================================*/
/*   Function :  PrepareDialog_NNsh                                        */
/*                                              _CAO\ݒ荀 */
/*=========================================================================*/
void PrepareDialog_NNsh(UInt16 formID, FormType **diagFrm, Boolean silk)
{
    // PalmOS v3.5ȉȂAÕtH[B
    if (NNshGlobal->palmOSVersion < 0x03503000)
    {
        FrmEraseForm(FrmGetActiveForm());
    }

    // _CAOtH[ANeBuɂ
    *diagFrm  = FrmInitForm(formID);
    if (*diagFrm == NULL)
    {
        return;
    }
    FrmSetActiveForm(*diagFrm);

    // VNȂꍇɂ͏I
    if (silk != true)
    {
        return;
    }

    // VN\ő剻
#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        VgaFormModify(*diagFrm, vgaFormModify160To240);
        SilkMaximizeWindow();
    }
    else
#endif // #ifdef USE_HANDERA
    {
        NNshSilkMaximize(*diagFrm);
    }
    HandEraMoveDialog(*diagFrm);

    return;
}

/*=========================================================================*/
/*   Function :  PrologueDialog_NNsh                                       */
/*                                        ݒ荀([_tH[)̕\ */
/*=========================================================================*/
void PrologueDialog_NNsh(FormType *prevFrm, FormType *diagFrm, Boolean silk)
{
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(diagFrm);

    // VNȂꍇɂ͏I
    if (silk != true)
    {
        return;
    }

    // VN\ŏ
#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        SilkMinimizeWindow();
    }
    else
#endif // #ifdef USE_HANDERA
    {
        NNshSilkMinimize(prevFrm);
    }
    return;
}
