/*============================================================================*
 *  FILE: 
 *     sslv2.c
 *
 *  Description: 
 *     SSL v2ʐMp(openssl v0.9.7bQlɎ...)
 *
 *===========================================================================*/
#define SSLV2_C
#include "local.h"

#ifdef USE_SSL
#ifdef USE_SSL_V2

static void client_hello_NNshSSLv2    (NNshSSLv2Ref *sslRef);
static Err   get_server_hello_NNshSSLv2(NNshSSLv2Ref *sslRef);
static Err client_master_key_NNshSSLv2 (NNshSSLv2Ref *sslRef);
static Err get_server_verify_NNshSSLv2 (NNshSSLv2Ref *sslRef);


/*=========================================================================*/
/*   Function : NNshSSLv2_Open                                             */
/*                                                          NNshSSL v2 */
/*=========================================================================*/
Err NNshSSLv2_Open(NNshSSLv2Ref **sslRef)
{

    *sslRef = MemPtrNew(sizeof(NNshSSLv2Ref) + MARGIN);
    if (*sslRef == NULL)    
    {
        // ̈mێsAAAG[
        return (~errNone);
    }
    MemSet(*sslRef, (sizeof(NNshSSLv2Ref) + MARGIN), 0x00);
    return (errNone); 
}

/*=========================================================================*/
/*   Function : NNshSSLv2_Close                                            */
/*                                                          NNshSSL v2I */
/*=========================================================================*/
Err NNshSSLv2_Close(NNshSSLv2Ref **sslRef)
{
    if (*sslRef != NULL)
    {

        if ((*sslRef)->buffer != NULL)
        {
            // [Nobt@̈J
            MemPtrFree((*sslRef)->buffer);
            (*sslRef)->buffer = NULL;
        }

        //
        MemPtrFree(*sslRef);
    }
    *sslRef = NULL;
    return (errNone); 
}

/*=========================================================================*/
/*   Function : NNshSSLv2_Connect                                          */
/*                                                          NNshSSL v2ڑ */
/*=========================================================================*/
Err NNshSSLv2_Connect(NNshSSLv2Ref *sslRef, NetSocketRef socketRef, UInt16 netRef)
{
    Err     ret;

    // SSLgpݒłȂ([N̈悪mۂĂȂ)I
    if (sslRef == NULL)
    {
        return (~errNone);
    }

    // ë/ϐ̏
    ret = errNone;
    sslRef->netRef    = netRef;
    sslRef->socketRef = socketRef;
    if (sslRef->buffer != NULL)
    {
        MemPtrFree(sslRef->buffer);
    }
    sslRef->buffer    = NULL;
    sslRef->state     = NNSHSSL_STATE_BEFORE;
    ret               = errNone;
    while (ret != errNone)
    {
        switch (sslRef->state)
        {
          case NNSHSSL_STATE_BEFORE:
          case NNSHSSL_STATE_CONNECT:
          case ((NNSHSSL_STATE_BEFORE)|(NNSHSSL_STATE_CONNECT)):
          case ((NNSHSSL_STATE_OK)|(NNSHSSL_STATE_CONNECT)):
            // obt@̊m
            sslRef->buffer = MemPtrNew(NNSHSSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER + MARGIN);
            if (sslRef->buffer == NULL)
            {
                ret = ~errNone;
                break;
            }
            else
            {
                ret = errNone;
            }
            MemSet(sslRef->buffer, (NNSHSSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER + MARGIN), 0x00);
            sslRef->state = SSL2_ST_SEND_CLIENT_HELLO;
            break;

          case SSL2_ST_SEND_CLIENT_HELLO:
            // Client Hello̐ƑM
            client_hello_NNshSSLv2(sslRef);
            ret = NNshNet_write(netRef, socketRef, sslRef->bufLen, sslRef->buffer);
NNsh_DebugMessage(ALTID_INFO, "NNshNet_write()", " ret:", ret);
            if (ret != errNone)
            {
                break;
            }
NNsh_DebugMessage(ALTID_INFO, "NNshNet_write(aaa)", " ret:", ret);
            sslRef->state = SSL2_ST_GET_SERVER_HELLO;
            break;

          case SSL2_ST_GET_SERVER_HELLO:
NNsh_DebugMessage(ALTID_INFO, "NNshNet_read(prev)", " ret:", ret);
            // Server Hello̎擾ƓemF(vgRT|[gĂ邩H)
            ret = NNshNet_read(netRef, socketRef, 
                               (NNSHSSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER + MARGIN),
                               sslRef->buffer, &(sslRef->bufLen));
NNsh_DebugMessage(ALTID_INFO, "NNshNet_read(after)", " ret:", ret);
            if (ret != errNone)
            {
                break;
            }
            ret = get_server_hello_NNshSSLv2(sslRef);
NNsh_DebugMessage(ALTID_INFO, "get server hello", " ret:", ret);
            if (ret != errNone)
            {
                break;
            }
            sslRef->state = SSL2_ST_SEND_CLIENT_MASTER_KEY;
            break;

          case SSL2_ST_SEND_CLIENT_MASTER_KEY:
NNsh_DebugMessage(ALTID_INFO, "CLIENT MASTER KEY", " ret:", ret);
            (void) client_master_key_NNshSSLv2(sslRef);
            ret = NNshNet_write(netRef, socketRef, sslRef->bufLen, sslRef->buffer);
            if (ret != errNone)
            {
                break;
            }
            sslRef->state = SSL2_ST_GET_SERVER_VERIFY;
            break;

          case SSL2_ST_GET_SERVER_VERIFY:
NNsh_DebugMessage(ALTID_INFO, "NNshNet_read(prev-2)", " ret:", ret);
            // Server Hello̎擾ƓemF(vgRT|[gĂ邩H)
            ret = NNshNet_read(netRef, socketRef, 
                               (NNSHSSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER + MARGIN),
                               sslRef->buffer, &(sslRef->bufLen));
NNsh_DebugMessage(ALTID_INFO, "NNshNet_read(after-2)", " ret:", ret);
            if (ret != errNone)
            {
                break;
            }
            ret = get_server_verify_NNshSSLv2(sslRef);
NNsh_DebugMessage(ALTID_INFO, "get server verify", " ret:", ret);
            if (ret != errNone)
            {
                break;
            }
            sslRef->state = SSL2_ST_SEND_CLIENT_MASTER_KEY;
            break;

#if 0
            if (ret <= 0)
            {
                goto FUNC_END;
            }
            s->init_num = 0;
            if (!s->hit) /* new session */
            {
                s->state = SSL2_ST_SEND_CLIENT_MASTER_KEY_A;
                BREAK;
            }
            else
            {
                s->state = SSL2_ST_CLIENT_START_ENCRYPTION;
                break;
            }
            break;

          case SSL2_ST_SEND_CLIENT_MASTER_KEY_A:
          case SSL2_ST_SEND_CLIENT_MASTER_KEY_B:
            ret = client_master_key(s);
            if (ret <= 0)
            {
                goto FUNC_END;
            }
            s->init_num = 0;
            s->state = SSL2_ST_CLIENT_START_ENCRYPTION;
            break;

          case SSL2_ST_CLIENT_START_ENCRYPTION:
            /* Ok, we now have all the stuff needed to
             * start encrypting, so lets fire it up :-) */
            if (!ssl2_enc_init(s,1))
            {
                ret = -1;
                goto FUNC_END;
            }
            s->s2->clear_text = 0;
            s->state = SSL2_ST_SEND_CLIENT_FINISHED_A;
            break;

          case SSL2_ST_SEND_CLIENT_FINISHED_A:
          case SSL2_ST_SEND_CLIENT_FINISHED_B:
            ret = client_finished(s);
            if (ret <= 0)
            {
                goto FUNC_END;
            }
            s->init_num = 0;
            s->state = SSL2_ST_GET_SERVER_VERIFY_A;
            break;

          case SSL2_ST_GET_SERVER_VERIFY_A:
          case SSL2_ST_GET_SERVER_VERIFY_B:
            ret = get_server_verify(s);
            if (ret <= 0)
            {
                goto FUNC_END;
            }
            s->init_num = 0;
            s->state = SSL2_ST_GET_SERVER_FINISHED_A;
            break;

          case SSL2_ST_GET_SERVER_FINISHED_A:
          case SSL2_ST_GET_SERVER_FINISHED_B:
            ret = get_server_finished(s);
            if (ret <= 0)
            {
                goto FUNC_END;
            }
            break;

          case SSL2_ST_SEND_CLIENT_CERTIFICATE_A:
          case SSL2_ST_SEND_CLIENT_CERTIFICATE_B:
          case SSL2_ST_SEND_CLIENT_CERTIFICATE_C:
          case SSL2_ST_SEND_CLIENT_CERTIFICATE_D:
          case SSL2_ST_X509_GET_CLIENT_CERTIFICATE:
            ret = client_certificate(s);
            if (ret <= 0)
            {
                goto FUNC_END;
            }
            s->init_num = 0;
            s->state = SSL2_ST_GET_SERVER_FINISHED_A;
            break;

          case SSL_ST_OK:
            if (s->init_buf != NULL)
            {
                BUF_MEM_free(s->init_buf);
                s->init_buf = NULL;
            }
            s->init_num = 0;
            /* ERR_clear_error(); */

            /* If we want to cache session-ids in the client
             * and we successfully add the session-id to the
             * cache, and there is a callback, then pass it out.
             * 26/11/96 - eay - only add if not a re-used session.
             */

            ssl_update_cache(s,SSL_SESS_CACHE_CLIENT);
            if (s->hit)
            {
                s->ctx->stats.sess_hit++;
            }
            ret = 1;
            /* s->server = 0; */
            s->ctx->stats.sess_connect_good++;

            if (cb != NULL)
            {
                cb(s,SSL_CB_HANDSHAKE_DONE,1);
            }
            goto FUNC_END;
            /* break; */
#endif
          default:
NNsh_DebugMessage(ALTID_INFO, "default", " ret:", ret);
            ret = ~errNone;
            break;
        }
    }   // while (ret != errNone)


NNsh_DebugMessage(ALTID_INFO, "FUNC END ", " ret:", ret);
    if (sslRef->buffer != NULL)
    {
        MemPtrFree(sslRef->buffer);
        sslRef->buffer = NULL;
    }
    return (ret);
}

/*=========================================================================*/
/*   Function : NNshSSLv2_Disconnect                                       */
/*                                                          NNshSSL v2ؒf */
/*=========================================================================*/
Err NNshSSLv2_Disconnect(NNshSSLv2Ref *sslRef)
{
    if (sslRef == NULL)
    {
        return (~errNone);
    }

    return (errNone);
}

/*==========================================================================*/
/*  Function : NNshSSLv2_Read                                               */
/*                                                       NNshSSL v2ǂݏo */
/*==========================================================================*/
Err NNshSSLv2_Read(NNshSSLv2Ref *sslRef, UInt16 size, void *data, UInt16 *readSize)
{
    if (sslRef == NULL)
    {
        return (~errNone);
    }

    return (errNone);
}

/*==========================================================================*/
/*  Function : NNshSSLv2_Write                                              */
/*                                                       NNshSSL v2 */
/*==========================================================================*/
Err NNshSSLv2_Write(NNshSSLv2Ref *sslRef, UInt16 size, void *data)
{
    if (sslRef == NULL)
    {
        return (~errNone);
    }

    return (errNone);
}

/*--------------------------------------------------------------------------*/
/*  Function : client_hello_NNshSSLv2                                       */
/*                                                  SSL v2 client helloM */
/*--------------------------------------------------------------------------*/
static void client_hello_NNshSSLv2(NNshSSLv2Ref *sslRef)
{
    UInt8   *ptr;
    UInt16   loc, cnt, *size;

    // Client Hellõf[^쐬
    loc  = 0;
    size = (UInt16 *) sslRef->buffer;
    ptr  = (UInt8 *) (size + 1);

    /* data type */
    ptr[loc] = SSL2_MT_CLIENT_HELLO;
    loc++;
    
    /* protocol version(high) */
    ptr[loc] = SSL2_VERSION_MAJOR;
    loc++;
    
    /* protocol version(low) */
    ptr[loc] = SSL2_VERSION_MINOR;
    loc++;

    /** Cipher Spec. length **/ // Cipher Spec.́A(セȂ)PL...
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x03;
    loc++;

    /** session ID length **/
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x00;
    loc++;

    /** challenge length **/
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = SSL2_CHALLENGE_LENGTH;
    loc++;
    
    /** Cipher spec. **/
#if 0
    // SSL2_RC4_128_EXPORT40_WITH_MD5(0x020080)Lɂ
    ptr[loc] = 0x02;
    loc++;
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x80;
    loc++;
#else
    // SSL2_RC4_128_WITH_MD5(0x010080)Lɂ
    ptr[loc] = 0x01;
    loc++;
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x80;
    loc++;
#endif

    /** challenge string **/
    // `W̐A16oCgA炢Ȑ...
    for (cnt = 0; cnt < SSL2_CHALLENGE_LENGTH; cnt++)
    {
        ptr[loc] = (0xff & SysRandom(TimGetTicks() * (cnt + 1)));
        sslRef->challenge[cnt] = ptr[loc];
        loc++;
    }

    *size = 0x8000 | loc;
    sslRef->bufLen = loc + sizeof(UInt16);

    return;
}

/*--------------------------------------------------------------------------*/
/*  Function : get_server_hello_NNshSSLv2                                   */
/*                                                  SSL v2 Server helloM */
/*--------------------------------------------------------------------------*/
static Err get_server_hello_NNshSSLv2(NNshSSLv2Ref *sslRef)
{
    UInt16 dataLen, sslVer, certLen, ciphLen, connLen;
    UInt8  mesType, certType, sessId, *ptr;
    
    ptr    = (UInt8 *) sslRef->buffer;
    dataLen = 0x7ffff & *((UInt16 *) ptr);    
    ptr = ptr + 2;

    mesType = *ptr;
    ptr++;

    sessId  = *ptr;
    ptr++;

    certType = *ptr;
    ptr++;

    sslVer = *((UInt16 *) ptr);
    ptr = ptr + 2;
    
    certLen = *((UInt16 *) ptr);
    ptr = ptr + 2;
    
    ciphLen = *((UInt16 *) ptr);
    ptr = ptr + 2;
    if (ciphLen == 0)
    {
        // T|[gÍvȂAG[IB
        return (~errNone);
    }   
    
    connLen = *((UInt16 *) ptr);
    ptr = ptr + 2;

    return (errNone);
}

/*--------------------------------------------------------------------------*/
/*  Function : client_master_key_NNshSSLv2                                  */
/*                                  SSL v2 client master key Mf[^쐬 */
/*--------------------------------------------------------------------------*/
static Err client_master_key_NNshSSLv2(NNshSSLv2Ref *sslRef)
{
    UInt8   *ptr;
    UInt16   loc, *size;

    // Client Hellõf[^쐬
    loc  = 0;
    size = (UInt16 *) sslRef->buffer;
    ptr  = (UInt8 *) (size + 1);

    /** key  **/
    ptr[loc] = SSL2_MT_CLIENT_MASTER_KEY;
    loc++;
    
    /** Cipher spec. **/
#if 0
    // SSL2_RC4_128_EXPORT40_WITH_MD5(0x020080)Lɂ
    ptr[loc] = 0x02;
    loc++;
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x80;
    loc++;
#else
    // SSL2_RC4_128_WITH_MD5(0x010080)Lɂ
    ptr[loc] = 0x01;
    loc++;
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x80;
    loc++;
#endif

    // clear key data length == 0
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x00;
    loc++;

    // encrypted data length == 128
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x80;
    loc++;

    // key argument length == 0
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x00;
    loc++;

    // encrypted key == 128bytes

    // ǂf[^gBBBH

    loc = loc + 128;
    *size = 0x8000 | loc;
    sslRef->bufLen = loc + sizeof(UInt16);

    return (errNone);
}

/*--------------------------------------------------------------------------*/
/*  Function : get_server_verify_NNshSSLv2                                  */
/*                                            SSL v2 serverR[ȟ */
/*--------------------------------------------------------------------------*/
static Err get_server_verify_NNshSSLv2(NNshSSLv2Ref *sslRef)
{
    return (errNone);
}

#if 0
static int client_master_key(SSL *s)
{
    unsigned char *buf;
    unsigned char *p,*d;
    int clear,enc,karg,i;
    SSL_SESSION *sess;
    const EVP_CIPHER *c;
    const EVP_MD *md;

    buf = (unsigned char *)s->init_buf->data;
    if (s->state == SSL2_ST_SEND_CLIENT_MASTER_KEY_A)
    {
        if (!ssl_cipher_get_evp(s->session,&c,&md,NULL))
        {
            ssl2_return_error(s,SSL2_PE_NO_CIPHER);
            SSLerr(SSL_F_CLIENT_MASTER_KEY,SSL_R_PROBLEMS_MAPPING_CIPHER_FUNCTIONS);
            return(-1);
        }
        sess = s->session;
        p = buf;
        d = p + 10;
        *(p++) = SSL2_MT_CLIENT_MASTER_KEY; /* type */

        i = ssl_put_cipher_by_char(s, sess->cipher, p);
        p = p + i;

        /* make key_arg data */
        i = EVP_CIPHER_iv_length(c);
        sess->key_arg_length=i;
        if (i > SSL_MAX_KEY_ARG_LENGTH)
        {
            ssl2_return_error(s, SSL2_PE_UNDEFINED_ERROR);
            SSLerr(SSL_F_CLIENT_MASTER_KEY, ERR_R_INTERNAL_ERROR);
            return -1;
        }
        if (i > 0)
        {
            RAND_pseudo_bytes(sess->key_arg,i);
        }

        /* make a master key */
        i = EVP_CIPHER_key_length(c);
        sess->master_key_length=i;
        if (i > 0)
        {
            if (i > sizeof sess->master_key)
            {
                ssl2_return_error(s, SSL2_PE_UNDEFINED_ERROR);
                SSLerr(SSL_F_CLIENT_MASTER_KEY, ERR_R_INTERNAL_ERROR);
                return -1;
            }
            if (RAND_bytes(sess->master_key,i) <= 0)
            {
                ssl2_return_error(s,SSL2_PE_UNDEFINED_ERROR);
                return(-1);
            }
        }

        if (sess->cipher->algorithm2 & SSL2_CF_8_BYTE_ENC)
        {
            enc=8;
        }
        else if (SSL_C_IS_EXPORT(sess->cipher))
        {
            enc=5;
        }
        else
        {
            enc=i;
        }

        if (i < enc)
        {
            ssl2_return_error(s,SSL2_PE_UNDEFINED_ERROR);
            SSLerr(SSL_F_CLIENT_MASTER_KEY,SSL_R_CIPHER_TABLE_SRC_ERROR);
            return(-1);
        }

        clear = i - enc;
        s2n(clear,p);
        memcpy(d,sess->master_key,(unsigned int)clear);
        d = d + clear;

        enc=ssl_rsa_public_encrypt(sess->sess_cert,enc,
                          &(sess->master_key[clear]),d,
                 (s->s2->ssl2_rollback)?RSA_SSLV23_PADDING:RSA_PKCS1_PADDING);

        if (enc <= 0)
        {
            ssl2_return_error(s,SSL2_PE_UNDEFINED_ERROR);
            SSLerr(SSL_F_CLIENT_MASTER_KEY,SSL_R_PUBLIC_KEY_ENCRYPT_ERROR);
            return(-1);
        }

#ifdef PKCS1_CHECK
        if (s->options & SSL_OP_PKCS1_CHECK_1)
        {
            d[1]++;
        }
        if (s->options & SSL_OP_PKCS1_CHECK_2)
        {
            sess->master_key[clear]++;
        }
#endif
        s2n(enc,p);
        d+=enc;
        karg=sess->key_arg_length;  
        s2n(karg,p); /* key arg size */
        if (karg > sizeof sess->key_arg)
        {
            ssl2_return_error(s,SSL2_PE_UNDEFINED_ERROR);
            SSLerr(SSL_F_CLIENT_MASTER_KEY, ERR_R_INTERNAL_ERROR);
            return -1;
        }
        memcpy(d,sess->key_arg,(unsigned int)karg);
        d+=karg;

        s->state=SSL2_ST_SEND_CLIENT_MASTER_KEY_B;
        s->init_num=d-buf;
        s->init_off=0;
    }

    /* SSL2_ST_SEND_CLIENT_MASTER_KEY_B */
    return(ssl2_do_write(s));
}

static int get_server_verify(SSL *s)
{
    unsigned char *p;
    int i, n, len;

    p = (unsigned char *) s->init_buf->data;
    if (s->state == SSL2_ST_GET_SERVER_VERIFY_A)
    {
        i=ssl2_read(s,(char *)&(p[s->init_num]),1-s->init_num);
        if (i < (1-s->init_num))
        { 
            return(ssl2_part_read(s,SSL_F_GET_SERVER_VERIFY,i));
        }
        s->init_num += i;

        s->state= SSL2_ST_GET_SERVER_VERIFY_B;
        if (*p != SSL2_MT_SERVER_VERIFY)
        {
            if (p[0] != SSL2_MT_ERROR)
            {
                ssl2_return_error(s,SSL2_PE_UNDEFINED_ERROR);
                SSLerr(SSL_F_GET_SERVER_VERIFY,
                       SSL_R_READ_WRONG_PACKET_TYPE);
            }
            else
            {
                 SSLerr(SSL_F_GET_SERVER_VERIFY,SSL_R_PEER_ERROR);
                 /* try to read the error message */
                 i = ssl2_read(s,(char *)&(p[s->init_num]),3-s->init_num);
                 return ssl2_part_read(s,SSL_F_GET_SERVER_VERIFY,i);
            }
            return(-1);
        }
    }
 
    p = (unsigned char *) s->init_buf->data;
    len = 1 + s->s2->challenge_length;
    n =  len - s->init_num;
    i = ssl2_read(s,(char *)&(p[s->init_num]),n);
    if (i < n)
    {
        return(ssl2_part_read(s,SSL_F_GET_SERVER_VERIFY,i));
    }
    if (s->msg_callback)
    {
        s->msg_callback(0, s->version, 0, p, len, s, s->msg_callback_arg); /* SERVER-VERIFY */
    }
    p += 1;

    if (memcmp(p,s->s2->challenge,s->s2->challenge_length) != 0)
    {
        ssl2_return_error(s,SSL2_PE_UNDEFINED_ERROR);
        SSLerr(SSL_F_GET_SERVER_VERIFY,SSL_R_CHALLENGE_IS_DIFFERENT);
        return(-1);
    }
    return(1);
}

/* SSL 2.0 imlementation for SSL_read/SSL_peek -
 * This routine will return 0 to len bytes, decrypted etc if required.
 */
static int ssl2_read_internal(SSL *s, void *buf, int len, int peek)
{
    int n;
    unsigned char mac[MAX_MAC_SIZE];
    unsigned char *p;
    int i;
    unsigned int mac_size;

ssl2_read_again:
    if (SSL_in_init(s) && !s->in_handshake)
    {
        n=s->handshake_func(s);
        if (n < 0)
        {
            return(n);
        }
        if (n == 0)
        {
            SSLerr(SSL_F_SSL2_READ_INTERNAL,SSL_R_SSL_HANDSHAKE_FAILURE);
            return(-1);
        }
    }

    clear_sys_error();
    s->rwstate=SSL_NOTHING;
    if (len <= 0)
    {
        return(len);
    }

    if (s->s2->ract_data_length != 0) /* read from buffer */
    {
        if (len > s->s2->ract_data_length)
        {
            n=s->s2->ract_data_length;
        }
        else
        {
            n=len;
        }
        memcpy(buf,s->s2->ract_data,(unsigned int)n);
        if (!peek)
        {
            s->s2->ract_data_length-=n;
            s->s2->ract_data+=n;
            if (s->s2->ract_data_length == 0)
            {
                s->rstate=SSL_ST_READ_HEADER;
            }
        }
        return(n);
    }

   /* s->s2->ract_data_length == 0
    * 
    * Fill the buffer, then goto ssl2_read_again.
    */
    if (s->rstate == SSL_ST_READ_HEADER)
    {
        if (s->first_packet)
        {
            n=read_n(s,5,SSL2_MAX_RECORD_LENGTH_2_BYTE_HEADER+2,0);
            if (n <= 0)
            {
                return(n); /* error or non-blocking */
            }
            s->first_packet=0;
            p=s->packet;
            if (!((p[0] & 0x80) && (
                 (p[2] == SSL2_MT_CLIENT_HELLO) ||
                 (p[2] == SSL2_MT_SERVER_HELLO))))
            {
                SSLerr(SSL_F_SSL2_READ_INTERNAL,SSL_R_NON_SSLV2_INITIAL_PACKET);
                return(-1);
            }
        }
        else
        {
            n=read_n(s,2,SSL2_MAX_RECORD_LENGTH_2_BYTE_HEADER+2,0);
             if (n <= 0)
             {
                 return(n); /* error or non-blocking */
             }
        }

        /* part read stuff */
       s->rstate=SSL_ST_READ_BODY;
       p=s->packet;
       /* Do header */
       /*s->s2->padding=0;*/
       s->s2->escape=0;
       s->s2->rlength=(((unsigned int)p[0])<<8)|((unsigned int)p[1]);
       if ((p[0] & TWO_BYTE_BIT))      /* Two byte header? */
       {
           s->s2->three_byte_header=0;
           s->s2->rlength&=TWO_BYTE_MASK;  
       }
       else
       {
           s->s2->three_byte_header=1;
           s->s2->rlength&=THREE_BYTE_MASK;

            /* security >s2->escape */
            s->s2->escape=((p[0] & SEC_ESC_BIT))?1:0;
       }
    }

    if (s->rstate == SSL_ST_READ_BODY)
    {
        n=s->s2->rlength+2+s->s2->three_byte_header;
        if (n > (int)s->packet_length)
        {
            n-=s->packet_length;
            i=read_n(s,(unsigned int)n,(unsigned int)n,1);
            if (i <= 0)
            {
                return(i); /* ERROR */
            }
        }

        p= &(s->packet[2]);
        s->rstate=SSL_ST_READ_HEADER;
        if (s->s2->three_byte_header)
        {
            s->s2->padding= *(p++);
        }
        else
        {
            s->s2->padding=0;
        }

        /* Data portion */
        if (s->s2->clear_text)
        {
            mac_size = 0;
            s->s2->mac_data=p;
            s->s2->ract_data=p;
            if (s->s2->padding)
            {
               SSLerr(SSL_F_SSL2_READ_INTERNAL,SSL_R_ILLEGAL_PADDING);
               return(-1);
            }
        }
        else
        {
            mac_size=EVP_MD_size(s->read_hash);
            OPENSSL_assert(mac_size <= MAX_MAC_SIZE);
            s->s2->mac_data=p;
            s->s2->ract_data= &p[mac_size];
            if (s->s2->padding + mac_size > s->s2->rlength)
            {
                SSLerr(SSL_F_SSL2_READ_INTERNAL,SSL_R_ILLEGAL_PADDING);
                return(-1);
            }
        }

        s->s2->ract_data_length=s->s2->rlength;
        /* added a check for length > max_size in case
         * encryption was not turned on yet due to an error */
        if ((!s->s2->clear_text) &&
           (s->s2->rlength >= mac_size))
        {
            ssl2_enc(s,0);
            s->s2->ract_data_length-=mac_size;
            ssl2_mac(s,mac,0);
            s->s2->ract_data_length-=s->s2->padding;
            if ((memcmp(mac,s->s2->mac_data,
                (unsigned int)mac_size) != 0) ||
                (s->s2->rlength%EVP_CIPHER_CTX_block_size(s->enc_read_ctx) != 0))
            {
                SSLerr(SSL_F_SSL2_READ_INTERNAL,SSL_R_BAD_MAC_DECODE);
                return(-1);
            }
        }
        INC32(s->s2->read_sequence); /* expect next number */
        /* s->s2->ract_data is now available for processing */

        /* Possibly the packet that we just read had 0 actual data bytes.
         * (SSLeay/OpenSSL itself never sends such packets; see ssl2_write.)
         * In this case, returning 0 would be interpreted by the caller
         * as indicating EOF, so it's not a good idea.  Instead, we just
         * continue reading; thus ssl2_read_internal may have to process
         * multiple packets before it can return.
         *
         * [Note that using select() for blocking sockets *never* guarantees
         * that the next SSL_read will not block -- the available
         * data may contain incomplete packets, and except for SSL 2,
         * renegotiation can confuse things even more.] */

         goto ssl2_read_again; /* This should really be
                                 * "return ssl2_read(s,buf,len)",
                                 * but that would allow for
                                 * denial-of-service attacks if a
                                 * C compiler is used that does not
                                 * recognize end-recursion. */
    }
    else
    {
        SSLerr(SSL_F_SSL2_READ_INTERNAL,SSL_R_BAD_STATE);
        return(-1);
    }
}

int ssl2_read(SSL *s, void *buf, int len)
{
    return ssl2_read_internal(s, buf, len, 0);
}

int ssl2_peek(SSL *s, void *buf, int len)
{
    return ssl2_read_internal(s, buf, len, 1);
}


#endif


#endif
#endif
